/**
 * generated by Xtext 2.10.0
 */
package com.regnosys.rosetta.generator;

import com.regnosys.rosetta.config.RosettaGeneratorsConfiguration;
import com.regnosys.rosetta.generator.external.ExternalGenerator;
import com.regnosys.rosetta.generator.external.ExternalGenerators;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.condition.ConditionGenerator;
import com.regnosys.rosetta.generator.java.enums.EnumGenerator;
import com.regnosys.rosetta.generator.java.expression.DeepPathUtilGenerator;
import com.regnosys.rosetta.generator.java.function.FunctionGenerator;
import com.regnosys.rosetta.generator.java.object.JavaPackageInfoGenerator;
import com.regnosys.rosetta.generator.java.object.MetaFieldGenerator;
import com.regnosys.rosetta.generator.java.object.ModelMetaGenerator;
import com.regnosys.rosetta.generator.java.object.ModelObjectGenerator;
import com.regnosys.rosetta.generator.java.object.ValidatorsGenerator;
import com.regnosys.rosetta.generator.java.reports.ReportGenerator;
import com.regnosys.rosetta.generator.java.reports.RuleGenerator;
import com.regnosys.rosetta.generator.java.reports.TabulatorGenerator;
import com.regnosys.rosetta.generator.java.validator.ValidatorGenerator;
import com.regnosys.rosetta.generator.resourcefsa.ResourceAwareFSAFactory;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.utils.DeepFeatureCallUtil;
import com.rosetta.util.DemandableLock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
@SuppressWarnings("all")
public class RosettaGenerator implements IGenerator2 {
  private static Logger LOGGER = LoggerFactory.getLogger(RosettaGenerator.class);

  @Inject
  private EnumGenerator enumGenerator;

  @Inject
  private ModelMetaGenerator metaGenerator;

  @Inject
  private ConditionGenerator conditionGenerator;

  @Inject
  private TabulatorGenerator tabulatorGenerator;

  @Inject
  private MetaFieldGenerator metaFieldGenerator;

  @Inject
  private ExternalGenerators externalGenerators;

  @Inject
  private JavaPackageInfoGenerator javaPackageInfoGenerator;

  @Inject
  private RuleGenerator ruleGenerator;

  @Inject
  private ModelObjectGenerator dataGenerator;

  @Inject
  private ValidatorsGenerator validatorsGenerator;

  @Inject
  private ValidatorGenerator validatorGenerator;

  @Inject
  @Extension
  private RosettaFunctionExtensions _rosettaFunctionExtensions;

  @Inject
  private FunctionGenerator funcGenerator;

  @Inject
  private ReportGenerator reportGenerator;

  @Inject
  private DeepPathUtilGenerator deepPathUtilGenerator;

  @Inject
  private DeepFeatureCallUtil deepFeatureCallUtil;

  @Inject
  private ResourceAwareFSAFactory fsaFactory;

  @Inject
  private RosettaGeneratorsConfiguration config;

  private final Set<String> ignoredFiles = Collections.<String>unmodifiableSet(CollectionLiterals.<String>newHashSet("model-no-code-gen.rosetta", "basictypes.rosetta", "annotations.rosetta"));

  private final Map<ResourceSet, DemandableLock> locks = CollectionLiterals.<ResourceSet, DemandableLock>newHashMap();

  public void beforeAllGenerate(final ResourceSet resourceSet, final IFileSystemAccess2 fsa2, final IGeneratorContext context) {
    RosettaGenerator.LOGGER.trace("Starting the before all generate method");
    final Function<ResourceSet, DemandableLock> _function = (ResourceSet it) -> {
      return new DemandableLock();
    };
    final DemandableLock lock = this.locks.computeIfAbsent(resourceSet, _function);
    try {
      lock.getWriteLock(true);
      final Function1<Resource, Boolean> _function_1 = (Resource it) -> {
        boolean _contains = this.ignoredFiles.contains(IterableExtensions.<Object>last(((Iterable<Object>)Conversions.doWrapArray(it.getURI().segments()))));
        return Boolean.valueOf((!_contains));
      };
      final Function1<Resource, RosettaModel> _function_2 = (Resource it) -> {
        EObject _head = IterableExtensions.<EObject>head(it.getContents());
        return ((RosettaModel) _head);
      };
      final Function1<RosettaModel, Boolean> _function_3 = (RosettaModel it) -> {
        return Boolean.valueOf(this.shouldGenerate(it));
      };
      final List<RosettaModel> models = IterableExtensions.<RosettaModel>toList(IterableExtensions.<RosettaModel>filter(IterableExtensions.<Resource, RosettaModel>map(IterableExtensions.<Resource>filter(resourceSet.getResources(), _function_1), _function_2), _function_3));
      RosettaModel _head = IterableExtensions.<RosettaModel>head(models);
      String _version = null;
      if (_head!=null) {
        _version=_head.getVersion();
      }
      final String version = _version;
      final Consumer<ExternalGenerator> _function_4 = (ExternalGenerator generator) -> {
        final Consumer<Map<String, ? extends CharSequence>> _function_5 = (Map<String, ? extends CharSequence> map) -> {
          final Consumer<Map.Entry<String, ? extends CharSequence>> _function_6 = (Map.Entry<String, ? extends CharSequence> it) -> {
            fsa2.generateFile(it.getKey(), generator.getOutputConfiguration().getName(), it.getValue());
          };
          map.entrySet().forEach(_function_6);
        };
        generator.beforeAllGenerate(resourceSet, models, version, _function_5, lock);
      };
      this.externalGenerators.forEach(_function_4);
    } catch (final Throwable _t) {
      if (_t instanceof CancellationException) {
        RosettaGenerator.LOGGER.trace("Code generation cancelled, this is expected");
      } else if (_t instanceof Exception) {
        final Exception e_1 = (Exception)_t;
        String _message = e_1.getMessage();
        String _plus = ("Unexpected calling before all generate for rosetta -" + _message);
        String _plus_1 = (_plus + 
          " - see debug logging for more");
        RosettaGenerator.LOGGER.warn(_plus_1);
        RosettaGenerator.LOGGER.debug("Unexpected calling before all generate for rosetta", e_1);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    } finally {
      lock.releaseWriteLock();
    }
  }

  @Override
  public void beforeGenerate(final Resource resource, final IFileSystemAccess2 fsa2, final IGeneratorContext context) {
    boolean _contains = this.ignoredFiles.contains(IterableExtensions.<Object>last(((Iterable<Object>)Conversions.doWrapArray(resource.getURI().segments()))));
    boolean _not = (!_contains);
    if (_not) {
      String _string = resource.getURI().toString();
      String _plus = ("Starting the before generate method for " + _string);
      RosettaGenerator.LOGGER.trace(_plus);
      final Function<ResourceSet, DemandableLock> _function = (ResourceSet it) -> {
        return new DemandableLock();
      };
      final DemandableLock lock = this.locks.computeIfAbsent(resource.getResourceSet(), _function);
      final IFileSystemAccess2 fsa = this.fsaFactory.resourceAwareFSA(resource, fsa2, true);
      try {
        lock.getWriteLock(true);
        this.fsaFactory.beforeGenerate(resource);
        EObject _head = IterableExtensions.<EObject>head(resource.getContents());
        final RosettaModel model = ((RosettaModel) _head);
        boolean _shouldGenerate = this.shouldGenerate(model);
        boolean _not_1 = (!_shouldGenerate);
        if (_not_1) {
          return;
        }
        final String version = model.getVersion();
        final Consumer<ExternalGenerator> _function_1 = (ExternalGenerator generator) -> {
          final Consumer<Map<String, ? extends CharSequence>> _function_2 = (Map<String, ? extends CharSequence> map) -> {
            final Consumer<Map.Entry<String, ? extends CharSequence>> _function_3 = (Map.Entry<String, ? extends CharSequence> it) -> {
              fsa.generateFile(it.getKey(), generator.getOutputConfiguration().getName(), it.getValue());
            };
            map.entrySet().forEach(_function_3);
          };
          generator.beforeGenerate(resource, model, version, _function_2, lock);
        };
        this.externalGenerators.forEach(_function_1);
      } catch (final Throwable _t) {
        if (_t instanceof CancellationException) {
          RosettaGenerator.LOGGER.trace("Code generation cancelled, this is expected");
        } else if (_t instanceof Exception) {
          final Exception e_1 = (Exception)_t;
          String _message = e_1.getMessage();
          String _plus_1 = ("Unexpected calling before generate for rosetta -" + _message);
          String _plus_2 = (_plus_1 + 
            " - see debug logging for more");
          RosettaGenerator.LOGGER.warn(_plus_2);
          RosettaGenerator.LOGGER.debug("Unexpected calling before generate for rosetta", e_1);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      } finally {
        lock.releaseWriteLock();
      }
    }
  }

  @Override
  public void doGenerate(final Resource resource, final IFileSystemAccess2 fsa2, final IGeneratorContext context) {
    boolean _contains = this.ignoredFiles.contains(IterableExtensions.<Object>last(((Iterable<Object>)Conversions.doWrapArray(resource.getURI().segments()))));
    boolean _not = (!_contains);
    if (_not) {
      String _string = resource.getURI().toString();
      String _plus = ("Starting the main generate method for " + _string);
      RosettaGenerator.LOGGER.trace(_plus);
      final IFileSystemAccess2 fsa = this.fsaFactory.resourceAwareFSA(resource, fsa2, false);
      final Function<ResourceSet, DemandableLock> _function = (ResourceSet it) -> {
        return new DemandableLock();
      };
      final DemandableLock lock = this.locks.computeIfAbsent(resource.getResourceSet(), _function);
      try {
        lock.getWriteLock(true);
        EObject _head = IterableExtensions.<EObject>head(resource.getContents());
        final RosettaModel model = ((RosettaModel) _head);
        boolean _shouldGenerate = this.shouldGenerate(model);
        boolean _not_1 = (!_shouldGenerate);
        if (_not_1) {
          return;
        }
        final String version = model.getVersion();
        final RosettaJavaPackages.RootPackage packages = new RosettaJavaPackages.RootPackage(model);
        final Consumer<RosettaRootElement> _function_1 = (RosettaRootElement it) -> {
          boolean _isCanceled = context.getCancelIndicator().isCanceled();
          if (_isCanceled) {
            return;
          }
          boolean _matched = false;
          if (it instanceof Data) {
            _matched=true;
            this.dataGenerator.generate(packages, fsa, ((Data)it), version);
            this.metaGenerator.generate(packages, fsa, ((Data)it), version);
            this.validatorsGenerator.generate(packages, fsa, ((Data)it), version);
            final Consumer<Condition> _function_2 = (Condition cond) -> {
              this.conditionGenerator.generate(packages, fsa, ((Data)it), cond, version);
            };
            ((Data)it).getConditions().forEach(_function_2);
            this.tabulatorGenerator.generate(fsa, ((Data)it), Optional.<RosettaExternalRuleSource>empty());
            RDataType _rDataType = new RDataType(((Data)it));
            boolean _isEligibleForDeepFeatureCall = this.deepFeatureCallUtil.isEligibleForDeepFeatureCall(_rDataType);
            if (_isEligibleForDeepFeatureCall) {
              this.deepPathUtilGenerator.generate(fsa, ((Data)it), version);
            }
          }
          if (!_matched) {
            if (it instanceof com.regnosys.rosetta.rosetta.simple.Function) {
              _matched=true;
              Boolean _isDispatchingFunction = this._rosettaFunctionExtensions.isDispatchingFunction(((com.regnosys.rosetta.rosetta.simple.Function)it));
              boolean _not_2 = (!(_isDispatchingFunction).booleanValue());
              if (_not_2) {
                this.funcGenerator.generate(packages, fsa, ((com.regnosys.rosetta.rosetta.simple.Function)it), version);
              }
              this.tabulatorGenerator.generate(fsa, ((com.regnosys.rosetta.rosetta.simple.Function)it));
            }
          }
          if (!_matched) {
            if (it instanceof RosettaRule) {
              _matched=true;
              this.ruleGenerator.generate(packages, fsa, ((RosettaRule)it), version);
            }
          }
          if (!_matched) {
            if (it instanceof RosettaReport) {
              _matched=true;
              this.reportGenerator.generate(packages, fsa, ((RosettaReport)it), version);
              this.tabulatorGenerator.generate(fsa, ((RosettaReport)it));
            }
          }
          if (!_matched) {
            if (it instanceof RosettaExternalRuleSource) {
              _matched=true;
              final Consumer<RosettaExternalClass> _function_2 = (RosettaExternalClass externalClass) -> {
                this.tabulatorGenerator.generate(fsa, externalClass.getData(), Optional.<RosettaExternalRuleSource>of(((RosettaExternalRuleSource)it)));
              };
              ((RosettaExternalRuleSource)it).getExternalClasses().forEach(_function_2);
            }
          }
        };
        model.getElements().forEach(_function_1);
        this.enumGenerator.generate(packages, fsa, model.getElements(), version);
        final Consumer<ExternalGenerator> _function_2 = (ExternalGenerator generator) -> {
          final Consumer<Map<String, ? extends CharSequence>> _function_3 = (Map<String, ? extends CharSequence> map) -> {
            final Consumer<Map.Entry<String, ? extends CharSequence>> _function_4 = (Map.Entry<String, ? extends CharSequence> it) -> {
              fsa.generateFile(it.getKey(), generator.getOutputConfiguration().getName(), it.getValue());
            };
            map.entrySet().forEach(_function_4);
          };
          generator.generate(resource, model, version, _function_3, lock);
        };
        this.externalGenerators.forEach(_function_2);
        this.metaFieldGenerator.generate(resource, fsa, context);
      } catch (final Throwable _t) {
        if (_t instanceof CancellationException) {
          RosettaGenerator.LOGGER.trace("Code generation cancelled, this is expected");
        } else if (_t instanceof Exception) {
          final Exception e_1 = (Exception)_t;
          String _message = e_1.getMessage();
          String _plus_1 = ("Unexpected calling standard generate for rosetta -" + _message);
          String _plus_2 = (_plus_1 + " - see debug logging for more");
          RosettaGenerator.LOGGER.warn(_plus_2);
          RosettaGenerator.LOGGER.info("Unexpected calling standard generate for rosetta", e_1);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      } finally {
        RosettaGenerator.LOGGER.trace("ending the main generate method");
        lock.releaseWriteLock();
      }
    }
  }

  @Override
  public void afterGenerate(final Resource resource, final IFileSystemAccess2 fsa2, final IGeneratorContext context) {
    boolean _contains = this.ignoredFiles.contains(IterableExtensions.<Object>last(((Iterable<Object>)Conversions.doWrapArray(resource.getURI().segments()))));
    boolean _not = (!_contains);
    if (_not) {
      String _string = resource.getURI().toString();
      String _plus = ("Starting the after generate method for " + _string);
      RosettaGenerator.LOGGER.trace(_plus);
      final Function<ResourceSet, DemandableLock> _function = (ResourceSet it) -> {
        return new DemandableLock();
      };
      final DemandableLock lock = this.locks.computeIfAbsent(resource.getResourceSet(), _function);
      final IFileSystemAccess2 fsa = this.fsaFactory.resourceAwareFSA(resource, fsa2, true);
      try {
        lock.getWriteLock(true);
        EObject _head = IterableExtensions.<EObject>head(resource.getContents());
        final RosettaModel model = ((RosettaModel) _head);
        boolean _shouldGenerate = this.shouldGenerate(model);
        boolean _not_1 = (!_shouldGenerate);
        if (_not_1) {
          return;
        }
        final String version = model.getVersion();
        final Consumer<ExternalGenerator> _function_1 = (ExternalGenerator generator) -> {
          final Consumer<Map<String, ? extends CharSequence>> _function_2 = (Map<String, ? extends CharSequence> map) -> {
            final Consumer<Map.Entry<String, ? extends CharSequence>> _function_3 = (Map.Entry<String, ? extends CharSequence> it) -> {
              fsa.generateFile(it.getKey(), generator.getOutputConfiguration().getName(), it.getValue());
            };
            map.entrySet().forEach(_function_3);
          };
          generator.afterGenerate(resource, model, version, _function_2, lock);
        };
        this.externalGenerators.forEach(_function_1);
        this.fsaFactory.afterGenerate(resource);
        final Function1<Resource, Boolean> _function_2 = (Resource it) -> {
          boolean _contains_1 = this.ignoredFiles.contains(IterableExtensions.<Object>last(((Iterable<Object>)Conversions.doWrapArray(it.getURI().segments()))));
          return Boolean.valueOf((!_contains_1));
        };
        final Function1<Resource, RosettaModel> _function_3 = (Resource it) -> {
          EObject _head_1 = IterableExtensions.<EObject>head(it.getContents());
          return ((RosettaModel) _head_1);
        };
        final Function1<RosettaModel, Boolean> _function_4 = (RosettaModel it) -> {
          return Boolean.valueOf(this.shouldGenerate(it));
        };
        final List<RosettaModel> models = IterableExtensions.<RosettaModel>toList(IterableExtensions.<RosettaModel>filter(IterableExtensions.<Resource, RosettaModel>map(IterableExtensions.<Resource>filter(resource.getResourceSet().getResources(), _function_2), _function_3), _function_4));
        this.javaPackageInfoGenerator.generatePackageInfoClasses(fsa2, models);
      } catch (final Throwable _t) {
        if (_t instanceof CancellationException) {
          RosettaGenerator.LOGGER.trace("Code generation cancelled, this is expected");
        } else if (_t instanceof Exception) {
          final Exception e_1 = (Exception)_t;
          String _message = e_1.getMessage();
          String _plus_1 = ("Unexpected calling after generate for rosetta -" + _message);
          String _plus_2 = (_plus_1 + 
            " - see debug logging for more");
          RosettaGenerator.LOGGER.warn(_plus_2);
          RosettaGenerator.LOGGER.debug("Unexpected calling after generate for rosetta", e_1);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      } finally {
        lock.releaseWriteLock();
      }
    }
  }

  public void afterAllGenerate(final ResourceSet resourceSet, final IFileSystemAccess2 fsa2, final IGeneratorContext context) {
    RosettaGenerator.LOGGER.trace("Starting the after all generate method");
    final Function<ResourceSet, DemandableLock> _function = (ResourceSet it) -> {
      return new DemandableLock();
    };
    final DemandableLock lock = this.locks.computeIfAbsent(resourceSet, _function);
    try {
      lock.getWriteLock(true);
      final Function1<Resource, Boolean> _function_1 = (Resource it) -> {
        boolean _contains = this.ignoredFiles.contains(IterableExtensions.<Object>last(((Iterable<Object>)Conversions.doWrapArray(it.getURI().segments()))));
        return Boolean.valueOf((!_contains));
      };
      final Function1<Resource, RosettaModel> _function_2 = (Resource it) -> {
        EObject _head = IterableExtensions.<EObject>head(it.getContents());
        return ((RosettaModel) _head);
      };
      final Function1<RosettaModel, Boolean> _function_3 = (RosettaModel it) -> {
        return Boolean.valueOf(this.shouldGenerate(it));
      };
      final List<RosettaModel> models = IterableExtensions.<RosettaModel>toList(IterableExtensions.<RosettaModel>filter(IterableExtensions.<Resource, RosettaModel>map(IterableExtensions.<Resource>filter(resourceSet.getResources(), _function_1), _function_2), _function_3));
      RosettaModel _head = IterableExtensions.<RosettaModel>head(models);
      String _version = null;
      if (_head!=null) {
        _version=_head.getVersion();
      }
      final String version = _version;
      final Consumer<ExternalGenerator> _function_4 = (ExternalGenerator generator) -> {
        final Consumer<Map<String, ? extends CharSequence>> _function_5 = (Map<String, ? extends CharSequence> map) -> {
          final Consumer<Map.Entry<String, ? extends CharSequence>> _function_6 = (Map.Entry<String, ? extends CharSequence> it) -> {
            fsa2.generateFile(it.getKey(), generator.getOutputConfiguration().getName(), it.getValue());
          };
          map.entrySet().forEach(_function_6);
        };
        generator.afterAllGenerate(resourceSet, models, version, _function_5, lock);
      };
      this.externalGenerators.forEach(_function_4);
    } catch (final Throwable _t) {
      if (_t instanceof CancellationException) {
        RosettaGenerator.LOGGER.trace("Code generation cancelled, this is expected");
      } else if (_t instanceof Exception) {
        final Exception e_1 = (Exception)_t;
        String _message = e_1.getMessage();
        String _plus = ("Unexpected calling after all generate for rosetta -" + _message);
        String _plus_1 = (_plus + 
          " - see debug logging for more");
        RosettaGenerator.LOGGER.warn(_plus_1);
        RosettaGenerator.LOGGER.debug("Unexpected calling after all generate for rosetta", e_1);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    } finally {
      lock.releaseWriteLock();
    }
  }

  private boolean shouldGenerate(final RosettaModel model) {
    return (this.config.getNamespaceFilter().test(model.getName()) || model.isOverridden());
  }
}
