package com.regnosys.rosetta.generator;

import com.regnosys.rosetta.generator.external.ExternalGenerator;
import com.regnosys.rosetta.generator.external.ExternalGenerators;
import com.regnosys.rosetta.generator.external.ExternalOutputConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class RosettaOutputConfigurationProvider extends OutputConfigurationProvider {
  @Inject
  private ExternalGenerators externalGeneratorsProvider;

  public static final String SRC_GEN_JAVA_OUTPUT = IFileSystemAccess.DEFAULT_OUTPUT;

  public static final String SRC_TEST_GEN_JAVA_OUTPUT = "SRC_TEST_GEN_JAVA_OUTPUT";

  public static final String SRC_MAIN_JAVA_OUTPUT = "SRC_MAIN_JAVA_OUTPUT";

  public static final String SRC_GEN_DAML_OUTPUT = "SRC_GEN_DAML_OUTPUT";

  @Override
  public Set<OutputConfiguration> getOutputConfigurations() {
    Collection<OutputConfiguration> _values = this.getOutConfigMap().values();
    final HashSet<OutputConfiguration> result = new HashSet<OutputConfiguration>(_values);
    final Function1<ExternalGenerator, ExternalOutputConfiguration> _function = (ExternalGenerator it) -> {
      return it.getOutputConfiguration();
    };
    final Function1<ExternalOutputConfiguration, OutputConfiguration> _function_1 = (ExternalOutputConfiguration it) -> {
      return this.inflate(it);
    };
    final Consumer<OutputConfiguration> _function_2 = (OutputConfiguration it) -> {
      result.add(it);
    };
    IterableExtensions.<ExternalOutputConfiguration, OutputConfiguration>map(IterableExtensions.<ExternalGenerator, ExternalOutputConfiguration>map(this.externalGeneratorsProvider, _function), _function_1).forEach(_function_2);
    return result;
  }

  public Map<String, OutputConfiguration> getOutConfigMap() {
    HashMap<String, OutputConfiguration> _xblockexpression = null;
    {
      OutputConfiguration srcGenJava = new OutputConfiguration(RosettaOutputConfigurationProvider.SRC_GEN_JAVA_OUTPUT);
      srcGenJava.setOutputDirectory("./src/generated/java");
      srcGenJava.setDescription("Generated Java Output Folder");
      srcGenJava.setOverrideExistingResources(true);
      srcGenJava.setCanClearOutputDirectory(true);
      srcGenJava.setCreateOutputDirectory(true);
      srcGenJava.setCleanUpDerivedResources(true);
      srcGenJava.setSetDerivedProperty(true);
      srcGenJava.setKeepLocalHistory(Boolean.valueOf(true));
      OutputConfiguration srcMainJava = new OutputConfiguration(RosettaOutputConfigurationProvider.SRC_MAIN_JAVA_OUTPUT);
      srcMainJava.setOutputDirectory("./src/main/java");
      srcMainJava.setDescription("Java Main Output Folder");
      srcMainJava.setOverrideExistingResources(false);
      srcMainJava.setCanClearOutputDirectory(false);
      srcMainJava.setCreateOutputDirectory(false);
      srcMainJava.setCleanUpDerivedResources(false);
      srcMainJava.setSetDerivedProperty(false);
      srcMainJava.setKeepLocalHistory(Boolean.valueOf(false));
      OutputConfiguration srcTestJava = new OutputConfiguration(RosettaOutputConfigurationProvider.SRC_TEST_GEN_JAVA_OUTPUT);
      srcTestJava.setOutputDirectory("./src/test/generated/java");
      srcTestJava.setDescription("Java Tests Output Folder");
      srcTestJava.setOverrideExistingResources(true);
      srcTestJava.setCanClearOutputDirectory(true);
      srcTestJava.setCreateOutputDirectory(true);
      srcTestJava.setCleanUpDerivedResources(true);
      srcTestJava.setSetDerivedProperty(true);
      srcTestJava.setKeepLocalHistory(Boolean.valueOf(false));
      OutputConfiguration srcGenDaml = new OutputConfiguration(RosettaOutputConfigurationProvider.SRC_GEN_DAML_OUTPUT);
      srcGenDaml.setOutputDirectory("./src/generated/daml");
      srcGenDaml.setDescription("Generated DAML Output Folder");
      srcGenDaml.setOverrideExistingResources(true);
      srcGenDaml.setCanClearOutputDirectory(true);
      srcGenDaml.setCreateOutputDirectory(true);
      srcGenDaml.setCleanUpDerivedResources(true);
      srcGenDaml.setSetDerivedProperty(true);
      srcGenDaml.setKeepLocalHistory(Boolean.valueOf(true));
      final HashMap<String, OutputConfiguration> result = new HashMap<String, OutputConfiguration>();
      result.put(RosettaOutputConfigurationProvider.SRC_GEN_JAVA_OUTPUT, srcGenJava);
      result.put(RosettaOutputConfigurationProvider.SRC_MAIN_JAVA_OUTPUT, srcMainJava);
      result.put(RosettaOutputConfigurationProvider.SRC_GEN_DAML_OUTPUT, srcGenDaml);
      result.put(RosettaOutputConfigurationProvider.SRC_TEST_GEN_JAVA_OUTPUT, srcTestJava);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  private OutputConfiguration inflate(@Extension final ExternalOutputConfiguration minimalConfig) {
    String _name = minimalConfig.getName();
    final OutputConfiguration config = new OutputConfiguration(_name);
    String _directory = minimalConfig.getDirectory();
    String _plus = ("./src/generated/" + _directory);
    config.setOutputDirectory(_plus);
    config.setDescription(minimalConfig.getDescription());
    config.setOverrideExistingResources(true);
    config.setCanClearOutputDirectory(true);
    config.setCreateOutputDirectory(true);
    config.setCleanUpDerivedResources(true);
    config.setSetDerivedProperty(true);
    config.setKeepLocalHistory(Boolean.valueOf(true));
    return config;
  }
}
