package com.regnosys.rosetta.generator.java.condition;

import com.google.inject.ImplementedBy;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.ImplicitVariableRepresentation;
import com.regnosys.rosetta.generator.java.JavaIdentifierRepresentationService;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.expression.ExpressionGenerator;
import com.regnosys.rosetta.generator.java.expression.JavaDependencyProvider;
import com.regnosys.rosetta.generator.java.statement.JavaBlock;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.generator.java.util.RosettaGrammarUtil;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RDataType;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ConditionGenerator {
  @Inject
  private ExpressionGenerator expressionHandler;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  private JavaDependencyProvider dependencies;

  @Inject
  @Extension
  private JavaIdentifierRepresentationService _javaIdentifierRepresentationService;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;

  public void generate(final RosettaJavaPackages.RootPackage root, final IFileSystemAccess2 fsa, final Data data, final Condition ele, final String version) {
    DottedPath _condition = root.condition();
    final JavaScope topScope = new JavaScope(_condition);
    final StringConcatenationClient classBody = this.conditionClassBody(ele, data, topScope, version);
    final String content = this._importManagerExtension.buildClass(root.condition(), classBody, topScope);
    StringConcatenation _builder = new StringConcatenation();
    String _withForwardSlashes = root.condition().withForwardSlashes();
    _builder.append(_withForwardSlashes);
    _builder.append("/");
    String _conditionJavaType = this._rosettaExtensions.toConditionJavaType(this._rosettaExtensions.conditionName(ele, data));
    _builder.append(_conditionJavaType);
    _builder.append(".java");
    fsa.generateFile(_builder.toString(), content);
  }

  private StringConcatenationClient conditionClassBody(final Condition rule, final Data data, final JavaScope scope, final String version) {
    StringConcatenationClient _xblockexpression = null;
    {
      EObject _eContainer = rule.eContainer();
      final Data rosettaClass = ((Data) _eContainer);
      final String definition = RosettaGrammarUtil.quote(RosettaGrammarUtil.extractNodeText(rule, SimplePackage.Literals.CONDITION__EXPRESSION));
      final String ruleName = this._rosettaExtensions.conditionName(rule, data);
      final String className = this._rosettaExtensions.toConditionJavaType(ruleName);
      final List<JavaClass<?>> deps = this.dependencies.javaDependencies(rule.getExpression());
      final ImplicitVariableRepresentation implicitVarRepr = this._javaIdentifierRepresentationService.getImplicitVarInContext(rule);
      final JavaScope classScope = scope.classScope(this._rosettaExtensions.toConditionJavaType(ruleName));
      final JavaScope validateScope = classScope.methodScope("validate");
      final GeneratedIdentifier pathId = validateScope.createUniqueIdentifier("path");
      final JavaScope defaultClassScope = classScope.classScope("Default");
      final GeneratedIdentifier defaultClassName = defaultClassScope.createUniqueIdentifier("Default");
      final Consumer<JavaClass<?>> _function = (JavaClass<?> it) -> {
        defaultClassScope.createIdentifier(this._javaIdentifierRepresentationService.toDependencyInstance(it), StringExtensions.toFirstLower(it.getSimpleName()));
      };
      deps.forEach(_function);
      final JavaScope defaultClassValidateScope = defaultClassScope.methodScope("validate");
      final GeneratedIdentifier defaultClassPathId = defaultClassValidateScope.createUniqueIdentifier("path");
      final GeneratedIdentifier defaultClassResultId = defaultClassValidateScope.createUniqueIdentifier("result");
      final GeneratedIdentifier defaultClassFailureMessageId = defaultClassValidateScope.createUniqueIdentifier("failureMessage");
      final JavaScope defaultClassExecuteScope = defaultClassScope.methodScope("execute");
      final GeneratedIdentifier defaultClassExceptionId = defaultClassExecuteScope.createUniqueIdentifier("ex");
      final JavaScope noOpClassScope = classScope.classScope("NoOp");
      final GeneratedIdentifier noOpClassName = noOpClassScope.createUniqueIdentifier("NoOp");
      final JavaScope noOpClassValidateScope = noOpClassScope.methodScope("validate");
      final GeneratedIdentifier noOpClassPathId = noOpClassValidateScope.createUniqueIdentifier("path");
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          CharSequence _emptyJavadocWithVersion = ModelGeneratorUtil.emptyJavadocWithVersion(version);
          _builder.append(_emptyJavadocWithVersion);
          _builder.newLineIfNotEmpty();
          _builder.append("@");
          _builder.append(RosettaDataRule.class);
          _builder.append("(\"");
          _builder.append(ruleName);
          _builder.append("\")");
          _builder.newLineIfNotEmpty();
          _builder.append("@");
          _builder.append(ImplementedBy.class);
          _builder.append("(");
          _builder.append(className);
          _builder.append(".Default.class)");
          _builder.newLineIfNotEmpty();
          _builder.append("public interface ");
          _builder.append(className);
          _builder.append(" extends ");
          _builder.append(Validator.class);
          _builder.append("<");
          JavaClass<?> _javaType = ConditionGenerator.this._javaTypeTranslator.toJavaType(new RDataType(rosettaClass));
          _builder.append(_javaType);
          _builder.append("> {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("String NAME = \"");
          _builder.append(ruleName, "\t");
          _builder.append("\";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("String DEFINITION = ");
          _builder.append(definition, "\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(ValidationResult.class, "\t");
          _builder.append("<");
          String _name = rosettaClass.getName();
          _builder.append(_name, "\t");
          _builder.append("> validate(");
          _builder.append(RosettaPath.class, "\t");
          _builder.append(" ");
          _builder.append(pathId, "\t");
          _builder.append(", ");
          String _name_1 = rosettaClass.getName();
          _builder.append(_name_1, "\t");
          _builder.append(" ");
          GeneratedIdentifier _createIdentifier = validateScope.createIdentifier(implicitVarRepr, StringExtensions.toFirstLower(rosettaClass.getName()));
          _builder.append(_createIdentifier, "\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("class ");
          _builder.append(defaultClassName, "\t");
          _builder.append(" implements ");
          _builder.append(className, "\t");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.newLine();
          {
            for(final JavaClass<?> dep : deps) {
              _builder.append("\t\t");
              _builder.append("@");
              _builder.append(Inject.class, "\t\t");
              _builder.append(" protected ");
              _builder.append(dep, "\t\t");
              _builder.append(" ");
              GeneratedIdentifier _identifierOrThrow = defaultClassScope.getIdentifierOrThrow(ConditionGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(dep));
              _builder.append(_identifierOrThrow, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.newLine();
            }
          }
          _builder.append("\t\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("public ");
          _builder.append(ValidationResult.class, "\t\t");
          _builder.append("<");
          String _name_2 = rosettaClass.getName();
          _builder.append(_name_2, "\t\t");
          _builder.append("> validate(");
          _builder.append(RosettaPath.class, "\t\t");
          _builder.append(" ");
          _builder.append(defaultClassPathId, "\t\t");
          _builder.append(", ");
          String _name_3 = rosettaClass.getName();
          _builder.append(_name_3, "\t\t");
          _builder.append(" ");
          GeneratedIdentifier _createIdentifier_1 = defaultClassValidateScope.createIdentifier(implicitVarRepr, StringExtensions.toFirstLower(rosettaClass.getName()));
          _builder.append(_createIdentifier_1, "\t\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append(ComparisonResult.class, "\t\t\t");
          _builder.append(" ");
          _builder.append(defaultClassResultId, "\t\t\t");
          _builder.append(" = executeDataRule(");
          GeneratedIdentifier _identifierOrThrow_1 = defaultClassValidateScope.getIdentifierOrThrow(implicitVarRepr);
          _builder.append(_identifierOrThrow_1, "\t\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("if (result.get()) {");
          _builder.newLine();
          _builder.append("\t\t\t\t");
          _builder.append("return ");
          _builder.append(ValidationResult.class, "\t\t\t\t");
          _builder.append(".success(NAME, ValidationResult.ValidationType.DATA_RULE, \"");
          String _name_4 = rosettaClass.getName();
          _builder.append(_name_4, "\t\t\t\t");
          _builder.append("\", ");
          _builder.append(defaultClassPathId, "\t\t\t\t");
          _builder.append(", DEFINITION);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("String ");
          _builder.append(defaultClassFailureMessageId, "\t\t\t");
          _builder.append(" = ");
          _builder.append(defaultClassResultId, "\t\t\t");
          _builder.append(".getError();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("if (");
          _builder.append(defaultClassFailureMessageId, "\t\t\t");
          _builder.append(" == null || ");
          _builder.append(defaultClassFailureMessageId, "\t\t\t");
          _builder.append(".contains(\"Null\") || ");
          _builder.append(defaultClassFailureMessageId, "\t\t\t");
          _builder.append(" == \"\") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t\t");
          _builder.append(defaultClassFailureMessageId, "\t\t\t\t");
          _builder.append(" = \"Condition has failed.\";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("return ");
          _builder.append(ValidationResult.class, "\t\t\t");
          _builder.append(".failure(NAME, ");
          _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
          _builder.append(".DATA_RULE, \"");
          String _name_5 = rosettaClass.getName();
          _builder.append(_name_5, "\t\t\t");
          _builder.append("\", ");
          _builder.append(defaultClassPathId, "\t\t\t");
          _builder.append(", DEFINITION, ");
          _builder.append(defaultClassFailureMessageId, "\t\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("private ");
          _builder.append(ComparisonResult.class, "\t\t");
          _builder.append(" executeDataRule(");
          String _name_6 = rosettaClass.getName();
          _builder.append(_name_6, "\t\t");
          _builder.append(" ");
          GeneratedIdentifier _createIdentifier_2 = defaultClassExecuteScope.createIdentifier(implicitVarRepr, StringExtensions.toFirstLower(rosettaClass.getName()));
          _builder.append(_createIdentifier_2, "\t\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("try ");
          JavaBlock _block = ConditionGenerator.this.expressionHandler.javaCode(rule.getExpression(), ConditionGenerator.this._javaTypeUtil.COMPARISON_RESULT, defaultClassExecuteScope).completeAsReturn().toBlock();
          _builder.append(_block, "\t\t\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("catch (");
          _builder.append(Exception.class, "\t\t\t");
          _builder.append(" ");
          _builder.append(defaultClassExceptionId, "\t\t\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t\t");
          _builder.append("return ");
          _builder.append(ComparisonResult.class, "\t\t\t\t");
          _builder.append(".failure(");
          _builder.append(defaultClassExceptionId, "\t\t\t\t");
          _builder.append(".getMessage());");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@SuppressWarnings(\"unused\")");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("class ");
          _builder.append(noOpClassName, "\t");
          _builder.append(" implements ");
          _builder.append(className, "\t");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("public ");
          _builder.append(ValidationResult.class, "\t\t");
          _builder.append("<");
          String _name_7 = rosettaClass.getName();
          _builder.append(_name_7, "\t\t");
          _builder.append("> validate(");
          _builder.append(RosettaPath.class, "\t\t");
          _builder.append(" ");
          _builder.append(noOpClassPathId, "\t\t");
          _builder.append(", ");
          String _name_8 = rosettaClass.getName();
          _builder.append(_name_8, "\t\t");
          _builder.append(" ");
          GeneratedIdentifier _createIdentifier_3 = noOpClassValidateScope.createIdentifier(implicitVarRepr, StringExtensions.toFirstLower(rosettaClass.getName()));
          _builder.append(_createIdentifier_3, "\t\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          _builder.append("return ");
          _builder.append(ValidationResult.class, "\t\t\t");
          _builder.append(".success(NAME, ValidationResult.ValidationType.DATA_RULE, \"");
          String _name_9 = rosettaClass.getName();
          _builder.append(_name_9, "\t\t\t");
          _builder.append("\", ");
          _builder.append(noOpClassPathId, "\t\t\t");
          _builder.append(", DEFINITION);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }
}
