package com.regnosys.rosetta.generator.java.enums;

import com.google.common.base.CaseFormat;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class EnumHelper {
  public static String convertValuesWithDisplay(final RosettaEnumValue enumValue) {
    String _formatEnumName = EnumHelper.formatEnumName(enumValue.getName());
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("(\"");
    String _name = enumValue.getName();
    _builder.append(_name);
    _builder.append("\"");
    {
      String _display = enumValue.getDisplay();
      boolean _tripleNotEquals = (_display != null);
      if (_tripleNotEquals) {
        _builder.append(", \"");
        String _display_1 = enumValue.getDisplay();
        _builder.append(_display_1);
        _builder.append("\"");
      }
    }
    _builder.append(")");
    return (_formatEnumName + _builder);
  }

  public static String convertValues(final RosettaEnumValue enumValue) {
    return EnumHelper.formatEnumName(enumValue.getName());
  }

  public static String formatEnumName(final String name) {
    boolean _noFormattingRequired = EnumHelper.noFormattingRequired(name);
    if (_noFormattingRequired) {
      return name;
    }
    final Function<String, List<String>> _function = (String it) -> {
      return EnumHelper.splitAtUnderscore(it);
    };
    final Function<List<String>, Stream<String>> _function_1 = (List<String> it) -> {
      return it.stream();
    };
    final Function<String, List<String>> _function_2 = (String it) -> {
      return EnumHelper.splitAtCamelCase(it);
    };
    final Function<List<String>, Stream<String>> _function_3 = (List<String> it) -> {
      return it.stream();
    };
    final Function<String, String> _function_4 = (String it) -> {
      return EnumHelper.camelCaseToUpperUnderscoreCase(it);
    };
    final Function<String, String> _function_5 = (String it) -> {
      return it.toUpperCase();
    };
    final List<String> parts = Arrays.<String>asList(EnumHelper.splitAtNumbers(EnumHelper.replaceSeparatorsWithUnderscores(name))).stream().<List<String>>map(_function).<String>flatMap(_function_1).<List<String>>map(_function_2).<String>flatMap(_function_3).<String>map(_function_4).<String>map(_function_5).collect(Collectors.<String>toList());
    return EnumHelper.removeDuplicateUnderscores(EnumHelper.prefixWithUnderscoreIfStartsWithNumber(String.join("_", parts)));
  }

  private static boolean noFormattingRequired(final String name) {
    return name.matches("^[A-Z0-9_]*$");
  }

  private static String replaceSeparatorsWithUnderscores(final String name) {
    return name.replace(".", "_").replace("-", "_").replace(" ", "_");
  }

  private static List<String> splitAtCamelCase(final String namePart) {
    return Arrays.<String>asList(namePart.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])"));
  }

  private static List<String> splitAtUnderscore(final String namePart) {
    return Arrays.<String>asList(namePart.split("_"));
  }

  private static String[] splitAtNumbers(final String namePart) {
    return namePart.split("(?=[X])(?<=[^X])|(?=[^X])(?<=[X])".replace("X", "\\d"));
  }

  private static String camelCaseToUpperUnderscoreCase(final String namePart) {
    if ((((!namePart.isEmpty()) && Character.isUpperCase(namePart.charAt(0))) && 
      Character.isLowerCase(namePart.charAt((namePart.length() - 1))))) {
      return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, namePart);
    }
    return namePart;
  }

  private static String removeDuplicateUnderscores(final String name) {
    return name.replace("__", "_");
  }

  private static String prefixWithUnderscoreIfStartsWithNumber(final String name) {
    boolean _isDigit = Character.isDigit(name.charAt(0));
    if (_isDigit) {
      return ("_" + name);
    } else {
      return name;
    }
  }
}
