package com.regnosys.rosetta.generator.java.expression;

import com.google.common.base.Objects;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaIdentifierRepresentationService;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.enums.EnumHelper;
import com.regnosys.rosetta.generator.java.statement.JavaLambdaBody;
import com.regnosys.rosetta.generator.java.statement.builder.JavaConditionalExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaIfThenElseBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaVariable;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.PreferWildcardImportMethod;
import com.regnosys.rosetta.generator.java.util.RecordJavaUtil;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumValueReference;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaParameter;
import com.regnosys.rosetta.rosetta.RosettaRecordFeature;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.CardinalityModifier;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.DistinctOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ExistsModifier;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FirstOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.LastOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.MaxOperation;
import com.regnosys.rosetta.rosetta.expression.MinOperation;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.Necessity;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.ReverseOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.expression.SortOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToEnumOperation;
import com.regnosys.rosetta.rosetta.expression.ToIntOperation;
import com.regnosys.rosetta.rosetta.expression.ToNumberOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.ToTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RShortcut;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaOperators;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.RosettaExpressionSwitch;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ExpressionGenerator extends RosettaExpressionSwitch<JavaStatementBuilder, ExpressionGenerator.Context> {
  public static class Context {
    public JavaType expectedType;

    public JavaScope scope;
  }

  @Inject
  protected RosettaTypeProvider typeProvider;

  @Inject
  private RosettaOperators operators;

  @Inject
  @Extension
  private CardinalityProvider cardinalityProvider;

  @Inject
  private RosettaFunctionExtensions funcExt;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  private ExpressionHelper exprHelper;

  @Inject
  @Extension
  private ImplicitVariableUtil _implicitVariableUtil;

  @Inject
  @Extension
  private JavaIdentifierRepresentationService _javaIdentifierRepresentationService;

  @Inject
  private RecordJavaUtil recordUtil;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  @Extension
  private TypeSystem _typeSystem;

  @Inject
  private RObjectFactory rObjectFactory;

  @Inject
  private TypeCoercionService typeCoercionService;

  @Inject
  @Extension
  private JavaTypeUtil typeUtil;

  /**
   * convert a rosetta expression to code
   * ParamMpa params  - a map keyed by classname or positional index that provides variable names for expression parameters
   */
  public JavaStatementBuilder javaCode(final RosettaExpression expr, final JavaType expectedType, final JavaScope scope) {
    ExpressionGenerator.Context _context = new ExpressionGenerator.Context();
    final Procedure1<ExpressionGenerator.Context> _function = (ExpressionGenerator.Context it) -> {
      it.expectedType = expectedType;
      it.scope = scope;
    };
    ExpressionGenerator.Context _doubleArrow = ObjectExtensions.<ExpressionGenerator.Context>operator_doubleArrow(_context, _function);
    final JavaStatementBuilder rawResult = this.doSwitch(expr, _doubleArrow);
    return this.typeCoercionService.addCoercions(rawResult, expectedType, scope);
  }

  private StringConcatenationClient runtimeMethod(final String methodName) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        PreferWildcardImportMethod _importWildcard = ExpressionGenerator.this._importManagerExtension.importWildcard(ExpressionGenerator.this._importManagerExtension.method(ExpressionOperators.class, methodName));
        _builder.append(_importWildcard);
      }
    };
    return _client;
  }

  private JavaStatementBuilder applyRuntimeMethod(final JavaStatementBuilder expr, final String methodName, final JavaType resultType) {
    final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod(methodName);
          _builder.append(_runtimeMethod);
          _builder.append("(");
          _builder.append(it);
          _builder.append(")");
        }
      };
      return JavaExpression.from(_client, resultType);
    };
    return expr.mapExpression(_function);
  }

  private JavaStatementBuilder callableWithArgsCall(final RosettaCallableWithArgs callable, final List<RosettaExpression> arguments, final JavaScope scope) {
    JavaStatementBuilder _switchResult = null;
    boolean _matched = false;
    if (callable instanceof com.regnosys.rosetta.rosetta.simple.Function) {
      _matched=true;
    }
    if (!_matched) {
      if (callable instanceof RosettaRule) {
        _matched=true;
      }
    }
    if (_matched) {
      JavaStatementBuilder _xblockexpression = null;
      {
        RFunction _xifexpression = null;
        if ((callable instanceof com.regnosys.rosetta.rosetta.simple.Function)) {
          _xifexpression = this.rObjectFactory.buildRFunction(((com.regnosys.rosetta.rosetta.simple.Function)callable));
        } else {
          _xifexpression = this.rObjectFactory.buildRFunction(((RosettaRule) callable));
        }
        final RFunction rCallable = _xifexpression;
        final JavaReferenceType outputType = this._javaTypeTranslator.attributeToJavaType(rCallable.getOutput());
        JavaStatementBuilder _xifexpression_1 = null;
        boolean _isEmpty = arguments.isEmpty();
        if (_isEmpty) {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(ExpressionGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(ExpressionGenerator.this._javaTypeTranslator.toFunctionJavaClass(rCallable)));
              _builder.append(_identifierOrThrow);
              _builder.append(".evaluate()");
            }
          };
          _xifexpression_1 = JavaExpression.from(_client, outputType);
        } else {
          JavaStatementBuilder _xblockexpression_1 = null;
          {
            JavaStatementBuilder argCode = this.javaCode(IterableExtensions.<RosettaExpression>head(arguments), this._javaTypeTranslator.attributeToJavaType(IterableExtensions.<RAttribute>head(rCallable.getInputs())), scope);
            for (int i = 1; (i < arguments.size()); i++) {
              final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression argList, JavaExpression newArg) -> {
                StringConcatenationClient _client_1 = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(argList);
                    _builder.append(", ");
                    _builder.append(newArg);
                  }
                };
                return JavaExpression.from(_client_1, null);
              };
              argCode = argCode.then(
                this.javaCode(arguments.get(i), this._javaTypeTranslator.attributeToJavaType(rCallable.getInputs().get(i)), scope), _function, scope);
            }
            final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
              StringConcatenationClient _client_1 = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(ExpressionGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(ExpressionGenerator.this._javaTypeTranslator.toFunctionJavaClass(rCallable)));
                  _builder.append(_identifierOrThrow);
                  _builder.append(".evaluate(");
                  _builder.append(it);
                  _builder.append(")");
                }
              };
              return JavaExpression.from(_client_1, outputType);
            };
            _xblockexpression_1 = argCode.collapseToSingleExpression(scope).mapExpression(_function);
          }
          _xifexpression_1 = _xblockexpression_1;
        }
        _xblockexpression = _xifexpression_1;
      }
      _switchResult = _xblockexpression;
    }
    if (!_matched) {
      if (callable instanceof RosettaExternalFunction) {
        _matched=true;
        JavaStatementBuilder _xblockexpression_1 = null;
        {
          final RType returnRType = this.typeProvider.getRTypeOfSymbol(callable);
          JavaStatementBuilder _xifexpression = null;
          boolean _isEmpty = arguments.isEmpty();
          if (_isEmpty) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("new ");
                JavaClass<RosettaFunction> _functionJavaClass = ExpressionGenerator.this._javaTypeTranslator.toFunctionJavaClass(((RosettaExternalFunction)callable));
                _builder.append(_functionJavaClass);
                _builder.append("().execute()");
              }
            };
            _xifexpression = JavaExpression.from(_client, this._javaTypeTranslator.toJavaReferenceType(returnRType));
          } else {
            JavaStatementBuilder _xblockexpression_2 = null;
            {
              JavaStatementBuilder argCode = null;
              final Function1<RosettaExpression, RType> _function = (RosettaExpression it) -> {
                return this.typeProvider.getRType(it);
              };
              final List<RType> argRTypes = ListExtensions.<RosettaExpression, RType>map(arguments, _function);
              JavaStatementBuilder _xifexpression_1 = null;
              final Function1<RType, Boolean> _function_1 = (RType it) -> {
                return Boolean.valueOf(this._typeSystem.isSubtypeOf(it, returnRType));
              };
              boolean _forall = IterableExtensions.<RType>forall(argRTypes, _function_1);
              if (_forall) {
                JavaStatementBuilder _xblockexpression_3 = null;
                {
                  final JavaReferenceType argAndReturnType = this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.join(argRTypes));
                  argCode = this.javaCode(IterableExtensions.<RosettaExpression>head(arguments), argAndReturnType, scope);
                  for (int i = 1; (i < arguments.size()); i++) {
                    final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression argList, JavaExpression newArg) -> {
                      StringConcatenationClient _client_1 = new StringConcatenationClient() {
                        @Override
                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                          _builder.append(argList);
                          _builder.append(", ");
                          _builder.append(newArg);
                        }
                      };
                      return JavaExpression.from(_client_1, null);
                    };
                    argCode = argCode.then(
                      this.javaCode(arguments.get(i), argAndReturnType, scope), _function_2, scope);
                  }
                  final Function<JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression it) -> {
                    StringConcatenationClient _client_1 = new StringConcatenationClient() {
                      @Override
                      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("new ");
                        JavaClass<RosettaFunction> _functionJavaClass = ExpressionGenerator.this._javaTypeTranslator.toFunctionJavaClass(((RosettaExternalFunction)callable));
                        _builder.append(_functionJavaClass);
                        _builder.append("().execute(");
                        _builder.append(it);
                        _builder.append(")");
                      }
                    };
                    return JavaExpression.from(_client_1, argAndReturnType);
                  };
                  _xblockexpression_3 = argCode.mapExpressionIfNotNull(_function_2);
                }
                _xifexpression_1 = _xblockexpression_3;
              } else {
                JavaStatementBuilder _xblockexpression_4 = null;
                {
                  argCode = this.javaCode(IterableExtensions.<RosettaExpression>head(arguments), this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.typeCallToRType(IterableExtensions.<RosettaParameter>head(((RosettaExternalFunction)callable).getParameters()).getTypeCall())), scope);
                  for (int i = 1; (i < arguments.size()); i++) {
                    final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression argList, JavaExpression newArg) -> {
                      StringConcatenationClient _client_1 = new StringConcatenationClient() {
                        @Override
                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                          _builder.append(argList);
                          _builder.append(", ");
                          _builder.append(newArg);
                        }
                      };
                      return JavaExpression.from(_client_1, null);
                    };
                    argCode = argCode.then(
                      this.javaCode(arguments.get(i), this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.typeCallToRType(((RosettaExternalFunction)callable).getParameters().get(i).getTypeCall())), scope), _function_2, scope);
                  }
                  final Function<JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression it) -> {
                    StringConcatenationClient _client_1 = new StringConcatenationClient() {
                      @Override
                      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("new ");
                        JavaClass<RosettaFunction> _functionJavaClass = ExpressionGenerator.this._javaTypeTranslator.toFunctionJavaClass(((RosettaExternalFunction)callable));
                        _builder.append(_functionJavaClass);
                        _builder.append("().execute(");
                        _builder.append(it);
                        _builder.append(")");
                      }
                    };
                    return JavaExpression.from(_client_1, this._javaTypeTranslator.toJavaReferenceType(returnRType));
                  };
                  _xblockexpression_4 = argCode.mapExpressionIfNotNull(_function_2);
                }
                _xifexpression_1 = _xblockexpression_4;
              }
              _xblockexpression_2 = _xifexpression_1;
            }
            _xifexpression = _xblockexpression_2;
          }
          _xblockexpression_1 = _xifexpression;
        }
        _switchResult = _xblockexpression_1;
      }
    }
    if (!_matched) {
      EClass _eClass = null;
      if (callable!=null) {
        _eClass=callable.eClass();
      }
      String _name = null;
      if (_eClass!=null) {
        _name=_eClass.getName();
      }
      String _plus = ("Unsupported callable with args of type " + _name);
      throw new UnsupportedOperationException(_plus);
    }
    return _switchResult;
  }

  private JavaStatementBuilder implicitVariable(final EObject context, final JavaScope scope) {
    JavaVariable _xblockexpression = null;
    {
      final JavaReferenceType itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.typeOfImplicitVariable(context));
      final EObject definingContainer = this._implicitVariableUtil.findContainerDefiningImplicitVariable(context).get();
      JavaType _xifexpression = null;
      if (((definingContainer instanceof Data) || (definingContainer instanceof RosettaRule))) {
        _xifexpression = itemType;
      } else {
        JavaType _xblockexpression_1 = null;
        {
          final RosettaFunctionalOperation f = ((RosettaFunctionalOperation) definingContainer);
          JavaType _xifexpression_1 = null;
          if (((f instanceof ThenOperation) && this.cardinalityProvider.isOutputListOfLists(f.getArgument()))) {
            JavaParameterizedType<MapperListOfLists<?>> _wrap = this.typeUtil.<MapperListOfLists<?>>wrap(this.typeUtil.MAPPER_LIST_OF_LISTS, itemType);
            _xifexpression_1 = ((JavaType) _wrap);
          } else {
            JavaType _xifexpression_2 = null;
            Boolean _isImplicitVariableMulti = this.cardinalityProvider.isImplicitVariableMulti(context);
            if ((_isImplicitVariableMulti).booleanValue()) {
              JavaParameterizedType<MapperC<?>> _wrap_1 = this.typeUtil.<MapperC<?>>wrap(this.typeUtil.MAPPER_C, itemType);
              _xifexpression_2 = ((JavaType) _wrap_1);
            } else {
              JavaParameterizedType<MapperS<?>> _wrap_2 = this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, itemType);
              _xifexpression_2 = ((JavaType) _wrap_2);
            }
            _xifexpression_1 = _xifexpression_2;
          }
          _xblockexpression_1 = _xifexpression_1;
        }
        _xifexpression = _xblockexpression_1;
      }
      final JavaType actualType = _xifexpression;
      GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(this._javaIdentifierRepresentationService.getImplicitVarInContext(context));
      _xblockexpression = new JavaVariable(_identifierOrThrow, actualType);
    }
    return _xblockexpression;
  }

  public StringConcatenationClient aliasCallArgs(final RShortcut alias, final RFunction function, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final RAttribute output = function.getOutput();
      final List<RAttribute> inputs = function.getInputs();
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            boolean _usesOutputParameter = ExpressionGenerator.this.exprHelper.usesOutputParameter(alias.getExpression());
            if (_usesOutputParameter) {
              GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(output);
              _builder.append(_identifierOrThrow);
              _builder.append(".toBuilder()");
              {
                boolean _isEmpty = inputs.isEmpty();
                boolean _not = (!_isEmpty);
                if (_not) {
                  _builder.append(", ");
                }
              }
            }
          }
          {
            boolean _hasElements = false;
            for(final RAttribute input : inputs) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(", ", "");
              }
              GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(input);
              _builder.append(_identifierOrThrow_1);
            }
          }
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient aliasCallArgs(final ShortcutDeclaration alias, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final com.regnosys.rosetta.rosetta.simple.Function func = EcoreUtil2.<com.regnosys.rosetta.rosetta.simple.Function>getContainerOfType(alias, com.regnosys.rosetta.rosetta.simple.Function.class);
      final RAttribute output = this.rObjectFactory.buildRAttribute(this.funcExt.getOutput(func));
      final Function1<Attribute, RAttribute> _function = (Attribute it) -> {
        return this.rObjectFactory.buildRAttribute(it);
      };
      final List<RAttribute> inputs = ListExtensions.<Attribute, RAttribute>map(this.funcExt.getInputs(func), _function);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            boolean _usesOutputParameter = ExpressionGenerator.this.exprHelper.usesOutputParameter(alias.getExpression());
            if (_usesOutputParameter) {
              GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(output);
              _builder.append(_identifierOrThrow);
              _builder.append(".toBuilder()");
              {
                boolean _isEmpty = inputs.isEmpty();
                boolean _not = (!_isEmpty);
                if (_not) {
                  _builder.append(", ");
                }
              }
            }
          }
          {
            boolean _hasElements = false;
            for(final RAttribute input : inputs) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(", ", "");
              }
              GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(input);
              _builder.append(_identifierOrThrow_1);
            }
          }
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  public JavaStatementBuilder featureCall(final JavaStatementBuilder receiverCode, final RType receiverType, final RosettaFeature feature, final boolean isDeepFeature, final JavaScope scope, final boolean autoValue) {
    final JavaReferenceType resultItemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfFeature(feature));
    StringConcatenationClient _switchResult = null;
    boolean _matched = false;
    if (feature instanceof Attribute) {
      _matched=true;
      _switchResult = this.buildMapFunc(receiverType, ((Attribute)feature), isDeepFeature, autoValue, scope);
    }
    if (!_matched) {
      if (feature instanceof RosettaMetaType) {
        _matched=true;
        _switchResult = ExpressionGenerator.buildMapFunc(((RosettaMetaType)feature), scope);
      }
    }
    if (!_matched) {
      if (feature instanceof RosettaEnumValue) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(resultItemType);
            _builder.append(".");
            String _convertValues = EnumHelper.convertValues(((RosettaEnumValue)feature));
            _builder.append(_convertValues);
          }
        };
        return JavaExpression.from(_client, resultItemType);
      }
    }
    if (!_matched) {
      if (feature instanceof RosettaRecordFeature) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(".<");
            JavaReferenceType _javaReferenceType = ExpressionGenerator.this._javaTypeTranslator.toJavaReferenceType(ExpressionGenerator.this._typeSystem.typeCallToRType(((RosettaRecordFeature)feature).getTypeCall()));
            _builder.append(_javaReferenceType);
            _builder.append(">map(\"");
            String _firstUpper = StringExtensions.toFirstUpper(((RosettaRecordFeature)feature).getName());
            _builder.append(_firstUpper);
            _builder.append("\", ");
            StringConcatenationClient _recordFeatureToLambda = ExpressionGenerator.this.recordUtil.recordFeatureToLambda(((RRecordType) receiverType), ((RosettaRecordFeature)feature), scope);
            _builder.append(_recordFeatureToLambda);
            _builder.append(")");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      Class<? extends RosettaFeature> _class = null;
      if (feature!=null) {
        _class=feature.getClass();
      }
      String _name = null;
      if (_class!=null) {
        _name=_class.getName();
      }
      String _plus = ("Unsupported feature type of " + _name);
      throw new UnsupportedOperationException(_plus);
    }
    final StringConcatenationClient right = _switchResult;
    final JavaStatementBuilder mapperReceiverCode = this.typeCoercionService.addCoercions(receiverCode, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, resultItemType), scope);
    JavaGenericTypeDeclaration<?> _xifexpression = null;
    if ((this.typeUtil.isMapperS(mapperReceiverCode.getExpressionType()) && (!this.cardinalityProvider.isFeatureMulti(feature)))) {
      _xifexpression = ((JavaGenericTypeDeclaration<?>) this.typeUtil.MAPPER_S);
    } else {
      _xifexpression = ((JavaGenericTypeDeclaration<?>) this.typeUtil.MAPPER_C);
    }
    final JavaGenericTypeDeclaration<?> resultWrapper = _xifexpression;
    final JavaParameterizedType<?> resultType = this.typeUtil.wrap(resultWrapper, resultItemType);
    final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(it);
          _builder.append(right);
        }
      };
      return JavaExpression.from(_client, resultType);
    };
    return mapperReceiverCode.collapseToSingleExpression(scope).mapExpression(_function);
  }

  private JavaStatementBuilder binaryExpr(final RosettaBinaryOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final RosettaExpression left = expr.getLeft();
      final RosettaExpression right = expr.getRight();
      final RType leftRtype = this.typeProvider.getRType(expr.getLeft());
      final RType rightRtype = this.typeProvider.getRType(expr.getRight());
      final JavaReferenceType joined = this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.join(leftRtype, rightRtype));
      final JavaReferenceType resultType = this._javaTypeTranslator.toJavaReferenceType(this.operators.resultType(expr.getOperator(), leftRtype, rightRtype));
      final JavaReferenceType leftType = this._javaTypeTranslator.toJavaReferenceType(leftRtype);
      final JavaReferenceType rightType = this._javaTypeTranslator.toJavaReferenceType(rightRtype);
      JavaStatementBuilder _switchResult = null;
      String _operator = expr.getOperator();
      if (_operator != null) {
        switch (_operator) {
          case "and":
          case "or":
            JavaStatementBuilder _xblockexpression_1 = null;
            {
              final JavaStatementBuilder leftCode = this.javaCode(left, this.typeUtil.COMPARISON_RESULT, context.scope);
              final JavaStatementBuilder rightCode = this.javaCode(right, this.typeUtil.COMPARISON_RESULT, context.scope);
              final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression l, JavaExpression r) -> {
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(l);
                    _builder.append(".");
                    String _operator = expr.getOperator();
                    _builder.append(_operator);
                    _builder.append("(");
                    _builder.append(r);
                    _builder.append(")");
                  }
                };
                return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
              };
              _xblockexpression_1 = leftCode.then(rightCode, _function, context.scope);
            }
            _switchResult = _xblockexpression_1;
            break;
          case "+":
          case "-":
          case "*":
          case "/":
            JavaStatementBuilder _xblockexpression_2 = null;
            {
              String _switchResult_1 = null;
              String _operator_1 = expr.getOperator();
              if (_operator_1 != null) {
                switch (_operator_1) {
                  case "+":
                    _switchResult_1 = "add";
                    break;
                  case "-":
                    _switchResult_1 = "subtract";
                    break;
                  case "*":
                    _switchResult_1 = "multiply";
                    break;
                  case "/":
                    _switchResult_1 = "divide";
                    break;
                }
              }
              final String method = _switchResult_1;
              JavaStatementBuilder _xifexpression = null;
              if ((this.typeUtil.extendsNumber(leftType) && this.typeUtil.extendsNumber(rightType))) {
                JavaStatementBuilder _xblockexpression_3 = null;
                {
                  final JavaStatementBuilder leftCode = this.javaCode(left, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, joined), context.scope);
                  final JavaStatementBuilder rightCode = this.javaCode(right, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, joined), context.scope);
                  final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression l, JavaExpression r) -> {
                    StringConcatenationClient _client = new StringConcatenationClient() {
                      @Override
                      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(MapperMaths.class);
                        _builder.append(".<");
                        _builder.append(resultType);
                        _builder.append(", ");
                        _builder.append(joined);
                        _builder.append(", ");
                        _builder.append(joined);
                        _builder.append(">");
                        _builder.append(method);
                        _builder.append("(");
                        _builder.append(l);
                        _builder.append(", ");
                        _builder.append(r);
                        _builder.append(")");
                      }
                    };
                    return JavaExpression.from(_client, this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, resultType));
                  };
                  _xblockexpression_3 = leftCode.then(rightCode, _function, context.scope);
                }
                _xifexpression = _xblockexpression_3;
              } else {
                JavaStatementBuilder _xblockexpression_4 = null;
                {
                  final JavaStatementBuilder leftCode = this.javaCode(left, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, leftType), context.scope);
                  final JavaStatementBuilder rightCode = this.javaCode(right, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, rightType), context.scope);
                  final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression l, JavaExpression r) -> {
                    StringConcatenationClient _client = new StringConcatenationClient() {
                      @Override
                      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(MapperMaths.class);
                        _builder.append(".<");
                        _builder.append(resultType);
                        _builder.append(", ");
                        _builder.append(leftType);
                        _builder.append(", ");
                        _builder.append(rightType);
                        _builder.append(">");
                        _builder.append(method);
                        _builder.append("(");
                        _builder.append(l);
                        _builder.append(", ");
                        _builder.append(r);
                        _builder.append(")");
                      }
                    };
                    return JavaExpression.from(_client, this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, resultType));
                  };
                  _xblockexpression_4 = leftCode.then(rightCode, _function, context.scope);
                }
                _xifexpression = _xblockexpression_4;
              }
              _xblockexpression_2 = _xifexpression;
            }
            _switchResult = _xblockexpression_2;
            break;
          case "contains":
          case "disjoint":
            JavaStatementBuilder _xblockexpression_3 = null;
            {
              final JavaStatementBuilder leftCode = this.javaCode(left, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, joined), context.scope);
              final JavaStatementBuilder rightCode = this.javaCode(right, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, joined), context.scope);
              final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression l, JavaExpression r) -> {
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod(expr.getOperator());
                    _builder.append(_runtimeMethod);
                    _builder.append("(");
                    _builder.append(l);
                    _builder.append(", ");
                    _builder.append(r);
                    _builder.append(")");
                  }
                };
                return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
              };
              _xblockexpression_3 = leftCode.then(rightCode, _function, context.scope);
            }
            _switchResult = _xblockexpression_3;
            break;
          case "default":
            JavaStatementBuilder _xblockexpression_4 = null;
            {
              final JavaStatementBuilder leftCode = this.javaCode(left, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, joined), context.scope);
              JavaStatementBuilder _xifexpression = null;
              boolean _isMulti = this.cardinalityProvider.isMulti(left);
              if (_isMulti) {
                JavaStatementBuilder _xblockexpression_5 = null;
                {
                  final JavaStatementBuilder rightCode = this.javaCode(right, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, joined), context.scope);
                  final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression l, JavaExpression r) -> {
                    StringConcatenationClient _client = new StringConcatenationClient() {
                      @Override
                      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(l);
                        _builder.append(".getMulti().isEmpty()");
                      }
                    };
                    JavaExpression _from = JavaExpression.from(_client, JavaPrimitiveType.BOOLEAN);
                    return new JavaConditionalExpression(_from, r, l, this.typeUtil);
                  };
                  _xblockexpression_5 = leftCode.then(rightCode, _function, context.scope);
                }
                _xifexpression = _xblockexpression_5;
              } else {
                JavaStatementBuilder _xblockexpression_6 = null;
                {
                  final JavaStatementBuilder rightCode = this.javaCode(right, joined, context.scope);
                  final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression l, JavaExpression r) -> {
                    StringConcatenationClient _client = new StringConcatenationClient() {
                      @Override
                      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(l);
                        _builder.append(".getOrDefault(");
                        _builder.append(r);
                        _builder.append(")");
                      }
                    };
                    return JavaExpression.from(_client, resultType);
                  };
                  _xblockexpression_6 = leftCode.then(rightCode, _function, context.scope);
                }
                _xifexpression = _xblockexpression_6;
              }
              _xblockexpression_4 = _xifexpression;
            }
            _switchResult = _xblockexpression_4;
            break;
          case "join":
            JavaStatementBuilder _xblockexpression_5 = null;
            {
              final JavaStatementBuilder leftCode = this.javaCode(left, this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, this.typeUtil.STRING), context.scope);
              JavaStatementBuilder _xifexpression = null;
              RosettaExpression _right = expr.getRight();
              boolean _tripleEquals = (_right == null);
              if (_tripleEquals) {
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(MapperS.class);
                    _builder.append(".of(\"\")");
                  }
                };
                _xifexpression = JavaExpression.from(_client, resultType);
              } else {
                _xifexpression = this.javaCode(right, this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, this.typeUtil.STRING), context.scope);
              }
              final JavaStatementBuilder rightCode = _xifexpression;
              final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression l, JavaExpression r) -> {
                StringConcatenationClient _client_1 = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(l);
                    _builder.append(".join(");
                    _builder.append(r);
                    _builder.append(")");
                  }
                };
                return JavaExpression.from(_client_1, this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, this.typeUtil.STRING));
              };
              _xblockexpression_5 = leftCode.then(rightCode, _function, context.scope);
            }
            _switchResult = _xblockexpression_5;
            break;
          case "=":
          case "<>":
          case "<":
          case "<=":
          case ">":
          case ">=":
            JavaStatementBuilder _xblockexpression_6 = null;
            {
              String _switchResult_1 = null;
              String _operator_1 = expr.getOperator();
              if (_operator_1 != null) {
                switch (_operator_1) {
                  case "=":
                    _switchResult_1 = "areEqual";
                    break;
                  case "<>":
                    _switchResult_1 = "notEqual";
                    break;
                  case "<":
                    _switchResult_1 = "lessThan";
                    break;
                  case "<=":
                    _switchResult_1 = "lessThanEquals";
                    break;
                  case ">":
                    _switchResult_1 = "greaterThan";
                    break;
                  case ">=":
                    _switchResult_1 = "greaterThanEquals";
                    break;
                }
              }
              final String method = _switchResult_1;
              final CardinalityModifier modifier = ((ModifiableBinaryOperation) expr).getCardMod();
              CardinalityModifier _xifexpression = null;
              String _operator_2 = expr.getOperator();
              boolean _equals = Objects.equal(_operator_2, "<>");
              if (_equals) {
                _xifexpression = CardinalityModifier.ANY;
              } else {
                _xifexpression = CardinalityModifier.ALL;
              }
              final CardinalityModifier defaultModifier = _xifexpression;
              final JavaStatementBuilder leftCode = this.javaCode(left, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, joined), context.scope);
              final JavaStatementBuilder rightCode = this.javaCode(right, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, joined), context.scope);
              final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression l, JavaExpression r) -> {
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod(method);
                    _builder.append(_runtimeMethod);
                    _builder.append("(");
                    _builder.append(l);
                    _builder.append(", ");
                    _builder.append(r);
                    _builder.append(", ");
                    StringConcatenationClient _cardinalityOperator = ExpressionGenerator.this.toCardinalityOperator(modifier, defaultModifier);
                    _builder.append(_cardinalityOperator);
                    _builder.append(")");
                  }
                };
                return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
              };
              _xblockexpression_6 = leftCode.then(rightCode, _function, context.scope);
            }
            _switchResult = _xblockexpression_6;
            break;
          default:
            String _operator_1 = expr.getOperator();
            String _plus = ("Unsupported binary operation of " + _operator_1);
            throw new UnsupportedOperationException(_plus);
        }
      } else {
        String _operator_1 = expr.getOperator();
        String _plus = ("Unsupported binary operation of " + _operator_1);
        throw new UnsupportedOperationException(_plus);
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient toCardinalityOperator(final CardinalityModifier cardOp, final CardinalityModifier defaultOp) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(CardinalityOperator.class);
        _builder.append(".");
        String _xifexpression = null;
        if ((cardOp == CardinalityModifier.NONE)) {
          _xifexpression = StringExtensions.toFirstUpper(defaultOp.toString());
        } else {
          _xifexpression = StringExtensions.toFirstUpper(cardOp.toString());
        }
        _builder.append(_xifexpression);
      }
    };
    return _client;
  }

  /**
   * Builds the expression of mapping functions to extract a path of attributes
   */
  private StringConcatenationClient buildMapFunc(final RType itemType, final Attribute attribute, final boolean isDeepFeature, final boolean autoValue, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final StringConcatenationClient mapFunc = this.buildMapFuncAttribute(itemType, attribute, isDeepFeature, scope);
      JavaReferenceType _xifexpression = null;
      if ((IterableExtensions.isNullOrEmpty(this._rosettaExtensions.metaAnnotations(attribute)) || isDeepFeature)) {
        _xifexpression = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfSymbol(attribute));
      } else {
        _xifexpression = this._javaTypeTranslator.toMetaJavaType(attribute);
      }
      final JavaReferenceType resultType = _xifexpression;
      StringConcatenationClient _xifexpression_1 = null;
      boolean _isIsMany = attribute.getCard().isIsMany();
      if (_isIsMany) {
        StringConcatenationClient _xifexpression_2 = null;
        if ((IterableExtensions.isNullOrEmpty(this._rosettaExtensions.metaAnnotations(attribute)) || (!autoValue))) {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(".<");
              _builder.append(resultType);
              _builder.append(">mapC(");
              _builder.append(mapFunc);
              _builder.append(")");
            }
          };
          _xifexpression_2 = _client;
        } else {
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(".<");
              _builder.append(resultType);
              _builder.append(">mapC(");
              _builder.append(mapFunc);
              _builder.append(").<");
              JavaReferenceType _javaReferenceType = ExpressionGenerator.this._javaTypeTranslator.toJavaReferenceType(ExpressionGenerator.this.typeProvider.getRTypeOfSymbol(attribute));
              _builder.append(_javaReferenceType);
              _builder.append(">map(\"getValue\", _f->_f.getValue())");
            }
          };
          _xifexpression_2 = _client_1;
        }
        _xifexpression_1 = _xifexpression_2;
      } else {
        StringConcatenationClient _xifexpression_3 = null;
        if ((IterableExtensions.isNullOrEmpty(this._rosettaExtensions.metaAnnotations(attribute)) || (!autoValue))) {
          StringConcatenationClient _client_2 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(".<");
              _builder.append(resultType);
              _builder.append(">map(");
              _builder.append(mapFunc);
              _builder.append(")");
            }
          };
          _xifexpression_3 = _client_2;
        } else {
          StringConcatenationClient _client_3 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(".<");
              _builder.append(resultType);
              _builder.append(">map(");
              _builder.append(mapFunc);
              _builder.append(").<");
              JavaReferenceType _javaReferenceType = ExpressionGenerator.this._javaTypeTranslator.toJavaReferenceType(ExpressionGenerator.this.typeProvider.getRTypeOfSymbol(attribute));
              _builder.append(_javaReferenceType);
              _builder.append(">map(\"getValue\", _f->_f.getValue())");
            }
          };
          _xifexpression_3 = _client_3;
        }
        _xifexpression_1 = _xifexpression_3;
      }
      _xblockexpression = _xifexpression_1;
    }
    return _xblockexpression;
  }

  private static StringConcatenationClient buildMapFunc(final RosettaMetaType meta, final JavaScope scope) {
    StringConcatenationClient _xifexpression = null;
    String _name = meta.getName();
    boolean _equals = Objects.equal(_name, "reference");
    if (_equals) {
      StringConcatenationClient _xblockexpression = null;
      {
        final JavaScope lambdaScope = scope.lambdaScope();
        final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier("a");
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(".map(\"get");
            String _firstUpper = StringExtensions.toFirstUpper(meta.getName());
            _builder.append(_firstUpper);
            _builder.append("\", ");
            _builder.append(lambdaParam);
            _builder.append("->");
            _builder.append(lambdaParam);
            _builder.append(".getGlobalReference())");
          }
        };
        _xblockexpression = _client;
      }
      _xifexpression = _xblockexpression;
    } else {
      StringConcatenationClient _xblockexpression_1 = null;
      {
        final JavaScope lambdaScope1 = scope.lambdaScope();
        final GeneratedIdentifier lambdaParam1 = lambdaScope1.createUniqueIdentifier("a");
        final JavaScope lambdaScope2 = scope.lambdaScope();
        final GeneratedIdentifier lambdaParam2 = lambdaScope2.createUniqueIdentifier("a");
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(".map(\"getMeta\", ");
            _builder.append(lambdaParam1);
            _builder.append("->");
            _builder.append(lambdaParam1);
            _builder.append(".getMeta()).map(\"get");
            String _firstUpper = StringExtensions.toFirstUpper(meta.getName());
            _builder.append(_firstUpper);
            _builder.append("\", ");
            _builder.append(lambdaParam2);
            _builder.append("->");
            _builder.append(lambdaParam2);
            _builder.append(".get");
            String _firstUpper_1 = StringExtensions.toFirstUpper(meta.getName());
            _builder.append(_firstUpper_1);
            _builder.append("())");
          }
        };
        _xblockexpression_1 = _client;
      }
      _xifexpression = _xblockexpression_1;
    }
    return _xifexpression;
  }

  private Pair<StringConcatenationClient, JavaType> inlineFunction(final InlineFunction ref, final JavaType expectedType, final JavaScope scope) {
    Pair<StringConcatenationClient, JavaType> _xblockexpression = null;
    {
      final JavaScope lambdaScope = scope.lambdaScope();
      List<GeneratedIdentifier> _xifexpression = null;
      int _size = ref.getParameters().size();
      boolean _equals = (_size == 0);
      if (_equals) {
        GeneratedIdentifier _createIdentifier = lambdaScope.createIdentifier(this._javaIdentifierRepresentationService.getImplicitVarInContext(ref), this._implicitVariableUtil.getDefaultImplicitVariable().getName());
        _xifexpression = Collections.<GeneratedIdentifier>unmodifiableList(CollectionLiterals.<GeneratedIdentifier>newArrayList(_createIdentifier));
      } else {
        final Function<ClosureParameter, GeneratedIdentifier> _function = (ClosureParameter it) -> {
          return lambdaScope.createIdentifier(it);
        };
        _xifexpression = ref.getParameters().stream().<GeneratedIdentifier>map(_function).collect(Collectors.<GeneratedIdentifier>toList());
      }
      final List<GeneratedIdentifier> paramIds = _xifexpression;
      final JavaStatementBuilder body = this.javaCode(ref.getBody(), expectedType, lambdaScope);
      StringConcatenationClient _xifexpression_1 = null;
      int _size_1 = paramIds.size();
      boolean _equals_1 = (_size_1 == 1);
      if (_equals_1) {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            GeneratedIdentifier _head = IterableExtensions.<GeneratedIdentifier>head(paramIds);
            _builder.append(_head);
            _builder.append(" -> ");
            JavaLambdaBody _lambdaBody = body.toLambdaBody();
            _builder.append(_lambdaBody);
          }
        };
        _xifexpression_1 = _client;
      } else {
        StringConcatenationClient _client_1 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("(");
            {
              boolean _hasElements = false;
              for(final GeneratedIdentifier id : paramIds) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                _builder.append(id);
              }
            }
            _builder.append(") -> ");
            JavaLambdaBody _lambdaBody = body.toLambdaBody();
            _builder.append(_lambdaBody);
          }
        };
        _xifexpression_1 = _client_1;
      }
      JavaType _expressionType = body.getExpressionType();
      _xblockexpression = new Pair<StringConcatenationClient, JavaType>(_xifexpression_1, _expressionType);
    }
    return _xblockexpression;
  }

  private JavaStatementBuilder buildConstraint(final RosettaExpression arg, final Iterable<Attribute> usedAttributes, final Necessity validationType, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaReferenceType argItemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRType(arg));
      final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod("choice");
            _builder.append(_runtimeMethod);
            _builder.append("(");
            _builder.append(it);
            _builder.append(", ");
            _builder.append(Arrays.class);
            _builder.append(".asList(");
            final Function1<Attribute, CharSequence> _function = (Attribute it_1) -> {
              String _name = it_1.getName();
              String _plus = ("\"" + _name);
              return (_plus + "\"");
            };
            String _join = IterableExtensions.<Attribute>join(usedAttributes, ", ", _function);
            _builder.append(_join);
            _builder.append("), ");
            _builder.append(ChoiceRuleValidationMethod.class);
            _builder.append(".");
            String _name = validationType.name();
            _builder.append(_name);
            _builder.append(")");
          }
        };
        return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
      };
      _xblockexpression = this.javaCode(arg, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, argItemType), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
    }
    return _xblockexpression;
  }

  private JavaStatementBuilder buildListOperationNoBody(final RosettaUnaryOperation op, final String name, final JavaType expectedArgumentType, final Function1<? super JavaType, ? extends JavaType> argumentTypeToReturnType, final JavaScope scope) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaStatementBuilder argCode = this.javaCode(op.getArgument(), expectedArgumentType, scope).collapseToSingleExpression(scope);
      final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(it);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(".");
            _builder.append(name, "\t");
            _builder.append("()");
          }
        };
        return JavaExpression.from(_client, 
          argumentTypeToReturnType.apply(argCode.getExpressionType()));
      };
      _xblockexpression = argCode.mapExpression(_function);
    }
    return _xblockexpression;
  }

  private JavaStatementBuilder buildSingleItemListOperationOptionalBody(final RosettaFunctionalOperation op, final String name, final JavaType expectedArgumentType, final JavaType expectedBodyType, final Function2<? super JavaType, ? super JavaType, ? extends JavaType> argumentAndBodyTypeToReturnType, final JavaScope scope) {
    JavaStatementBuilder _xifexpression = null;
    InlineFunction _function = op.getFunction();
    boolean _tripleEquals = (_function == null);
    if (_tripleEquals) {
      final Function1<JavaType, JavaType> _function_1 = (JavaType it) -> {
        return argumentAndBodyTypeToReturnType.apply(it, null);
      };
      _xifexpression = this.buildListOperationNoBody(op, name, expectedArgumentType, _function_1, scope);
    } else {
      _xifexpression = this.buildSingleItemListOperation(op, name, expectedArgumentType, expectedBodyType, argumentAndBodyTypeToReturnType, scope);
    }
    return _xifexpression;
  }

  private JavaStatementBuilder buildSingleItemListOperation(final RosettaFunctionalOperation op, final String name, final JavaType expectedArgumentType, final JavaType expectedBodyType, final Function2<? super JavaType, ? super JavaType, ? extends JavaType> argumentAndBodyTypeToReturnType, final JavaScope scope) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaStatementBuilder argCode = this.javaCode(op.getArgument(), expectedArgumentType, scope).collapseToSingleExpression(scope);
      final Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(op.getFunction(), expectedBodyType, scope);
      final StringConcatenationClient inlineFunctionCode = inlineFunctionCodeAndBodyType.getKey();
      final JavaType inlineFunctionBodyType = inlineFunctionCodeAndBodyType.getValue();
      final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(it);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(".");
            _builder.append(name, "\t");
            _builder.append("(");
            _builder.append(inlineFunctionCode, "\t");
            _builder.append(")");
          }
        };
        return JavaExpression.from(_client, 
          argumentAndBodyTypeToReturnType.apply(argCode.getExpressionType(), inlineFunctionBodyType));
      };
      _xblockexpression = argCode.mapExpression(_function);
    }
    return _xblockexpression;
  }

  private StringConcatenationClient buildMapFuncAttribute(final RType itemType, final Attribute attribute, final boolean isDeepFeature, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaScope lambdaScope = scope.lambdaScope();
      final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier(StringExtensions.toFirstLower(itemType.getName()));
      StringConcatenationClient _xifexpression = null;
      if (isDeepFeature) {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("\"choose");
            String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper);
            _builder.append("\", ");
            _builder.append(lambdaParam);
            _builder.append(" -> ");
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(ExpressionGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(ExpressionGenerator.this._javaTypeTranslator.toDeepPathUtilJavaClass(((RDataType) itemType).getData())));
            _builder.append(_identifierOrThrow);
            _builder.append(".choose");
            String _firstUpper_1 = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper_1);
            _builder.append("(");
            _builder.append(lambdaParam);
            _builder.append(")");
          }
        };
        _xifexpression = _client;
      } else {
        StringConcatenationClient _client_1 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("\"get");
            String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper);
            _builder.append("\", ");
            _builder.append(lambdaParam);
            _builder.append(" -> ");
            {
              boolean _isOverride = attribute.isOverride();
              if (_isOverride) {
                _builder.append("(");
                JavaReferenceType _javaReferenceType = ExpressionGenerator.this._javaTypeTranslator.toJavaReferenceType(ExpressionGenerator.this.typeProvider.getRTypeOfSymbol(attribute));
                _builder.append(_javaReferenceType);
                _builder.append(") ");
              }
            }
            _builder.append(lambdaParam);
            _builder.append(".get");
            String _firstUpper_1 = StringExtensions.toFirstUpper(attribute.getName());
            _builder.append(_firstUpper_1);
            _builder.append("()");
          }
        };
        _xifexpression = _client_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  /**
   * Create a string representation of a rosetta function
   * mainly used to give human readable names to the mapping functions used to extract attributes
   */
  public StringConcatenationClient toNodeLabel(final RosettaExpression expr) {
    StringConcatenationClient _switchResult = null;
    boolean _matched = false;
    if (expr instanceof RosettaFeatureCall) {
      _matched=true;
      _switchResult = this.toNodeLabel(((RosettaFeatureCall)expr));
    }
    if (!_matched) {
      if (expr instanceof RosettaBinaryOperation) {
        _matched=true;
        _switchResult = this.toNodeLabel(((RosettaBinaryOperation)expr));
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaStringLiteral) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("\\\"");
            String _value = ((RosettaStringLiteral)expr).getValue();
            _builder.append(_value);
            _builder.append("\\\"");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaConditionalExpression) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("choice");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaEnumValueReference) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            String _name = ((RosettaEnumValueReference)expr).getEnumeration().getName();
            _builder.append(_name);
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaEnumValue) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            String _name = ((RosettaEnumValue)expr).getName();
            _builder.append(_name);
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (expr instanceof ListLiteral) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("[");
            {
              EList<RosettaExpression> _elements = ((ListLiteral)expr).getElements();
              boolean _hasElements = false;
              for(final RosettaExpression el : _elements) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(el);
                _builder.append(_nodeLabel);
              }
            }
            _builder.append("]");
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaLiteral) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            String _stringValue = ((RosettaLiteral)expr).stringValue();
            _builder.append(_stringValue);
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaSymbolReference) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            String _name = ((RosettaSymbolReference)expr).getSymbol().getName();
            _builder.append(_name);
            {
              boolean _isExplicitArguments = ((RosettaSymbolReference)expr).isExplicitArguments();
              if (_isExplicitArguments) {
                _builder.append("(");
                {
                  EList<RosettaExpression> _args = ((RosettaSymbolReference)expr).getArgs();
                  boolean _hasElements = false;
                  for(final RosettaExpression arg : _args) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(arg);
                    _builder.append(_nodeLabel);
                  }
                }
                _builder.append(")");
              }
            }
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaImplicitVariable) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            String _name = ExpressionGenerator.this._implicitVariableUtil.getDefaultImplicitVariable().getName();
            _builder.append(_name);
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaFunctionalOperation) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(((RosettaFunctionalOperation)expr).getArgument());
            _builder.append(_nodeLabel);
            _builder.append(" ");
            String _operator = ((RosettaFunctionalOperation)expr).getOperator();
            _builder.append(_operator);
            {
              InlineFunction _function = ((RosettaFunctionalOperation)expr).getFunction();
              boolean _tripleNotEquals = (_function != null);
              if (_tripleNotEquals) {
                _builder.append(" [");
                StringConcatenationClient _nodeLabel_1 = ExpressionGenerator.this.toNodeLabel(((RosettaFunctionalOperation)expr).getFunction().getBody());
                _builder.append(_nodeLabel_1);
                _builder.append("]");
              }
            }
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      if (expr instanceof RosettaUnaryOperation) {
        _matched=true;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(((RosettaUnaryOperation)expr).getArgument());
            _builder.append(_nodeLabel);
            _builder.append(" ");
            String _operator = ((RosettaUnaryOperation)expr).getOperator();
            _builder.append(_operator);
          }
        };
        _switchResult = _client;
      }
    }
    if (!_matched) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("Unsupported expression type of ");
          Class<? extends RosettaExpression> _class = null;
          if (expr!=null) {
            _class=expr.getClass();
          }
          String _name = null;
          if (_class!=null) {
            _name=_class.getName();
          }
          _builder.append(_name);
        }
      };
      _switchResult = _client;
    }
    return _switchResult;
  }

  public StringConcatenationClient toNodeLabel(final RosettaFeatureCall call) {
    StringConcatenationClient _xblockexpression = null;
    {
      final RosettaFeature feature = call.getFeature();
      String _switchResult = null;
      boolean _matched = false;
      if (feature instanceof RosettaMetaType) {
        _matched=true;
      }
      if (!_matched) {
        if (feature instanceof Attribute) {
          _matched=true;
        }
      }
      if (!_matched) {
        if (feature instanceof RosettaEnumValue) {
          _matched=true;
        }
      }
      if (_matched) {
        _switchResult = feature.getName();
      }
      if (!_matched) {
        Class<? extends RosettaFeature> _class = null;
        if (feature!=null) {
          _class=feature.getClass();
        }
        String _plus = ("Unsupported expression type (feature) " + _class);
        throw new UnsupportedOperationException(_plus);
      }
      final String right = _switchResult;
      final RosettaExpression receiver = call.getReceiver();
      final StringConcatenationClient left = this.toNodeLabel(receiver);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(left);
          _builder.append("->");
          _builder.append(right);
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  public StringConcatenationClient toNodeLabel(final RosettaBinaryOperation binOp) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(binOp.getLeft());
        _builder.append(_nodeLabel);
        _builder.append(" ");
        String _operator = binOp.getOperator();
        _builder.append(_operator);
        _builder.append(" ");
        StringConcatenationClient _nodeLabel_1 = ExpressionGenerator.this.toNodeLabel(binOp.getRight());
        _builder.append(_nodeLabel_1);
      }
    };
    return _client;
  }

  @Override
  protected JavaStatementBuilder caseAbsentOperation(final RosettaAbsentExpression expr, final ExpressionGenerator.Context context) {
    return this.applyRuntimeMethod(this.javaCode(expr.getArgument(), this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, expr.getArgument()), context.scope), "notExists", this.typeUtil.COMPARISON_RESULT);
  }

  @Override
  protected JavaStatementBuilder caseAddOperation(final ArithmeticOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseAndOperation(final LogicalOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseAsKeyOperation(final AsKeyOperation expr, final ExpressionGenerator.Context context) {
    return this.doSwitch(expr.getArgument(), context);
  }

  @Override
  protected JavaStatementBuilder caseBooleanLiteral(final RosettaBooleanLiteral expr, final ExpressionGenerator.Context context) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        boolean _isValue = expr.isValue();
        _builder.append(_isValue);
      }
    };
    return JavaExpression.from(_client, JavaPrimitiveType.BOOLEAN);
  }

  @Override
  protected JavaStatementBuilder caseChoiceOperation(final ChoiceOperation expr, final ExpressionGenerator.Context context) {
    return this.buildConstraint(expr.getArgument(), expr.getAttributes(), expr.getNecessity(), context);
  }

  @Override
  protected JavaStatementBuilder caseConditionalExpression(final RosettaConditionalExpression expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaStatementBuilder condition = this.javaCode(expr.getIf(), JavaPrimitiveType.BOOLEAN, context.scope);
      final JavaStatementBuilder thenBranch = this.javaCode(expr.getIfthen(), context.expectedType, context.scope);
      final JavaStatementBuilder elseBranch = this.javaCode(expr.getElsethen(), context.expectedType, context.scope);
      final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
        return new JavaIfThenElseBuilder(it, thenBranch, elseBranch, this.typeUtil);
      };
      _xblockexpression = condition.collapseToSingleExpression(context.scope).mapExpression(_function);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseContainsOperation(final RosettaContainsExpression expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseDefaultOperation(final DefaultOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseCountOperation(final RosettaCountOperation expr, final ExpressionGenerator.Context context) {
    final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(it);
          _builder.append(".resultCount()");
        }
      };
      return JavaExpression.from(_client, JavaPrimitiveType.INT);
    };
    return this.javaCode(expr.getArgument(), this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, expr.getArgument()), context.scope).mapExpression(_function);
  }

  @Override
  protected JavaStatementBuilder caseDisjointOperation(final RosettaDisjointExpression expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseDistinctOperation(final DistinctOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaReferenceType argItemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRType(expr.getArgument()));
      final JavaStatementBuilder argCode = this.javaCode(expr.getArgument(), this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, argItemType), context.scope);
      final JavaType argType = argCode.getExpressionType();
      JavaParameterizedType<MapperC<?>> _xifexpression = null;
      boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(argType);
      if (_hasWildcardArgument) {
        _xifexpression = this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, argItemType);
      } else {
        _xifexpression = this.typeUtil.<MapperC<?>>wrap(this.typeUtil.MAPPER_C, argItemType);
      }
      _xblockexpression = this.applyRuntimeMethod(argCode, "distinct", _xifexpression);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseDivideOperation(final ArithmeticOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseEqualsOperation(final EqualityOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  public JavaStatementBuilder exists(final JavaStatementBuilder arg, final ExistsModifier modifier, final JavaScope scope) {
    JavaStatementBuilder _xblockexpression = null;
    {
      String _xifexpression = null;
      if ((modifier == ExistsModifier.SINGLE)) {
        _xifexpression = "singleExists";
      } else {
        String _xifexpression_1 = null;
        if ((modifier == ExistsModifier.MULTIPLE)) {
          _xifexpression_1 = "multipleExists";
        } else {
          _xifexpression_1 = "exists";
        }
        _xifexpression = _xifexpression_1;
      }
      final String methodName = _xifexpression;
      _xblockexpression = this.applyRuntimeMethod(this.typeCoercionService.addCoercions(arg, this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, this.typeUtil.getItemType(arg.getExpressionType())), scope), methodName, this.typeUtil.COMPARISON_RESULT);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseExistsOperation(final RosettaExistsExpression expr, final ExpressionGenerator.Context context) {
    return this.exists(this.javaCode(expr.getArgument(), this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, expr.getArgument()), context.scope), expr.getModifier(), context.scope);
  }

  @Override
  protected JavaStatementBuilder caseFeatureCall(final RosettaFeatureCall expr, final ExpressionGenerator.Context context) {
    boolean autoValue = true;
    if (((expr.eContainer() instanceof RosettaFeatureCall) && 
      (((RosettaFeatureCall) expr.eContainer()).getFeature() instanceof RosettaMetaType))) {
      autoValue = false;
    }
    return this.featureCall(this.javaCode(expr.getReceiver(), this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, expr.getReceiver()), context.scope), this.typeProvider.getRType(expr.getReceiver()), expr.getFeature(), false, context.scope, autoValue);
  }

  @Override
  protected JavaStatementBuilder caseDeepFeatureCall(final RosettaDeepFeatureCall expr, final ExpressionGenerator.Context context) {
    return this.featureCall(this.javaCode(expr.getReceiver(), this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, expr.getReceiver()), context.scope), this.typeProvider.getRType(expr.getReceiver()), expr.getFeature(), true, context.scope, false);
  }

  @Override
  protected JavaStatementBuilder caseFilterOperation(final FilterOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final StringConcatenationClient inlineFunctionCode = this.inlineFunction(expr.getFunction(), JavaPrimitiveType.BOOLEAN.toReferenceType(), context.scope).getKey();
      JavaStatementBuilder _xifexpression = null;
      boolean _isPreviousOperationMulti = this.cardinalityProvider.isPreviousOperationMulti(expr);
      boolean _not = (!_isPreviousOperationMulti);
      if (_not) {
        JavaStatementBuilder _xblockexpression_1 = null;
        {
          final JavaStatementBuilder argCode = this.javaCode(expr.getArgument(), this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope);
          final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(it);
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append(".filterSingleNullSafe(");
                _builder.append(inlineFunctionCode, "\t");
                _builder.append(")");
              }
            };
            return JavaExpression.from(_client, 
              argCode.getExpressionType());
          };
          _xblockexpression_1 = argCode.mapExpression(_function);
        }
        _xifexpression = _xblockexpression_1;
      } else {
        JavaStatementBuilder _xifexpression_1 = null;
        boolean _isOutputListOfLists = this.cardinalityProvider.isOutputListOfLists(expr.getArgument());
        if (_isOutputListOfLists) {
          JavaStatementBuilder _xblockexpression_2 = null;
          {
            final JavaStatementBuilder argCode = this.javaCode(expr.getArgument(), this.typeUtil.<MapperListOfLists<?>>wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope);
            final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(it);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append(".filterListNullSafe(");
                  _builder.append(inlineFunctionCode, "\t");
                  _builder.append(")");
                }
              };
              return JavaExpression.from(_client, 
                argCode.getExpressionType());
            };
            _xblockexpression_2 = argCode.mapExpression(_function);
          }
          _xifexpression_1 = _xblockexpression_2;
        } else {
          JavaStatementBuilder _xblockexpression_3 = null;
          {
            final JavaStatementBuilder argCode = this.javaCode(expr.getArgument(), this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope);
            final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(it);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append(".filterItemNullSafe(");
                  _builder.append(inlineFunctionCode, "\t");
                  _builder.append(")");
                }
              };
              return JavaExpression.from(_client, 
                argCode.getExpressionType());
            };
            _xblockexpression_3 = argCode.mapExpression(_function);
          }
          _xifexpression_1 = _xblockexpression_3;
        }
        _xifexpression = _xifexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseFirstOperation(final FirstOperation expr, final ExpressionGenerator.Context context) {
    final Function1<JavaType, JavaType> _function = (JavaType it) -> {
      return this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType(it));
    };
    return this.buildListOperationNoBody(expr, "first", this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), _function, context.scope);
  }

  @Override
  protected JavaStatementBuilder caseFlattenOperation(final FlattenOperation expr, final ExpressionGenerator.Context context) {
    final Function1<JavaType, JavaType> _function = (JavaType it) -> {
      JavaParameterizedType<MapperC<?>> _xifexpression = null;
      boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(it);
      if (_hasWildcardArgument) {
        _xifexpression = this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument());
      } else {
        _xifexpression = this.typeUtil.<MapperC<?>>wrap(this.typeUtil.MAPPER_C, expr.getArgument());
      }
      return _xifexpression;
    };
    return this.buildListOperationNoBody(expr, "flattenList", this.typeUtil.<MapperListOfLists<?>>wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, expr.getArgument()), _function, context.scope);
  }

  @Override
  protected JavaStatementBuilder caseGreaterThanOperation(final ComparisonOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseGreaterThanOrEqualOperation(final ComparisonOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseImplicitVariable(final RosettaImplicitVariable expr, final ExpressionGenerator.Context context) {
    return this.implicitVariable(expr, context.scope);
  }

  @Override
  protected JavaStatementBuilder caseIntLiteral(final RosettaIntLiteral expr, final ExpressionGenerator.Context context) {
    final int intValue = expr.getValue().intValue();
    BigInteger _valueOf = BigInteger.valueOf(intValue);
    BigInteger _value = expr.getValue();
    boolean _equals = Objects.equal(_valueOf, _value);
    if (_equals) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(intValue);
        }
      };
      return JavaExpression.from(_client, JavaPrimitiveType.INT);
    }
    final long longValue = expr.getValue().longValue();
    BigInteger _valueOf_1 = BigInteger.valueOf(intValue);
    BigInteger _value_1 = expr.getValue();
    boolean _equals_1 = Objects.equal(_valueOf_1, _value_1);
    if (_equals_1) {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(longValue);
          _builder.append("l");
        }
      };
      return JavaExpression.from(_client_1, JavaPrimitiveType.LONG);
    }
    StringConcatenationClient _client_2 = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("new ");
        _builder.append(BigInteger.class);
        _builder.append("(\"");
        BigInteger _value = expr.getValue();
        _builder.append(_value);
        _builder.append("\")");
      }
    };
    return JavaExpression.from(_client_2, this.typeUtil.BIG_INTEGER);
  }

  @Override
  protected JavaStatementBuilder caseJoinOperation(final JoinOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseLastOperation(final LastOperation expr, final ExpressionGenerator.Context context) {
    final Function1<JavaType, JavaType> _function = (JavaType it) -> {
      return this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType(it));
    };
    return this.buildListOperationNoBody(expr, "last", this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), _function, context.scope);
  }

  @Override
  protected JavaStatementBuilder caseLessThanOperation(final ComparisonOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseLessThanOrEqualOperation(final ComparisonOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseListLiteral(final ListLiteral expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      boolean _isEmpty = expr.getElements().isEmpty();
      if (_isEmpty) {
        return JavaExpression.NULL;
      }
      final JavaReferenceType itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRType(expr));
      final RosettaExpression first = IterableExtensions.<RosettaExpression>head(expr.getElements());
      JavaType _xifexpression = null;
      boolean _isMulti = this.cardinalityProvider.isMulti(first);
      if (_isMulti) {
        JavaParameterizedType<MapperC<?>> _wrapExtends = this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, itemType);
        _xifexpression = ((JavaType) _wrapExtends);
      } else {
        _xifexpression = this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, itemType);
      }
      JavaStatementBuilder elementsCode = this.javaCode(first, _xifexpression, context.scope);
      for (int i = 1; (i < expr.getElements().size()); i++) {
        {
          final RosettaExpression elem = expr.getElements().get(i);
          JavaType _xifexpression_1 = null;
          boolean _isMulti_1 = this.cardinalityProvider.isMulti(elem);
          if (_isMulti_1) {
            JavaParameterizedType<MapperC<?>> _wrapExtends_1 = this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, itemType);
            _xifexpression_1 = ((JavaType) _wrapExtends_1);
          } else {
            _xifexpression_1 = this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, itemType);
          }
          final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression elemList, JavaExpression newElem) -> {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(elemList);
                _builder.append(", ");
                _builder.append(newElem);
              }
            };
            return JavaExpression.from(_client, null);
          };
          elementsCode = elementsCode.then(
            this.javaCode(elem, _xifexpression_1, context.scope), _function, 
            context.scope);
        }
      }
      final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(MapperC.class);
            _builder.append(".<");
            _builder.append(itemType);
            _builder.append(">of(");
            _builder.append(it);
            _builder.append(")");
          }
        };
        return JavaExpression.from(_client, 
          this.typeUtil.<MapperC<?>>wrap(this.typeUtil.MAPPER_C, itemType));
      };
      _xblockexpression = elementsCode.collapseToSingleExpression(context.scope).mapExpression(_function);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseMapOperation(final MapOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaReferenceType bodyItemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRType(expr.getFunction().getBody()));
      final boolean isBodyMulti = this.cardinalityProvider.isBodyExpressionMulti(expr.getFunction());
      JavaStatementBuilder _xifexpression = null;
      boolean _isPreviousOperationMulti = this.cardinalityProvider.isPreviousOperationMulti(expr);
      boolean _not = (!_isPreviousOperationMulti);
      if (_not) {
        JavaStatementBuilder _xifexpression_1 = null;
        if (isBodyMulti) {
          JavaStatementBuilder _xblockexpression_1 = null;
          {
            final Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, bodyItemType), context.scope);
            final StringConcatenationClient inlineFunctionCode = inlineFunctionCodeAndBodyType.getKey();
            final JavaType inlineFunctionBodyType = inlineFunctionCodeAndBodyType.getValue();
            final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(it);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append(".mapSingleToList(");
                  _builder.append(inlineFunctionCode, "\t");
                  _builder.append(")");
                }
              };
              return JavaExpression.from(_client, inlineFunctionBodyType);
            };
            _xblockexpression_1 = this.javaCode(expr.getArgument(), this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
          }
          _xifexpression_1 = _xblockexpression_1;
        } else {
          final Function2<JavaType, JavaType, JavaType> _function = (JavaType a, JavaType b) -> {
            return b;
          };
          _xifexpression_1 = this.buildSingleItemListOperationOptionalBody(expr, "mapSingleToItem", this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument()), this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, bodyItemType), _function, context.scope);
        }
        _xifexpression = _xifexpression_1;
      } else {
        JavaStatementBuilder _xifexpression_2 = null;
        boolean _isOutputListOfLists = this.cardinalityProvider.isOutputListOfLists(expr.getArgument());
        if (_isOutputListOfLists) {
          JavaStatementBuilder _xifexpression_3 = null;
          if (isBodyMulti) {
            JavaStatementBuilder _xblockexpression_2 = null;
            {
              final Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, bodyItemType), context.scope);
              final StringConcatenationClient inlineFunctionCode = inlineFunctionCodeAndBodyType.getKey();
              final JavaType inlineFunctionBodyType = inlineFunctionCodeAndBodyType.getValue();
              final Function<JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression it) -> {
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(it);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".mapListToList(");
                    _builder.append(inlineFunctionCode, "\t");
                    _builder.append(")");
                  }
                };
                JavaParameterizedType<MapperListOfLists<?>> _xifexpression_4 = null;
                boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(inlineFunctionBodyType);
                if (_hasWildcardArgument) {
                  _xifexpression_4 = this.typeUtil.<MapperListOfLists<?>>wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, bodyItemType);
                } else {
                  _xifexpression_4 = this.typeUtil.<MapperListOfLists<?>>wrap(this.typeUtil.MAPPER_LIST_OF_LISTS, bodyItemType);
                }
                return JavaExpression.from(_client, _xifexpression_4);
              };
              _xblockexpression_2 = this.javaCode(expr.getArgument(), this.typeUtil.<MapperListOfLists<?>>wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function_1);
            }
            _xifexpression_3 = _xblockexpression_2;
          } else {
            JavaStatementBuilder _xblockexpression_3 = null;
            {
              final Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, bodyItemType), context.scope);
              final StringConcatenationClient inlineFunctionCode = inlineFunctionCodeAndBodyType.getKey();
              final JavaType inlineFunctionBodyType = inlineFunctionCodeAndBodyType.getValue();
              final Function<JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression it) -> {
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(it);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".mapListToItem(");
                    _builder.append(inlineFunctionCode, "\t");
                    _builder.append(")");
                  }
                };
                JavaParameterizedType<MapperC<?>> _xifexpression_4 = null;
                boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(inlineFunctionBodyType);
                if (_hasWildcardArgument) {
                  _xifexpression_4 = this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, bodyItemType);
                } else {
                  _xifexpression_4 = this.typeUtil.<MapperC<?>>wrap(this.typeUtil.MAPPER_C, bodyItemType);
                }
                return JavaExpression.from(_client, _xifexpression_4);
              };
              _xblockexpression_3 = this.javaCode(expr.getArgument(), this.typeUtil.<MapperListOfLists<?>>wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function_1);
            }
            _xifexpression_3 = _xblockexpression_3;
          }
          _xifexpression_2 = _xifexpression_3;
        } else {
          JavaStatementBuilder _xifexpression_4 = null;
          if (isBodyMulti) {
            JavaStatementBuilder _xblockexpression_4 = null;
            {
              final Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, bodyItemType), context.scope);
              final StringConcatenationClient inlineFunctionCode = inlineFunctionCodeAndBodyType.getKey();
              final JavaType inlineFunctionBodyType = inlineFunctionCodeAndBodyType.getValue();
              final Function<JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression it) -> {
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(it);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".mapItemToList(");
                    _builder.append(inlineFunctionCode, "\t");
                    _builder.append(")");
                  }
                };
                JavaParameterizedType<MapperListOfLists<?>> _xifexpression_5 = null;
                boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(inlineFunctionBodyType);
                if (_hasWildcardArgument) {
                  _xifexpression_5 = this.typeUtil.<MapperListOfLists<?>>wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, bodyItemType);
                } else {
                  _xifexpression_5 = this.typeUtil.<MapperListOfLists<?>>wrap(this.typeUtil.MAPPER_LIST_OF_LISTS, bodyItemType);
                }
                return JavaExpression.from(_client, _xifexpression_5);
              };
              _xblockexpression_4 = this.javaCode(expr.getArgument(), this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function_1);
            }
            _xifexpression_4 = _xblockexpression_4;
          } else {
            final Function2<JavaType, JavaType, JavaType> _function_1 = (JavaType a, JavaType b) -> {
              JavaParameterizedType<MapperC<?>> _xifexpression_5 = null;
              boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(b);
              if (_hasWildcardArgument) {
                _xifexpression_5 = this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, bodyItemType);
              } else {
                _xifexpression_5 = this.typeUtil.<MapperC<?>>wrap(this.typeUtil.MAPPER_C, bodyItemType);
              }
              return _xifexpression_5;
            };
            _xifexpression_4 = this.buildSingleItemListOperationOptionalBody(expr, "mapItem", this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, bodyItemType), _function_1, context.scope);
          }
          _xifexpression_2 = _xifexpression_4;
        }
        _xifexpression = _xifexpression_2;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseMaxOperation(final MaxOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      JavaParameterizedType<MapperS<?>> _xifexpression = null;
      InlineFunction _function = expr.getFunction();
      boolean _tripleNotEquals = (_function != null);
      if (_tripleNotEquals) {
        _xifexpression = this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr.getFunction().getBody());
      }
      final JavaParameterizedType<MapperS<?>> bodyType = _xifexpression;
      final Function2<JavaType, JavaType, JavaType> _function_1 = (JavaType a, JavaType b) -> {
        return this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType(a));
      };
      _xblockexpression = this.buildSingleItemListOperationOptionalBody(expr, "max", this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), bodyType, _function_1, context.scope);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseMinOperation(final MinOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      JavaParameterizedType<MapperS<?>> _xifexpression = null;
      InlineFunction _function = expr.getFunction();
      boolean _tripleNotEquals = (_function != null);
      if (_tripleNotEquals) {
        _xifexpression = this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr.getFunction().getBody());
      }
      final JavaParameterizedType<MapperS<?>> bodyType = _xifexpression;
      final Function2<JavaType, JavaType, JavaType> _function_1 = (JavaType a, JavaType b) -> {
        return this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType(a));
      };
      _xblockexpression = this.buildSingleItemListOperationOptionalBody(expr, "min", this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), bodyType, _function_1, context.scope);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseMultiplyOperation(final ArithmeticOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseNotEqualsOperation(final EqualityOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseNumberLiteral(final RosettaNumberLiteral expr, final ExpressionGenerator.Context context) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("new ");
        _builder.append(BigDecimal.class);
        _builder.append("(\"");
        BigDecimal _value = expr.getValue();
        _builder.append(_value);
        _builder.append("\")");
      }
    };
    return JavaExpression.from(_client, this.typeUtil.BIG_DECIMAL);
  }

  @Override
  protected JavaStatementBuilder caseOneOfOperation(final OneOfOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      RType _rType = this.typeProvider.getRType(expr.getArgument());
      final RDataType type = ((RDataType) _rType);
      _xblockexpression = this.buildConstraint(expr.getArgument(), this._rosettaExtensions.getAllAttributes(type.getData()), Necessity.REQUIRED, context);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseOnlyElementOperation(final RosettaOnlyElement expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaReferenceType itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRType(expr.getArgument()));
      _xblockexpression = this.javaCode(expr.getArgument(), itemType, context.scope);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseOnlyExists(final RosettaOnlyExistsExpression expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final RosettaExpression first = IterableExtensions.<RosettaExpression>head(expr.getArgs());
      RDataType parentType = null;
      JavaStatementBuilder _xifexpression = null;
      if ((first instanceof RosettaFeatureCall)) {
        JavaStatementBuilder _xblockexpression_1 = null;
        {
          RType _rType = this.typeProvider.getRType(((RosettaFeatureCall)first).getReceiver());
          parentType = ((RDataType) _rType);
          _xblockexpression_1 = this.javaCode(((RosettaFeatureCall)first).getReceiver(), this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, this._javaTypeTranslator.toJavaReferenceType(parentType)), context.scope);
        }
        _xifexpression = _xblockexpression_1;
      } else {
        JavaStatementBuilder _xblockexpression_2 = null;
        {
          RType _typeOfImplicitVariable = this.typeProvider.typeOfImplicitVariable(expr);
          parentType = ((RDataType) _typeOfImplicitVariable);
          _xblockexpression_2 = this.typeCoercionService.addCoercions(this.implicitVariable(expr, context.scope), this.typeUtil.<Mapper<?>>wrapExtends(this.typeUtil.MAPPER, this._javaTypeTranslator.toJavaReferenceType(parentType)), context.scope);
        }
        _xifexpression = _xblockexpression_2;
      }
      final JavaStatementBuilder parent = _xifexpression;
      final Function1<RosettaExpression, RosettaNamed> _function = (RosettaExpression it) -> {
        if ((it instanceof RosettaFeatureCall)) {
          return ((RosettaFeatureCall)it).getFeature();
        } else {
          if ((it instanceof RosettaSymbolReference)) {
            return ((RosettaSymbolReference)it).getSymbol();
          }
        }
        Class<? extends RosettaExpression> _class = null;
        if (it!=null) {
          _class=it.getClass();
        }
        String _name = null;
        if (_class!=null) {
          _name=_class.getName();
        }
        String _plus = ("Unsupported parent in `only exists` expression of type " + _name);
        throw new UnsupportedOperationException(_plus);
      };
      final List<RosettaNamed> requiredAttributes = ListExtensions.<RosettaExpression, RosettaNamed>map(expr.getArgs(), _function);
      final List<Attribute> allAttrs = this._rosettaExtensions.allNonOverridesAttributes(parentType.getData());
      final Function<JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod("onlyExists");
            _builder.append(_runtimeMethod);
            _builder.append("(");
            _builder.append(it);
            _builder.append(", ");
            _builder.append(Arrays.class);
            _builder.append(".asList(");
            final Function1<Attribute, CharSequence> _function = (Attribute it_1) -> {
              String _name = it_1.getName();
              String _plus = ("\"" + _name);
              return (_plus + "\"");
            };
            String _join = IterableExtensions.<Attribute>join(allAttrs, ", ", _function);
            _builder.append(_join);
            _builder.append("), ");
            _builder.append(Arrays.class);
            _builder.append(".asList(");
            final Function1<RosettaNamed, CharSequence> _function_1 = (RosettaNamed it_1) -> {
              String _name = it_1.getName();
              String _plus = ("\"" + _name);
              return (_plus + "\"");
            };
            String _join_1 = IterableExtensions.<RosettaNamed>join(requiredAttributes, ", ", _function_1);
            _builder.append(_join_1);
            _builder.append("))");
          }
        };
        return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
      };
      _xblockexpression = parent.collapseToSingleExpression(context.scope).mapExpression(_function_1);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseOrOperation(final LogicalOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseReduceOperation(final ReduceOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaReferenceType outputType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRType(expr.getFunction().getBody()));
      final Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, outputType), context.scope);
      final StringConcatenationClient inlineFunctionCode = inlineFunctionCodeAndBodyType.getKey();
      final JavaType inlineFunctionBodyType = inlineFunctionCodeAndBodyType.getValue();
      final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(it);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(".<");
            _builder.append(outputType, "\t");
            _builder.append(">reduce(");
            _builder.append(inlineFunctionCode, "\t");
            _builder.append(")");
          }
        };
        return JavaExpression.from(_client, inlineFunctionBodyType);
      };
      _xblockexpression = this.javaCode(expr.getArgument(), this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseReverseOperation(final ReverseOperation expr, final ExpressionGenerator.Context context) {
    final Function1<JavaType, JavaType> _function = (JavaType it) -> {
      return it;
    };
    return this.buildListOperationNoBody(expr, "reverse", this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), _function, context.scope);
  }

  @Override
  protected JavaStatementBuilder caseSortOperation(final SortOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      JavaParameterizedType<MapperS<?>> _xifexpression = null;
      InlineFunction _function = expr.getFunction();
      boolean _tripleNotEquals = (_function != null);
      if (_tripleNotEquals) {
        _xifexpression = this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr.getFunction().getBody());
      }
      final JavaParameterizedType<MapperS<?>> bodyType = _xifexpression;
      final Function2<JavaType, JavaType, JavaType> _function_1 = (JavaType a, JavaType b) -> {
        return a;
      };
      _xblockexpression = this.buildSingleItemListOperationOptionalBody(expr, "sort", this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), bodyType, _function_1, context.scope);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseStringLiteral(final RosettaStringLiteral expr, final ExpressionGenerator.Context context) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("\"");
        String _escapeJava = StringEscapeUtils.escapeJava(expr.getValue());
        _builder.append(_escapeJava);
        _builder.append("\"");
      }
    };
    return JavaExpression.from(_client, this.typeUtil.STRING);
  }

  @Override
  protected JavaStatementBuilder caseSubtractOperation(final ArithmeticOperation expr, final ExpressionGenerator.Context context) {
    return this.binaryExpr(expr, context);
  }

  @Override
  protected JavaStatementBuilder caseSumOperation(final SumOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaReferenceType itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRType(expr.getArgument()));
      String _simpleName = itemType.getSimpleName();
      String _plus = ("sum" + _simpleName);
      final Function1<JavaType, JavaType> _function = (JavaType it) -> {
        return this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, itemType);
      };
      _xblockexpression = this.buildListOperationNoBody(expr, _plus, this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, itemType), _function, context.scope);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseSymbolReference(final RosettaSymbolReference expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final RosettaSymbol s = expr.getSymbol();
      JavaStatementBuilder _switchResult = null;
      boolean _matched = false;
      if (s instanceof Attribute) {
        _matched=true;
        JavaStatementBuilder _xblockexpression_1 = null;
        {
          final RAttribute attribute = this.rObjectFactory.buildRAttribute(((Attribute)s));
          final RType implicitType = this.typeProvider.typeOfImplicitVariable(expr);
          final Iterable<? extends RosettaFeature> implicitFeatures = this._rosettaExtensions.allFeatures(implicitType, expr);
          JavaStatementBuilder _xifexpression = null;
          boolean _contains = IterableExtensions.contains(implicitFeatures, s);
          if (_contains) {
            JavaStatementBuilder _xblockexpression_2 = null;
            {
              boolean autoValue = true;
              if (((expr.eContainer() instanceof RosettaFeatureCall) && 
                (((RosettaFeatureCall) expr.eContainer()).getFeature() instanceof RosettaMetaType))) {
                autoValue = false;
              }
              _xblockexpression_2 = this.featureCall(this.implicitVariable(expr, context.scope), implicitType, ((RosettaFeature)s), false, context.scope, autoValue);
            }
            _xifexpression = _xblockexpression_2;
          } else {
            GeneratedIdentifier _identifierOrThrow = context.scope.getIdentifierOrThrow(attribute);
            JavaReferenceType _attributeToJavaType = this._javaTypeTranslator.attributeToJavaType(attribute);
            _xifexpression = new JavaVariable(_identifierOrThrow, _attributeToJavaType);
          }
          _xblockexpression_1 = _xifexpression;
        }
        _switchResult = _xblockexpression_1;
      }
      if (!_matched) {
        if (s instanceof ShortcutDeclaration) {
          _matched=true;
          JavaExpression _xblockexpression_1 = null;
          {
            final boolean isMulti = this.cardinalityProvider.isSymbolMulti(s);
            final RShortcut shortcut = this.rObjectFactory.buildRShortcut(((ShortcutDeclaration)s));
            final JavaReferenceType itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfSymbol(s));
            JavaExpression _xifexpression = null;
            boolean _usesOutputParameter = this.exprHelper.usesOutputParameter(((ShortcutDeclaration)s).getExpression());
            if (_usesOutputParameter) {
              JavaExpression _xblockexpression_2 = null;
              {
                JavaReferenceType _xifexpression_1 = null;
                if (isMulti) {
                  _xifexpression_1 = this.typeUtil.<List<?>>wrap(this.typeUtil.LIST, itemType);
                } else {
                  _xifexpression_1 = itemType;
                }
                final JavaReferenceType aliasType = _xifexpression_1;
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    GeneratedIdentifier _identifierOrThrow = context.scope.getIdentifierOrThrow(shortcut);
                    _builder.append(_identifierOrThrow);
                    _builder.append("(");
                    StringConcatenationClient _aliasCallArgs = ExpressionGenerator.this.aliasCallArgs(((ShortcutDeclaration)s), context.scope);
                    _builder.append(_aliasCallArgs);
                    _builder.append(").build()");
                  }
                };
                _xblockexpression_2 = JavaExpression.from(_client, aliasType);
              }
              _xifexpression = _xblockexpression_2;
            } else {
              JavaExpression _xblockexpression_3 = null;
              {
                JavaType _xifexpression_1 = null;
                if (isMulti) {
                  JavaParameterizedType<MapperC<?>> _wrapExtendsIfNotFinal = this.typeUtil.<MapperC<?>>wrapExtendsIfNotFinal(this.typeUtil.MAPPER_C, itemType);
                  _xifexpression_1 = ((JavaType) _wrapExtendsIfNotFinal);
                } else {
                  _xifexpression_1 = this.typeUtil.<MapperS<?>>wrapExtendsIfNotFinal(this.typeUtil.MAPPER_S, itemType);
                }
                final JavaType aliasType = _xifexpression_1;
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    GeneratedIdentifier _identifierOrThrow = context.scope.getIdentifierOrThrow(shortcut);
                    _builder.append(_identifierOrThrow);
                    _builder.append("(");
                    StringConcatenationClient _aliasCallArgs = ExpressionGenerator.this.aliasCallArgs(((ShortcutDeclaration)s), context.scope);
                    _builder.append(_aliasCallArgs);
                    _builder.append(")");
                  }
                };
                _xblockexpression_3 = JavaExpression.from(_client, aliasType);
              }
              _xifexpression = _xblockexpression_3;
            }
            _xblockexpression_1 = _xifexpression;
          }
          _switchResult = _xblockexpression_1;
        }
      }
      if (!_matched) {
        if (s instanceof RosettaEnumeration) {
          _matched=true;
          JavaExpression _xblockexpression_1 = null;
          {
            final JavaType t = this._javaTypeTranslator.toJavaType(new REnumType(((RosettaEnumeration)s)));
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(t);
              }
            };
            _xblockexpression_1 = JavaExpression.from(_client, t);
          }
          _switchResult = _xblockexpression_1;
        }
      }
      if (!_matched) {
        if (s instanceof ClosureParameter) {
          _matched=true;
          GeneratedIdentifier _identifierOrThrow = context.scope.getIdentifierOrThrow(s);
          JavaType _xifexpression = null;
          boolean _isMulti = this.cardinalityProvider.isMulti(expr);
          if (_isMulti) {
            JavaParameterizedType<MapperC<?>> _wrap = this.typeUtil.<MapperC<?>>wrap(this.typeUtil.MAPPER_C, expr);
            _xifexpression = ((JavaType) _wrap);
          } else {
            _xifexpression = this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, expr);
          }
          _switchResult = new JavaVariable(_identifierOrThrow, _xifexpression);
        }
      }
      if (!_matched) {
        if (s instanceof RosettaCallableWithArgs) {
          _matched=true;
          _switchResult = this.callableWithArgsCall(((RosettaCallableWithArgs)s), expr.getArgs(), context.scope);
        }
      }
      if (!_matched) {
        Class<? extends RosettaSymbol> _class = null;
        if (s!=null) {
          _class=s.getClass();
        }
        String _name = null;
        if (_class!=null) {
          _name=_class.getName();
        }
        String _plus = ("Unsupported symbol type of " + _name);
        throw new UnsupportedOperationException(_plus);
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseThenOperation(final ThenOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      RosettaExpression _argument = expr.getArgument();
      JavaType _xifexpression = null;
      boolean _isMulti = this.cardinalityProvider.isMulti(expr.getArgument());
      if (_isMulti) {
        JavaParameterizedType<MapperC<?>> _wrapExtends = this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument());
        _xifexpression = ((JavaType) _wrapExtends);
      } else {
        _xifexpression = this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument());
      }
      final JavaStatementBuilder thenArgCode = this.javaCode(_argument, _xifexpression, context.scope);
      final JavaStatementBuilder thenAsVarCode = thenArgCode.declareAsVariable(true, "thenResult", context.scope);
      int _size = expr.getFunction().getParameters().size();
      boolean _equals = (_size == 0);
      if (_equals) {
        context.scope.createKeySynonym(this._javaIdentifierRepresentationService.getImplicitVarInContext(expr.getFunction()), thenArgCode);
      } else {
        context.scope.createKeySynonym(IterableExtensions.<ClosureParameter>head(expr.getFunction().getParameters()), thenArgCode);
      }
      RosettaExpression _body = expr.getFunction().getBody();
      JavaType _xifexpression_1 = null;
      boolean _isMulti_1 = this.cardinalityProvider.isMulti(expr);
      if (_isMulti_1) {
        JavaParameterizedType<MapperC<?>> _wrapExtends_1 = this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, expr);
        _xifexpression_1 = ((JavaType) _wrapExtends_1);
      } else {
        _xifexpression_1 = this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr);
      }
      final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (JavaExpression a, JavaExpression b) -> {
        return b;
      };
      _xblockexpression = thenAsVarCode.then(
        this.javaCode(_body, _xifexpression_1, context.scope), _function, 
        context.scope);
    }
    return _xblockexpression;
  }

  private JavaStatementBuilder conversionOperation(final RosettaUnaryOperation expr, final ExpressionGenerator.Context context, final StringConcatenationClient conversion, final Class<? extends Exception> errorClass) {
    final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(it);
          _builder.append(".checkedMap(\"");
          String _operator = expr.getOperator();
          _builder.append(_operator);
          _builder.append("\", ");
          _builder.append(conversion);
          _builder.append(", ");
          _builder.append(errorClass);
          _builder.append(".class)");
        }
      };
      return JavaExpression.from(_client, this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, expr));
    };
    return this.javaCode(expr.getArgument(), this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
  }

  @Override
  protected JavaStatementBuilder caseToEnumOperation(final ToEnumOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      RosettaEnumeration _enumeration = expr.getEnumeration();
      final JavaType javaEnum = this._javaTypeTranslator.toJavaType(new REnumType(_enumeration));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(javaEnum);
          _builder.append("::fromDisplayName");
        }
      };
      _xblockexpression = this.conversionOperation(expr, context, _client, IllegalArgumentException.class);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseToIntOperation(final ToIntOperation expr, final ExpressionGenerator.Context context) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(Integer.class);
        _builder.append("::parseInt");
      }
    };
    return this.conversionOperation(expr, context, _client, NumberFormatException.class);
  }

  @Override
  protected JavaStatementBuilder caseToNumberOperation(final ToNumberOperation expr, final ExpressionGenerator.Context context) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(BigDecimal.class);
        _builder.append("::new");
      }
    };
    return this.conversionOperation(expr, context, _client, NumberFormatException.class);
  }

  @Override
  protected JavaStatementBuilder caseToStringOperation(final ToStringOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final RType rType = this.typeProvider.getRType(expr.getArgument());
      StringConcatenationClient _xifexpression = null;
      RType _stripFromTypeAliases = this._typeSystem.stripFromTypeAliases(rType);
      if ((_stripFromTypeAliases instanceof REnumType)) {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            JavaReferenceType _javaReferenceType = ExpressionGenerator.this._javaTypeTranslator.toJavaReferenceType(rType);
            _builder.append(_javaReferenceType);
            _builder.append("::toDisplayString");
          }
        };
        _xifexpression = _client;
      } else {
        StringConcatenationClient _client_1 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(Object.class);
            _builder.append("::toString");
          }
        };
        _xifexpression = _client_1;
      }
      final StringConcatenationClient toStringMethod = _xifexpression;
      final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
        StringConcatenationClient _client_2 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(it);
            _builder.append(".map(\"");
            String _operator = expr.getOperator();
            _builder.append(_operator);
            _builder.append("\", ");
            _builder.append(toStringMethod);
            _builder.append(")");
          }
        };
        return JavaExpression.from(_client_2, this.typeUtil.<MapperS<?>>wrap(this.typeUtil.MAPPER_S, expr));
      };
      _xblockexpression = this.javaCode(expr.getArgument(), this.typeUtil.<MapperS<?>>wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseToTimeOperation(final ToTimeOperation expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final JavaScope lambdaScope = context.scope.lambdaScope();
      final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier("s");
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(lambdaParam);
          _builder.append(" -> ");
          _builder.append(LocalTime.class);
          _builder.append(".parse(s, ");
          _builder.append(DateTimeFormatter.class);
          _builder.append(".ISO_LOCAL_TIME)");
        }
      };
      _xblockexpression = this.conversionOperation(expr, context, _client, 
        DateTimeParseException.class);
    }
    return _xblockexpression;
  }

  @Override
  protected JavaStatementBuilder caseConstructorExpression(final RosettaConstructorExpression expr, final ExpressionGenerator.Context context) {
    JavaStatementBuilder _xblockexpression = null;
    {
      final RType type = this._typeSystem.stripFromTypeAliases(this.typeProvider.getRType(expr));
      final JavaReferenceType clazz = this._javaTypeTranslator.toJavaReferenceType(type);
      JavaStatementBuilder _xifexpression = null;
      if ((type instanceof RDataType)) {
        JavaStatementBuilder _xifexpression_1 = null;
        boolean _isEmpty = expr.getValues().isEmpty();
        if (_isEmpty) {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append(clazz);
              _builder.append(".builder()");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append(".build()");
              _builder.newLine();
            }
          };
          _xifexpression_1 = JavaExpression.from(_client, clazz);
        } else {
          final Function1<ConstructorKeyValuePair, JavaStatementBuilder> _function = (ConstructorKeyValuePair pair) -> {
            JavaStatementBuilder _xblockexpression_1 = null;
            {
              RosettaFeature _key = pair.getKey();
              final Attribute attr = ((Attribute) _key);
              final RosettaExpression attrExpr = pair.getValue();
              final boolean isReference = this._rosettaExtensions.isReference(attr);
              final boolean assignAsKey = (attrExpr instanceof AsKeyOperation);
              final Function<JavaExpression, JavaStatementBuilder> _function_1 = (JavaExpression it) -> {
                StringConcatenationClient _client_1 = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(".set");
                    String _firstUpper = StringExtensions.toFirstUpper(attr.getName());
                    _builder.append(_firstUpper);
                    {
                      if ((isReference && (!assignAsKey))) {
                        _builder.append("Value");
                      }
                    }
                    _builder.append("(");
                    _builder.append(it);
                    _builder.append(")");
                  }
                };
                return JavaExpression.from(_client_1, null);
              };
              _xblockexpression_1 = this.evaluateConstructorValue(attr, attrExpr, this.cardinalityProvider.isSymbolMulti(attr), assignAsKey, context.scope).collapseToSingleExpression(context.scope).mapExpression(_function_1);
            }
            return _xblockexpression_1;
          };
          final Function2<JavaStatementBuilder, JavaStatementBuilder, JavaStatementBuilder> _function_1 = (JavaStatementBuilder acc, JavaStatementBuilder attrCode) -> {
            final BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression allSetCode, JavaExpression setAttr) -> {
              StringConcatenationClient _client_1 = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(allSetCode);
                  _builder.newLineIfNotEmpty();
                  _builder.append(setAttr);
                  _builder.newLineIfNotEmpty();
                }
              };
              return JavaExpression.from(_client_1, 
                null);
            };
            return acc.then(attrCode, _function_2, context.scope);
          };
          final Function<JavaExpression, JavaStatementBuilder> _function_2 = (JavaExpression it) -> {
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(clazz);
                _builder.append(".builder()");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append(it, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append(".build()");
                _builder.newLine();
              }
            };
            return JavaExpression.from(_client_1, clazz);
          };
          _xifexpression_1 = IterableExtensions.<JavaStatementBuilder>reduce(ListExtensions.<ConstructorKeyValuePair, JavaStatementBuilder>map(expr.getValues(), _function), _function_1).mapExpression(_function_2);
        }
        _xifexpression = _xifexpression_1;
      } else {
        JavaStatementBuilder _xblockexpression_1 = null;
        {
          final Function1<ConstructorKeyValuePair, String> _function_3 = (ConstructorKeyValuePair it) -> {
            return it.getKey().getName();
          };
          final Function1<ConstructorKeyValuePair, JavaStatementBuilder> _function_4 = (ConstructorKeyValuePair it) -> {
            return this.evaluateConstructorValue(it.getKey(), it.getValue(), false, false, context.scope);
          };
          final Map<String, JavaStatementBuilder> featureMap = IterableExtensions.<ConstructorKeyValuePair, String, JavaStatementBuilder>toMap(expr.getValues(), _function_3, _function_4);
          _xblockexpression_1 = this.recordUtil.recordConstructor(((RRecordType) type), featureMap, context.scope);
        }
        _xifexpression = _xblockexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  private JavaStatementBuilder evaluateConstructorValue(final RosettaFeature feature, final RosettaExpression value, final boolean isMulti, final boolean assignAsKey, final JavaScope scope) {
    JavaStatementBuilder _xifexpression = null;
    if (assignAsKey) {
      JavaStatementBuilder _xblockexpression = null;
      {
        final JavaReferenceType metaClass = this._javaTypeTranslator.toMetaJavaType(((Attribute) feature));
        JavaStatementBuilder _xifexpression_1 = null;
        if (isMulti) {
          JavaStatementBuilder _xblockexpression_1 = null;
          {
            final JavaScope lambdaScope = scope.lambdaScope();
            final GeneratedIdentifier item = lambdaScope.createUniqueIdentifier("item");
            final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(it);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append(".getItems()");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append(".map(");
                  _builder.append(item, "\t");
                  _builder.append(" -> ");
                  _builder.append(metaClass, "\t");
                  _builder.append(".builder()");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".setExternalReference(");
                  _builder.append(item, "\t\t");
                  _builder.append(".getMappedObject().getMeta().getExternalKey())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".setGlobalReference(");
                  _builder.append(item, "\t\t");
                  _builder.append(".getMappedObject().getMeta().getGlobalKey())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".build())");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append(".collect(");
                  _builder.append(Collectors.class, "\t");
                  _builder.append(".toList())");
                }
              };
              return JavaExpression.from(_client, 
                this.typeUtil.<List<?>>wrap(this.typeUtil.LIST, metaClass));
            };
            _xblockexpression_1 = this.javaCode(value, this.typeUtil.<MapperC<?>>wrapExtends(this.typeUtil.MAPPER_C, value), scope).collapseToSingleExpression(scope).mapExpression(_function);
          }
          _xifexpression_1 = _xblockexpression_1;
        } else {
          JavaStatementBuilder _xblockexpression_2 = null;
          {
            final JavaScope lambdaScope = scope.lambdaScope();
            final GeneratedIdentifier r = lambdaScope.createUniqueIdentifier("r");
            final GeneratedIdentifier m = lambdaScope.createUniqueIdentifier("m");
            final Function<JavaExpression, JavaStatementBuilder> _function = (JavaExpression it) -> {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append(metaClass);
                  _builder.append(".builder()");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append(".setGlobalReference(");
                  _builder.append(Optional.class, "\t");
                  _builder.append(".ofNullable(");
                  _builder.append(it, "\t");
                  _builder.append(")");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".map(");
                  _builder.append(r, "\t\t");
                  _builder.append(" -> ");
                  _builder.append(r, "\t\t");
                  _builder.append(".getMeta())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".map(");
                  _builder.append(m, "\t\t");
                  _builder.append(" -> ");
                  _builder.append(m, "\t\t");
                  _builder.append(".getGlobalKey())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".orElse(null))");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append(".setExternalReference(");
                  _builder.append(Optional.class, "\t");
                  _builder.append(".ofNullable(");
                  _builder.append(it, "\t");
                  _builder.append(")");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".map(");
                  _builder.append(r, "\t\t");
                  _builder.append(" -> ");
                  _builder.append(r, "\t\t");
                  _builder.append(".getMeta())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".map(");
                  _builder.append(m, "\t\t");
                  _builder.append(" -> ");
                  _builder.append(m, "\t\t");
                  _builder.append(".getExternalKey())");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append(".orElse(null))");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append(".build()");
                }
              };
              return JavaExpression.from(_client, metaClass);
            };
            _xblockexpression_2 = this.javaCode(value, this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRType(value)), scope).declareAsVariable(true, feature.getName(), scope).mapExpression(_function);
          }
          _xifexpression_1 = _xblockexpression_2;
        }
        _xblockexpression = _xifexpression_1;
      }
      _xifexpression = _xblockexpression;
    } else {
      JavaStatementBuilder _xblockexpression_1 = null;
      {
        final JavaReferenceType clazz = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfFeature(feature));
        JavaReferenceType _xifexpression_1 = null;
        if (isMulti) {
          _xifexpression_1 = this.typeUtil.<List<?>>wrap(this.typeUtil.LIST, clazz);
        } else {
          _xifexpression_1 = clazz;
        }
        _xblockexpression_1 = this.javaCode(value, _xifexpression_1, scope);
      }
      _xifexpression = _xblockexpression_1;
    }
    return _xifexpression;
  }

  @Override
  protected JavaStatementBuilder caseToDateOperation(final ToDateOperation expr, final ExpressionGenerator.Context context) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(Date.class);
        _builder.append("::parse");
      }
    };
    return this.conversionOperation(expr, context, _client, DateTimeParseException.class);
  }

  @Override
  protected JavaStatementBuilder caseToDateTimeOperation(final ToDateTimeOperation expr, final ExpressionGenerator.Context context) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(LocalDateTime.class);
        _builder.append("::parse");
      }
    };
    return this.conversionOperation(expr, context, _client, DateTimeParseException.class);
  }

  @Override
  protected JavaStatementBuilder caseToZonedDateTimeOperation(final ToZonedDateTimeOperation expr, final ExpressionGenerator.Context context) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append(ZonedDateTime.class);
        _builder.append("::parse");
      }
    };
    return this.conversionOperation(expr, context, _client, DateTimeParseException.class);
  }
}
