package com.regnosys.rosetta.generator.java.object;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.regnosys.rosetta.config.RosettaGeneratorsConfiguration;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.impl.RosettaFactoryImpl;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimpleFactory;
import com.regnosys.rosetta.scoping.RosettaScopeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.meta.BasicRosettaMetaData;
import com.rosetta.model.lib.meta.FieldWithMeta;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.MetaDataFields;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.meta.TemplateFields;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class MetaFieldGenerator {
  /**
   * generate once per resource marker
   */
  public static class MarkerAdapterFactory extends AdapterFactoryImpl {
    private final String namespace;

    public MarkerAdapterFactory(final String namespace) {
      this.namespace = namespace;
    }

    public String getNamespace() {
      return this.namespace;
    }
  }

  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  @Extension
  private ModelObjectGenerator _modelObjectGenerator;

  @Inject
  private RosettaJavaPackages packages;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  @Extension
  private TypeSystem _typeSystem;

  @Inject
  private RosettaGeneratorsConfiguration config;

  public void generate(final Resource resource, final IFileSystemAccess2 fsa, final IGeneratorContext ctx) {
    final RosettaModel model = IterableExtensions.<RosettaModel>head(Iterables.<RosettaModel>filter(resource.getContents(), RosettaModel.class));
    String _name = null;
    if (model!=null) {
      _name=model.getName();
    }
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_name);
    if (_isNullOrEmpty) {
      return;
    }
    final Function1<Resource, EList<EObject>> _function = (Resource it) -> {
      return it.getContents();
    };
    final List<RosettaModel> allModels = IterableExtensions.<RosettaModel>toList(Iterables.<RosettaModel>filter(IterableExtensions.<Resource, EObject>flatMap(resource.getResourceSet().getResources(), _function), RosettaModel.class));
    final Function1<RosettaModel, EList<RosettaRootElement>> _function_1 = (RosettaModel it) -> {
      return it.getElements();
    };
    final List<RosettaMetaType> allMetaTypes = IterableExtensions.<RosettaMetaType>toList(Iterables.<RosettaMetaType>filter(IterableExtensions.<RosettaModel, RosettaRootElement>flatMap(allModels, _function_1), RosettaMetaType.class));
    StringConcatenation _builder = new StringConcatenation();
    String _withForwardSlashes = this.packages.basicMetafields().withForwardSlashes();
    _builder.append(_withForwardSlashes);
    _builder.append("/MetaFields.java");
    fsa.generateFile(_builder.toString(), 
      this.metaFields("MetaFields", CollectionLiterals.<Object>newArrayList(GlobalKeyFields.class), this.getMetaFieldTypes(allMetaTypes)));
    StringConcatenation _builder_1 = new StringConcatenation();
    String _withForwardSlashes_1 = this.packages.basicMetafields().withForwardSlashes();
    _builder_1.append(_withForwardSlashes_1);
    _builder_1.append("/MetaAndTemplateFields.java");
    fsa.generateFile(_builder_1.toString(), 
      this.metaFields("MetaAndTemplateFields", CollectionLiterals.<Object>newArrayList(GlobalKeyFields.class, TemplateFields.class), this.getMetaAndTemplateFieldTypes(allMetaTypes)));
    final Function1<RosettaRootElement, Boolean> _function_2 = (RosettaRootElement it) -> {
      return Boolean.valueOf((it instanceof Data));
    };
    final Iterable<RosettaRootElement> modelClasses = IterableExtensions.<RosettaRootElement>filter(model.getElements(), _function_2);
    boolean _isEmpty = IterableExtensions.isEmpty(modelClasses);
    if (_isEmpty) {
      return;
    }
    final Function<RosettaRootElement, String> _function_3 = (RosettaRootElement c) -> {
      return this.namespace(c);
    };
    final ImmutableMap<String, Collection<RosettaRootElement>> namespaceClasses = Multimaps.<String, RosettaRootElement>index(modelClasses, _function_3).asMap();
    ImmutableSet<Map.Entry<String, Collection<RosettaRootElement>>> _entrySet = namespaceClasses.entrySet();
    for (final Map.Entry<String, Collection<RosettaRootElement>> nsc : _entrySet) {
      {
        boolean _isCanceled = ctx.getCancelIndicator().isCanceled();
        if (_isCanceled) {
          return;
        }
        final Function1<Data, List<ExpandedAttribute>> _function_4 = (Data it) -> {
          return RosettaAttributeExtensions.getExpandedAttributes(it);
        };
        final Function1<ExpandedAttribute, Boolean> _function_5 = (ExpandedAttribute it) -> {
          return Boolean.valueOf((it.hasMetas() && IterableExtensions.<ExpandedAttribute>exists(it.getMetas(), ((Function1<ExpandedAttribute, Boolean>) (ExpandedAttribute it_1) -> {
            return Boolean.valueOf((Objects.equal(it_1.getName(), "reference") || Objects.equal(it_1.getName(), "address")));
          }))));
        };
        final Set<ExpandedAttribute> refs = IterableExtensions.<ExpandedAttribute>toSet(IterableExtensions.<ExpandedAttribute>filter(IterableExtensions.<Data, ExpandedAttribute>flatMap(Iterables.<Data>filter(nsc.getValue(), Data.class), _function_4), _function_5));
        for (final ExpandedAttribute ref : refs) {
          {
            final RosettaModel targetModel = ref.getType().getModel();
            boolean _shouldGenerate = this.shouldGenerate(targetModel);
            if (_shouldGenerate) {
              final RosettaJavaPackages.RootPackage targetPackage = new RosettaJavaPackages.RootPackage(targetModel);
              final JavaClass<?> metaJt = this._javaTypeTranslator.toMetaJavaType(ref);
              boolean _isCanceled_1 = ctx.getCancelIndicator().isCanceled();
              if (_isCanceled_1) {
                return;
              }
              StringConcatenation _builder_2 = new StringConcatenation();
              String _withForwardSlashes_2 = metaJt.getCanonicalName().withForwardSlashes();
              _builder_2.append(_withForwardSlashes_2);
              _builder_2.append(".java");
              fsa.generateFile(_builder_2.toString(), this.referenceWithMeta(targetPackage, metaJt, ref.getRosettaType()));
            }
          }
        }
        final Function1<Data, List<ExpandedAttribute>> _function_6 = (Data it) -> {
          return RosettaAttributeExtensions.getExpandedAttributes(it);
        };
        final Function1<ExpandedAttribute, Boolean> _function_7 = (ExpandedAttribute it) -> {
          return Boolean.valueOf((it.hasMetas() && (!IterableExtensions.<ExpandedAttribute>exists(it.getMetas(), ((Function1<ExpandedAttribute, Boolean>) (ExpandedAttribute it_1) -> {
            return Boolean.valueOf((Objects.equal(it_1.getName(), "reference") || Objects.equal(it_1.getName(), "address")));
          })))));
        };
        final Set<ExpandedAttribute> metas = IterableExtensions.<ExpandedAttribute>toSet(IterableExtensions.<ExpandedAttribute>filter(IterableExtensions.<Data, ExpandedAttribute>flatMap(Iterables.<Data>filter(nsc.getValue(), Data.class), _function_6), _function_7));
        for (final ExpandedAttribute meta : metas) {
          {
            final RosettaModel targetModel = meta.getType().getModel();
            boolean _shouldGenerate = this.shouldGenerate(targetModel);
            if (_shouldGenerate) {
              final RosettaJavaPackages.RootPackage targetPackage = new RosettaJavaPackages.RootPackage(targetModel);
              final JavaClass<?> metaJt = this._javaTypeTranslator.toMetaJavaType(meta);
              boolean _isCanceled_1 = ctx.getCancelIndicator().isCanceled();
              if (_isCanceled_1) {
                return;
              }
              StringConcatenation _builder_2 = new StringConcatenation();
              String _withForwardSlashes_2 = metaJt.getCanonicalName().withForwardSlashes();
              _builder_2.append(_withForwardSlashes_2);
              _builder_2.append(".java");
              fsa.generateFile(_builder_2.toString(), this.fieldWithMeta(targetPackage, metaJt, meta.getRosettaType()));
            }
          }
        }
      }
    }
  }

  public TypeCall toTypeCall(final RosettaType t) {
    final TypeCall typeCall = RosettaFactoryImpl.eINSTANCE.createTypeCall();
    typeCall.setType(t);
    return typeCall;
  }

  public TypeCall getStringType() {
    final RosettaMetaType stringType = RosettaFactoryImpl.eINSTANCE.createRosettaMetaType();
    stringType.setName("string");
    return this.toTypeCall(stringType);
  }

  public RosettaCardinality getCardSingle() {
    RosettaCardinality _xblockexpression = null;
    {
      final RosettaCardinality cardSingle = RosettaFactory.eINSTANCE.createRosettaCardinality();
      cardSingle.setInf(0);
      cardSingle.setSup(1);
      _xblockexpression = cardSingle;
    }
    return _xblockexpression;
  }

  public List<Attribute> getMetaFieldTypes(final Collection<RosettaMetaType> utypes) {
    final RosettaCardinality cardMult = RosettaFactory.eINSTANCE.createRosettaCardinality();
    cardMult.setInf(0);
    cardMult.setSup(1000);
    cardMult.setUnbounded(true);
    final Attribute globalKeyAttribute = SimpleFactory.eINSTANCE.createAttribute();
    globalKeyAttribute.setName("globalKey");
    globalKeyAttribute.setCard(this.getCardSingle());
    globalKeyAttribute.setTypeCall(this.getStringType());
    final Attribute externalKeyAttribute = SimpleFactory.eINSTANCE.createAttribute();
    externalKeyAttribute.setName("externalKey");
    externalKeyAttribute.setCard(this.getCardSingle());
    externalKeyAttribute.setTypeCall(this.getStringType());
    final Data keysType = SimpleFactory.eINSTANCE.createData();
    keysType.setName("Key");
    keysType.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
    RosettaModel _model = keysType.getModel();
    _model.setName("com.rosetta.model.lib.meta");
    final Attribute keysAttribute = SimpleFactory.eINSTANCE.createAttribute();
    keysAttribute.setName("key");
    keysAttribute.setTypeCall(this.toTypeCall(keysType));
    keysAttribute.setCard(cardMult);
    final Function1<RosettaMetaType, Boolean> _function = (RosettaMetaType t) -> {
      return Boolean.valueOf((((!Objects.equal(t.getName(), "key")) && (!Objects.equal(t.getName(), "id"))) && (!Objects.equal(t.getName(), "reference"))));
    };
    final Set<RosettaMetaType> filteredTypes = IterableExtensions.<RosettaMetaType>toSet(IterableExtensions.<RosettaMetaType>filter(utypes, _function));
    final Function1<RosettaMetaType, Attribute> _function_1 = (RosettaMetaType it) -> {
      return this.toAttribute(it);
    };
    final List<Attribute> result = IterableExtensions.<Attribute>toList(IterableExtensions.<RosettaMetaType, Attribute>map(filteredTypes, _function_1));
    result.addAll(Collections.<Attribute>unmodifiableList(CollectionLiterals.<Attribute>newArrayList(globalKeyAttribute, externalKeyAttribute, keysAttribute)));
    return result;
  }

  public Attribute toAttribute(final RosettaMetaType type) {
    final Attribute newAttribute = SimpleFactory.eINSTANCE.createAttribute();
    newAttribute.setCard(this.getCardSingle());
    newAttribute.setName(type.getName());
    newAttribute.setTypeCall(this.toTypeCall(type));
    return newAttribute;
  }

  public List<Attribute> getMetaAndTemplateFieldTypes(final Collection<RosettaMetaType> utypes) {
    final RosettaMetaType templateGlobalReferenceType = RosettaFactoryImpl.eINSTANCE.createRosettaMetaType();
    templateGlobalReferenceType.setName("templateGlobalReference");
    templateGlobalReferenceType.setTypeCall(this.getStringType());
    final RosettaModel libModel = RosettaFactory.eINSTANCE.createRosettaModel();
    libModel.setName(RosettaScopeProvider.LIB_NAMESPACE);
    templateGlobalReferenceType.setModel(libModel);
    final ArrayList<RosettaMetaType> plusTypes = new ArrayList<RosettaMetaType>(utypes);
    plusTypes.add(templateGlobalReferenceType);
    final List<Attribute> metaFieldTypes = this.getMetaFieldTypes(plusTypes);
    return metaFieldTypes;
  }

  public String metaFields(final String name, final Collection<Object> interfaces, final Collection<Attribute> attributes) {
    String _xblockexpression = null;
    {
      final Function1<Attribute, Boolean> _function = (Attribute t) -> {
        String _name = t.getName();
        return Boolean.valueOf(Objects.equal(_name, "scheme"));
      };
      boolean _exists = IterableExtensions.<Attribute>exists(attributes, _function);
      if (_exists) {
        interfaces.add(MetaDataFields.class);
      }
      final Data d = SimpleFactory.eINSTANCE.createData();
      d.setName(name);
      d.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
      RosettaModel _model = d.getModel();
      _model.setName(this.packages.basicMetafields().withDots());
      d.getAttributes().addAll(attributes);
      DottedPath _basicMetafields = this.packages.basicMetafields();
      final JavaScope scope = new JavaScope(_basicMetafields);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          DottedPath _basicMetafields = MetaFieldGenerator.this.packages.basicMetafields();
          String _name = d.getName();
          String _plus = (_name + "Meta");
          GeneratedJavaClass<Object> _generatedJavaClass = new GeneratedJavaClass<Object>(_basicMetafields, _plus, Object.class);
          StringConcatenationClient _classBody = MetaFieldGenerator.this._modelObjectGenerator.classBody(d, scope, _generatedJavaClass, "1", interfaces);
          _builder.append(_classBody);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("class ");
          _builder.append(name);
          _builder.append("Meta extends ");
          _builder.append(BasicRosettaMetaData.class);
          _builder.append("<");
          _builder.append(name);
          _builder.append(">{");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      final StringConcatenationClient body = _client;
      _xblockexpression = this._importManagerExtension.buildClass(this.packages.basicMetafields(), body, scope);
    }
    return _xblockexpression;
  }

  public CharSequence fieldWithMeta(final RosettaJavaPackages.RootPackage root, final JavaClass<?> metaJavaType, final TypeCall typeCall) {
    String _xblockexpression = null;
    {
      final Attribute valueAttribute = SimpleFactory.eINSTANCE.createAttribute();
      valueAttribute.setCard(this.getCardSingle());
      valueAttribute.setName("value");
      valueAttribute.setTypeCall(EcoreUtil2.<TypeCall>copy(typeCall));
      final Data metaType = SimpleFactory.eINSTANCE.createData();
      metaType.setName("MetaFields");
      metaType.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
      RosettaModel _model = metaType.getModel();
      _model.setName(this.packages.basicMetafields().withDots());
      final Attribute metaAttribute = SimpleFactory.eINSTANCE.createAttribute();
      metaAttribute.setName("meta");
      metaAttribute.setTypeCall(this.toTypeCall(metaType));
      metaAttribute.setCard(this.getCardSingle());
      final Data d = SimpleFactory.eINSTANCE.createData();
      d.setName(metaJavaType.getSimpleName());
      d.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
      RosettaModel _model_1 = d.getModel();
      _model_1.setName(metaJavaType.getPackageName().withDots());
      d.getAttributes().addAll(
        Collections.<Attribute>unmodifiableList(CollectionLiterals.<Attribute>newArrayList(valueAttribute, metaAttribute)));
      final JavaParameterizedType<FieldWithMeta<?>> FWMType = JavaParameterizedType.<FieldWithMeta<?>>from(new TypeReference<FieldWithMeta<?>>() {
      }, this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.typeCallToRType(typeCall)));
      DottedPath _packageName = metaJavaType.getPackageName();
      final JavaScope scope = new JavaScope(_packageName);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          DottedPath _packageName = metaJavaType.getPackageName();
          String _name = d.getName();
          String _plus = (_name + "Meta");
          GeneratedJavaClass<Object> _generatedJavaClass = new GeneratedJavaClass<Object>(_packageName, _plus, Object.class);
          StringConcatenationClient _classBody = MetaFieldGenerator.this._modelObjectGenerator.classBody(d, scope, _generatedJavaClass, "1", Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(GlobalKey.class, FWMType)));
          _builder.append(_classBody);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("class ");
          String _simpleName = metaJavaType.getSimpleName();
          _builder.append(_simpleName);
          _builder.append("Meta extends ");
          _builder.append(BasicRosettaMetaData.class);
          _builder.append("<");
          String _simpleName_1 = metaJavaType.getSimpleName();
          _builder.append(_simpleName_1);
          _builder.append(">{");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      final StringConcatenationClient body = _client;
      _xblockexpression = this._importManagerExtension.buildClass(metaJavaType.getPackageName(), body, scope);
    }
    return _xblockexpression;
  }

  public List<Attribute> referenceAttributes(final TypeCall typeCall) {
    List<Attribute> _xblockexpression = null;
    {
      final Attribute valueAttribute = SimpleFactory.eINSTANCE.createAttribute();
      valueAttribute.setCard(this.getCardSingle());
      valueAttribute.setName("value");
      valueAttribute.setTypeCall(EcoreUtil2.<TypeCall>copy(typeCall));
      final Attribute globalRefAttribute = SimpleFactory.eINSTANCE.createAttribute();
      globalRefAttribute.setName("globalReference");
      globalRefAttribute.setCard(this.getCardSingle());
      globalRefAttribute.setTypeCall(this.getStringType());
      final Attribute externalRefAttribute = SimpleFactory.eINSTANCE.createAttribute();
      externalRefAttribute.setName("externalReference");
      externalRefAttribute.setCard(this.getCardSingle());
      externalRefAttribute.setTypeCall(this.getStringType());
      final Data refType = SimpleFactory.eINSTANCE.createData();
      refType.setName("Reference");
      refType.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
      RosettaModel _model = refType.getModel();
      _model.setName("com.rosetta.model.lib.meta");
      final Attribute refAttribute = SimpleFactory.eINSTANCE.createAttribute();
      refAttribute.setName("reference");
      refAttribute.setTypeCall(this.toTypeCall(refType));
      refAttribute.setCard(this.getCardSingle());
      _xblockexpression = Collections.<Attribute>unmodifiableList(CollectionLiterals.<Attribute>newArrayList(valueAttribute, globalRefAttribute, externalRefAttribute, refAttribute));
    }
    return _xblockexpression;
  }

  public String referenceWithMeta(final RosettaJavaPackages.RootPackage root, final JavaClass<?> metaJavaType, final TypeCall typeCall) {
    String _xblockexpression = null;
    {
      final Data d = SimpleFactory.eINSTANCE.createData();
      d.setName(metaJavaType.getSimpleName());
      d.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
      RosettaModel _model = d.getModel();
      _model.setName(metaJavaType.getPackageName().withDots());
      d.getAttributes().addAll(this.referenceAttributes(typeCall));
      final JavaParameterizedType<ReferenceWithMeta<?>> refInterface = JavaParameterizedType.<ReferenceWithMeta<?>>from(new TypeReference<ReferenceWithMeta<?>>() {
      }, this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.typeCallToRType(typeCall)));
      DottedPath _metaField = root.metaField();
      final JavaScope scope = new JavaScope(_metaField);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          DottedPath _metaField = root.metaField();
          String _name = d.getName();
          String _plus = (_name + "Meta");
          GeneratedJavaClass<Object> _generatedJavaClass = new GeneratedJavaClass<Object>(_metaField, _plus, Object.class);
          StringConcatenationClient _classBody = MetaFieldGenerator.this._modelObjectGenerator.classBody(d, scope, _generatedJavaClass, "1", Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(refInterface)));
          _builder.append(_classBody);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("class ");
          String _simpleName = metaJavaType.getSimpleName();
          _builder.append(_simpleName);
          _builder.append("Meta extends ");
          _builder.append(BasicRosettaMetaData.class);
          _builder.append("<");
          String _simpleName_1 = metaJavaType.getSimpleName();
          _builder.append(_simpleName_1);
          _builder.append(">{");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      };
      final StringConcatenationClient body = _client;
      _xblockexpression = this._importManagerExtension.buildClass(root.metaField(), body, scope);
    }
    return _xblockexpression;
  }

  private String namespace(final RosettaRootElement rc) {
    return rc.getModel().getName();
  }

  private boolean shouldGenerate(final RosettaModel model) {
    return (this.config.getNamespaceFilter().test(model.getName()) || model.isOverridden());
  }
}
