package com.regnosys.rosetta.generator.java.object;

import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.Templatable;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ModelObjectBoilerPlate {
  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  @Extension
  private ModelObjectBuilderGenerator _modelObjectBuilderGenerator;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  private final Function1<String, String> toBuilder = ((Function1<String, String>) (String s) -> {
    return (s + "Builder");
  });

  private final Function1<String, String> identity = ((Function1<String, String>) (String s) -> {
    return s;
  });

  public StringConcatenationClient builderBoilerPlate(final Data c, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final List<ExpandedAttribute> attrs = IterableExtensions.<ExpandedAttribute>toList(RosettaAttributeExtensions.getExpandedAttributes(c));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          StringConcatenationClient _contributeEquals = ModelObjectBoilerPlate.this.contributeEquals(c, attrs, scope);
          _builder.append(_contributeEquals);
          _builder.newLineIfNotEmpty();
          StringConcatenationClient _contributeHashCode = ModelObjectBoilerPlate.this.contributeHashCode(c, attrs, scope);
          _builder.append(_contributeHashCode);
          _builder.newLineIfNotEmpty();
          StringConcatenationClient _contributeToString = ModelObjectBoilerPlate.this.contributeToString(c, ModelObjectBoilerPlate.this.toBuilder, scope);
          _builder.append(_contributeToString);
          _builder.newLineIfNotEmpty();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  public StringConcatenationClient implementsClause(final Data d, final Collection<Object> extraInterfaces) {
    StringConcatenationClient _xblockexpression = null;
    {
      final HashSet<Object> interfaces = CollectionLiterals.<Object>newHashSet();
      boolean _hasKeyedAnnotation = this._rosettaExtensions.hasKeyedAnnotation(d);
      if (_hasKeyedAnnotation) {
        interfaces.add(GlobalKey.class);
      }
      boolean _hasTemplateAnnotation = this._rosettaExtensions.hasTemplateAnnotation(d);
      if (_hasTemplateAnnotation) {
        interfaces.add(Templatable.class);
      }
      interfaces.addAll(extraInterfaces);
      StringConcatenationClient _xifexpression = null;
      boolean _isEmpty = interfaces.isEmpty();
      if (_isEmpty) {
        _xifexpression = null;
      } else {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(", ");
            {
              final Function1<Object, String> _function = (Object it) -> {
                return it.getClass().getName();
              };
              List<Object> _sortBy = IterableExtensions.<Object, String>sortBy(interfaces, _function);
              boolean _hasElements = false;
              for(final Object i : _sortBy) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                _builder.append(i);
              }
            }
          }
        };
        _xifexpression = _client;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  public StringConcatenationClient implementsClauseBuilder(final Data d) {
    StringConcatenationClient _xblockexpression = null;
    {
      final ArrayList<StringConcatenationClient> interfaces = CollectionLiterals.<StringConcatenationClient>newArrayList();
      boolean _hasKeyedAnnotation = this._rosettaExtensions.hasKeyedAnnotation(d);
      if (_hasKeyedAnnotation) {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(GlobalKey.GlobalKeyBuilder.class);
          }
        };
        interfaces.add(_client);
      }
      boolean _hasTemplateAnnotation = this._rosettaExtensions.hasTemplateAnnotation(d);
      if (_hasTemplateAnnotation) {
        StringConcatenationClient _client_1 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(Templatable.TemplatableBuilder.class);
          }
        };
        interfaces.add(_client_1);
      }
      StringConcatenationClient _xifexpression = null;
      boolean _isEmpty = interfaces.isEmpty();
      if (_isEmpty) {
        _xifexpression = null;
      } else {
        StringConcatenationClient _client_2 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(", ");
            {
              boolean _hasElements = false;
              for(final StringConcatenationClient i : interfaces) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                _builder.append(i);
              }
            }
          }
        };
        _xifexpression = _client_2;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  public JavaType toListOrSingleMetaType(final ExpandedAttribute attribute) {
    JavaReferenceType _xifexpression = null;
    boolean _isMultiple = attribute.isMultiple();
    if (_isMultiple) {
      _xifexpression = this._javaTypeTranslator.toPolymorphicList(this._javaTypeTranslator.toMetaOrRegularJavaType(attribute));
    } else {
      _xifexpression = this._javaTypeTranslator.toMetaOrRegularJavaType(attribute);
    }
    return _xifexpression;
  }

  public StringConcatenationClient boilerPlate(final Data c, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final List<ExpandedAttribute> attributes = IterableExtensions.<ExpandedAttribute>toList(RosettaAttributeExtensions.getExpandedAttributes(c));
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          StringConcatenationClient _contributeEquals = ModelObjectBoilerPlate.this.contributeEquals(c, attributes, scope);
          _builder.append(_contributeEquals);
          _builder.newLineIfNotEmpty();
          StringConcatenationClient _contributeHashCode = ModelObjectBoilerPlate.this.contributeHashCode(c, attributes, scope);
          _builder.append(_contributeHashCode);
          _builder.newLineIfNotEmpty();
          StringConcatenationClient _contributeToString = ModelObjectBoilerPlate.this.contributeToString(c, ModelObjectBoilerPlate.this.identity, scope);
          _builder.append(_contributeToString);
          _builder.newLineIfNotEmpty();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient contributeHashCode(final ExpandedAttribute attr, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final GeneratedIdentifier id = scope.getIdentifierOrThrow(attr);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            boolean _isEnum = attr.isEnum();
            if (_isEnum) {
              {
                boolean _isList = RosettaAttributeExtensions.isList(attr);
                if (_isList) {
                  _builder.append("_result = 31 * _result + (");
                  _builder.append(id);
                  _builder.append(" != null ? ");
                  _builder.append(id);
                  _builder.append(".stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("_result = 31 * _result + (");
                  _builder.append(id);
                  _builder.append(" != null ? ");
                  _builder.append(id);
                  _builder.append(".getClass().getName().hashCode() : 0);");
                  _builder.newLineIfNotEmpty();
                }
              }
            } else {
              _builder.append("_result = 31 * _result + (");
              _builder.append(id);
              _builder.append(" != null ? ");
              _builder.append(id);
              _builder.append(".hashCode() : 0);");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient contributeHashCode(final Data c, final List<ExpandedAttribute> attributes, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaScope methodScope = scope.methodScope("hashCode");
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("public int hashCode() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("int _result = ");
          String _contribtueSuperHashCode = ModelObjectBoilerPlate.this.contribtueSuperHashCode(c);
          _builder.append(_contribtueSuperHashCode, "\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          {
            final Function1<ExpandedAttribute, Boolean> _function = (ExpandedAttribute it) -> {
              boolean _isOverriding = it.isOverriding();
              return Boolean.valueOf((!_isOverriding));
            };
            Iterable<ExpandedAttribute> _filter = IterableExtensions.<ExpandedAttribute>filter(attributes, _function);
            for(final ExpandedAttribute field : _filter) {
              _builder.append("\t");
              StringConcatenationClient _contributeHashCode = ModelObjectBoilerPlate.this.contributeHashCode(field, methodScope);
              _builder.append(_contributeHashCode, "\t");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("return _result;");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient contributeToString(final Data c, final Function1<? super String, ? extends String> classNameFunc, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaScope methodScope = scope.methodScope("toString");
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("public String toString() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("return \"");
          String _apply = classNameFunc.apply(c.getName());
          _builder.append(_apply, "\t");
          _builder.append(" {\" +");
          _builder.newLineIfNotEmpty();
          {
            final Function1<ExpandedAttribute, Boolean> _function = (ExpandedAttribute it) -> {
              boolean _isOverriding = it.isOverriding();
              return Boolean.valueOf((!_isOverriding));
            };
            Iterable<ExpandedAttribute> _filter = IterableExtensions.<ExpandedAttribute>filter(RosettaAttributeExtensions.getExpandedAttributes(c), _function);
            boolean _hasElements = false;
            for(final ExpandedAttribute attribute : _filter) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(" \", \" +", "\t\t");
              }
              _builder.append("\t\t");
              _builder.append("\"");
              String _name = attribute.getName();
              _builder.append(_name, "\t\t");
              _builder.append("=\" + this.");
              GeneratedIdentifier _identifierOrThrow = methodScope.getIdentifierOrThrow(attribute);
              _builder.append(_identifierOrThrow, "\t\t");
              _builder.append(" +");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("\'}\'");
          {
            boolean _hasSuperType = c.hasSuperType();
            if (_hasSuperType) {
              _builder.append(" + \" \" + super.toString()");
            }
          }
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient contributeEquals(final Data c, final List<ExpandedAttribute> attributes, final JavaScope scope) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaScope methodScope = scope.methodScope("equals");
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("public boolean equals(Object o) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("if (this == o) return true;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("if (o == null || !(o instanceof ");
          _builder.append(RosettaModelObject.class, "\t");
          _builder.append(") || !getType().equals(((RosettaModelObject)o).getType())) return false;");
          _builder.newLineIfNotEmpty();
          {
            boolean _hasSuperType = c.hasSuperType();
            if (_hasSuperType) {
              _builder.append("\t");
              _builder.append("if (!super.equals(o)) return false;");
              _builder.newLine();
            }
          }
          _builder.newLine();
          _builder.append("\t");
          {
            boolean _isEmpty = attributes.isEmpty();
            boolean _not = (!_isEmpty);
            if (_not) {
              String _firstUpper = StringExtensions.toFirstUpper(c.getName());
              _builder.append(_firstUpper, "\t");
              _builder.append(" _that = getType().cast(o);");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            final Function1<ExpandedAttribute, Boolean> _function = (ExpandedAttribute it) -> {
              boolean _isOverriding = it.isOverriding();
              return Boolean.valueOf((!_isOverriding));
            };
            Iterable<ExpandedAttribute> _filter = IterableExtensions.<ExpandedAttribute>filter(attributes, _function);
            for(final ExpandedAttribute field : _filter) {
              _builder.append("\t");
              StringConcatenationClient _contributeToEquals = ModelObjectBoilerPlate.this.contributeToEquals(field, methodScope);
              _builder.append(_contributeToEquals, "\t");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("return true;");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient contributeToEquals(final ExpandedAttribute a, final JavaScope scope) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        {
          boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue(a);
          if (_cardinalityIsListValue) {
            _builder.append("if (!");
            _builder.append(ListEquals.class);
            _builder.append(".listEquals(");
            GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(a);
            _builder.append(_identifierOrThrow);
            _builder.append(", _that.get");
            String _firstUpper = StringExtensions.toFirstUpper(a.getName());
            _builder.append(_firstUpper);
            _builder.append("())) return false;");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("if (!");
            _builder.append(Objects.class);
            _builder.append(".equals(");
            GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(a);
            _builder.append(_identifierOrThrow_1);
            _builder.append(", _that.get");
            String _firstUpper_1 = StringExtensions.toFirstUpper(a.getName());
            _builder.append(_firstUpper_1);
            _builder.append("())) return false;");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    };
    return _client;
  }

  private String contribtueSuperHashCode(final Data c) {
    String _xifexpression = null;
    boolean _hasSuperType = c.hasSuperType();
    if (_hasSuperType) {
      _xifexpression = "super.hashCode()";
    } else {
      _xifexpression = "0";
    }
    return _xifexpression;
  }

  public StringConcatenationClient processMethod(final Data c) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("default void process(");
        _builder.append(RosettaPath.class);
        _builder.append(" path, ");
        _builder.append(Processor.class);
        _builder.append(" processor) {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<ExpandedAttribute, Boolean> _function = (ExpandedAttribute it) -> {
            boolean _isOverriding = it.isOverriding();
            return Boolean.valueOf((!_isOverriding));
          };
          Iterable<ExpandedAttribute> _filter = IterableExtensions.<ExpandedAttribute>filter(RosettaAttributeExtensions.expandedAttributesPlus(c), _function);
          for(final ExpandedAttribute a : _filter) {
            {
              if ((a.isDataType() || a.hasMetas())) {
                _builder.append("\t");
                _builder.append("processRosetta(path.newSubPath(\"");
                String _name = a.getName();
                _builder.append(_name, "\t");
                _builder.append("\"), processor, ");
                JavaReferenceType _metaOrRegularJavaType = ModelObjectBoilerPlate.this._javaTypeTranslator.toMetaOrRegularJavaType(a);
                _builder.append(_metaOrRegularJavaType, "\t");
                _builder.append(".class, get");
                String _firstUpper = StringExtensions.toFirstUpper(a.getName());
                _builder.append(_firstUpper, "\t");
                _builder.append("()");
                StringConcatenationClient _metaFlags = ModelObjectBoilerPlate.this.getMetaFlags(a);
                _builder.append(_metaFlags, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("processor.processBasic(path.newSubPath(\"");
                String _name_1 = a.getName();
                _builder.append(_name_1, "\t");
                _builder.append("\"), ");
                JavaReferenceType _metaOrRegularJavaType_1 = ModelObjectBoilerPlate.this._javaTypeTranslator.toMetaOrRegularJavaType(a);
                _builder.append(_metaOrRegularJavaType_1, "\t");
                _builder.append(".class, get");
                String _firstUpper_1 = StringExtensions.toFirstUpper(a.getName());
                _builder.append(_firstUpper_1, "\t");
                _builder.append("(), this");
                StringConcatenationClient _metaFlags_1 = ModelObjectBoilerPlate.this.getMetaFlags(a);
                _builder.append(_metaFlags_1, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    };
    return _client;
  }

  public StringConcatenationClient builderProcessMethod(final Data c) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("default void process(");
        _builder.append(RosettaPath.class);
        _builder.append(" path, ");
        _builder.append(BuilderProcessor.class);
        _builder.append(" processor) {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<ExpandedAttribute, Boolean> _function = (ExpandedAttribute it) -> {
            boolean _isOverriding = it.isOverriding();
            return Boolean.valueOf((!_isOverriding));
          };
          Iterable<ExpandedAttribute> _filter = IterableExtensions.<ExpandedAttribute>filter(RosettaAttributeExtensions.expandedAttributesPlus(c), _function);
          for(final ExpandedAttribute a : _filter) {
            {
              if ((a.isDataType() || a.hasMetas())) {
                _builder.append("\t");
                _builder.append("processRosetta(path.newSubPath(\"");
                String _name = a.getName();
                _builder.append(_name, "\t");
                _builder.append("\"), processor, ");
                StringConcatenationClient _builderTypeSingle = ModelObjectBoilerPlate.this._modelObjectBuilderGenerator.toBuilderTypeSingle(a);
                _builder.append(_builderTypeSingle, "\t");
                _builder.append(".class, get");
                String _firstUpper = StringExtensions.toFirstUpper(a.getName());
                _builder.append(_firstUpper, "\t");
                _builder.append("()");
                StringConcatenationClient _metaFlags = ModelObjectBoilerPlate.this.getMetaFlags(a);
                _builder.append(_metaFlags, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("processor.processBasic(path.newSubPath(\"");
                String _name_1 = a.getName();
                _builder.append(_name_1, "\t");
                _builder.append("\"), ");
                JavaReferenceType _metaOrRegularJavaType = ModelObjectBoilerPlate.this._javaTypeTranslator.toMetaOrRegularJavaType(a);
                _builder.append(_metaOrRegularJavaType, "\t");
                _builder.append(".class, get");
                String _firstUpper_1 = StringExtensions.toFirstUpper(a.getName());
                _builder.append(_firstUpper_1, "\t");
                _builder.append("(), this");
                StringConcatenationClient _metaFlags_1 = ModelObjectBoilerPlate.this.getMetaFlags(a);
                _builder.append(_metaFlags_1, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    };
    return _client;
  }

  private StringConcatenationClient getMetaFlags(final ExpandedAttribute attribute) {
    StringConcatenationClient _xifexpression = null;
    boolean _isMetaType = attribute.getType().isMetaType();
    if (_isMetaType) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append(", ");
          _builder.append(AttributeMeta.class);
          _builder.append(".META");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _xifexpression_1 = null;
      boolean _hasIdAnnotation = attribute.hasIdAnnotation();
      if (_hasIdAnnotation) {
        StringConcatenationClient _client_1 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(", ");
            _builder.append(AttributeMeta.class);
            _builder.append(".GLOBAL_KEY_FIELD");
          }
        };
        _xifexpression_1 = _client_1;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }

  public boolean needsBuilder(final ExpandedAttribute attribute) {
    return (attribute.isDataType() || attribute.hasMetas());
  }
}
