package com.regnosys.rosetta.generator.java.object;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ValidatorsGenerator {
  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  @Extension
  private RosettaTypeProvider _rosettaTypeProvider;

  @Inject
  @Extension
  private TypeSystem _typeSystem;

  @Inject
  @Extension
  private RBuiltinTypeService _rBuiltinTypeService;

  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;

  public void generate(final RosettaJavaPackages.RootPackage root, final IFileSystemAccess2 fsa, final Data data, final String version) {
    final RDataType t = new RDataType(data);
    String _withForwardSlashes = this._javaTypeTranslator.toValidatorClass(t).getCanonicalName().withForwardSlashes();
    String _plus = (_withForwardSlashes + ".java");
    fsa.generateFile(_plus, 
      this.generateClass(root, data, version));
    String _withForwardSlashes_1 = this._javaTypeTranslator.toTypeFormatValidatorClass(t).getCanonicalName().withForwardSlashes();
    String _plus_1 = (_withForwardSlashes_1 + ".java");
    fsa.generateFile(_plus_1, 
      this.generateTypeFormatValidator(root, data, version));
    String _withForwardSlashes_2 = this._javaTypeTranslator.toOnlyExistsValidatorClass(t).getCanonicalName().withForwardSlashes();
    String _plus_2 = (_withForwardSlashes_2 + ".java");
    fsa.generateFile(_plus_2, 
      this.generateOnlyExistsValidator(root, data, version));
  }

  private String generateClass(final RosettaJavaPackages.RootPackage root, final Data d, final String version) {
    String _xblockexpression = null;
    {
      DottedPath _typeValidation = root.typeValidation();
      final JavaScope scope = new JavaScope(_typeValidation);
      _xblockexpression = this._importManagerExtension.buildClass(root.typeValidation(), this.classBody(new RDataType(d), version, this._rosettaExtensions.allNonOverridesAttributes(d)), scope);
    }
    return _xblockexpression;
  }

  private String generateTypeFormatValidator(final RosettaJavaPackages.RootPackage root, final Data d, final String version) {
    String _xblockexpression = null;
    {
      DottedPath _typeValidation = root.typeValidation();
      final JavaScope scope = new JavaScope(_typeValidation);
      _xblockexpression = this._importManagerExtension.buildClass(root.typeValidation(), this.typeFormatClassBody(new RDataType(d), version, this._rosettaExtensions.allNonOverridesAttributes(d)), scope);
    }
    return _xblockexpression;
  }

  private String generateOnlyExistsValidator(final RosettaJavaPackages.RootPackage root, final Data d, final String version) {
    String _xblockexpression = null;
    {
      DottedPath _existsValidation = root.existsValidation();
      final JavaScope scope = new JavaScope(_existsValidation);
      _xblockexpression = this._importManagerExtension.buildClass(root.existsValidation(), this.onlyExistsClassBody(new RDataType(d), version, this._rosettaExtensions.allNonOverridesAttributes(d)), scope);
    }
    return _xblockexpression;
  }

  private StringConcatenationClient classBody(final RDataType t, final String version, final Iterable<Attribute> attributes) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("public class ");
        JavaClass<?> _validatorClass = ValidatorsGenerator.this._javaTypeTranslator.toValidatorClass(t);
        _builder.append(_validatorClass);
        _builder.append(" implements ");
        _builder.append(Validator.class);
        _builder.append("<");
        JavaClass<?> _javaType = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType);
        _builder.append("> {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ");
        _builder.append(List.class, "\t");
        _builder.append("<");
        _builder.append(ComparisonResult.class, "\t");
        _builder.append("> getComparisonResults(");
        JavaClass<?> _javaType_1 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_1, "\t");
        _builder.append(" o) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        _builder.append(Lists.class, "\t\t");
        _builder.append(".<");
        _builder.append(ComparisonResult.class, "\t\t");
        _builder.append(">newArrayList(");
        _builder.newLineIfNotEmpty();
        {
          final Function1<Attribute, StringConcatenationClient> _function = (Attribute it) -> {
            return ValidatorsGenerator.this.checkCardinality(RosettaAttributeExtensions.toExpandedAttribute(it));
          };
          final Function1<StringConcatenationClient, Boolean> _function_1 = (StringConcatenationClient it) -> {
            return Boolean.valueOf((it != null));
          };
          Iterable<StringConcatenationClient> _filter = IterableExtensions.<StringConcatenationClient>filter(IterableExtensions.<Attribute, StringConcatenationClient>map(attributes, _function), _function_1);
          boolean _hasElements = false;
          for(final StringConcatenationClient attrCheck : _filter) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "\t\t\t\t");
            }
            _builder.append("\t\t\t\t");
            _builder.append(attrCheck, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(ValidationResult.class, "\t");
        _builder.append("<");
        JavaClass<?> _javaType_2 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_2, "\t");
        _builder.append("> validate(");
        _builder.append(RosettaPath.class, "\t");
        _builder.append(" path, ");
        JavaClass<?> _javaType_3 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_3, "\t");
        _builder.append(" o) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("String error = getComparisonResults(o)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".stream()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".filter(res -> !res.get())");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".map(res -> res.getError())");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".collect(");
        Method _method = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "joining");
        _builder.append(_method, "\t\t\t");
        _builder.append("(\"; \"));");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (!");
        Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
        _builder.append(_method_1, "\t\t");
        _builder.append("(error)) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("return ");
        Method _method_2 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
        _builder.append(_method_2, "\t\t\t");
        _builder.append("(\"");
        String _name = t.getName();
        _builder.append(_name, "\t\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
        _builder.append(".CARDINALITY, \"");
        String _name_1 = t.getName();
        _builder.append(_name_1, "\t\t\t");
        _builder.append("\", path, \"\", error);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ");
        Method _method_3 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
        _builder.append(_method_3, "\t\t");
        _builder.append("(\"");
        String _name_2 = t.getName();
        _builder.append(_name_2, "\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t");
        _builder.append(".CARDINALITY, \"");
        String _name_3 = t.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append("\", path, \"\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(List.class, "\t");
        _builder.append("<");
        _builder.append(ValidationResult.class, "\t");
        _builder.append("<?>> getValidationResults(");
        _builder.append(RosettaPath.class, "\t");
        _builder.append(" path, ");
        JavaClass<?> _javaType_4 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_4, "\t");
        _builder.append(" o) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return getComparisonResults(o)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".stream()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".map(res -> {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if (!");
        Method _method_4 = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
        _builder.append(_method_4, "\t\t\t\t");
        _builder.append("(res.getError())) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("return ");
        Method _method_5 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
        _builder.append(_method_5, "\t\t\t\t\t");
        _builder.append("(\"");
        String _name_4 = t.getName();
        _builder.append(_name_4, "\t\t\t\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t\t");
        _builder.append(".CARDINALITY, \"");
        String _name_5 = t.getName();
        _builder.append(_name_5, "\t\t\t\t\t");
        _builder.append("\", path, \"\", res.getError());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return ");
        Method _method_6 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
        _builder.append(_method_6, "\t\t\t\t");
        _builder.append("(\"");
        String _name_6 = t.getName();
        _builder.append(_name_6, "\t\t\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t");
        _builder.append(".CARDINALITY, \"");
        String _name_7 = t.getName();
        _builder.append(_name_7, "\t\t\t\t");
        _builder.append("\", path, \"\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("})");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".collect(");
        Method _method_7 = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "toList");
        _builder.append(_method_7, "\t\t\t");
        _builder.append("());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    };
    return _client;
  }

  private StringConcatenationClient typeFormatClassBody(final RDataType t, final String version, final Iterable<Attribute> attributes) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("public class ");
        JavaClass<?> _typeFormatValidatorClass = ValidatorsGenerator.this._javaTypeTranslator.toTypeFormatValidatorClass(t);
        _builder.append(_typeFormatValidatorClass);
        _builder.append(" implements ");
        _builder.append(Validator.class);
        _builder.append("<");
        JavaClass<?> _javaType = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType);
        _builder.append("> {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ");
        _builder.append(List.class, "\t");
        _builder.append("<");
        _builder.append(ComparisonResult.class, "\t");
        _builder.append("> getComparisonResults(");
        JavaClass<?> _javaType_1 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_1, "\t");
        _builder.append(" o) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        _builder.append(Lists.class, "\t\t");
        _builder.append(".<");
        _builder.append(ComparisonResult.class, "\t\t");
        _builder.append(">newArrayList(");
        _builder.newLineIfNotEmpty();
        {
          final Function1<Attribute, StringConcatenationClient> _function = (Attribute it) -> {
            return ValidatorsGenerator.this.checkTypeFormat(it);
          };
          final Function1<StringConcatenationClient, Boolean> _function_1 = (StringConcatenationClient it) -> {
            return Boolean.valueOf((it != null));
          };
          Iterable<StringConcatenationClient> _filter = IterableExtensions.<StringConcatenationClient>filter(IterableExtensions.<Attribute, StringConcatenationClient>map(attributes, _function), _function_1);
          boolean _hasElements = false;
          for(final StringConcatenationClient attrCheck : _filter) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "\t\t\t\t");
            }
            _builder.append("\t\t\t\t");
            _builder.append(attrCheck, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(ValidationResult.class, "\t");
        _builder.append("<");
        JavaClass<?> _javaType_2 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_2, "\t");
        _builder.append("> validate(");
        _builder.append(RosettaPath.class, "\t");
        _builder.append(" path, ");
        JavaClass<?> _javaType_3 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_3, "\t");
        _builder.append(" o) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("String error = getComparisonResults(o)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".stream()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".filter(res -> !res.get())");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".map(res -> res.getError())");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".collect(");
        Method _method = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "joining");
        _builder.append(_method, "\t\t\t");
        _builder.append("(\"; \"));");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (!");
        Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
        _builder.append(_method_1, "\t\t");
        _builder.append("(error)) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("return ");
        Method _method_2 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
        _builder.append(_method_2, "\t\t\t");
        _builder.append("(\"");
        String _name = t.getName();
        _builder.append(_name, "\t\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
        _builder.append(".TYPE_FORMAT, \"");
        String _name_1 = t.getName();
        _builder.append(_name_1, "\t\t\t");
        _builder.append("\", path, \"\", error);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ");
        Method _method_3 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
        _builder.append(_method_3, "\t\t");
        _builder.append("(\"");
        String _name_2 = t.getName();
        _builder.append(_name_2, "\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t");
        _builder.append(".TYPE_FORMAT, \"");
        String _name_3 = t.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append("\", path, \"\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(List.class, "\t");
        _builder.append("<");
        _builder.append(ValidationResult.class, "\t");
        _builder.append("<?>> getValidationResults(");
        _builder.append(RosettaPath.class, "\t");
        _builder.append(" path, ");
        JavaClass<?> _javaType_4 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_4, "\t");
        _builder.append(" o) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return getComparisonResults(o)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".stream()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".map(res -> {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if (!");
        Method _method_4 = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
        _builder.append(_method_4, "\t\t\t\t");
        _builder.append("(res.getError())) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("return ");
        Method _method_5 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
        _builder.append(_method_5, "\t\t\t\t\t");
        _builder.append("(\"");
        String _name_4 = t.getName();
        _builder.append(_name_4, "\t\t\t\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t\t");
        _builder.append(".TYPE_FORMAT, \"");
        String _name_5 = t.getName();
        _builder.append(_name_5, "\t\t\t\t\t");
        _builder.append("\", path, \"\", res.getError());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return ");
        Method _method_6 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
        _builder.append(_method_6, "\t\t\t\t");
        _builder.append("(\"");
        String _name_6 = t.getName();
        _builder.append(_name_6, "\t\t\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t");
        _builder.append(".TYPE_FORMAT, \"");
        String _name_7 = t.getName();
        _builder.append(_name_7, "\t\t\t\t");
        _builder.append("\", path, \"\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("})");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".collect(");
        Method _method_7 = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "toList");
        _builder.append(_method_7, "\t\t\t");
        _builder.append("());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    };
    return _client;
  }

  private StringConcatenationClient onlyExistsClassBody(final RDataType t, final String version, final Iterable<Attribute> attributes) {
    StringConcatenationClient _client = new StringConcatenationClient() {
      @Override
      protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
        _builder.append("public class ");
        JavaClass<?> _onlyExistsValidatorClass = ValidatorsGenerator.this._javaTypeTranslator.toOnlyExistsValidatorClass(t);
        _builder.append(_onlyExistsValidatorClass);
        _builder.append(" implements ");
        _builder.append(ValidatorWithArg.class);
        _builder.append("<");
        JavaClass<?> _javaType = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType);
        _builder.append(", ");
        _builder.append(Set.class);
        _builder.append("<String>> {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Casting is required to ensure types are output to ensure recompilation in Rosetta */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public <T2 extends ");
        JavaClass<?> _javaType_1 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_1, "\t");
        _builder.append("> ");
        _builder.append(ValidationResult.class, "\t");
        _builder.append("<");
        JavaClass<?> _javaType_2 = ValidatorsGenerator.this._javaTypeTranslator.toJavaType(t);
        _builder.append(_javaType_2, "\t");
        _builder.append("> validate(");
        _builder.append(RosettaPath.class, "\t");
        _builder.append(" path, T2 o, ");
        _builder.append(Set.class, "\t");
        _builder.append("<String> fields) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append(Map.class, "\t\t");
        _builder.append("<String, Boolean> fieldExistenceMap = ");
        _builder.append(ImmutableMap.class, "\t\t");
        _builder.append(".<String, Boolean>builder()");
        _builder.newLineIfNotEmpty();
        {
          for(final Attribute attr : attributes) {
            _builder.append("\t\t\t\t");
            _builder.append(".put(\"");
            String _name = attr.getName();
            _builder.append(_name, "\t\t\t\t");
            _builder.append("\", ");
            _builder.append(ExistenceChecker.class, "\t\t\t\t");
            _builder.append(".isSet((");
            JavaReferenceType _multiMetaOrRegularJavaType = ValidatorsGenerator.this._javaTypeTranslator.toMultiMetaOrRegularJavaType(RosettaAttributeExtensions.toExpandedAttribute(attr));
            _builder.append(_multiMetaOrRegularJavaType, "\t\t\t\t");
            _builder.append(") o.get");
            String _name_1 = attr.getName();
            String _firstUpper = null;
            if (_name_1!=null) {
              _firstUpper=StringExtensions.toFirstUpper(_name_1);
            }
            _builder.append(_firstUpper, "\t\t\t\t");
            _builder.append("()))");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t\t\t");
        _builder.append(".build();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Find the fields that are set");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(Set.class, "\t\t");
        _builder.append("<String> setFields = fieldExistenceMap.entrySet().stream()");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append(".filter(Map.Entry::getValue)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(".map(Map.Entry::getKey)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(".collect(");
        _builder.append(Collectors.class, "\t\t\t\t");
        _builder.append(".toSet());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (setFields.equals(fields)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ");
        Method _method = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
        _builder.append(_method, "\t\t\t");
        _builder.append("(\"");
        String _name_2 = t.getName();
        _builder.append(_name_2, "\t\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
        _builder.append(".ONLY_EXISTS, \"");
        String _name_3 = t.getName();
        _builder.append(_name_3, "\t\t\t");
        _builder.append("\", path, \"\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ");
        Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
        _builder.append(_method_1, "\t\t");
        _builder.append("(\"");
        String _name_4 = t.getName();
        _builder.append(_name_4, "\t\t");
        _builder.append("\", ");
        _builder.append(ValidationResult.ValidationType.class, "\t\t");
        _builder.append(".ONLY_EXISTS, \"");
        String _name_5 = t.getName();
        _builder.append(_name_5, "\t\t");
        _builder.append("\", path, \"\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("String.format(\"[%s] should only be set.  Set fields: %s\", fields, setFields));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    };
    return _client;
  }

  private StringConcatenationClient checkCardinality(final ExpandedAttribute attr) {
    StringConcatenationClient _xifexpression = null;
    if (((attr.getInf() == 0) && attr.isUnbound())) {
      _xifexpression = null;
    } else {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            boolean _isMultiple = attr.isMultiple();
            if (_isMultiple) {
              Method _method = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkCardinality");
              _builder.append(_method);
              _builder.append("(\"");
              String _name = attr.getName();
              _builder.append(_name);
              _builder.append("\", (");
              JavaReferenceType _multiMetaOrRegularJavaType = ValidatorsGenerator.this._javaTypeTranslator.toMultiMetaOrRegularJavaType(attr);
              _builder.append(_multiMetaOrRegularJavaType);
              _builder.append(") o.get");
              String _name_1 = attr.getName();
              String _firstUpper = null;
              if (_name_1!=null) {
                _firstUpper=StringExtensions.toFirstUpper(_name_1);
              }
              _builder.append(_firstUpper);
              _builder.append("() == null ? 0 : ((");
              JavaReferenceType _multiMetaOrRegularJavaType_1 = ValidatorsGenerator.this._javaTypeTranslator.toMultiMetaOrRegularJavaType(attr);
              _builder.append(_multiMetaOrRegularJavaType_1);
              _builder.append(") o.get");
              String _name_2 = attr.getName();
              String _firstUpper_1 = null;
              if (_name_2!=null) {
                _firstUpper_1=StringExtensions.toFirstUpper(_name_2);
              }
              _builder.append(_firstUpper_1);
              _builder.append("()).size(), ");
              int _inf = attr.getInf();
              _builder.append(_inf);
              _builder.append(", ");
              int _sup = attr.getSup();
              _builder.append(_sup);
              _builder.append(")");
              _builder.newLineIfNotEmpty();
            } else {
              Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkCardinality");
              _builder.append(_method_1);
              _builder.append("(\"");
              String _name_3 = attr.getName();
              _builder.append(_name_3);
              _builder.append("\", (");
              JavaReferenceType _multiMetaOrRegularJavaType_2 = ValidatorsGenerator.this._javaTypeTranslator.toMultiMetaOrRegularJavaType(attr);
              _builder.append(_multiMetaOrRegularJavaType_2);
              _builder.append(") o.get");
              String _name_4 = attr.getName();
              String _firstUpper_2 = null;
              if (_name_4!=null) {
                _firstUpper_2=StringExtensions.toFirstUpper(_name_4);
              }
              _builder.append(_firstUpper_2);
              _builder.append("() != null ? 1 : 0, ");
              int _inf_1 = attr.getInf();
              _builder.append(_inf_1);
              _builder.append(", ");
              int _sup_1 = attr.getSup();
              _builder.append(_sup_1);
              _builder.append(")");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      };
      _xifexpression = _client;
    }
    return _xifexpression;
  }

  private StringConcatenationClient checkTypeFormat(final Attribute attr) {
    final RType t = this._typeSystem.stripFromTypeAliases(this._rosettaTypeProvider.getRTypeOfSymbol(attr));
    if ((t instanceof RStringType)) {
      boolean _notEquals = (!Objects.equal(t, this._rBuiltinTypeService.UNCONSTRAINED_STRING));
      if (_notEquals) {
        final int min = ((RStringType)t).getInterval().getMinBound();
        final StringConcatenationClient max = this.optional(((RStringType)t).getInterval().getMax());
        final StringConcatenationClient pattern = this.optionalPattern(((RStringType)t).getPattern());
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            Method _method = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkString");
            _builder.append(_method);
            _builder.append("(\"");
            String _name = attr.getName();
            _builder.append(_name);
            _builder.append("\", ");
            StringConcatenationClient _attributeValue = ValidatorsGenerator.this.getAttributeValue(attr);
            _builder.append(_attributeValue);
            _builder.append(", ");
            _builder.append(min);
            _builder.append(", ");
            _builder.append(max);
            _builder.append(", ");
            _builder.append(pattern);
            _builder.append(")");
          }
        };
        return _client;
      }
    } else {
      if ((t instanceof RNumberType)) {
        boolean _notEquals_1 = (!Objects.equal(t, this._rBuiltinTypeService.UNCONSTRAINED_NUMBER));
        if (_notEquals_1) {
          final StringConcatenationClient digits = this.optional(((RNumberType)t).getDigits());
          final StringConcatenationClient fractionalDigits = this.optional(((RNumberType)t).getFractionalDigits());
          final StringConcatenationClient min_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMin());
          final StringConcatenationClient max_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMax());
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              Method _method = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkNumber");
              _builder.append(_method);
              _builder.append("(\"");
              String _name = attr.getName();
              _builder.append(_name);
              _builder.append("\", ");
              StringConcatenationClient _attributeValue = ValidatorsGenerator.this.getAttributeValue(attr);
              _builder.append(_attributeValue);
              _builder.append(", ");
              _builder.append(digits);
              _builder.append(", ");
              _builder.append(fractionalDigits);
              _builder.append(", ");
              _builder.append(min_1);
              _builder.append(", ");
              _builder.append(max_1);
              _builder.append(")");
            }
          };
          return _client_1;
        }
      }
    }
    return null;
  }

  private StringConcatenationClient getAttributeValue(final Attribute attr) {
    StringConcatenationClient _xifexpression = null;
    boolean _isEmpty = IterableExtensions.isEmpty(this._rosettaExtensions.metaAnnotations(attr));
    if (_isEmpty) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("o.get");
          String _name = attr.getName();
          String _firstUpper = null;
          if (_name!=null) {
            _firstUpper=StringExtensions.toFirstUpper(_name);
          }
          _builder.append(_firstUpper);
          _builder.append("()");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _xblockexpression = null;
      {
        final JavaReferenceType jt = this._javaTypeTranslator.toMultiMetaOrRegularJavaType(RosettaAttributeExtensions.toExpandedAttribute(attr));
        StringConcatenationClient _xifexpression_1 = null;
        boolean _isList = this._javaTypeUtil.isList(jt);
        if (_isList) {
          StringConcatenationClient _xblockexpression_1 = null;
          {
            final JavaType itemType = this._javaTypeUtil.getItemType(jt);
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("o.get");
                String _name = attr.getName();
                String _firstUpper = null;
                if (_name!=null) {
                  _firstUpper=StringExtensions.toFirstUpper(_name);
                }
                _builder.append(_firstUpper);
                _builder.append("().stream().map(");
                _builder.append(itemType);
                _builder.append("::getValue).collect(");
                _builder.append(Collectors.class);
                _builder.append(".toList())");
              }
            };
            _xblockexpression_1 = _client_1;
          }
          _xifexpression_1 = _xblockexpression_1;
        } else {
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("o.get");
              String _name = attr.getName();
              String _firstUpper = null;
              if (_name!=null) {
                _firstUpper=StringExtensions.toFirstUpper(_name);
              }
              _builder.append(_firstUpper);
              _builder.append("().getValue()");
            }
          };
          _xifexpression_1 = _client_1;
        }
        _xblockexpression = _xifexpression_1;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }

  private StringConcatenationClient optional(final Optional<?> v) {
    StringConcatenationClient _xifexpression = null;
    boolean _isPresent = v.isPresent();
    if (_isPresent) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "of");
          _builder.append(_method);
          _builder.append("(");
          Object _get = v.get();
          _builder.append(_get);
          _builder.append(")");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "empty");
          _builder.append(_method);
          _builder.append("()");
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient optionalPattern(final Optional<Pattern> v) {
    StringConcatenationClient _xifexpression = null;
    boolean _isPresent = v.isPresent();
    if (_isPresent) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "of");
          _builder.append(_method);
          _builder.append("(");
          _builder.append(Pattern.class);
          _builder.append(".compile(\"");
          String _escapeJava = StringEscapeUtils.escapeJava(v.get().toString());
          _builder.append(_escapeJava);
          _builder.append("\"))");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "empty");
          _builder.append(_method);
          _builder.append("()");
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient optionalBigDecimal(final Optional<BigDecimal> v) {
    StringConcatenationClient _xifexpression = null;
    boolean _isPresent = v.isPresent();
    if (_isPresent) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "of");
          _builder.append(_method);
          _builder.append("(new ");
          _builder.append(BigDecimal.class);
          _builder.append("(\"");
          String _escapeJava = StringEscapeUtils.escapeJava(v.get().toString());
          _builder.append(_escapeJava);
          _builder.append("\"))");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "empty");
          _builder.append(_method);
          _builder.append("()");
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }
}
