package com.regnosys.rosetta.generator.java.util;

import com.google.common.base.Objects;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.TargetLanguageStringConcatenation;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.types.JavaTypeRepresentation;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaType;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ImportingStringConcatenation extends TargetLanguageStringConcatenation {
  @Accessors(AccessorType.PUBLIC_GETTER)
  private Map<DottedPath, DottedPath> imports = CollectionLiterals.<DottedPath, DottedPath>newHashMap();

  private Map<DottedPath, DottedPath> staticImports = CollectionLiterals.<DottedPath, DottedPath>newHashMap();

  private JavaScope scope;

  public ImportingStringConcatenation(final JavaScope topScope) {
    this.scope = topScope;
  }

  @Override
  protected void append(final Object object, final int index) {
    if ((object instanceof JavaClass)) {
      throw new IllegalStateException();
    } else {
      super.append(object, index);
    }
  }

  @Override
  protected void append(final Object object, final String indentation, final int index) {
    if ((object instanceof JavaClass)) {
      throw new IllegalStateException();
    } else {
      super.append(object, indentation, index);
    }
  }

  @Override
  protected Object handle(final Object object) {
    if ((object instanceof JavaClass)) {
      return this.getOrImportIdentifier(object, ((JavaClass)object).getPackageName(), ((JavaClass)object).getSimpleName());
    } else {
      if ((object instanceof PreferWildcardImportClass)) {
        final JavaClass<?> jc = ((PreferWildcardImportClass)object).getJavaClass();
        return this.getOrWildcardImportIdentifier(jc, jc.getPackageName(), jc.getSimpleName());
      } else {
        if ((object instanceof Method)) {
          return this.getOrStaticImportIdentifier(object, DottedPath.splitOnDots(((Method)object).getDeclaringClass().getCanonicalName()), ((Method)object).getName());
        } else {
          if ((object instanceof PreferWildcardImportMethod)) {
            final Method m = ((PreferWildcardImportMethod)object).getMethod();
            return this.getOrStaticWildcardImportIdentifier(m, DottedPath.splitOnDots(m.getDeclaringClass().getCanonicalName()), m.getName());
          }
        }
      }
    }
    return super.handle(object);
  }

  @Override
  protected Object normalize(final Object object) {
    final Object n = super.normalize(object);
    final JavaType t = JavaType.from(n);
    if ((t == null)) {
      return n;
    }
    if ((t instanceof JavaClass)) {
      if ((t instanceof JavaParameterizedType)) {
        return new JavaTypeRepresentation(t);
      }
      return t;
    }
    return new JavaTypeRepresentation(t);
  }

  public GeneratedIdentifier getOrImportIdentifier(final Object object, final DottedPath packageName, final String simpleName) {
    final DottedPath canonicalName = packageName.child(simpleName);
    final Supplier<GeneratedIdentifier> _function = () -> {
      final Function1<GeneratedIdentifier, Boolean> _function_1 = (GeneratedIdentifier it) -> {
        String _desiredName = it.getDesiredName();
        return Boolean.valueOf(Objects.equal(_desiredName, simpleName));
      };
      GeneratedIdentifier _findFirst = IterableExtensions.<GeneratedIdentifier>findFirst(this.scope.getIdentifiers(), _function_1);
      boolean _tripleNotEquals = (_findFirst != null);
      if (_tripleNotEquals) {
        return this.scope.createIdentifier(object, canonicalName.withDots());
      }
      this.addImportIfNotAlreadyImported(packageName, canonicalName);
      return this.scope.createIdentifier(object, simpleName);
    };
    return this.scope.getIdentifier(object).orElseGet(_function);
  }

  public GeneratedIdentifier getOrWildcardImportIdentifier(final Object object, final DottedPath packageName, final String simpleName) {
    final DottedPath canonicalName = packageName.child(simpleName);
    final Function<GeneratedIdentifier, GeneratedIdentifier> _function = (GeneratedIdentifier it) -> {
      boolean _containsKey = this.imports.containsKey(canonicalName);
      if (_containsKey) {
        this.addWildcardImport(packageName);
      }
      return it;
    };
    final Supplier<GeneratedIdentifier> _function_1 = () -> {
      final Function1<GeneratedIdentifier, Boolean> _function_2 = (GeneratedIdentifier it) -> {
        String _desiredName = it.getDesiredName();
        return Boolean.valueOf(Objects.equal(_desiredName, simpleName));
      };
      GeneratedIdentifier _findFirst = IterableExtensions.<GeneratedIdentifier>findFirst(this.scope.getIdentifiers(), _function_2);
      boolean _tripleNotEquals = (_findFirst != null);
      if (_tripleNotEquals) {
        return this.scope.createIdentifier(object, canonicalName.withDots());
      }
      this.addWildcardImport(packageName);
      return this.scope.createIdentifier(object, simpleName);
    };
    return this.scope.getIdentifier(object).<GeneratedIdentifier>map(_function).orElseGet(_function_1);
  }

  public GeneratedIdentifier getOrStaticImportIdentifier(final Object object, final DottedPath canonicalClassName, final String staticMemberName) {
    final DottedPath canonicalStaticMemberName = canonicalClassName.child(staticMemberName);
    final Supplier<GeneratedIdentifier> _function = () -> {
      final Function1<GeneratedIdentifier, Boolean> _function_1 = (GeneratedIdentifier it) -> {
        String _desiredName = it.getDesiredName();
        return Boolean.valueOf(Objects.equal(_desiredName, staticMemberName));
      };
      GeneratedIdentifier _findFirst = IterableExtensions.<GeneratedIdentifier>findFirst(this.scope.getIdentifiers(), _function_1);
      boolean _tripleNotEquals = (_findFirst != null);
      if (_tripleNotEquals) {
        return this.scope.createIdentifier(object, canonicalStaticMemberName.withDots());
      }
      this.addStaticImportIfNotAlreadyImported(canonicalClassName, canonicalStaticMemberName);
      return this.scope.createIdentifier(object, staticMemberName);
    };
    return this.scope.getIdentifier(object).orElseGet(_function);
  }

  public GeneratedIdentifier getOrStaticWildcardImportIdentifier(final Object object, final DottedPath canonicalClassName, final String staticMemberName) {
    final DottedPath canonicalStaticMemberName = canonicalClassName.child(staticMemberName);
    final Function<GeneratedIdentifier, GeneratedIdentifier> _function = (GeneratedIdentifier it) -> {
      boolean _containsKey = this.staticImports.containsKey(canonicalStaticMemberName);
      if (_containsKey) {
        this.addStaticWildcardImport(canonicalClassName);
      }
      return it;
    };
    final Supplier<GeneratedIdentifier> _function_1 = () -> {
      final Function1<GeneratedIdentifier, Boolean> _function_2 = (GeneratedIdentifier it) -> {
        String _desiredName = it.getDesiredName();
        return Boolean.valueOf(Objects.equal(_desiredName, staticMemberName));
      };
      GeneratedIdentifier _findFirst = IterableExtensions.<GeneratedIdentifier>findFirst(this.scope.getIdentifiers(), _function_2);
      boolean _tripleNotEquals = (_findFirst != null);
      if (_tripleNotEquals) {
        return this.scope.createIdentifier(object, canonicalStaticMemberName.withDots());
      }
      this.addStaticWildcardImport(canonicalClassName);
      return this.scope.createIdentifier(object, staticMemberName);
    };
    return this.scope.getIdentifier(object).<GeneratedIdentifier>map(_function).orElseGet(_function_1);
  }

  public void addImportIfNotAlreadyImported(final DottedPath packageName, final DottedPath canonicalName) {
    boolean _containsKey = this.imports.containsKey(packageName.child("*"));
    boolean _not = (!_containsKey);
    if (_not) {
      this.imports.put(canonicalName, packageName);
    }
  }

  public void addWildcardImport(final DottedPath packageName) {
    final DottedPath wildcard = packageName.child("*");
    DottedPath _put = this.imports.put(wildcard, packageName);
    boolean _tripleEquals = (_put == null);
    if (_tripleEquals) {
      final Predicate<Map.Entry<DottedPath, DottedPath>> _function = (Map.Entry<DottedPath, DottedPath> it) -> {
        return ((!Objects.equal(it.getKey(), wildcard)) && Objects.equal(it.getValue(), packageName));
      };
      this.imports.entrySet().removeIf(_function);
    }
  }

  public void addStaticImportIfNotAlreadyImported(final DottedPath canonicalClassName, final DottedPath canonicalStaticMemberName) {
    boolean _containsKey = this.staticImports.containsKey(canonicalClassName.child("*"));
    boolean _not = (!_containsKey);
    if (_not) {
      this.staticImports.put(canonicalStaticMemberName, canonicalClassName);
    }
  }

  public void addStaticWildcardImport(final DottedPath canonicalClassName) {
    final DottedPath wildcard = canonicalClassName.child("*");
    DottedPath _put = this.staticImports.put(wildcard, canonicalClassName);
    boolean _tripleEquals = (_put == null);
    if (_tripleEquals) {
      final Predicate<Map.Entry<DottedPath, DottedPath>> _function = (Map.Entry<DottedPath, DottedPath> it) -> {
        return ((!Objects.equal(it.getKey(), wildcard)) && Objects.equal(it.getValue(), canonicalClassName));
      };
      this.staticImports.entrySet().removeIf(_function);
    }
  }

  public List<DottedPath> getImports() {
    return IterableExtensions.<DottedPath>sort(this.imports.keySet());
  }

  public List<DottedPath> getStaticImports() {
    return IterableExtensions.<DottedPath>sort(this.staticImports.keySet());
  }
}
