package com.regnosys.rosetta.generator.java.validator;

import com.google.common.base.Objects;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.AttributeValidation;
import com.rosetta.model.lib.validation.ConditionValidation;
import com.rosetta.model.lib.validation.ElementValidationResult;
import com.rosetta.model.lib.validation.RosettaModelObjectValidator;
import com.rosetta.model.lib.validation.TypeValidation;
import com.rosetta.model.lib.validation.ValidationUtil;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ValidatorGenerator {
  @Inject
  @Extension
  private ImportManagerExtension _importManagerExtension;

  @Inject
  @Extension
  private RosettaExtensions _rosettaExtensions;

  @Inject
  @Extension
  private JavaTypeTranslator _javaTypeTranslator;

  @Inject
  @Extension
  private RosettaTypeProvider _rosettaTypeProvider;

  @Inject
  @Extension
  private TypeSystem _typeSystem;

  @Inject
  @Extension
  private RBuiltinTypeService _rBuiltinTypeService;

  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;

  @Inject
  @Extension
  private RObjectFactory _rObjectFactory;

  public void generate(final RosettaJavaPackages.RootPackage root, final IFileSystemAccess2 fsa, final Data data, final String version) {
    DottedPath _typeValidation = root.typeValidation();
    final JavaScope topScope = new JavaScope(_typeValidation);
    final StringConcatenationClient classBody = this.classBody(data, topScope, root);
    final String content = this._importManagerExtension.buildClass(root.typeValidation(), classBody, topScope);
    StringConcatenation _builder = new StringConcatenation();
    String _withForwardSlashes = root.typeValidation().withForwardSlashes();
    _builder.append(_withForwardSlashes);
    _builder.append("/");
    String _name = data.getName();
    _builder.append(_name);
    _builder.append("Validator.java");
    fsa.generateFile(_builder.toString(), content);
  }

  private StringConcatenationClient classBody(final Data data, final JavaScope scope, final RosettaJavaPackages.RootPackage root) {
    StringConcatenationClient _xblockexpression = null;
    {
      final JavaReferenceType modelPojo = this._javaTypeTranslator.toJavaReferenceType(new RDataType(data));
      final RDataType rDataType = new RDataType(data);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("public class ");
          String _name = data.getName();
          _builder.append(_name);
          _builder.append("Validator implements ");
          _builder.append(RosettaModelObjectValidator.class);
          _builder.append("<");
          _builder.append(modelPojo);
          _builder.append(">{");
          _builder.newLineIfNotEmpty();
          {
            EList<Condition> _conditions = data.getConditions();
            for(final Condition con : _conditions) {
              _builder.append("\t");
              _builder.append("@");
              _builder.append(Inject.class, "\t");
              _builder.append(" protected ");
              DottedPath _condition = root.condition();
              String _conditionJavaType = ValidatorGenerator.this._rosettaExtensions.toConditionJavaType(ValidatorGenerator.this._rosettaExtensions.conditionName(con, data));
              GeneratedJavaClass<Object> _generatedJavaClass = new GeneratedJavaClass<Object>(_condition, _conditionJavaType, Object.class);
              _builder.append(_generatedJavaClass, "\t");
              _builder.append(" ");
              String _firstLower = StringExtensions.toFirstLower(ValidatorGenerator.this._rosettaExtensions.conditionName(con, data));
              _builder.append(_firstLower, "\t");
              _builder.append(" ;");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t\t\t\t\t\t");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(TypeValidation.class, "\t");
          _builder.append(" validate(");
          _builder.append(RosettaPath.class, "\t");
          _builder.append(" path, ");
          JavaReferenceType _javaReferenceType = ValidatorGenerator.this._javaTypeTranslator.toJavaReferenceType(rDataType);
          _builder.append(_javaReferenceType, "\t");
          _builder.append(" o) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append(DottedPath.class, "\t\t");
          _builder.append(" packageName = ");
          _builder.append(DottedPath.class, "\t\t");
          _builder.append(".of(o.getClass().getPackage().toString());");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append(String.class, "\t\t");
          _builder.append(" simpleName = o.getClass().getSimpleName();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append(ModelSymbolId.class, "\t\t");
          _builder.append(" modelSymbolId = new ");
          _builder.append(ModelSymbolId.class, "\t\t");
          _builder.append("(packageName, simpleName);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.newLine();
          _builder.append("\t \t");
          _builder.append(List.class, "\t \t");
          _builder.append("<");
          _builder.append(AttributeValidation.class, "\t \t");
          _builder.append("> attributeValidations = new ");
          _builder.append(ArrayList.class, "\t \t");
          _builder.append("<>();");
          _builder.newLineIfNotEmpty();
          {
            List<Attribute> _allNonOverridesAttributes = ValidatorGenerator.this._rosettaExtensions.allNonOverridesAttributes(data);
            for(final Attribute attribute : _allNonOverridesAttributes) {
              _builder.append("\t \t");
              _builder.append("attributeValidations.add(validate");
              String _firstUpper = StringExtensions.toFirstUpper(attribute.getName());
              _builder.append(_firstUpper, "\t \t");
              _builder.append("(");
              StringConcatenationClient _attributeValue = ValidatorGenerator.this.getAttributeValue(attribute);
              _builder.append(_attributeValue, "\t \t");
              _builder.append(", path));");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t \t");
          _builder.newLine();
          _builder.append("\t \t");
          _builder.append(List.class, "\t \t");
          _builder.append("<");
          _builder.append(ConditionValidation.class, "\t \t");
          _builder.append("> conditionValidations = new ");
          _builder.append(ArrayList.class, "\t \t");
          _builder.append("<>();");
          _builder.newLineIfNotEmpty();
          {
            EList<Condition> _conditions_1 = data.getConditions();
            for(final Condition dataCondition : _conditions_1) {
              _builder.append("\t \t");
              _builder.append("conditionValidations.add(validate");
              String _firstUpper_1 = StringExtensions.toFirstUpper(ValidatorGenerator.this._rosettaExtensions.conditionName(dataCondition, data));
              _builder.append(_firstUpper_1, "\t \t");
              _builder.append("(o, path));");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.newLine();
          _builder.append("\t \t");
          _builder.append("return new ");
          _builder.append(TypeValidation.class, "\t \t");
          _builder.append("(modelSymbolId, attributeValidations, conditionValidations);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.newLine();
          {
            List<Attribute> _allNonOverridesAttributes_1 = ValidatorGenerator.this._rosettaExtensions.allNonOverridesAttributes(data);
            for(final Attribute attribute_1 : _allNonOverridesAttributes_1) {
              _builder.append("\t");
              _builder.append("public ");
              _builder.append(AttributeValidation.class, "\t");
              _builder.append(" validate");
              String _firstUpper_2 = StringExtensions.toFirstUpper(attribute_1.getName());
              _builder.append(_firstUpper_2, "\t");
              _builder.append("(");
              JavaReferenceType _attributeToJavaType = ValidatorGenerator.this._javaTypeTranslator.attributeToJavaType(ValidatorGenerator.this._rObjectFactory.buildRAttribute(attribute_1));
              _builder.append(_attributeToJavaType, "\t");
              _builder.append(" atr, ");
              _builder.append(RosettaPath.class, "\t");
              _builder.append(" path) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append(List.class, "\t\t");
              _builder.append("<");
              _builder.append(ElementValidationResult.class, "\t\t");
              _builder.append("> validationResults = new ");
              _builder.append(ArrayList.class, "\t\t");
              _builder.append("<>();");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              final StringConcatenationClient cardinalityCheck = ValidatorGenerator.this.checkCardinality(attribute_1);
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append(ElementValidationResult.class, "\t\t");
              _builder.append(" cardinalityValidation =");
              {
                if ((cardinalityCheck != null)) {
                  _builder.append(cardinalityCheck, "\t\t");
                  _builder.append(";");
                } else {
                  _builder.append(ElementValidationResult.class, "\t\t");
                  _builder.append(".success(path);");
                }
              }
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              {
                boolean _isIsMany = attribute_1.getCard().isIsMany();
                boolean _not = (!_isIsMany);
                if (_not) {
                  final StringConcatenationClient typeFormatCheck = ValidatorGenerator.this.checkTypeFormat(attribute_1, "atr");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("    ");
                  {
                    if ((typeFormatCheck != null)) {
                      _builder.append("validationResults.add(");
                      _builder.append(typeFormatCheck, "\t\t    ");
                      _builder.append(");");
                    }
                  }
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("if (atr != null) {");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("    ");
                  _builder.append("for (");
                  JavaReferenceType _javaReferenceType_1 = ValidatorGenerator.this._javaTypeTranslator.toJavaReferenceType(ValidatorGenerator.this._rosettaTypeProvider.getRTypeOfSymbol(attribute_1));
                  _builder.append(_javaReferenceType_1, "\t\t    ");
                  _builder.append(" atrb : atr) {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("\t\t");
                  final StringConcatenationClient typeFormatCheck_1 = ValidatorGenerator.this.checkTypeFormat(attribute_1, "atrb");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("\t\t");
                  {
                    if ((typeFormatCheck_1 != null)) {
                      _builder.append("validationResults.add(");
                      _builder.append(typeFormatCheck_1, "\t\t\t\t");
                      _builder.append(");");
                    }
                  }
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                }
              }
              _builder.append("\t");
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return new ");
              _builder.append(AttributeValidation.class, "\t\t");
              _builder.append("(\"");
              String _name_1 = attribute_1.getName();
              _builder.append(_name_1, "\t\t");
              _builder.append("\", cardinalityValidation, validationResults);");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.newLine();
          {
            EList<Condition> _conditions_2 = data.getConditions();
            for(final Condition dataCondition_1 : _conditions_2) {
              _builder.append("\t");
              _builder.append("public ");
              _builder.append(ConditionValidation.class, "\t");
              _builder.append(" validate");
              String _firstUpper_3 = StringExtensions.toFirstUpper(ValidatorGenerator.this._rosettaExtensions.conditionName(dataCondition_1, data));
              _builder.append(_firstUpper_3, "\t");
              _builder.append("(");
              JavaReferenceType _javaReferenceType_2 = ValidatorGenerator.this._javaTypeTranslator.toJavaReferenceType(rDataType);
              _builder.append(_javaReferenceType_2, "\t");
              _builder.append(" data, ");
              _builder.append(RosettaPath.class, "\t");
              _builder.append(" path) {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append(ElementValidationResult.class, "\t\t");
              _builder.append(" result = ");
              String _firstLower_1 = StringExtensions.toFirstLower(ValidatorGenerator.this._rosettaExtensions.conditionName(dataCondition_1, data));
              _builder.append(_firstLower_1, "\t\t");
              _builder.append(".validate(path, data);");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return new ");
              _builder.append(ConditionValidation.class, "\t\t");
              _builder.append("(");
              String _firstLower_2 = StringExtensions.toFirstLower(ValidatorGenerator.this._rosettaExtensions.conditionName(dataCondition_1, data));
              _builder.append(_firstLower_2, "\t\t");
              _builder.append(".toString(), result);");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
            }
          }
          _builder.append("}");
          _builder.newLine();
        }
      };
      _xblockexpression = _client;
    }
    return _xblockexpression;
  }

  private StringConcatenationClient checkCardinality(final Attribute attr) {
    StringConcatenationClient _xifexpression = null;
    if (((attr.getCard().getInf() == 0) && attr.getCard().isUnbounded())) {
      _xifexpression = null;
    } else {
      StringConcatenationClient _xifexpression_1 = null;
      boolean _isIsMany = attr.getCard().isIsMany();
      if (_isIsMany) {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            Method _method = ValidatorGenerator.this._importManagerExtension.method(ValidationUtil.class, "checkCardinality");
            _builder.append(_method);
            _builder.append("(\"");
            String _string = attr.getName().toString();
            _builder.append(_string);
            _builder.append("\", atr == null ? 0 : atr.size(), ");
            int _inf = attr.getCard().getInf();
            _builder.append(_inf);
            _builder.append(", ");
            int _sup = attr.getCard().getSup();
            _builder.append(_sup);
            _builder.append(" , path)");
          }
        };
        _xifexpression_1 = _client;
      } else {
        StringConcatenationClient _client_1 = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            Method _method = ValidatorGenerator.this._importManagerExtension.method(ValidationUtil.class, "checkCardinality");
            _builder.append(_method);
            _builder.append("(\"");
            String _string = attr.getName().toString();
            _builder.append(_string);
            _builder.append("\", atr != null ? 1 : 0, ");
            int _inf = attr.getCard().getInf();
            _builder.append(_inf);
            _builder.append(", ");
            int _sup = attr.getCard().getSup();
            _builder.append(_sup);
            _builder.append(", path)");
          }
        };
        _xifexpression_1 = _client_1;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient checkTypeFormat(final Attribute attr, final String atrVariable) {
    final RType t = this._typeSystem.stripFromTypeAliases(this._rosettaTypeProvider.getRTypeOfSymbol(attr));
    if ((t instanceof RStringType)) {
      boolean _notEquals = (!Objects.equal(t, this._rBuiltinTypeService.UNCONSTRAINED_STRING));
      if (_notEquals) {
        final int min = ((RStringType)t).getInterval().getMinBound();
        final StringConcatenationClient max = this.optional(((RStringType)t).getInterval().getMax());
        final StringConcatenationClient pattern = this.optionalPattern(((RStringType)t).getPattern());
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            Method _method = ValidatorGenerator.this._importManagerExtension.method(ValidationUtil.class, "checkString");
            _builder.append(_method);
            _builder.append("(\"");
            String _name = attr.getName();
            _builder.append(_name);
            _builder.append("\", ");
            _builder.append(atrVariable);
            _builder.append(", ");
            _builder.append(min);
            _builder.append(", ");
            _builder.append(max);
            _builder.append(", ");
            _builder.append(pattern);
            _builder.append(", path)");
          }
        };
        return _client;
      }
    } else {
      if ((t instanceof RNumberType)) {
        final boolean testintomethod = false;
        boolean _notEquals_1 = (!Objects.equal(t, this._rBuiltinTypeService.UNCONSTRAINED_NUMBER));
        if (_notEquals_1) {
          final StringConcatenationClient digits = this.optional(((RNumberType)t).getDigits());
          final StringConcatenationClient fractionalDigits = this.optional(((RNumberType)t).getFractionalDigits());
          final StringConcatenationClient min_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMin());
          final StringConcatenationClient max_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMax());
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              Method _method = ValidatorGenerator.this._importManagerExtension.method(ValidationUtil.class, "checkNumber");
              _builder.append(_method);
              _builder.append("(\"");
              String _name = attr.getName();
              _builder.append(_name);
              _builder.append("\", ");
              _builder.append(atrVariable);
              _builder.append(", ");
              _builder.append(digits);
              _builder.append(", ");
              {
                boolean _isInteger = ((RNumberType)t).isInteger();
                boolean _not = (!_isInteger);
                if (_not) {
                  _builder.append(fractionalDigits);
                  _builder.append(", ");
                }
              }
              _builder.append(min_1);
              _builder.append(", ");
              _builder.append(max_1);
              _builder.append(", path)");
            }
          };
          return _client_1;
        }
      }
    }
    return null;
  }

  private StringConcatenationClient getAttributeValue(final Attribute attr) {
    StringConcatenationClient _xifexpression = null;
    boolean _isEmpty = IterableExtensions.isEmpty(this._rosettaExtensions.metaAnnotations(attr));
    if (_isEmpty) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("o.get");
          String _name = attr.getName();
          String _firstUpper = null;
          if (_name!=null) {
            _firstUpper=StringExtensions.toFirstUpper(_name);
          }
          _builder.append(_firstUpper);
          _builder.append("()");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _xblockexpression = null;
      {
        final JavaReferenceType jt = this._javaTypeTranslator.toMultiMetaOrRegularJavaType(RosettaAttributeExtensions.toExpandedAttribute(attr));
        StringConcatenationClient _xifexpression_1 = null;
        boolean _isList = this._javaTypeUtil.isList(jt);
        if (_isList) {
          StringConcatenationClient _xblockexpression_1 = null;
          {
            final JavaType itemType = this._javaTypeUtil.getItemType(jt);
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("o.get");
                String _name = attr.getName();
                String _firstUpper = null;
                if (_name!=null) {
                  _firstUpper=StringExtensions.toFirstUpper(_name);
                }
                _builder.append(_firstUpper);
                _builder.append("().stream().map(");
                _builder.append(itemType);
                _builder.append("::getValue).collect(");
                _builder.append(Collectors.class);
                _builder.append(".toList())");
              }
            };
            _xblockexpression_1 = _client_1;
          }
          _xifexpression_1 = _xblockexpression_1;
        } else {
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("o.get");
              String _name = attr.getName();
              String _firstUpper = null;
              if (_name!=null) {
                _firstUpper=StringExtensions.toFirstUpper(_name);
              }
              _builder.append(_firstUpper);
              _builder.append("().getValue()");
            }
          };
          _xifexpression_1 = _client_1;
        }
        _xblockexpression = _xifexpression_1;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }

  private StringConcatenationClient optional(final Optional<?> v) {
    StringConcatenationClient _xifexpression = null;
    boolean _isPresent = v.isPresent();
    if (_isPresent) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "of");
          _builder.append(_method);
          _builder.append("(");
          Object _get = v.get();
          _builder.append(_get);
          _builder.append(")");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "empty");
          _builder.append(_method);
          _builder.append("()");
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient optionalPattern(final Optional<Pattern> v) {
    StringConcatenationClient _xifexpression = null;
    boolean _isPresent = v.isPresent();
    if (_isPresent) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "of");
          _builder.append(_method);
          _builder.append("(");
          _builder.append(Pattern.class);
          _builder.append(".compile(\"");
          String _escapeJava = StringEscapeUtils.escapeJava(v.get().toString());
          _builder.append(_escapeJava);
          _builder.append("\"))");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "empty");
          _builder.append(_method);
          _builder.append("()");
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }

  private StringConcatenationClient optionalBigDecimal(final Optional<BigDecimal> v) {
    StringConcatenationClient _xifexpression = null;
    boolean _isPresent = v.isPresent();
    if (_isPresent) {
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "of");
          _builder.append(_method);
          _builder.append("(new ");
          _builder.append(BigDecimal.class);
          _builder.append("(\"");
          String _escapeJava = StringEscapeUtils.escapeJava(v.get().toString());
          _builder.append(_escapeJava);
          _builder.append("\"))");
        }
      };
      _xifexpression = _client;
    } else {
      StringConcatenationClient _client_1 = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          Method _method = ValidatorGenerator.this._importManagerExtension.method(Optional.class, "empty");
          _builder.append(_method);
          _builder.append("()");
        }
      };
      _xifexpression = _client_1;
    }
    return _xifexpression;
  }
}
