package com.regnosys.rosetta.generator.object;

import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.TypeCall;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
@SuppressWarnings("all")
public final class ExpandedAttribute {
  private final String name;

  private final String enclosingType;

  private final ExpandedType type;

  private final TypeCall rosettaType;

  private final boolean overriding;

  private final int inf;

  private final int sup;

  private final boolean isUnbound;

  private final List<ExpandedSynonym> synonyms;

  private final String definition;

  private final List<RosettaDocReference> docReferences;

  private final boolean isEnum;

  private final List<ExpandedAttribute> metas;

  public ExpandedType getType() {
    return this.type;
  }

  public boolean isMultiple() {
    return ((this.isUnbound() || (this.inf > 1)) || (this.sup != 1));
  }

  public boolean isSingleOptional() {
    return ((this.inf == 0) && (!this.isMultiple()));
  }

  public int refIndex() {
    for (int i = 0; (i < this.metas.size()); i++) {
      String _name = this.metas.get(i).getName();
      if (_name != null) {
        switch (_name) {
          case "reference":
          case "address":
            return i;
        }
      }
    }
    return (-1);
  }

  public boolean hasMetas() {
    boolean _isEmpty = this.metas.isEmpty();
    return (!_isEmpty);
  }

  public boolean hasIdAnnotation() {
    final Function1<ExpandedAttribute, String> _function = (ExpandedAttribute it) -> {
      return it.name;
    };
    return ListExtensions.<ExpandedAttribute, String>map(this.metas, _function).contains("id");
  }

  public boolean isDataType() {
    return this.getType().isType();
  }

  public boolean builtInType() {
    return this.getType().isBuiltInType();
  }

  public String javaAnnotation() {
    if ((((this.name == "key") && (this.type.getName() == "Key")) && (this.type.getModel().getName() == "com.rosetta.model.lib.meta"))) {
      return "location";
    } else {
      if ((((this.name == "reference") && (this.type.getName() == "Reference")) && (this.type.getModel().getName() == "com.rosetta.model.lib.meta"))) {
        return "address";
      } else {
        return this.name;
      }
    }
  }

  public ExpandedAttribute(final String name, final String enclosingType, final ExpandedType type, final TypeCall rosettaType, final boolean overriding, final int inf, final int sup, final boolean isUnbound, final List<ExpandedSynonym> synonyms, final String definition, final List<RosettaDocReference> docReferences, final boolean isEnum, final List<ExpandedAttribute> metas) {
    super();
    this.name = name;
    this.enclosingType = enclosingType;
    this.type = type;
    this.rosettaType = rosettaType;
    this.overriding = overriding;
    this.inf = inf;
    this.sup = sup;
    this.isUnbound = isUnbound;
    this.synonyms = synonyms;
    this.definition = definition;
    this.docReferences = docReferences;
    this.isEnum = isEnum;
    this.metas = metas;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.name== null) ? 0 : this.name.hashCode());
    result = prime * result + ((this.enclosingType== null) ? 0 : this.enclosingType.hashCode());
    result = prime * result + ((this.type== null) ? 0 : this.type.hashCode());
    result = prime * result + ((this.rosettaType== null) ? 0 : this.rosettaType.hashCode());
    result = prime * result + (this.overriding ? 1231 : 1237);
    result = prime * result + this.inf;
    result = prime * result + this.sup;
    result = prime * result + (this.isUnbound ? 1231 : 1237);
    result = prime * result + ((this.synonyms== null) ? 0 : this.synonyms.hashCode());
    result = prime * result + ((this.definition== null) ? 0 : this.definition.hashCode());
    result = prime * result + ((this.docReferences== null) ? 0 : this.docReferences.hashCode());
    result = prime * result + (this.isEnum ? 1231 : 1237);
    return prime * result + ((this.metas== null) ? 0 : this.metas.hashCode());
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ExpandedAttribute other = (ExpandedAttribute) obj;
    if (this.name == null) {
      if (other.name != null)
        return false;
    } else if (!this.name.equals(other.name))
      return false;
    if (this.enclosingType == null) {
      if (other.enclosingType != null)
        return false;
    } else if (!this.enclosingType.equals(other.enclosingType))
      return false;
    if (this.type == null) {
      if (other.type != null)
        return false;
    } else if (!this.type.equals(other.type))
      return false;
    if (this.rosettaType == null) {
      if (other.rosettaType != null)
        return false;
    } else if (!this.rosettaType.equals(other.rosettaType))
      return false;
    if (other.overriding != this.overriding)
      return false;
    if (other.inf != this.inf)
      return false;
    if (other.sup != this.sup)
      return false;
    if (other.isUnbound != this.isUnbound)
      return false;
    if (this.synonyms == null) {
      if (other.synonyms != null)
        return false;
    } else if (!this.synonyms.equals(other.synonyms))
      return false;
    if (this.definition == null) {
      if (other.definition != null)
        return false;
    } else if (!this.definition.equals(other.definition))
      return false;
    if (this.docReferences == null) {
      if (other.docReferences != null)
        return false;
    } else if (!this.docReferences.equals(other.docReferences))
      return false;
    if (other.isEnum != this.isEnum)
      return false;
    if (this.metas == null) {
      if (other.metas != null)
        return false;
    } else if (!this.metas.equals(other.metas))
      return false;
    return true;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("name", this.name);
    b.add("enclosingType", this.enclosingType);
    b.add("type", this.type);
    b.add("rosettaType", this.rosettaType);
    b.add("overriding", this.overriding);
    b.add("inf", this.inf);
    b.add("sup", this.sup);
    b.add("isUnbound", this.isUnbound);
    b.add("synonyms", this.synonyms);
    b.add("definition", this.definition);
    b.add("docReferences", this.docReferences);
    b.add("isEnum", this.isEnum);
    b.add("metas", this.metas);
    return b.toString();
  }

  @Pure
  public String getName() {
    return this.name;
  }

  @Pure
  public String getEnclosingType() {
    return this.enclosingType;
  }

  @Pure
  public TypeCall getRosettaType() {
    return this.rosettaType;
  }

  @Pure
  public boolean isOverriding() {
    return this.overriding;
  }

  @Pure
  public int getInf() {
    return this.inf;
  }

  @Pure
  public int getSup() {
    return this.sup;
  }

  @Pure
  public boolean isUnbound() {
    return this.isUnbound;
  }

  @Pure
  public List<ExpandedSynonym> getSynonyms() {
    return this.synonyms;
  }

  @Pure
  public String getDefinition() {
    return this.definition;
  }

  @Pure
  public List<RosettaDocReference> getDocReferences() {
    return this.docReferences;
  }

  @Pure
  public boolean isEnum() {
    return this.isEnum;
  }

  @Pure
  public List<ExpandedAttribute> getMetas() {
    return this.metas;
  }
}
