package com.regnosys.rosetta.generator.object;

import com.regnosys.rosetta.rosetta.RosettaMapping;
import com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue;
import com.regnosys.rosetta.rosetta.RosettaSynonymSource;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
@SuppressWarnings("all")
public final class ExpandedSynonym {
  private final List<RosettaSynonymSource> sources;

  private final List<ExpandedSynonymValue> values;

  private final List<String> hints;

  private final RosettaMergeSynonymValue merge;

  private final List<ExpandedSynonymValue> metaValues;

  private final RosettaMapping mappingLogic;

  private final String mapperName;

  private final String format;

  private final String patternMatcher;

  private final String patternReplace;

  private final boolean removeHtml;

  public ExpandedSynonym(final List<RosettaSynonymSource> sources, final List<ExpandedSynonymValue> values, final List<String> hints, final RosettaMergeSynonymValue merge, final List<ExpandedSynonymValue> metaValues, final RosettaMapping mappingLogic, final String mapperName, final String format, final String patternMatcher, final String patternReplace, final boolean removeHtml) {
    super();
    this.sources = sources;
    this.values = values;
    this.hints = hints;
    this.merge = merge;
    this.metaValues = metaValues;
    this.mappingLogic = mappingLogic;
    this.mapperName = mapperName;
    this.format = format;
    this.patternMatcher = patternMatcher;
    this.patternReplace = patternReplace;
    this.removeHtml = removeHtml;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.sources== null) ? 0 : this.sources.hashCode());
    result = prime * result + ((this.values== null) ? 0 : this.values.hashCode());
    result = prime * result + ((this.hints== null) ? 0 : this.hints.hashCode());
    result = prime * result + ((this.merge== null) ? 0 : this.merge.hashCode());
    result = prime * result + ((this.metaValues== null) ? 0 : this.metaValues.hashCode());
    result = prime * result + ((this.mappingLogic== null) ? 0 : this.mappingLogic.hashCode());
    result = prime * result + ((this.mapperName== null) ? 0 : this.mapperName.hashCode());
    result = prime * result + ((this.format== null) ? 0 : this.format.hashCode());
    result = prime * result + ((this.patternMatcher== null) ? 0 : this.patternMatcher.hashCode());
    result = prime * result + ((this.patternReplace== null) ? 0 : this.patternReplace.hashCode());
    return prime * result + (this.removeHtml ? 1231 : 1237);
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ExpandedSynonym other = (ExpandedSynonym) obj;
    if (this.sources == null) {
      if (other.sources != null)
        return false;
    } else if (!this.sources.equals(other.sources))
      return false;
    if (this.values == null) {
      if (other.values != null)
        return false;
    } else if (!this.values.equals(other.values))
      return false;
    if (this.hints == null) {
      if (other.hints != null)
        return false;
    } else if (!this.hints.equals(other.hints))
      return false;
    if (this.merge == null) {
      if (other.merge != null)
        return false;
    } else if (!this.merge.equals(other.merge))
      return false;
    if (this.metaValues == null) {
      if (other.metaValues != null)
        return false;
    } else if (!this.metaValues.equals(other.metaValues))
      return false;
    if (this.mappingLogic == null) {
      if (other.mappingLogic != null)
        return false;
    } else if (!this.mappingLogic.equals(other.mappingLogic))
      return false;
    if (this.mapperName == null) {
      if (other.mapperName != null)
        return false;
    } else if (!this.mapperName.equals(other.mapperName))
      return false;
    if (this.format == null) {
      if (other.format != null)
        return false;
    } else if (!this.format.equals(other.format))
      return false;
    if (this.patternMatcher == null) {
      if (other.patternMatcher != null)
        return false;
    } else if (!this.patternMatcher.equals(other.patternMatcher))
      return false;
    if (this.patternReplace == null) {
      if (other.patternReplace != null)
        return false;
    } else if (!this.patternReplace.equals(other.patternReplace))
      return false;
    if (other.removeHtml != this.removeHtml)
      return false;
    return true;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("sources", this.sources);
    b.add("values", this.values);
    b.add("hints", this.hints);
    b.add("merge", this.merge);
    b.add("metaValues", this.metaValues);
    b.add("mappingLogic", this.mappingLogic);
    b.add("mapperName", this.mapperName);
    b.add("format", this.format);
    b.add("patternMatcher", this.patternMatcher);
    b.add("patternReplace", this.patternReplace);
    b.add("removeHtml", this.removeHtml);
    return b.toString();
  }

  @Pure
  public List<RosettaSynonymSource> getSources() {
    return this.sources;
  }

  @Pure
  public List<ExpandedSynonymValue> getValues() {
    return this.values;
  }

  @Pure
  public List<String> getHints() {
    return this.hints;
  }

  @Pure
  public RosettaMergeSynonymValue getMerge() {
    return this.merge;
  }

  @Pure
  public List<ExpandedSynonymValue> getMetaValues() {
    return this.metaValues;
  }

  @Pure
  public RosettaMapping getMappingLogic() {
    return this.mappingLogic;
  }

  @Pure
  public String getMapperName() {
    return this.mapperName;
  }

  @Pure
  public String getFormat() {
    return this.format;
  }

  @Pure
  public String getPatternMatcher() {
    return this.patternMatcher;
  }

  @Pure
  public String getPatternReplace() {
    return this.patternReplace;
  }

  @Pure
  public boolean isRemoveHtml() {
    return this.removeHtml;
  }
}
