package com.regnosys.rosetta.generator.object;

import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
@SuppressWarnings("all")
public final class ExpandedSynonymValue {
  private final String name;

  private final String path;

  private final int maps;

  private final boolean isMeta;

  public ExpandedSynonymValue(final String name, final String path, final int maps, final boolean isMeta) {
    super();
    this.name = name;
    this.path = path;
    this.maps = maps;
    this.isMeta = isMeta;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.name== null) ? 0 : this.name.hashCode());
    result = prime * result + ((this.path== null) ? 0 : this.path.hashCode());
    result = prime * result + this.maps;
    return prime * result + (this.isMeta ? 1231 : 1237);
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ExpandedSynonymValue other = (ExpandedSynonymValue) obj;
    if (this.name == null) {
      if (other.name != null)
        return false;
    } else if (!this.name.equals(other.name))
      return false;
    if (this.path == null) {
      if (other.path != null)
        return false;
    } else if (!this.path.equals(other.path))
      return false;
    if (other.maps != this.maps)
      return false;
    if (other.isMeta != this.isMeta)
      return false;
    return true;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("name", this.name);
    b.add("path", this.path);
    b.add("maps", this.maps);
    b.add("isMeta", this.isMeta);
    return b.toString();
  }

  @Pure
  public String getName() {
    return this.name;
  }

  @Pure
  public String getPath() {
    return this.path;
  }

  @Pure
  public int getMaps() {
    return this.maps;
  }

  @Pure
  public boolean isMeta() {
    return this.isMeta;
  }
}
