package com.regnosys.rosetta.generator.object;

import com.regnosys.rosetta.rosetta.RosettaModel;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
@SuppressWarnings("all")
public final class ExpandedType {
  private final RosettaModel model;

  private final String name;

  private final boolean type;

  private final boolean enumeration;

  private final boolean metaType;

  public boolean isBuiltInType() {
    return (!(this.type || this.enumeration));
  }

  public ExpandedType(final RosettaModel model, final String name, final boolean type, final boolean enumeration, final boolean metaType) {
    super();
    this.model = model;
    this.name = name;
    this.type = type;
    this.enumeration = enumeration;
    this.metaType = metaType;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.model== null) ? 0 : this.model.hashCode());
    result = prime * result + ((this.name== null) ? 0 : this.name.hashCode());
    result = prime * result + (this.type ? 1231 : 1237);
    result = prime * result + (this.enumeration ? 1231 : 1237);
    return prime * result + (this.metaType ? 1231 : 1237);
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ExpandedType other = (ExpandedType) obj;
    if (this.model == null) {
      if (other.model != null)
        return false;
    } else if (!this.model.equals(other.model))
      return false;
    if (this.name == null) {
      if (other.name != null)
        return false;
    } else if (!this.name.equals(other.name))
      return false;
    if (other.type != this.type)
      return false;
    if (other.enumeration != this.enumeration)
      return false;
    if (other.metaType != this.metaType)
      return false;
    return true;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("model", this.model);
    b.add("name", this.name);
    b.add("type", this.type);
    b.add("enumeration", this.enumeration);
    b.add("metaType", this.metaType);
    return b.toString();
  }

  @Pure
  public RosettaModel getModel() {
    return this.model;
  }

  @Pure
  public String getName() {
    return this.name;
  }

  @Pure
  public boolean isType() {
    return this.type;
  }

  @Pure
  public boolean isEnumeration() {
    return this.enumeration;
  }

  @Pure
  public boolean isMetaType() {
    return this.metaType;
  }
}
