package com.regnosys.rosetta.generator.util;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.object.ExpandedSynonym;
import com.regnosys.rosetta.generator.object.ExpandedSynonymValue;
import com.regnosys.rosetta.generator.object.ExpandedType;
import com.regnosys.rosetta.rosetta.RosettaClassSynonym;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaEnumSynonym;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonym;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.rosetta.RosettaMapping;
import com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaSynonym;
import com.regnosys.rosetta.rosetta.RosettaSynonymBase;
import com.regnosys.rosetta.rosetta.RosettaSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaSynonymValueBase;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypedFeature;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.scoping.RosettaScopeProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.SimpleCache;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;

@SuppressWarnings("all")
public class RosettaAttributeExtensions {
  public static boolean cardinalityIsSingleValue(final ExpandedAttribute attribute) {
    int _sup = attribute.getSup();
    return (_sup == 1);
  }

  public static boolean cardinalityIsListValue(final ExpandedAttribute attribute) {
    boolean _cardinalityIsSingleValue = RosettaAttributeExtensions.cardinalityIsSingleValue(attribute);
    return (_cardinalityIsSingleValue != true);
  }

  /**
   * Note that these methods will add a "meta" attribute if the data type has annotations
   */
  public static List<ExpandedAttribute> getExpandedAttributes(final Data data) {
    final Function1<Attribute, ExpandedAttribute> _function = (Attribute it) -> {
      return RosettaAttributeExtensions.toExpandedAttribute(it);
    };
    List<ExpandedAttribute> _list = IterableExtensions.<ExpandedAttribute>toList(ListExtensions.<Attribute, ExpandedAttribute>map(data.getAttributes(), _function));
    List<ExpandedAttribute> _additionalAttributes = RosettaAttributeExtensions.additionalAttributes(data);
    return IterableExtensions.<ExpandedAttribute>toList(Iterables.<ExpandedAttribute>concat(_list, _additionalAttributes));
  }

  public static List<ExpandedAttribute> expandedAttributesPlus(final Data data) {
    final List<ExpandedAttribute> atts = RosettaAttributeExtensions.getExpandedAttributes(data);
    boolean _hasSuperType = data.hasSuperType();
    if (_hasSuperType) {
      final List<ExpandedAttribute> attsWithSuper = RosettaAttributeExtensions.expandedAttributesPlus(data.getSuperType());
      final ArrayList<ExpandedAttribute> result = CollectionLiterals.<ExpandedAttribute>newArrayList();
      final Consumer<ExpandedAttribute> _function = (ExpandedAttribute it) -> {
        final Function1<ExpandedAttribute, Boolean> _function_1 = (ExpandedAttribute att) -> {
          String _name = att.getName();
          String _name_1 = it.getName();
          return Boolean.valueOf(Objects.equal(_name, _name_1));
        };
        final ExpandedAttribute overridenAtt = IterableExtensions.<ExpandedAttribute>findFirst(atts, _function_1);
        if ((overridenAtt != null)) {
          result.add(overridenAtt);
        } else {
          result.add(it);
        }
      };
      attsWithSuper.forEach(_function);
      final Function1<ExpandedAttribute, Boolean> _function_1 = (ExpandedAttribute att) -> {
        boolean _contains = result.contains(att);
        return Boolean.valueOf((!_contains));
      };
      result.addAll(IterableExtensions.<ExpandedAttribute>toList(IterableExtensions.<ExpandedAttribute>filter(atts, _function_1)));
      return result;
    }
    return atts;
  }

  private static List<ExpandedAttribute> additionalAttributes(final Data data) {
    final ArrayList<ExpandedAttribute> res = CollectionLiterals.<ExpandedAttribute>newArrayList();
    final RosettaExtensions rosExt = new RosettaExtensions();
    boolean _hasKeyedAnnotation = rosExt.hasKeyedAnnotation(data);
    if (_hasKeyedAnnotation) {
      String _name = data.getName();
      ExpandedType _provideMetaFieldsType = RosettaAttributeExtensions.provideMetaFieldsType(data);
      List<ExpandedSynonym> _emptyList = CollectionLiterals.<ExpandedSynonym>emptyList();
      List<RosettaDocReference> _emptyList_1 = CollectionLiterals.<RosettaDocReference>emptyList();
      List<ExpandedAttribute> _emptyList_2 = CollectionLiterals.<ExpandedAttribute>emptyList();
      ExpandedAttribute _expandedAttribute = new ExpandedAttribute(
        "meta", _name, _provideMetaFieldsType, 
        null, 
        false, 
        0, 
        1, 
        false, _emptyList, 
        "", _emptyList_1, 
        false, _emptyList_2);
      res.add(_expandedAttribute);
    }
    return res;
  }

  public static final String METAFIELDS_CLASS_NAME = "MetaFields";

  public static final String META_AND_TEMPLATE_FIELDS_CLASS_NAME = "MetaAndTemplateFields";

  private static SimpleCache<Data, ExpandedType> metaFieldsCache = new SimpleCache<Data, ExpandedType>(((Function<Data, ExpandedType>) (Data data) -> {
    final RosettaModel rosModel = RosettaFactory.eINSTANCE.createRosettaModel();
    rosModel.setName(RosettaScopeProvider.LIB_NAMESPACE);
    final RosettaExtensions rosExt = new RosettaExtensions();
    String _xifexpression = null;
    boolean _hasTemplateAnnotation = rosExt.hasTemplateAnnotation(data);
    if (_hasTemplateAnnotation) {
      _xifexpression = RosettaAttributeExtensions.META_AND_TEMPLATE_FIELDS_CLASS_NAME;
    } else {
      _xifexpression = RosettaAttributeExtensions.METAFIELDS_CLASS_NAME;
    }
    final String name = _xifexpression;
    return new ExpandedType(rosModel, name, true, false, false);
  }));

  private static ExpandedType provideMetaFieldsType(final Data data) {
    return RosettaAttributeExtensions.metaFieldsCache.get(data);
  }

  public static List<ExpandedAttribute> getExpandedAttributes(final RosettaEnumeration rosettaEnum) {
    final Function1<RosettaEnumValue, ExpandedAttribute> _function = (RosettaEnumValue it) -> {
      return RosettaAttributeExtensions.expandedEnumAttribute(it);
    };
    return ListExtensions.<RosettaEnumValue, ExpandedAttribute>map(rosettaEnum.getEnumValues(), _function);
  }

  public static ExpandedAttribute expandedEnumAttribute(final RosettaEnumValue value) {
    String _name = value.getName();
    String _name_1 = value.getEnumeration().getName();
    final Function1<RosettaEnumSynonym, ExpandedSynonym> _function = (RosettaEnumSynonym it) -> {
      return RosettaAttributeExtensions.toExpandedSynonym(it);
    };
    List<ExpandedSynonym> _map = ListExtensions.<RosettaEnumSynonym, ExpandedSynonym>map(value.getEnumSynonyms(), _function);
    String _definition = value.getDefinition();
    EList<RosettaDocReference> _references = value.getReferences();
    List<ExpandedAttribute> _emptyList = Collections.<ExpandedAttribute>emptyList();
    return new ExpandedAttribute(_name, _name_1, null, null, false, 0, 0, false, _map, _definition, _references, true, _emptyList);
  }

  public static ExpandedSynonym toExpandedSynonym(final RosettaEnumSynonym syn) {
    EList<RosettaSynonymSource> _sources = syn.getSources();
    String _synonymValue = syn.getSynonymValue();
    ExpandedSynonymValue _expandedSynonymValue = new ExpandedSynonymValue(_synonymValue, null, 0, false);
    List<ExpandedSynonymValue> _singletonList = Collections.<ExpandedSynonymValue>singletonList(_expandedSynonymValue);
    ArrayList<String> _newArrayList = CollectionLiterals.<String>newArrayList();
    List<ExpandedSynonymValue> _emptyList = Collections.<ExpandedSynonymValue>emptyList();
    String _patternMatch = syn.getPatternMatch();
    String _patternReplace = syn.getPatternReplace();
    boolean _isRemoveHtml = syn.isRemoveHtml();
    return new ExpandedSynonym(_sources, _singletonList, _newArrayList, null, _emptyList, null, null, 
      null, _patternMatch, _patternReplace, _isRemoveHtml);
  }

  public static boolean isList(final ExpandedAttribute a) {
    return RosettaAttributeExtensions.cardinalityIsListValue(a);
  }

  public static List<ExpandedSynonym> toRosettaExpandedSynonym(final Attribute attr, final int index) {
    List<ExpandedSynonym> _xblockexpression = null;
    {
      final Function1<RosettaSynonym, Boolean> _function = (RosettaSynonym it) -> {
        int _size = it.getBody().getMetaValues().size();
        return Boolean.valueOf((_size > index));
      };
      final Function1<RosettaSynonym, ExpandedSynonym> _function_1 = (RosettaSynonym s) -> {
        EList<RosettaSynonymSource> _sources = s.getSources();
        List<ExpandedSynonymValue> _list = IterableExtensions.<ExpandedSynonymValue>toList(RosettaAttributeExtensions.metaSynValue(((RosettaSynonymValueBase[])Conversions.unwrapArray(s.getBody().getValues(), RosettaSynonymValueBase.class)), s.getBody().getMetaValues().get(index)));
        EList<String> _hints = s.getBody().getHints();
        RosettaMergeSynonymValue _merge = s.getBody().getMerge();
        final Function1<String, ExpandedSynonymValue> _function_2 = (String it) -> {
          return new ExpandedSynonymValue(it, null, 1, true);
        };
        List<ExpandedSynonymValue> _map = ListExtensions.<String, ExpandedSynonymValue>map(s.getBody().getMetaValues(), _function_2);
        RosettaMapping _mappingLogic = s.getBody().getMappingLogic();
        String _mapper = s.getBody().getMapper();
        String _format = s.getBody().getFormat();
        String _patternMatch = s.getBody().getPatternMatch();
        String _patternReplace = s.getBody().getPatternReplace();
        boolean _isRemoveHtml = s.getBody().isRemoveHtml();
        return new ExpandedSynonym(_sources, _list, _hints, _merge, _map, _mappingLogic, _mapper, _format, _patternMatch, _patternReplace, _isRemoveHtml);
      };
      final Iterable<ExpandedSynonym> s = IterableExtensions.<RosettaSynonym, ExpandedSynonym>map(IterableExtensions.<RosettaSynonym>filter(attr.getSynonyms(), _function), _function_1);
      _xblockexpression = IterableExtensions.<ExpandedSynonym>toList(s);
    }
    return _xblockexpression;
  }

  public static List<ExpandedSynonym> toRosettaExpandedSynonym(final List<RosettaSynonymSource> sources, final List<RosettaExternalSynonym> externalSynonyms, final int index) {
    final Function1<RosettaExternalSynonym, Boolean> _function = (RosettaExternalSynonym it) -> {
      int _size = it.getBody().getMetaValues().size();
      return Boolean.valueOf((_size > index));
    };
    final Function1<RosettaExternalSynonym, ExpandedSynonym> _function_1 = (RosettaExternalSynonym s) -> {
      List<ExpandedSynonymValue> _list = IterableExtensions.<ExpandedSynonymValue>toList(RosettaAttributeExtensions.metaSynValue(((RosettaSynonymValueBase[])Conversions.unwrapArray(s.getBody().getValues(), RosettaSynonymValueBase.class)), s.getBody().getMetaValues().get(index)));
      EList<String> _hints = s.getBody().getHints();
      RosettaMergeSynonymValue _merge = s.getBody().getMerge();
      final Function1<String, ExpandedSynonymValue> _function_2 = (String it) -> {
        return new ExpandedSynonymValue(it, null, 1, true);
      };
      List<ExpandedSynonymValue> _map = ListExtensions.<String, ExpandedSynonymValue>map(s.getBody().getMetaValues(), _function_2);
      RosettaMapping _mappingLogic = s.getBody().getMappingLogic();
      String _mapper = s.getBody().getMapper();
      String _format = s.getBody().getFormat();
      String _patternMatch = s.getBody().getPatternMatch();
      String _patternReplace = s.getBody().getPatternReplace();
      boolean _isRemoveHtml = s.getBody().isRemoveHtml();
      return new ExpandedSynonym(sources, _list, _hints, _merge, _map, _mappingLogic, _mapper, _format, _patternMatch, _patternReplace, _isRemoveHtml);
    };
    final Function1<ExpandedSynonym, Boolean> _function_2 = (ExpandedSynonym it) -> {
      boolean _isEmpty = it.getValues().isEmpty();
      return Boolean.valueOf((!_isEmpty));
    };
    return IterableExtensions.<ExpandedSynonym>toList(IterableExtensions.<ExpandedSynonym>filter(IterableExtensions.<RosettaExternalSynonym, ExpandedSynonym>map(IterableExtensions.<RosettaExternalSynonym>filter(externalSynonyms, _function), _function_1), _function_2));
  }

  public static ExpandedAttribute toExpandedAttribute(final Attribute attr) {
    ExpandedAttribute _xblockexpression = null;
    {
      final ArrayList<ExpandedAttribute> metas = CollectionLiterals.<ExpandedAttribute>newArrayList();
      final Procedure2<AnnotationRef, Integer> _function = (AnnotationRef annoRef, Integer i) -> {
        Attribute _attribute = null;
        if (annoRef!=null) {
          _attribute=annoRef.getAttribute();
        }
        final Attribute annoAttr = _attribute;
        boolean _and = false;
        if (!(annoAttr != null)) {
          _and = false;
        } else {
          TypeCall _typeCall = annoAttr.getTypeCall();
          RosettaType _type = null;
          if (_typeCall!=null) {
            _type=_typeCall.getType();
          }
          boolean _tripleNotEquals = (_type != null);
          _and = _tripleNotEquals;
        }
        if (_and) {
          String _name = annoAttr.getName();
          String _name_1 = annoRef.getAnnotation().getName();
          ExpandedType _expandedType = RosettaAttributeExtensions.toExpandedType(annoAttr.getTypeCall().getType());
          TypeCall _typeCall_1 = annoAttr.getTypeCall();
          boolean _isOverride = annoAttr.isOverride();
          List<ExpandedSynonym> _rosettaExpandedSynonym = RosettaAttributeExtensions.toRosettaExpandedSynonym(attr, (i).intValue());
          String _definition = attr.getDefinition();
          EList<RosettaDocReference> _references = attr.getReferences();
          List<ExpandedAttribute> _emptyList = Collections.<ExpandedAttribute>emptyList();
          ExpandedAttribute _expandedAttribute = new ExpandedAttribute(_name, _name_1, _expandedType, _typeCall_1, _isOverride, 
            0, 
            1, 
            false, _rosettaExpandedSynonym, _definition, _references, 
            false, _emptyList);
          metas.add(_expandedAttribute);
        }
      };
      IterableExtensions.<AnnotationRef>forEach(attr.getAnnotations(), _function);
      String _name = attr.getName();
      EObject _eContainer = attr.eContainer();
      String _name_1 = ((RosettaType) _eContainer).getName();
      TypeCall _typeCall = attr.getTypeCall();
      RosettaType _type = null;
      if (_typeCall!=null) {
        _type=_typeCall.getType();
      }
      ExpandedType _expandedType = null;
      if (_type!=null) {
        _expandedType=RosettaAttributeExtensions.toExpandedType(_type);
      }
      TypeCall _typeCall_1 = attr.getTypeCall();
      boolean _isOverride = attr.isOverride();
      int _inf = attr.getCard().getInf();
      int _sup = attr.getCard().getSup();
      boolean _isUnbounded = attr.getCard().isUnbounded();
      List<ExpandedSynonym> _rosettaExpandedSynonyms = RosettaAttributeExtensions.toRosettaExpandedSynonyms(attr.getSynonyms(), (-1));
      String _definition = attr.getDefinition();
      EList<RosettaDocReference> _references = attr.getReferences();
      boolean _isEnumeration = RosettaAttributeExtensions.isEnumeration(attr);
      _xblockexpression = new ExpandedAttribute(_name, _name_1, _expandedType, _typeCall_1, _isOverride, _inf, _sup, _isUnbounded, _rosettaExpandedSynonyms, _definition, _references, _isEnumeration, metas);
    }
    return _xblockexpression;
  }

  public static ExpandedType toExpandedType(final RosettaType type) {
    RosettaModel _model = type.getModel();
    String _name = type.getName();
    return new ExpandedType(_model, _name, (type instanceof Data), (type instanceof RosettaEnumeration), (type instanceof RosettaMetaType));
  }

  public static List<ExpandedSynonym> toRosettaExpandedSynonyms(final List<RosettaSynonym> synonyms, final int meta) {
    List<ExpandedSynonym> _xifexpression = null;
    if ((meta < 0)) {
      final Function1<RosettaSynonym, ExpandedSynonym> _function = (RosettaSynonym it) -> {
        EList<RosettaSynonymSource> _sources = it.getSources();
        EList<RosettaSynonymValueBase> _values = it.getBody().getValues();
        List<ExpandedSynonymValue> _map = null;
        if (_values!=null) {
          final Function1<RosettaSynonymValueBase, ExpandedSynonymValue> _function_1 = (RosettaSynonymValueBase it_1) -> {
            String _name = it_1.getName();
            String _path = it_1.getPath();
            int _maps = it_1.getMaps();
            return new ExpandedSynonymValue(_name, _path, _maps, false);
          };
          _map=ListExtensions.<RosettaSynonymValueBase, ExpandedSynonymValue>map(_values, _function_1);
        }
        EList<String> _hints = it.getBody().getHints();
        RosettaMergeSynonymValue _merge = it.getBody().getMerge();
        final Function1<String, ExpandedSynonymValue> _function_2 = (String it_1) -> {
          return new ExpandedSynonymValue(it_1, null, 1, true);
        };
        List<ExpandedSynonymValue> _map_1 = ListExtensions.<String, ExpandedSynonymValue>map(it.getBody().getMetaValues(), _function_2);
        RosettaMapping _mappingLogic = it.getBody().getMappingLogic();
        String _mapper = it.getBody().getMapper();
        String _format = it.getBody().getFormat();
        String _patternMatch = it.getBody().getPatternMatch();
        String _patternReplace = it.getBody().getPatternReplace();
        boolean _isRemoveHtml = it.getBody().isRemoveHtml();
        return new ExpandedSynonym(_sources, _map, _hints, _merge, _map_1, _mappingLogic, _mapper, _format, _patternMatch, _patternReplace, _isRemoveHtml);
      };
      _xifexpression = ListExtensions.<RosettaSynonym, ExpandedSynonym>map(synonyms, _function);
    } else {
      final Function1<RosettaSynonym, Boolean> _function_1 = (RosettaSynonym it) -> {
        int _size = it.getBody().getMetaValues().size();
        return Boolean.valueOf((_size > meta));
      };
      final Function1<RosettaSynonym, ExpandedSynonym> _function_2 = (RosettaSynonym s) -> {
        EList<RosettaSynonymSource> _sources = s.getSources();
        List<ExpandedSynonymValue> _metaSynValue = RosettaAttributeExtensions.metaSynValue(((RosettaSynonymValueBase[])Conversions.unwrapArray(s.getBody().getValues(), RosettaSynonymValueBase.class)), s.getBody().getMetaValues().get(meta));
        EList<String> _hints = s.getBody().getHints();
        RosettaMergeSynonymValue _merge = s.getBody().getMerge();
        final Function1<String, ExpandedSynonymValue> _function_3 = (String it) -> {
          return new ExpandedSynonymValue(it, null, 1, true);
        };
        List<ExpandedSynonymValue> _map = ListExtensions.<String, ExpandedSynonymValue>map(s.getBody().getMetaValues(), _function_3);
        RosettaMapping _mappingLogic = s.getBody().getMappingLogic();
        String _mapper = s.getBody().getMapper();
        String _format = s.getBody().getFormat();
        String _patternMatch = s.getBody().getPatternMatch();
        String _patternReplace = s.getBody().getPatternReplace();
        boolean _isRemoveHtml = s.getBody().isRemoveHtml();
        return new ExpandedSynonym(_sources, _metaSynValue, _hints, _merge, _map, _mappingLogic, _mapper, _format, _patternMatch, _patternReplace, _isRemoveHtml);
      };
      _xifexpression = IterableExtensions.<ExpandedSynonym>toList(IterableExtensions.<RosettaSynonym, ExpandedSynonym>map(IterableExtensions.<RosettaSynonym>filter(synonyms, _function_1), _function_2));
    }
    return _xifexpression;
  }

  public static List<ExpandedSynonymValue> metaSynValue(final RosettaSynonymValueBase[] values, final String meta) {
    List<ExpandedSynonymValue> _xifexpression = null;
    if (((values == null) || ((List<RosettaSynonymValueBase>)Conversions.doWrapArray(values)).isEmpty())) {
      ExpandedSynonymValue _expandedSynonymValue = new ExpandedSynonymValue(meta, null, 2, true);
      _xifexpression = Collections.<ExpandedSynonymValue>unmodifiableList(CollectionLiterals.<ExpandedSynonymValue>newArrayList(_expandedSynonymValue));
    } else {
      final Function1<RosettaSynonymValueBase, ExpandedSynonymValue> _function = (RosettaSynonymValueBase value) -> {
        ExpandedSynonymValue _xblockexpression = null;
        {
          String _xifexpression_1 = null;
          String _path = value.getPath();
          boolean _tripleEquals = (_path == null);
          if (_tripleEquals) {
            _xifexpression_1 = value.getName();
          } else {
            String _path_1 = value.getPath();
            String _plus = (_path_1 + "->");
            String _name = value.getName();
            _xifexpression_1 = (_plus + _name);
          }
          final String path = _xifexpression_1;
          final String name = meta;
          int _maps = value.getMaps();
          _xblockexpression = new ExpandedSynonymValue(name, path, _maps, true);
        }
        return _xblockexpression;
      };
      _xifexpression = ListExtensions.<RosettaSynonymValueBase, ExpandedSynonymValue>map(((List<RosettaSynonymValueBase>)Conversions.doWrapArray(values)), _function);
    }
    return _xifexpression;
  }

  protected static ExpandedSynonym _toRosettaExpandedSynonym(final RosettaSynonymBase synonym) {
    return null;
  }

  protected static ExpandedSynonym _toRosettaExpandedSynonym(final RosettaSynonym syn) {
    EList<RosettaSynonymSource> _sources = syn.getSources();
    EList<RosettaSynonymValueBase> _values = syn.getBody().getValues();
    List<ExpandedSynonymValue> _map = null;
    if (_values!=null) {
      final Function1<RosettaSynonymValueBase, ExpandedSynonymValue> _function = (RosettaSynonymValueBase it) -> {
        String _name = it.getName();
        String _path = it.getPath();
        int _maps = it.getMaps();
        return new ExpandedSynonymValue(_name, _path, _maps, false);
      };
      _map=ListExtensions.<RosettaSynonymValueBase, ExpandedSynonymValue>map(_values, _function);
    }
    EList<String> _hints = syn.getBody().getHints();
    RosettaMergeSynonymValue _merge = syn.getBody().getMerge();
    final Function1<String, ExpandedSynonymValue> _function_1 = (String it) -> {
      return new ExpandedSynonymValue(it, null, 1, true);
    };
    List<ExpandedSynonymValue> _map_1 = ListExtensions.<String, ExpandedSynonymValue>map(syn.getBody().getMetaValues(), _function_1);
    RosettaMapping _mappingLogic = syn.getBody().getMappingLogic();
    String _mapper = syn.getBody().getMapper();
    String _format = syn.getBody().getFormat();
    String _patternMatch = syn.getBody().getPatternMatch();
    String _patternReplace = syn.getBody().getPatternReplace();
    boolean _isRemoveHtml = syn.getBody().isRemoveHtml();
    return new ExpandedSynonym(_sources, _map, _hints, _merge, _map_1, _mappingLogic, _mapper, _format, _patternMatch, _patternReplace, _isRemoveHtml);
  }

  protected static ExpandedSynonym _toRosettaExpandedSynonym(final RosettaExternalSynonym syn) {
    ExpandedSynonym _xblockexpression = null;
    {
      EObject _eContainer = syn.eContainer();
      final RosettaExternalRegularAttribute externalAttr = ((RosettaExternalRegularAttribute) _eContainer);
      EObject _eContainer_1 = externalAttr.eContainer();
      final RosettaExternalClass externalClass = ((RosettaExternalClass) _eContainer_1);
      EObject _eContainer_2 = externalClass.eContainer();
      final RosettaExternalSynonymSource externalSynonymSource = ((RosettaExternalSynonymSource) _eContainer_2);
      final EList<RosettaSynonymSource> superSynonyms = externalSynonymSource.getSuperSynonymSources();
      final ArrayList<RosettaSynonymSource> sources = new ArrayList<RosettaSynonymSource>();
      sources.add(externalSynonymSource);
      if ((superSynonyms != null)) {
        sources.addAll(superSynonyms);
      }
      EList<RosettaSynonymValueBase> _values = syn.getBody().getValues();
      List<ExpandedSynonymValue> _map = null;
      if (_values!=null) {
        final Function1<RosettaSynonymValueBase, ExpandedSynonymValue> _function = (RosettaSynonymValueBase it) -> {
          String _name = it.getName();
          String _path = it.getPath();
          int _maps = it.getMaps();
          return new ExpandedSynonymValue(_name, _path, _maps, false);
        };
        _map=ListExtensions.<RosettaSynonymValueBase, ExpandedSynonymValue>map(_values, _function);
      }
      EList<String> _hints = syn.getBody().getHints();
      RosettaMergeSynonymValue _merge = syn.getBody().getMerge();
      final Function1<String, ExpandedSynonymValue> _function_1 = (String it) -> {
        return new ExpandedSynonymValue(it, null, 1, true);
      };
      List<ExpandedSynonymValue> _map_1 = ListExtensions.<String, ExpandedSynonymValue>map(syn.getBody().getMetaValues(), _function_1);
      RosettaMapping _mappingLogic = syn.getBody().getMappingLogic();
      String _mapper = syn.getBody().getMapper();
      String _format = syn.getBody().getFormat();
      String _patternMatch = syn.getBody().getPatternMatch();
      String _patternReplace = syn.getBody().getPatternReplace();
      boolean _isRemoveHtml = syn.getBody().isRemoveHtml();
      _xblockexpression = new ExpandedSynonym(sources, _map, _hints, _merge, _map_1, _mappingLogic, _mapper, _format, _patternMatch, _patternReplace, _isRemoveHtml);
    }
    return _xblockexpression;
  }

  protected static ExpandedSynonym _toRosettaExpandedSynonym(final RosettaExternalClassSynonym syn) {
    ExpandedSynonym _xblockexpression = null;
    {
      List<ExpandedSynonymValue> _xifexpression = null;
      RosettaSynonymValueBase _value = syn.getValue();
      boolean _tripleEquals = (_value == null);
      if (_tripleEquals) {
        _xifexpression = Collections.<ExpandedSynonymValue>emptyList();
      } else {
        String _name = syn.getValue().getName();
        String _path = syn.getValue().getPath();
        int _maps = syn.getValue().getMaps();
        ExpandedSynonymValue _expandedSynonymValue = new ExpandedSynonymValue(_name, _path, _maps, false);
        _xifexpression = CollectionLiterals.<ExpandedSynonymValue>newArrayList(_expandedSynonymValue);
      }
      final List<ExpandedSynonymValue> synVals = _xifexpression;
      List<ExpandedSynonymValue> _xifexpression_1 = null;
      RosettaSynonymValueBase _metaValue = syn.getMetaValue();
      boolean _tripleNotEquals = (_metaValue != null);
      if (_tripleNotEquals) {
        String _name_1 = syn.getMetaValue().getName();
        String _path_1 = syn.getMetaValue().getPath();
        int _maps_1 = syn.getMetaValue().getMaps();
        ExpandedSynonymValue _expandedSynonymValue_1 = new ExpandedSynonymValue(_name_1, _path_1, _maps_1, true);
        _xifexpression_1 = CollectionLiterals.<ExpandedSynonymValue>newArrayList(_expandedSynonymValue_1);
      } else {
        _xifexpression_1 = Collections.<ExpandedSynonymValue>emptyList();
      }
      final List<ExpandedSynonymValue> synMetaVals = _xifexpression_1;
      EObject _eContainer = syn.eContainer();
      final RosettaExternalClass externalClass = ((RosettaExternalClass) _eContainer);
      EObject _eContainer_1 = externalClass.eContainer();
      final RosettaExternalSynonymSource externalSynonymSource = ((RosettaExternalSynonymSource) _eContainer_1);
      final EList<RosettaSynonymSource> superSynonyms = externalSynonymSource.getSuperSynonymSources();
      final ArrayList<RosettaSynonymSource> sources = new ArrayList<RosettaSynonymSource>();
      sources.add(externalSynonymSource);
      if ((superSynonyms != null)) {
        sources.addAll(superSynonyms);
      }
      ArrayList<String> _newArrayList = CollectionLiterals.<String>newArrayList();
      _xblockexpression = new ExpandedSynonym(sources, synVals, _newArrayList, null, synMetaVals, null, null, null, null, null, false);
    }
    return _xblockexpression;
  }

  protected static ExpandedSynonym _toRosettaExpandedSynonym(final RosettaClassSynonym syn) {
    ExpandedSynonym _xblockexpression = null;
    {
      List<ExpandedSynonymValue> _xifexpression = null;
      RosettaSynonymValueBase _value = syn.getValue();
      boolean _tripleEquals = (_value == null);
      if (_tripleEquals) {
        _xifexpression = Collections.<ExpandedSynonymValue>emptyList();
      } else {
        String _name = syn.getValue().getName();
        String _path = syn.getValue().getPath();
        int _maps = syn.getValue().getMaps();
        ExpandedSynonymValue _expandedSynonymValue = new ExpandedSynonymValue(_name, _path, _maps, false);
        _xifexpression = CollectionLiterals.<ExpandedSynonymValue>newArrayList(_expandedSynonymValue);
      }
      final List<ExpandedSynonymValue> synVals = _xifexpression;
      List<ExpandedSynonymValue> _xifexpression_1 = null;
      RosettaSynonymValueBase _metaValue = syn.getMetaValue();
      boolean _tripleNotEquals = (_metaValue != null);
      if (_tripleNotEquals) {
        String _name_1 = syn.getMetaValue().getName();
        String _path_1 = syn.getMetaValue().getPath();
        int _maps_1 = syn.getMetaValue().getMaps();
        ExpandedSynonymValue _expandedSynonymValue_1 = new ExpandedSynonymValue(_name_1, _path_1, _maps_1, true);
        _xifexpression_1 = CollectionLiterals.<ExpandedSynonymValue>newArrayList(_expandedSynonymValue_1);
      } else {
        _xifexpression_1 = Collections.<ExpandedSynonymValue>emptyList();
      }
      final List<ExpandedSynonymValue> synMetaVals = _xifexpression_1;
      EList<RosettaSynonymSource> _sources = syn.getSources();
      ArrayList<String> _newArrayList = CollectionLiterals.<String>newArrayList();
      _xblockexpression = new ExpandedSynonym(_sources, synVals, _newArrayList, null, synMetaVals, null, null, null, null, null, false);
    }
    return _xblockexpression;
  }

  private static boolean isEnumeration(final RosettaTypedFeature a) {
    TypeCall _typeCall = a.getTypeCall();
    RosettaType _type = null;
    if (_typeCall!=null) {
      _type=_typeCall.getType();
    }
    return (_type instanceof RosettaEnumeration);
  }

  public static ExpandedSynonym toRosettaExpandedSynonym(final EObject syn) {
    if (syn instanceof RosettaClassSynonym) {
      return _toRosettaExpandedSynonym((RosettaClassSynonym)syn);
    } else if (syn instanceof RosettaSynonym) {
      return _toRosettaExpandedSynonym((RosettaSynonym)syn);
    } else if (syn instanceof RosettaExternalClassSynonym) {
      return _toRosettaExpandedSynonym((RosettaExternalClassSynonym)syn);
    } else if (syn instanceof RosettaExternalSynonym) {
      return _toRosettaExpandedSynonym((RosettaExternalSynonym)syn);
    } else if (syn instanceof RosettaSynonymBase) {
      return _toRosettaExpandedSynonym((RosettaSynonymBase)syn);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(syn).toString());
    }
  }
}
