package com.regnosys.rosetta.generator.util;

import com.google.common.base.Objects;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTyped;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RAssignedRoot;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RShortcut;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class RosettaFunctionExtensions {
  @Inject
  private RosettaTypeProvider typeProvider;

  /**
   * spec functions do not have operation hence, do not provide an implementation
   */
  public Boolean handleAsSpecFunction(final Function function) {
    return Boolean.valueOf(((IterableExtensions.isNullOrEmpty(function.getOperations()) && (!(this.isDispatchingFunction(function)).booleanValue())) && (!(this.handleAsEnumFunction(function)).booleanValue())));
  }

  public Boolean handleAsEnumFunction(final Function function) {
    return Boolean.valueOf((IterableExtensions.isNullOrEmpty(function.getOperations()) && (!IterableExtensions.isEmpty(this.getDispatchingFunctions(function)))));
  }

  public Boolean isDispatchingFunction(final Function function) {
    return Boolean.valueOf((function instanceof FunctionDispatch));
  }

  public Iterable<FunctionDispatch> getDispatchingFunctions(final Function function) {
    final Function1<FunctionDispatch, Boolean> _function = (FunctionDispatch it) -> {
      String _name = it.getName();
      String _name_1 = function.getName();
      return Boolean.valueOf(Objects.equal(_name, _name_1));
    };
    return IterableExtensions.<FunctionDispatch>filter(EcoreUtil2.<FunctionDispatch>getSiblingsOfType(function, FunctionDispatch.class), _function);
  }

  public Function getMainFunction(final Function function) {
    Boolean _isDispatchingFunction = this.isDispatchingFunction(function);
    if ((_isDispatchingFunction).booleanValue()) {
      final Function1<Function, Boolean> _function = (Function it) -> {
        return Boolean.valueOf((Objects.equal(it.getName(), function.getName()) && IterableExtensions.isNullOrEmpty(it.getOperations())));
      };
      return IterableExtensions.<Function>head(IterableExtensions.<Function>filter(EcoreUtil2.<Function>getSiblingsOfType(function, Function.class), _function));
    }
    return null;
  }

  protected Attribute _getOutput(final Function function) {
    return function.getOutput();
  }

  protected Attribute _getOutput(final FunctionDispatch function) {
    final Function mainFunction = this.getMainFunction(function);
    if ((mainFunction != null)) {
      return mainFunction.getOutput();
    }
    return null;
  }

  protected List<Attribute> _getInputs(final Function function) {
    return function.getInputs();
  }

  protected List<Attribute> _getInputs(final FunctionDispatch function) {
    List<Attribute> _xblockexpression = null;
    {
      final Function mainFunction = this.getMainFunction(function);
      if ((mainFunction != null)) {
        return mainFunction.getInputs();
      }
      _xblockexpression = CollectionLiterals.<Attribute>emptyList();
    }
    return _xblockexpression;
  }

  public String inputsAsArgs(final ShortcutDeclaration alias) {
    String _xblockexpression = null;
    {
      final Function func = EcoreUtil2.<Function>getContainerOfType(alias, Function.class);
      final Function1<Attribute, CharSequence> _function = (Attribute it) -> {
        return it.getName();
      };
      _xblockexpression = IterableExtensions.<Attribute>join(this.getInputs(func), ", ", _function);
    }
    return _xblockexpression;
  }

  protected boolean _needsBuilder(final Void ele) {
    return false;
  }

  protected boolean _needsBuilder(final RAttribute rAttribute) {
    return this.needsBuilder(rAttribute.getRType());
  }

  protected boolean _needsBuilder(final RosettaTyped ele) {
    return this.needsBuilder(ele.getTypeCall().getType());
  }

  protected boolean _needsBuilder(final RosettaExpression expr) {
    return this.needsBuilder(this.typeProvider.getRType(expr));
  }

  protected boolean _needsBuilder(final AssignPathRoot root) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (root instanceof Attribute) {
      _matched=true;
      _switchResult = this.needsBuilder(((Attribute)root).getTypeCall().getType());
    }
    if (!_matched) {
      if (root instanceof ShortcutDeclaration) {
        _matched=true;
        _switchResult = this.needsBuilder(((ShortcutDeclaration)root).getExpression());
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }

  protected boolean _needsBuilder(final RAssignedRoot root) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (root instanceof RAttribute) {
      _matched=true;
      _switchResult = this.needsBuilder(((RAttribute)root).getRType());
    }
    if (!_matched) {
      if (root instanceof RShortcut) {
        _matched=true;
        _switchResult = this.needsBuilder(((RShortcut)root).getExpression());
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }

  protected boolean _needsBuilder(final RosettaType type) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (type instanceof Data) {
      _matched=true;
      _switchResult = true;
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }

  protected boolean _needsBuilder(final TypeCall typeCall) {
    return this.needsBuilder(typeCall.getType());
  }

  protected boolean _needsBuilder(final RType type) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (type instanceof RDataType) {
      _matched=true;
      _switchResult = true;
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }

  public boolean isOutput(final Attribute attr) {
    EStructuralFeature _eContainingFeature = attr.eContainingFeature();
    return (_eContainingFeature == SimplePackage.Literals.FUNCTION__OUTPUT);
  }

  public boolean isQualifierFunctionFor(final Function function, final Data type) {
    return (this.isQualifierFunction(function) && Objects.equal(this.getInputs(function).get(0).getTypeCall().getType(), type));
  }

  public boolean isQualifierFunction(final Function function) {
    boolean _isEmpty = this.getQualifierAnnotations(function).isEmpty();
    return (!_isEmpty);
  }

  public boolean isQualifierFunction(final RFunction function) {
    boolean _isEmpty = this.getQualifierAnnotations(function.getAnnotations()).isEmpty();
    return (!_isEmpty);
  }

  public List<AnnotationRef> getMetadataAnnotations(final Annotated element) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it) -> {
      String _name = it.getAnnotation().getName();
      return Boolean.valueOf(Objects.equal("metadata", _name));
    };
    return IterableExtensions.<AnnotationRef>toList(IterableExtensions.<AnnotationRef>filter(element.getAnnotations(), _function));
  }

  public List<AnnotationRef> getQualifierAnnotations(final Annotated element) {
    return this.getQualifierAnnotations(element.getAnnotations());
  }

  public List<AnnotationRef> getQualifierAnnotations(final List<AnnotationRef> annotations) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it) -> {
      String _name = it.getAnnotation().getName();
      return Boolean.valueOf(Objects.equal("qualification", _name));
    };
    return IterableExtensions.<AnnotationRef>toList(IterableExtensions.<AnnotationRef>filter(annotations, _function));
  }

  public List<AnnotationRef> getCreationAnnotations(final Annotated element) {
    final Function1<AnnotationRef, Boolean> _function = (AnnotationRef it) -> {
      String _name = it.getAnnotation().getName();
      return Boolean.valueOf(Objects.equal("creation", _name));
    };
    return IterableExtensions.<AnnotationRef>toList(IterableExtensions.<AnnotationRef>filter(element.getAnnotations(), _function));
  }

  public Attribute getOutput(final Function function) {
    if (function instanceof FunctionDispatch) {
      return _getOutput((FunctionDispatch)function);
    } else if (function != null) {
      return _getOutput(function);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(function).toString());
    }
  }

  public List<Attribute> getInputs(final Function function) {
    if (function instanceof FunctionDispatch) {
      return _getInputs((FunctionDispatch)function);
    } else if (function != null) {
      return _getInputs(function);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(function).toString());
    }
  }

  public boolean needsBuilder(final Object root) {
    if (root instanceof AssignPathRoot) {
      return _needsBuilder((AssignPathRoot)root);
    } else if (root instanceof RosettaType) {
      return _needsBuilder((RosettaType)root);
    } else if (root instanceof RosettaTyped) {
      return _needsBuilder((RosettaTyped)root);
    } else if (root instanceof TypeCall) {
      return _needsBuilder((TypeCall)root);
    } else if (root instanceof RosettaExpression) {
      return _needsBuilder((RosettaExpression)root);
    } else if (root instanceof RAttribute) {
      return _needsBuilder((RAttribute)root);
    } else if (root instanceof RType) {
      return _needsBuilder((RType)root);
    } else if (root instanceof RAssignedRoot) {
      return _needsBuilder((RAssignedRoot)root);
    } else if (root == null) {
      return _needsBuilder((Void)null);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(root).toString());
    }
  }
}
