/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta;

import com.regnosys.rosetta.rosetta.simple.Data;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Qualifiable Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * *********************************************************************
 * Qualifiable used for RosettaProduct and RosettaEvent. Check enum RosettaQualifiableType when adding new classes
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getQType <em>QType</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getModel <em>Model</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getRosettaClass <em>Rosetta Class</em>}</li>
 * </ul>
 *
 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaQualifiableConfiguration()
 * @model
 * @generated
 */
public interface RosettaQualifiableConfiguration extends EObject {
	/**
	 * Returns the value of the '<em><b>QType</b></em>' attribute.
	 * The literals are from the enumeration {@link com.regnosys.rosetta.rosetta.RosettaQualifiableType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>QType</em>' attribute.
	 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableType
	 * @see #setQType(RosettaQualifiableType)
	 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaQualifiableConfiguration_QType()
	 * @model unique="false"
	 * @generated
	 */
	RosettaQualifiableType getQType();

	/**
	 * Sets the value of the '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getQType <em>QType</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>QType</em>' attribute.
	 * @see com.regnosys.rosetta.rosetta.RosettaQualifiableType
	 * @see #getQType()
	 * @generated
	 */
	void setQType(RosettaQualifiableType value);

	/**
	 * Returns the value of the '<em><b>Model</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link com.regnosys.rosetta.rosetta.RosettaModel#getConfigurations <em>Configurations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Model</em>' container reference.
	 * @see #setModel(RosettaModel)
	 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaQualifiableConfiguration_Model()
	 * @see com.regnosys.rosetta.rosetta.RosettaModel#getConfigurations
	 * @model opposite="configurations" transient="false"
	 * @generated
	 */
	RosettaModel getModel();

	/**
	 * Sets the value of the '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getModel <em>Model</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Model</em>' container reference.
	 * @see #getModel()
	 * @generated
	 */
	void setModel(RosettaModel value);

	/**
	 * Returns the value of the '<em><b>Rosetta Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rosetta Class</em>' reference.
	 * @see #setRosettaClass(Data)
	 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaQualifiableConfiguration_RosettaClass()
	 * @model
	 * @generated
	 */
	Data getRosettaClass();

	/**
	 * Sets the value of the '{@link com.regnosys.rosetta.rosetta.RosettaQualifiableConfiguration#getRosettaClass <em>Rosetta Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Rosetta Class</em>' reference.
	 * @see #getRosettaClass()
	 * @generated
	 */
	void setRosettaClass(Data value);

} // RosettaQualifiableConfiguration
