/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta;

import com.regnosys.rosetta.rosetta.simple.Data;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Report</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * *******************
 * Reports and rules - Should be a separate grammar
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.RosettaReport#getRegulatoryBody <em>Regulatory Body</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.RosettaReport#getEligibilityRules <em>Eligibility Rules</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.RosettaReport#getReportingStandard <em>Reporting Standard</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.RosettaReport#getInputType <em>Input Type</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.RosettaReport#getReportType <em>Report Type</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.RosettaReport#getRuleSource <em>Rule Source</em>}</li>
 * </ul>
 *
 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaReport()
 * @model
 * @generated
 */
public interface RosettaReport extends RosettaRootElement {
	/**
	 * Returns the value of the '<em><b>Regulatory Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Regulatory Body</em>' containment reference.
	 * @see #setRegulatoryBody(RegulatoryDocumentReference)
	 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaReport_RegulatoryBody()
	 * @model containment="true"
	 * @generated
	 */
	RegulatoryDocumentReference getRegulatoryBody();

	/**
	 * Sets the value of the '{@link com.regnosys.rosetta.rosetta.RosettaReport#getRegulatoryBody <em>Regulatory Body</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Regulatory Body</em>' containment reference.
	 * @see #getRegulatoryBody()
	 * @generated
	 */
	void setRegulatoryBody(RegulatoryDocumentReference value);

	/**
	 * Returns the value of the '<em><b>Eligibility Rules</b></em>' reference list.
	 * The list contents are of type {@link com.regnosys.rosetta.rosetta.RosettaRule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Eligibility Rules</em>' reference list.
	 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaReport_EligibilityRules()
	 * @model
	 * @generated
	 */
	EList<RosettaRule> getEligibilityRules();

	/**
	 * Returns the value of the '<em><b>Reporting Standard</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reporting Standard</em>' reference.
	 * @see #setReportingStandard(RosettaCorpus)
	 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaReport_ReportingStandard()
	 * @model
	 * @generated
	 */
	RosettaCorpus getReportingStandard();

	/**
	 * Sets the value of the '{@link com.regnosys.rosetta.rosetta.RosettaReport#getReportingStandard <em>Reporting Standard</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reporting Standard</em>' reference.
	 * @see #getReportingStandard()
	 * @generated
	 */
	void setReportingStandard(RosettaCorpus value);

	/**
	 * Returns the value of the '<em><b>Input Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Input Type</em>' containment reference.
	 * @see #setInputType(TypeCall)
	 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaReport_InputType()
	 * @model containment="true"
	 * @generated
	 */
	TypeCall getInputType();

	/**
	 * Sets the value of the '{@link com.regnosys.rosetta.rosetta.RosettaReport#getInputType <em>Input Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Input Type</em>' containment reference.
	 * @see #getInputType()
	 * @generated
	 */
	void setInputType(TypeCall value);

	/**
	 * Returns the value of the '<em><b>Report Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Report Type</em>' reference.
	 * @see #setReportType(Data)
	 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaReport_ReportType()
	 * @model
	 * @generated
	 */
	Data getReportType();

	/**
	 * Sets the value of the '{@link com.regnosys.rosetta.rosetta.RosettaReport#getReportType <em>Report Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Report Type</em>' reference.
	 * @see #getReportType()
	 * @generated
	 */
	void setReportType(Data value);

	/**
	 * Returns the value of the '<em><b>Rule Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rule Source</em>' reference.
	 * @see #setRuleSource(RosettaExternalRuleSource)
	 * @see com.regnosys.rosetta.rosetta.RosettaPackage#getRosettaReport_RuleSource()
	 * @model
	 * @generated
	 */
	RosettaExternalRuleSource getRuleSource();

	/**
	 * Sets the value of the '{@link com.regnosys.rosetta.rosetta.RosettaReport#getRuleSource <em>Rule Source</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Rule Source</em>' reference.
	 * @see #getRuleSource()
	 * @generated
	 */
	void setRuleSource(RosettaExternalRuleSource value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" unique="false"
	 * @generated
	 */
	String getRegulatoryId();

} // RosettaReport
