/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.expression;

import com.regnosys.rosetta.rosetta.RosettaPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.regnosys.rosetta.rosetta.expression.ExpressionFactory
 * @model kind="package"
 * @generated
 */
public interface ExpressionPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "expression";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.rosetta-model.com/RosettaExpression";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "expression";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ExpressionPackage eINSTANCE = com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl.init();

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaExpression <em>Rosetta Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaExpression
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaExpression()
	 * @generated
	 */
	int ROSETTA_EXPRESSION = 0;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXPRESSION__GENERATED = 0;

	/**
	 * The number of structural features of the '<em>Rosetta Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXPRESSION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.HasGeneratedInput <em>Has Generated Input</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.HasGeneratedInput
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getHasGeneratedInput()
	 * @generated
	 */
	int HAS_GENERATED_INPUT = 1;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_GENERATED_INPUT__GENERATED_INPUT_WAS_SET = 0;

	/**
	 * The number of structural features of the '<em>Has Generated Input</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_GENERATED_INPUT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaLiteral <em>Rosetta Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaLiteral
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaLiteral()
	 * @generated
	 */
	int ROSETTA_LITERAL = 2;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_LITERAL__GENERATED = ROSETTA_EXPRESSION__GENERATED;

	/**
	 * The number of structural features of the '<em>Rosetta Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_LITERAL_FEATURE_COUNT = ROSETTA_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaBooleanLiteralImpl <em>Rosetta Boolean Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaBooleanLiteralImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaBooleanLiteral()
	 * @generated
	 */
	int ROSETTA_BOOLEAN_LITERAL = 3;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BOOLEAN_LITERAL__GENERATED = ROSETTA_LITERAL__GENERATED;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BOOLEAN_LITERAL__VALUE = ROSETTA_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta Boolean Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BOOLEAN_LITERAL_FEATURE_COUNT = ROSETTA_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaStringLiteralImpl <em>Rosetta String Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaStringLiteralImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaStringLiteral()
	 * @generated
	 */
	int ROSETTA_STRING_LITERAL = 4;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_STRING_LITERAL__GENERATED = ROSETTA_LITERAL__GENERATED;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_STRING_LITERAL__VALUE = ROSETTA_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta String Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_STRING_LITERAL_FEATURE_COUNT = ROSETTA_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaNumberLiteralImpl <em>Rosetta Number Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaNumberLiteralImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaNumberLiteral()
	 * @generated
	 */
	int ROSETTA_NUMBER_LITERAL = 5;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_NUMBER_LITERAL__GENERATED = ROSETTA_LITERAL__GENERATED;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_NUMBER_LITERAL__VALUE = ROSETTA_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta Number Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_NUMBER_LITERAL_FEATURE_COUNT = ROSETTA_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaIntLiteralImpl <em>Rosetta Int Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaIntLiteralImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaIntLiteral()
	 * @generated
	 */
	int ROSETTA_INT_LITERAL = 6;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_INT_LITERAL__GENERATED = ROSETTA_LITERAL__GENERATED;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_INT_LITERAL__VALUE = ROSETTA_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta Int Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_INT_LITERAL_FEATURE_COUNT = ROSETTA_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaPatternLiteralImpl <em>Rosetta Pattern Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaPatternLiteralImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaPatternLiteral()
	 * @generated
	 */
	int ROSETTA_PATTERN_LITERAL = 7;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_PATTERN_LITERAL__GENERATED = ROSETTA_LITERAL__GENERATED;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_PATTERN_LITERAL__VALUE = ROSETTA_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta Pattern Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_PATTERN_LITERAL_FEATURE_COUNT = ROSETTA_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ListLiteralImpl <em>List Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ListLiteralImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getListLiteral()
	 * @generated
	 */
	int LIST_LITERAL = 8;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_LITERAL__GENERATED = ROSETTA_EXPRESSION__GENERATED;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_LITERAL__ELEMENTS = ROSETTA_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>List Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_LITERAL_FEATURE_COUNT = ROSETTA_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaReferenceImpl <em>Rosetta Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaReferenceImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaReference()
	 * @generated
	 */
	int ROSETTA_REFERENCE = 9;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REFERENCE__GENERATED = ROSETTA_EXPRESSION__GENERATED;

	/**
	 * The number of structural features of the '<em>Rosetta Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_REFERENCE_FEATURE_COUNT = ROSETTA_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaSymbolReferenceImpl <em>Rosetta Symbol Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaSymbolReferenceImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaSymbolReference()
	 * @generated
	 */
	int ROSETTA_SYMBOL_REFERENCE = 10;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYMBOL_REFERENCE__GENERATED = ROSETTA_REFERENCE__GENERATED;

	/**
	 * The feature id for the '<em><b>Symbol</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYMBOL_REFERENCE__SYMBOL = ROSETTA_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Explicit Arguments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS = ROSETTA_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Raw Args</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYMBOL_REFERENCE__RAW_ARGS = ROSETTA_REFERENCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Implicit Variable Is In Context</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYMBOL_REFERENCE__IMPLICIT_VARIABLE_IS_IN_CONTEXT = ROSETTA_REFERENCE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Implicit Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT = ROSETTA_REFERENCE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Rosetta Symbol Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_SYMBOL_REFERENCE_FEATURE_COUNT = ROSETTA_REFERENCE_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaImplicitVariableImpl <em>Rosetta Implicit Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaImplicitVariableImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaImplicitVariable()
	 * @generated
	 */
	int ROSETTA_IMPLICIT_VARIABLE = 11;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_IMPLICIT_VARIABLE__GENERATED = ROSETTA_REFERENCE__GENERATED;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_IMPLICIT_VARIABLE__NAME = ROSETTA_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta Implicit Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_IMPLICIT_VARIABLE_FEATURE_COUNT = ROSETTA_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaFeatureCallImpl <em>Rosetta Feature Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaFeatureCallImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaFeatureCall()
	 * @generated
	 */
	int ROSETTA_FEATURE_CALL = 12;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE_CALL__GENERATED = ROSETTA_EXPRESSION__GENERATED;

	/**
	 * The feature id for the '<em><b>Receiver</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE_CALL__RECEIVER = ROSETTA_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE_CALL__FEATURE = ROSETTA_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Rosetta Feature Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FEATURE_CALL_FEATURE_COUNT = ROSETTA_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaDeepFeatureCallImpl <em>Rosetta Deep Feature Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaDeepFeatureCallImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaDeepFeatureCall()
	 * @generated
	 */
	int ROSETTA_DEEP_FEATURE_CALL = 13;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DEEP_FEATURE_CALL__GENERATED = ROSETTA_EXPRESSION__GENERATED;

	/**
	 * The feature id for the '<em><b>Receiver</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DEEP_FEATURE_CALL__RECEIVER = ROSETTA_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DEEP_FEATURE_CALL__FEATURE = ROSETTA_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Rosetta Deep Feature Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DEEP_FEATURE_CALL_FEATURE_COUNT = ROSETTA_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaConditionalExpressionImpl <em>Rosetta Conditional Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaConditionalExpressionImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaConditionalExpression()
	 * @generated
	 */
	int ROSETTA_CONDITIONAL_EXPRESSION = 14;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONDITIONAL_EXPRESSION__GENERATED = ROSETTA_EXPRESSION__GENERATED;

	/**
	 * The feature id for the '<em><b>If</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONDITIONAL_EXPRESSION__IF = ROSETTA_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ifthen</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONDITIONAL_EXPRESSION__IFTHEN = ROSETTA_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Elsethen</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONDITIONAL_EXPRESSION__ELSETHEN = ROSETTA_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Full</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONDITIONAL_EXPRESSION__FULL = ROSETTA_EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Rosetta Conditional Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONDITIONAL_EXPRESSION_FEATURE_COUNT = ROSETTA_EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaConstructorExpressionImpl <em>Rosetta Constructor Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaConstructorExpressionImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaConstructorExpression()
	 * @generated
	 */
	int ROSETTA_CONSTRUCTOR_EXPRESSION = 15;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONSTRUCTOR_EXPRESSION__GENERATED = ROSETTA_EXPRESSION__GENERATED;

	/**
	 * The feature id for the '<em><b>Type Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONSTRUCTOR_EXPRESSION__TYPE_CALL = ROSETTA_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Type Inferred</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONSTRUCTOR_EXPRESSION__IS_TYPE_INFERRED = ROSETTA_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Values</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONSTRUCTOR_EXPRESSION__VALUES = ROSETTA_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Implicit Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY = ROSETTA_EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Rosetta Constructor Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONSTRUCTOR_EXPRESSION_FEATURE_COUNT = ROSETTA_EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ConstructorKeyValuePairImpl <em>Constructor Key Value Pair</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ConstructorKeyValuePairImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getConstructorKeyValuePair()
	 * @generated
	 */
	int CONSTRUCTOR_KEY_VALUE_PAIR = 16;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR_KEY_VALUE_PAIR__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR_KEY_VALUE_PAIR__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Constructor Key Value Pair</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRUCTOR_KEY_VALUE_PAIR_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaOperation <em>Rosetta Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaOperation()
	 * @generated
	 */
	int ROSETTA_OPERATION = 17;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_OPERATION__GENERATED = ROSETTA_EXPRESSION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_OPERATION__OPERATOR = ROSETTA_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_OPERATION_FEATURE_COUNT = ROSETTA_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation <em>Rosetta Binary Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaBinaryOperation()
	 * @generated
	 */
	int ROSETTA_BINARY_OPERATION = 18;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BINARY_OPERATION__GENERATED = ROSETTA_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BINARY_OPERATION__OPERATOR = ROSETTA_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BINARY_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BINARY_OPERATION__LEFT = ROSETTA_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BINARY_OPERATION__RIGHT = ROSETTA_OPERATION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Rosetta Binary Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_BINARY_OPERATION_FEATURE_COUNT = ROSETTA_OPERATION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ArithmeticOperationImpl <em>Arithmetic Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ArithmeticOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getArithmeticOperation()
	 * @generated
	 */
	int ARITHMETIC_OPERATION = 19;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_OPERATION__GENERATED = ROSETTA_BINARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_OPERATION__OPERATOR = ROSETTA_BINARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_BINARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_OPERATION__LEFT = ROSETTA_BINARY_OPERATION__LEFT;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_OPERATION__RIGHT = ROSETTA_BINARY_OPERATION__RIGHT;

	/**
	 * The number of structural features of the '<em>Arithmetic Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_OPERATION_FEATURE_COUNT = ROSETTA_BINARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.DefaultOperationImpl <em>Default Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.DefaultOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getDefaultOperation()
	 * @generated
	 */
	int DEFAULT_OPERATION = 20;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_OPERATION__GENERATED = ROSETTA_BINARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_OPERATION__OPERATOR = ROSETTA_BINARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_BINARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_OPERATION__LEFT = ROSETTA_BINARY_OPERATION__LEFT;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_OPERATION__RIGHT = ROSETTA_BINARY_OPERATION__RIGHT;

	/**
	 * The number of structural features of the '<em>Default Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_OPERATION_FEATURE_COUNT = ROSETTA_BINARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.LogicalOperationImpl <em>Logical Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.LogicalOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getLogicalOperation()
	 * @generated
	 */
	int LOGICAL_OPERATION = 21;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_OPERATION__GENERATED = ROSETTA_BINARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_OPERATION__OPERATOR = ROSETTA_BINARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_BINARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_OPERATION__LEFT = ROSETTA_BINARY_OPERATION__LEFT;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_OPERATION__RIGHT = ROSETTA_BINARY_OPERATION__RIGHT;

	/**
	 * The number of structural features of the '<em>Logical Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_OPERATION_FEATURE_COUNT = ROSETTA_BINARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation <em>Modifiable Binary Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getModifiableBinaryOperation()
	 * @generated
	 */
	int MODIFIABLE_BINARY_OPERATION = 22;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIABLE_BINARY_OPERATION__GENERATED = ROSETTA_BINARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIABLE_BINARY_OPERATION__OPERATOR = ROSETTA_BINARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIABLE_BINARY_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_BINARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIABLE_BINARY_OPERATION__LEFT = ROSETTA_BINARY_OPERATION__LEFT;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIABLE_BINARY_OPERATION__RIGHT = ROSETTA_BINARY_OPERATION__RIGHT;

	/**
	 * The feature id for the '<em><b>Card Mod</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIABLE_BINARY_OPERATION__CARD_MOD = ROSETTA_BINARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Modifiable Binary Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODIFIABLE_BINARY_OPERATION_FEATURE_COUNT = ROSETTA_BINARY_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.EqualityOperationImpl <em>Equality Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.EqualityOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getEqualityOperation()
	 * @generated
	 */
	int EQUALITY_OPERATION = 23;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_OPERATION__GENERATED = MODIFIABLE_BINARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_OPERATION__OPERATOR = MODIFIABLE_BINARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_OPERATION__GENERATED_INPUT_WAS_SET = MODIFIABLE_BINARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_OPERATION__LEFT = MODIFIABLE_BINARY_OPERATION__LEFT;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_OPERATION__RIGHT = MODIFIABLE_BINARY_OPERATION__RIGHT;

	/**
	 * The feature id for the '<em><b>Card Mod</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_OPERATION__CARD_MOD = MODIFIABLE_BINARY_OPERATION__CARD_MOD;

	/**
	 * The number of structural features of the '<em>Equality Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_OPERATION_FEATURE_COUNT = MODIFIABLE_BINARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ComparisonOperationImpl <em>Comparison Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ComparisonOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getComparisonOperation()
	 * @generated
	 */
	int COMPARISON_OPERATION = 24;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON_OPERATION__GENERATED = MODIFIABLE_BINARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON_OPERATION__OPERATOR = MODIFIABLE_BINARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON_OPERATION__GENERATED_INPUT_WAS_SET = MODIFIABLE_BINARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON_OPERATION__LEFT = MODIFIABLE_BINARY_OPERATION__LEFT;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON_OPERATION__RIGHT = MODIFIABLE_BINARY_OPERATION__RIGHT;

	/**
	 * The feature id for the '<em><b>Card Mod</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON_OPERATION__CARD_MOD = MODIFIABLE_BINARY_OPERATION__CARD_MOD;

	/**
	 * The number of structural features of the '<em>Comparison Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARISON_OPERATION_FEATURE_COUNT = MODIFIABLE_BINARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaContainsExpressionImpl <em>Rosetta Contains Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaContainsExpressionImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaContainsExpression()
	 * @generated
	 */
	int ROSETTA_CONTAINS_EXPRESSION = 25;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONTAINS_EXPRESSION__GENERATED = ROSETTA_BINARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONTAINS_EXPRESSION__OPERATOR = ROSETTA_BINARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONTAINS_EXPRESSION__GENERATED_INPUT_WAS_SET = ROSETTA_BINARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONTAINS_EXPRESSION__LEFT = ROSETTA_BINARY_OPERATION__LEFT;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONTAINS_EXPRESSION__RIGHT = ROSETTA_BINARY_OPERATION__RIGHT;

	/**
	 * The number of structural features of the '<em>Rosetta Contains Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_CONTAINS_EXPRESSION_FEATURE_COUNT = ROSETTA_BINARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaDisjointExpressionImpl <em>Rosetta Disjoint Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaDisjointExpressionImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaDisjointExpression()
	 * @generated
	 */
	int ROSETTA_DISJOINT_EXPRESSION = 26;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DISJOINT_EXPRESSION__GENERATED = ROSETTA_BINARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DISJOINT_EXPRESSION__OPERATOR = ROSETTA_BINARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DISJOINT_EXPRESSION__GENERATED_INPUT_WAS_SET = ROSETTA_BINARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DISJOINT_EXPRESSION__LEFT = ROSETTA_BINARY_OPERATION__LEFT;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DISJOINT_EXPRESSION__RIGHT = ROSETTA_BINARY_OPERATION__RIGHT;

	/**
	 * The number of structural features of the '<em>Rosetta Disjoint Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_DISJOINT_EXPRESSION_FEATURE_COUNT = ROSETTA_BINARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.JoinOperationImpl <em>Join Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.JoinOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getJoinOperation()
	 * @generated
	 */
	int JOIN_OPERATION = 27;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_OPERATION__GENERATED = ROSETTA_BINARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_OPERATION__OPERATOR = ROSETTA_BINARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_BINARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_OPERATION__LEFT = ROSETTA_BINARY_OPERATION__LEFT;

	/**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_OPERATION__RIGHT = ROSETTA_BINARY_OPERATION__RIGHT;

	/**
	 * The feature id for the '<em><b>Explicit Separator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_OPERATION__EXPLICIT_SEPARATOR = ROSETTA_BINARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Join Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_OPERATION_FEATURE_COUNT = ROSETTA_BINARY_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaOnlyExistsExpressionImpl <em>Rosetta Only Exists Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaOnlyExistsExpressionImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaOnlyExistsExpression()
	 * @generated
	 */
	int ROSETTA_ONLY_EXISTS_EXPRESSION = 28;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ONLY_EXISTS_EXPRESSION__GENERATED = ROSETTA_EXPRESSION__GENERATED;

	/**
	 * The feature id for the '<em><b>Args</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ONLY_EXISTS_EXPRESSION__ARGS = ROSETTA_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta Only Exists Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ONLY_EXISTS_EXPRESSION_FEATURE_COUNT = ROSETTA_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation <em>Rosetta Unary Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaUnaryOperation()
	 * @generated
	 */
	int ROSETTA_UNARY_OPERATION = 29;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_UNARY_OPERATION__GENERATED = ROSETTA_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_UNARY_OPERATION__OPERATOR = ROSETTA_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_UNARY_OPERATION__ARGUMENT = ROSETTA_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Rosetta Unary Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_UNARY_OPERATION_FEATURE_COUNT = ROSETTA_OPERATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.ListOperation <em>List Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.ListOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getListOperation()
	 * @generated
	 */
	int LIST_OPERATION = 30;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OPERATION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OPERATION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OPERATION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>List Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OPERATION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists <em>Can Handle List Of Lists</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getCanHandleListOfLists()
	 * @generated
	 */
	int CAN_HANDLE_LIST_OF_LISTS = 31;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAN_HANDLE_LIST_OF_LISTS__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAN_HANDLE_LIST_OF_LISTS__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAN_HANDLE_LIST_OF_LISTS__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAN_HANDLE_LIST_OF_LISTS__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Can Handle List Of Lists</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAN_HANDLE_LIST_OF_LISTS_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaExistsExpressionImpl <em>Rosetta Exists Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaExistsExpressionImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaExistsExpression()
	 * @generated
	 */
	int ROSETTA_EXISTS_EXPRESSION = 32;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXISTS_EXPRESSION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXISTS_EXPRESSION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXISTS_EXPRESSION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXISTS_EXPRESSION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Modifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXISTS_EXPRESSION__MODIFIER = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta Exists Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_EXISTS_EXPRESSION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaAbsentExpressionImpl <em>Rosetta Absent Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaAbsentExpressionImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaAbsentExpression()
	 * @generated
	 */
	int ROSETTA_ABSENT_EXPRESSION = 33;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ABSENT_EXPRESSION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ABSENT_EXPRESSION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ABSENT_EXPRESSION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ABSENT_EXPRESSION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Rosetta Absent Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ABSENT_EXPRESSION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaOnlyElementImpl <em>Rosetta Only Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaOnlyElementImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaOnlyElement()
	 * @generated
	 */
	int ROSETTA_ONLY_ELEMENT = 34;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ONLY_ELEMENT__GENERATED = LIST_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ONLY_ELEMENT__OPERATOR = LIST_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ONLY_ELEMENT__GENERATED_INPUT_WAS_SET = LIST_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ONLY_ELEMENT__ARGUMENT = LIST_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Rosetta Only Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_ONLY_ELEMENT_FEATURE_COUNT = LIST_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaCountOperationImpl <em>Rosetta Count Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaCountOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaCountOperation()
	 * @generated
	 */
	int ROSETTA_COUNT_OPERATION = 35;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_COUNT_OPERATION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_COUNT_OPERATION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_COUNT_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_COUNT_OPERATION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Rosetta Count Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_COUNT_OPERATION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.FlattenOperationImpl <em>Flatten Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.FlattenOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getFlattenOperation()
	 * @generated
	 */
	int FLATTEN_OPERATION = 36;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATTEN_OPERATION__GENERATED = LIST_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATTEN_OPERATION__OPERATOR = LIST_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATTEN_OPERATION__GENERATED_INPUT_WAS_SET = LIST_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATTEN_OPERATION__ARGUMENT = LIST_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Flatten Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATTEN_OPERATION_FEATURE_COUNT = LIST_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.DistinctOperationImpl <em>Distinct Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.DistinctOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getDistinctOperation()
	 * @generated
	 */
	int DISTINCT_OPERATION = 37;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTINCT_OPERATION__GENERATED = LIST_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTINCT_OPERATION__OPERATOR = LIST_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTINCT_OPERATION__GENERATED_INPUT_WAS_SET = LIST_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTINCT_OPERATION__ARGUMENT = LIST_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Distinct Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTINCT_OPERATION_FEATURE_COUNT = LIST_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ReverseOperationImpl <em>Reverse Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ReverseOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getReverseOperation()
	 * @generated
	 */
	int REVERSE_OPERATION = 38;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REVERSE_OPERATION__GENERATED = LIST_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REVERSE_OPERATION__OPERATOR = LIST_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REVERSE_OPERATION__GENERATED_INPUT_WAS_SET = LIST_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REVERSE_OPERATION__ARGUMENT = LIST_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Reverse Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REVERSE_OPERATION_FEATURE_COUNT = LIST_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.FirstOperationImpl <em>First Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.FirstOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getFirstOperation()
	 * @generated
	 */
	int FIRST_OPERATION = 39;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIRST_OPERATION__GENERATED = LIST_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIRST_OPERATION__OPERATOR = LIST_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIRST_OPERATION__GENERATED_INPUT_WAS_SET = LIST_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIRST_OPERATION__ARGUMENT = LIST_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>First Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIRST_OPERATION_FEATURE_COUNT = LIST_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.LastOperationImpl <em>Last Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.LastOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getLastOperation()
	 * @generated
	 */
	int LAST_OPERATION = 40;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAST_OPERATION__GENERATED = LIST_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAST_OPERATION__OPERATOR = LIST_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAST_OPERATION__GENERATED_INPUT_WAS_SET = LIST_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAST_OPERATION__ARGUMENT = LIST_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Last Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LAST_OPERATION_FEATURE_COUNT = LIST_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.SumOperationImpl <em>Sum Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.SumOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getSumOperation()
	 * @generated
	 */
	int SUM_OPERATION = 41;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUM_OPERATION__GENERATED = LIST_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUM_OPERATION__OPERATOR = LIST_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUM_OPERATION__GENERATED_INPUT_WAS_SET = LIST_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUM_OPERATION__ARGUMENT = LIST_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Sum Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUM_OPERATION_FEATURE_COUNT = LIST_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.AsKeyOperationImpl <em>As Key Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.AsKeyOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getAsKeyOperation()
	 * @generated
	 */
	int AS_KEY_OPERATION = 42;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AS_KEY_OPERATION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AS_KEY_OPERATION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AS_KEY_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AS_KEY_OPERATION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>As Key Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AS_KEY_OPERATION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.OneOfOperationImpl <em>One Of Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.OneOfOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getOneOfOperation()
	 * @generated
	 */
	int ONE_OF_OPERATION = 43;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_OF_OPERATION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_OF_OPERATION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_OF_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_OF_OPERATION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>One Of Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_OF_OPERATION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl <em>Choice Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getChoiceOperation()
	 * @generated
	 */
	int CHOICE_OPERATION = 44;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPERATION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPERATION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPERATION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Necessity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPERATION__NECESSITY = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPERATION__ATTRIBUTES = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Choice Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_OPERATION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToStringOperationImpl <em>To String Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ToStringOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToStringOperation()
	 * @generated
	 */
	int TO_STRING_OPERATION = 45;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_STRING_OPERATION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_STRING_OPERATION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_STRING_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_STRING_OPERATION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>To String Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_STRING_OPERATION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.ParseOperation <em>Parse Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.ParseOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getParseOperation()
	 * @generated
	 */
	int PARSE_OPERATION = 46;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARSE_OPERATION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARSE_OPERATION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARSE_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARSE_OPERATION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>Parse Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARSE_OPERATION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToNumberOperationImpl <em>To Number Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ToNumberOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToNumberOperation()
	 * @generated
	 */
	int TO_NUMBER_OPERATION = 47;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_NUMBER_OPERATION__GENERATED = PARSE_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_NUMBER_OPERATION__OPERATOR = PARSE_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_NUMBER_OPERATION__GENERATED_INPUT_WAS_SET = PARSE_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_NUMBER_OPERATION__ARGUMENT = PARSE_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>To Number Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_NUMBER_OPERATION_FEATURE_COUNT = PARSE_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToIntOperationImpl <em>To Int Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ToIntOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToIntOperation()
	 * @generated
	 */
	int TO_INT_OPERATION = 48;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_INT_OPERATION__GENERATED = PARSE_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_INT_OPERATION__OPERATOR = PARSE_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_INT_OPERATION__GENERATED_INPUT_WAS_SET = PARSE_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_INT_OPERATION__ARGUMENT = PARSE_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>To Int Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_INT_OPERATION_FEATURE_COUNT = PARSE_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToTimeOperationImpl <em>To Time Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ToTimeOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToTimeOperation()
	 * @generated
	 */
	int TO_TIME_OPERATION = 49;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_TIME_OPERATION__GENERATED = PARSE_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_TIME_OPERATION__OPERATOR = PARSE_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_TIME_OPERATION__GENERATED_INPUT_WAS_SET = PARSE_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_TIME_OPERATION__ARGUMENT = PARSE_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>To Time Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_TIME_OPERATION_FEATURE_COUNT = PARSE_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToEnumOperationImpl <em>To Enum Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ToEnumOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToEnumOperation()
	 * @generated
	 */
	int TO_ENUM_OPERATION = 50;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ENUM_OPERATION__GENERATED = PARSE_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ENUM_OPERATION__OPERATOR = PARSE_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ENUM_OPERATION__GENERATED_INPUT_WAS_SET = PARSE_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ENUM_OPERATION__ARGUMENT = PARSE_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Enumeration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ENUM_OPERATION__ENUMERATION = PARSE_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>To Enum Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ENUM_OPERATION_FEATURE_COUNT = PARSE_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToDateOperationImpl <em>To Date Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ToDateOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToDateOperation()
	 * @generated
	 */
	int TO_DATE_OPERATION = 51;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_OPERATION__GENERATED = PARSE_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_OPERATION__OPERATOR = PARSE_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_OPERATION__GENERATED_INPUT_WAS_SET = PARSE_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_OPERATION__ARGUMENT = PARSE_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>To Date Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_OPERATION_FEATURE_COUNT = PARSE_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToDateTimeOperationImpl <em>To Date Time Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ToDateTimeOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToDateTimeOperation()
	 * @generated
	 */
	int TO_DATE_TIME_OPERATION = 52;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_TIME_OPERATION__GENERATED = PARSE_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_TIME_OPERATION__OPERATOR = PARSE_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_TIME_OPERATION__GENERATED_INPUT_WAS_SET = PARSE_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_TIME_OPERATION__ARGUMENT = PARSE_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>To Date Time Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_DATE_TIME_OPERATION_FEATURE_COUNT = PARSE_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToZonedDateTimeOperationImpl <em>To Zoned Date Time Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ToZonedDateTimeOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToZonedDateTimeOperation()
	 * @generated
	 */
	int TO_ZONED_DATE_TIME_OPERATION = 53;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ZONED_DATE_TIME_OPERATION__GENERATED = PARSE_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ZONED_DATE_TIME_OPERATION__OPERATOR = PARSE_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ZONED_DATE_TIME_OPERATION__GENERATED_INPUT_WAS_SET = PARSE_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ZONED_DATE_TIME_OPERATION__ARGUMENT = PARSE_OPERATION__ARGUMENT;

	/**
	 * The number of structural features of the '<em>To Zoned Date Time Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TO_ZONED_DATE_TIME_OPERATION_FEATURE_COUNT = PARSE_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ClosureParameterImpl <em>Closure Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ClosureParameterImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getClosureParameter()
	 * @generated
	 */
	int CLOSURE_PARAMETER = 54;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOSURE_PARAMETER__NAME = RosettaPackage.ROSETTA_SYMBOL__NAME;

	/**
	 * The feature id for the '<em><b>Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOSURE_PARAMETER__FUNCTION = RosettaPackage.ROSETTA_SYMBOL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Closure Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOSURE_PARAMETER_FEATURE_COUNT = RosettaPackage.ROSETTA_SYMBOL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.InlineFunctionImpl <em>Inline Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.InlineFunctionImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getInlineFunction()
	 * @generated
	 */
	int INLINE_FUNCTION = 55;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_FUNCTION__PARAMETERS = 0;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_FUNCTION__BODY = 1;

	/**
	 * The number of structural features of the '<em>Inline Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_FUNCTION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation <em>Rosetta Functional Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaFunctionalOperation()
	 * @generated
	 */
	int ROSETTA_FUNCTIONAL_OPERATION = 56;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FUNCTIONAL_OPERATION__GENERATED = ROSETTA_UNARY_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FUNCTIONAL_OPERATION__OPERATOR = ROSETTA_UNARY_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_UNARY_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FUNCTIONAL_OPERATION__ARGUMENT = ROSETTA_UNARY_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FUNCTIONAL_OPERATION__FUNCTION = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rosetta Functional Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROSETTA_FUNCTIONAL_OPERATION_FEATURE_COUNT = ROSETTA_UNARY_OPERATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation <em>Mandatory Functional Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getMandatoryFunctionalOperation()
	 * @generated
	 */
	int MANDATORY_FUNCTIONAL_OPERATION = 57;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANDATORY_FUNCTIONAL_OPERATION__GENERATED = ROSETTA_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANDATORY_FUNCTIONAL_OPERATION__OPERATOR = ROSETTA_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANDATORY_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANDATORY_FUNCTIONAL_OPERATION__ARGUMENT = ROSETTA_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANDATORY_FUNCTIONAL_OPERATION__FUNCTION = ROSETTA_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Mandatory Functional Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MANDATORY_FUNCTIONAL_OPERATION_FEATURE_COUNT = ROSETTA_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation <em>Unary Functional Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getUnaryFunctionalOperation()
	 * @generated
	 */
	int UNARY_FUNCTIONAL_OPERATION = 58;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_FUNCTIONAL_OPERATION__GENERATED = ROSETTA_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_FUNCTIONAL_OPERATION__OPERATOR = ROSETTA_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_FUNCTIONAL_OPERATION__ARGUMENT = ROSETTA_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_FUNCTIONAL_OPERATION__FUNCTION = ROSETTA_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Unary Functional Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_FUNCTIONAL_OPERATION_FEATURE_COUNT = ROSETTA_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ReduceOperationImpl <em>Reduce Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ReduceOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getReduceOperation()
	 * @generated
	 */
	int REDUCE_OPERATION = 59;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REDUCE_OPERATION__GENERATED = MANDATORY_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REDUCE_OPERATION__OPERATOR = MANDATORY_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REDUCE_OPERATION__GENERATED_INPUT_WAS_SET = MANDATORY_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REDUCE_OPERATION__ARGUMENT = MANDATORY_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REDUCE_OPERATION__FUNCTION = MANDATORY_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Reduce Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REDUCE_OPERATION_FEATURE_COUNT = MANDATORY_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.FilterOperationImpl <em>Filter Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.FilterOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getFilterOperation()
	 * @generated
	 */
	int FILTER_OPERATION = 60;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_OPERATION__GENERATED = MANDATORY_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_OPERATION__OPERATOR = MANDATORY_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_OPERATION__GENERATED_INPUT_WAS_SET = MANDATORY_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_OPERATION__ARGUMENT = MANDATORY_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_OPERATION__FUNCTION = MANDATORY_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Filter Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_OPERATION_FEATURE_COUNT = MANDATORY_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.MapOperationImpl <em>Map Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.MapOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getMapOperation()
	 * @generated
	 */
	int MAP_OPERATION = 61;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_OPERATION__GENERATED = MANDATORY_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_OPERATION__OPERATOR = MANDATORY_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_OPERATION__GENERATED_INPUT_WAS_SET = MANDATORY_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_OPERATION__ARGUMENT = MANDATORY_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_OPERATION__FUNCTION = MANDATORY_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Map Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_OPERATION_FEATURE_COUNT = MANDATORY_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ThenOperationImpl <em>Then Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ThenOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getThenOperation()
	 * @generated
	 */
	int THEN_OPERATION = 62;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THEN_OPERATION__GENERATED = MANDATORY_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THEN_OPERATION__OPERATOR = MANDATORY_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THEN_OPERATION__GENERATED_INPUT_WAS_SET = MANDATORY_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THEN_OPERATION__ARGUMENT = MANDATORY_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THEN_OPERATION__FUNCTION = MANDATORY_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Then Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THEN_OPERATION_FEATURE_COUNT = MANDATORY_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation <em>Comparing Functional Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getComparingFunctionalOperation()
	 * @generated
	 */
	int COMPARING_FUNCTIONAL_OPERATION = 63;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARING_FUNCTIONAL_OPERATION__GENERATED = ROSETTA_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARING_FUNCTIONAL_OPERATION__OPERATOR = ROSETTA_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARING_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET = ROSETTA_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARING_FUNCTIONAL_OPERATION__ARGUMENT = ROSETTA_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARING_FUNCTIONAL_OPERATION__FUNCTION = ROSETTA_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Comparing Functional Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPARING_FUNCTIONAL_OPERATION_FEATURE_COUNT = ROSETTA_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.SortOperationImpl <em>Sort Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.SortOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getSortOperation()
	 * @generated
	 */
	int SORT_OPERATION = 64;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SORT_OPERATION__GENERATED = COMPARING_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SORT_OPERATION__OPERATOR = COMPARING_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SORT_OPERATION__GENERATED_INPUT_WAS_SET = COMPARING_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SORT_OPERATION__ARGUMENT = COMPARING_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SORT_OPERATION__FUNCTION = COMPARING_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Sort Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SORT_OPERATION_FEATURE_COUNT = COMPARING_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.MinOperationImpl <em>Min Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.MinOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getMinOperation()
	 * @generated
	 */
	int MIN_OPERATION = 65;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_OPERATION__GENERATED = COMPARING_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_OPERATION__OPERATOR = COMPARING_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_OPERATION__GENERATED_INPUT_WAS_SET = COMPARING_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_OPERATION__ARGUMENT = COMPARING_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_OPERATION__FUNCTION = COMPARING_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Min Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_OPERATION_FEATURE_COUNT = COMPARING_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.impl.MaxOperationImpl <em>Max Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.impl.MaxOperationImpl
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getMaxOperation()
	 * @generated
	 */
	int MAX_OPERATION = 66;

	/**
	 * The feature id for the '<em><b>Generated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_OPERATION__GENERATED = COMPARING_FUNCTIONAL_OPERATION__GENERATED;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_OPERATION__OPERATOR = COMPARING_FUNCTIONAL_OPERATION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Generated Input Was Set</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_OPERATION__GENERATED_INPUT_WAS_SET = COMPARING_FUNCTIONAL_OPERATION__GENERATED_INPUT_WAS_SET;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_OPERATION__ARGUMENT = COMPARING_FUNCTIONAL_OPERATION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_OPERATION__FUNCTION = COMPARING_FUNCTIONAL_OPERATION__FUNCTION;

	/**
	 * The number of structural features of the '<em>Max Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAX_OPERATION_FEATURE_COUNT = COMPARING_FUNCTIONAL_OPERATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.CardinalityModifier <em>Cardinality Modifier</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.CardinalityModifier
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getCardinalityModifier()
	 * @generated
	 */
	int CARDINALITY_MODIFIER = 67;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.ExistsModifier <em>Exists Modifier</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.ExistsModifier
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getExistsModifier()
	 * @generated
	 */
	int EXISTS_MODIFIER = 68;

	/**
	 * The meta object id for the '{@link com.regnosys.rosetta.rosetta.expression.Necessity <em>Necessity</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.regnosys.rosetta.rosetta.expression.Necessity
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getNecessity()
	 * @generated
	 */
	int NECESSITY = 69;

	/**
	 * The meta object id for the '<em>Pattern</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.util.regex.Pattern
	 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getPattern()
	 * @generated
	 */
	int PATTERN = 70;


	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaExpression <em>Rosetta Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaExpression
	 * @generated
	 */
	EClass getRosettaExpression();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaExpression#isGenerated <em>Generated</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Generated</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaExpression#isGenerated()
	 * @see #getRosettaExpression()
	 * @generated
	 */
	EAttribute getRosettaExpression_Generated();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.HasGeneratedInput <em>Has Generated Input</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Has Generated Input</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.HasGeneratedInput
	 * @generated
	 */
	EClass getHasGeneratedInput();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.HasGeneratedInput#isGeneratedInputWasSet <em>Generated Input Was Set</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Generated Input Was Set</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.HasGeneratedInput#isGeneratedInputWasSet()
	 * @see #getHasGeneratedInput()
	 * @generated
	 */
	EAttribute getHasGeneratedInput_GeneratedInputWasSet();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaLiteral <em>Rosetta Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Literal</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaLiteral
	 * @generated
	 */
	EClass getRosettaLiteral();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral <em>Rosetta Boolean Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Boolean Literal</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral
	 * @generated
	 */
	EClass getRosettaBooleanLiteral();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral#isValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral#isValue()
	 * @see #getRosettaBooleanLiteral()
	 * @generated
	 */
	EAttribute getRosettaBooleanLiteral_Value();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral <em>Rosetta String Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta String Literal</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral
	 * @generated
	 */
	EClass getRosettaStringLiteral();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral#getValue()
	 * @see #getRosettaStringLiteral()
	 * @generated
	 */
	EAttribute getRosettaStringLiteral_Value();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral <em>Rosetta Number Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Number Literal</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral
	 * @generated
	 */
	EClass getRosettaNumberLiteral();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral#getValue()
	 * @see #getRosettaNumberLiteral()
	 * @generated
	 */
	EAttribute getRosettaNumberLiteral_Value();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral <em>Rosetta Int Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Int Literal</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral
	 * @generated
	 */
	EClass getRosettaIntLiteral();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral#getValue()
	 * @see #getRosettaIntLiteral()
	 * @generated
	 */
	EAttribute getRosettaIntLiteral_Value();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaPatternLiteral <em>Rosetta Pattern Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Pattern Literal</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaPatternLiteral
	 * @generated
	 */
	EClass getRosettaPatternLiteral();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaPatternLiteral#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaPatternLiteral#getValue()
	 * @see #getRosettaPatternLiteral()
	 * @generated
	 */
	EAttribute getRosettaPatternLiteral_Value();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ListLiteral <em>List Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>List Literal</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ListLiteral
	 * @generated
	 */
	EClass getListLiteral();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.expression.ListLiteral#getElements <em>Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Elements</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ListLiteral#getElements()
	 * @see #getListLiteral()
	 * @generated
	 */
	EReference getListLiteral_Elements();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaReference <em>Rosetta Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaReference
	 * @generated
	 */
	EClass getRosettaReference();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference <em>Rosetta Symbol Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Symbol Reference</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference
	 * @generated
	 */
	EClass getRosettaSymbolReference();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#getSymbol <em>Symbol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Symbol</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#getSymbol()
	 * @see #getRosettaSymbolReference()
	 * @generated
	 */
	EReference getRosettaSymbolReference_Symbol();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#isExplicitArguments <em>Explicit Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Explicit Arguments</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#isExplicitArguments()
	 * @see #getRosettaSymbolReference()
	 * @generated
	 */
	EAttribute getRosettaSymbolReference_ExplicitArguments();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#getRawArgs <em>Raw Args</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Raw Args</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#getRawArgs()
	 * @see #getRosettaSymbolReference()
	 * @generated
	 */
	EReference getRosettaSymbolReference_RawArgs();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#isImplicitVariableIsInContext <em>Implicit Variable Is In Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Implicit Variable Is In Context</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#isImplicitVariableIsInContext()
	 * @see #getRosettaSymbolReference()
	 * @generated
	 */
	EAttribute getRosettaSymbolReference_ImplicitVariableIsInContext();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#getImplicitArgument <em>Implicit Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Implicit Argument</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference#getImplicitArgument()
	 * @see #getRosettaSymbolReference()
	 * @generated
	 */
	EReference getRosettaSymbolReference_ImplicitArgument();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable <em>Rosetta Implicit Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Implicit Variable</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable
	 * @generated
	 */
	EClass getRosettaImplicitVariable();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall <em>Rosetta Feature Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Feature Call</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall
	 * @generated
	 */
	EClass getRosettaFeatureCall();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall#getReceiver <em>Receiver</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Receiver</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall#getReceiver()
	 * @see #getRosettaFeatureCall()
	 * @generated
	 */
	EReference getRosettaFeatureCall_Receiver();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall#getFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Feature</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall#getFeature()
	 * @see #getRosettaFeatureCall()
	 * @generated
	 */
	EReference getRosettaFeatureCall_Feature();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall <em>Rosetta Deep Feature Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Deep Feature Call</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall
	 * @generated
	 */
	EClass getRosettaDeepFeatureCall();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall#getReceiver <em>Receiver</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Receiver</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall#getReceiver()
	 * @see #getRosettaDeepFeatureCall()
	 * @generated
	 */
	EReference getRosettaDeepFeatureCall_Receiver();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall#getFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Feature</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall#getFeature()
	 * @see #getRosettaDeepFeatureCall()
	 * @generated
	 */
	EReference getRosettaDeepFeatureCall_Feature();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression <em>Rosetta Conditional Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Conditional Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression
	 * @generated
	 */
	EClass getRosettaConditionalExpression();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression#getIf <em>If</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>If</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression#getIf()
	 * @see #getRosettaConditionalExpression()
	 * @generated
	 */
	EReference getRosettaConditionalExpression_If();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression#getIfthen <em>Ifthen</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Ifthen</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression#getIfthen()
	 * @see #getRosettaConditionalExpression()
	 * @generated
	 */
	EReference getRosettaConditionalExpression_Ifthen();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression#getElsethen <em>Elsethen</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Elsethen</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression#getElsethen()
	 * @see #getRosettaConditionalExpression()
	 * @generated
	 */
	EReference getRosettaConditionalExpression_Elsethen();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression#isFull <em>Full</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Full</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression#isFull()
	 * @see #getRosettaConditionalExpression()
	 * @generated
	 */
	EAttribute getRosettaConditionalExpression_Full();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression <em>Rosetta Constructor Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Constructor Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression
	 * @generated
	 */
	EClass getRosettaConstructorExpression();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression#getValues <em>Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Values</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression#getValues()
	 * @see #getRosettaConstructorExpression()
	 * @generated
	 */
	EReference getRosettaConstructorExpression_Values();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression#isImplicitEmpty <em>Implicit Empty</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Implicit Empty</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression#isImplicitEmpty()
	 * @see #getRosettaConstructorExpression()
	 * @generated
	 */
	EAttribute getRosettaConstructorExpression_ImplicitEmpty();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair <em>Constructor Key Value Pair</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constructor Key Value Pair</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair
	 * @generated
	 */
	EClass getConstructorKeyValuePair();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Key</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair#getKey()
	 * @see #getConstructorKeyValuePair()
	 * @generated
	 */
	EReference getConstructorKeyValuePair_Key();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair#getValue()
	 * @see #getConstructorKeyValuePair()
	 * @generated
	 */
	EReference getConstructorKeyValuePair_Value();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaOperation <em>Rosetta Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaOperation
	 * @generated
	 */
	EClass getRosettaOperation();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaOperation#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaOperation#getOperator()
	 * @see #getRosettaOperation()
	 * @generated
	 */
	EAttribute getRosettaOperation_Operator();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation <em>Rosetta Binary Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Binary Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation
	 * @generated
	 */
	EClass getRosettaBinaryOperation();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation#getLeft()
	 * @see #getRosettaBinaryOperation()
	 * @generated
	 */
	EReference getRosettaBinaryOperation_Left();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation#getRight()
	 * @see #getRosettaBinaryOperation()
	 * @generated
	 */
	EReference getRosettaBinaryOperation_Right();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ArithmeticOperation <em>Arithmetic Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Arithmetic Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ArithmeticOperation
	 * @generated
	 */
	EClass getArithmeticOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.DefaultOperation <em>Default Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Default Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.DefaultOperation
	 * @generated
	 */
	EClass getDefaultOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.LogicalOperation <em>Logical Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Logical Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.LogicalOperation
	 * @generated
	 */
	EClass getLogicalOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation <em>Modifiable Binary Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Modifiable Binary Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation
	 * @generated
	 */
	EClass getModifiableBinaryOperation();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation#getCardMod <em>Card Mod</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Card Mod</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation#getCardMod()
	 * @see #getModifiableBinaryOperation()
	 * @generated
	 */
	EAttribute getModifiableBinaryOperation_CardMod();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.EqualityOperation <em>Equality Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Equality Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.EqualityOperation
	 * @generated
	 */
	EClass getEqualityOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ComparisonOperation <em>Comparison Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Comparison Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ComparisonOperation
	 * @generated
	 */
	EClass getComparisonOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression <em>Rosetta Contains Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Contains Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression
	 * @generated
	 */
	EClass getRosettaContainsExpression();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression <em>Rosetta Disjoint Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Disjoint Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression
	 * @generated
	 */
	EClass getRosettaDisjointExpression();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.JoinOperation <em>Join Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Join Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.JoinOperation
	 * @generated
	 */
	EClass getJoinOperation();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.JoinOperation#isExplicitSeparator <em>Explicit Separator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Explicit Separator</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.JoinOperation#isExplicitSeparator()
	 * @see #getJoinOperation()
	 * @generated
	 */
	EAttribute getJoinOperation_ExplicitSeparator();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression <em>Rosetta Only Exists Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Only Exists Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression
	 * @generated
	 */
	EClass getRosettaOnlyExistsExpression();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression#getArgs <em>Args</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Args</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression#getArgs()
	 * @see #getRosettaOnlyExistsExpression()
	 * @generated
	 */
	EReference getRosettaOnlyExistsExpression_Args();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation <em>Rosetta Unary Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Unary Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation
	 * @generated
	 */
	EClass getRosettaUnaryOperation();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation#getArgument <em>Argument</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Argument</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation#getArgument()
	 * @see #getRosettaUnaryOperation()
	 * @generated
	 */
	EReference getRosettaUnaryOperation_Argument();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ListOperation <em>List Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>List Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ListOperation
	 * @generated
	 */
	EClass getListOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists <em>Can Handle List Of Lists</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Can Handle List Of Lists</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists
	 * @generated
	 */
	EClass getCanHandleListOfLists();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression <em>Rosetta Exists Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Exists Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression
	 * @generated
	 */
	EClass getRosettaExistsExpression();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression#getModifier <em>Modifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Modifier</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression#getModifier()
	 * @see #getRosettaExistsExpression()
	 * @generated
	 */
	EAttribute getRosettaExistsExpression_Modifier();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression <em>Rosetta Absent Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Absent Expression</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression
	 * @generated
	 */
	EClass getRosettaAbsentExpression();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement <em>Rosetta Only Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Only Element</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement
	 * @generated
	 */
	EClass getRosettaOnlyElement();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaCountOperation <em>Rosetta Count Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Count Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaCountOperation
	 * @generated
	 */
	EClass getRosettaCountOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.FlattenOperation <em>Flatten Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Flatten Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.FlattenOperation
	 * @generated
	 */
	EClass getFlattenOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.DistinctOperation <em>Distinct Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Distinct Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.DistinctOperation
	 * @generated
	 */
	EClass getDistinctOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ReverseOperation <em>Reverse Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reverse Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ReverseOperation
	 * @generated
	 */
	EClass getReverseOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.FirstOperation <em>First Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>First Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.FirstOperation
	 * @generated
	 */
	EClass getFirstOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.LastOperation <em>Last Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Last Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.LastOperation
	 * @generated
	 */
	EClass getLastOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.SumOperation <em>Sum Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sum Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.SumOperation
	 * @generated
	 */
	EClass getSumOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.AsKeyOperation <em>As Key Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>As Key Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.AsKeyOperation
	 * @generated
	 */
	EClass getAsKeyOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.OneOfOperation <em>One Of Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>One Of Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.OneOfOperation
	 * @generated
	 */
	EClass getOneOfOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ChoiceOperation <em>Choice Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Choice Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ChoiceOperation
	 * @generated
	 */
	EClass getChoiceOperation();

	/**
	 * Returns the meta object for the attribute '{@link com.regnosys.rosetta.rosetta.expression.ChoiceOperation#getNecessity <em>Necessity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Necessity</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ChoiceOperation#getNecessity()
	 * @see #getChoiceOperation()
	 * @generated
	 */
	EAttribute getChoiceOperation_Necessity();

	/**
	 * Returns the meta object for the reference list '{@link com.regnosys.rosetta.rosetta.expression.ChoiceOperation#getAttributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Attributes</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ChoiceOperation#getAttributes()
	 * @see #getChoiceOperation()
	 * @generated
	 */
	EReference getChoiceOperation_Attributes();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ToStringOperation <em>To String Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>To String Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ToStringOperation
	 * @generated
	 */
	EClass getToStringOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ParseOperation <em>Parse Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parse Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ParseOperation
	 * @generated
	 */
	EClass getParseOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ToNumberOperation <em>To Number Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>To Number Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ToNumberOperation
	 * @generated
	 */
	EClass getToNumberOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ToIntOperation <em>To Int Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>To Int Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ToIntOperation
	 * @generated
	 */
	EClass getToIntOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ToTimeOperation <em>To Time Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>To Time Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ToTimeOperation
	 * @generated
	 */
	EClass getToTimeOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ToEnumOperation <em>To Enum Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>To Enum Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ToEnumOperation
	 * @generated
	 */
	EClass getToEnumOperation();

	/**
	 * Returns the meta object for the reference '{@link com.regnosys.rosetta.rosetta.expression.ToEnumOperation#getEnumeration <em>Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Enumeration</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ToEnumOperation#getEnumeration()
	 * @see #getToEnumOperation()
	 * @generated
	 */
	EReference getToEnumOperation_Enumeration();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ToDateOperation <em>To Date Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>To Date Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ToDateOperation
	 * @generated
	 */
	EClass getToDateOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation <em>To Date Time Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>To Date Time Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation
	 * @generated
	 */
	EClass getToDateTimeOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation <em>To Zoned Date Time Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>To Zoned Date Time Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation
	 * @generated
	 */
	EClass getToZonedDateTimeOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ClosureParameter <em>Closure Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Closure Parameter</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ClosureParameter
	 * @generated
	 */
	EClass getClosureParameter();

	/**
	 * Returns the meta object for the container reference '{@link com.regnosys.rosetta.rosetta.expression.ClosureParameter#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Function</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ClosureParameter#getFunction()
	 * @see #getClosureParameter()
	 * @generated
	 */
	EReference getClosureParameter_Function();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.InlineFunction <em>Inline Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Inline Function</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.InlineFunction
	 * @generated
	 */
	EClass getInlineFunction();

	/**
	 * Returns the meta object for the containment reference list '{@link com.regnosys.rosetta.rosetta.expression.InlineFunction#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameters</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.InlineFunction#getParameters()
	 * @see #getInlineFunction()
	 * @generated
	 */
	EReference getInlineFunction_Parameters();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.InlineFunction#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Body</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.InlineFunction#getBody()
	 * @see #getInlineFunction()
	 * @generated
	 */
	EReference getInlineFunction_Body();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation <em>Rosetta Functional Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rosetta Functional Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation
	 * @generated
	 */
	EClass getRosettaFunctionalOperation();

	/**
	 * Returns the meta object for the containment reference '{@link com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Function</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation#getFunction()
	 * @see #getRosettaFunctionalOperation()
	 * @generated
	 */
	EReference getRosettaFunctionalOperation_Function();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation <em>Mandatory Functional Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mandatory Functional Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation
	 * @generated
	 */
	EClass getMandatoryFunctionalOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation <em>Unary Functional Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unary Functional Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation
	 * @generated
	 */
	EClass getUnaryFunctionalOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ReduceOperation <em>Reduce Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reduce Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ReduceOperation
	 * @generated
	 */
	EClass getReduceOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.FilterOperation <em>Filter Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Filter Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.FilterOperation
	 * @generated
	 */
	EClass getFilterOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.MapOperation <em>Map Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.MapOperation
	 * @generated
	 */
	EClass getMapOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ThenOperation <em>Then Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Then Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ThenOperation
	 * @generated
	 */
	EClass getThenOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation <em>Comparing Functional Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Comparing Functional Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation
	 * @generated
	 */
	EClass getComparingFunctionalOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.SortOperation <em>Sort Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sort Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.SortOperation
	 * @generated
	 */
	EClass getSortOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.MinOperation <em>Min Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Min Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.MinOperation
	 * @generated
	 */
	EClass getMinOperation();

	/**
	 * Returns the meta object for class '{@link com.regnosys.rosetta.rosetta.expression.MaxOperation <em>Max Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Max Operation</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.MaxOperation
	 * @generated
	 */
	EClass getMaxOperation();

	/**
	 * Returns the meta object for enum '{@link com.regnosys.rosetta.rosetta.expression.CardinalityModifier <em>Cardinality Modifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Cardinality Modifier</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.CardinalityModifier
	 * @generated
	 */
	EEnum getCardinalityModifier();

	/**
	 * Returns the meta object for enum '{@link com.regnosys.rosetta.rosetta.expression.ExistsModifier <em>Exists Modifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Exists Modifier</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.ExistsModifier
	 * @generated
	 */
	EEnum getExistsModifier();

	/**
	 * Returns the meta object for enum '{@link com.regnosys.rosetta.rosetta.expression.Necessity <em>Necessity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Necessity</em>'.
	 * @see com.regnosys.rosetta.rosetta.expression.Necessity
	 * @generated
	 */
	EEnum getNecessity();

	/**
	 * Returns the meta object for data type '{@link java.util.regex.Pattern <em>Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Pattern</em>'.
	 * @see java.util.regex.Pattern
	 * @model instanceClass="java.util.regex.Pattern"
	 * @generated
	 */
	EDataType getPattern();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ExpressionFactory getExpressionFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaExpression <em>Rosetta Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.RosettaExpression
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaExpression()
		 * @generated
		 */
		EClass ROSETTA_EXPRESSION = eINSTANCE.getRosettaExpression();

		/**
		 * The meta object literal for the '<em><b>Generated</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_EXPRESSION__GENERATED = eINSTANCE.getRosettaExpression_Generated();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.HasGeneratedInput <em>Has Generated Input</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.HasGeneratedInput
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getHasGeneratedInput()
		 * @generated
		 */
		EClass HAS_GENERATED_INPUT = eINSTANCE.getHasGeneratedInput();

		/**
		 * The meta object literal for the '<em><b>Generated Input Was Set</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HAS_GENERATED_INPUT__GENERATED_INPUT_WAS_SET = eINSTANCE.getHasGeneratedInput_GeneratedInputWasSet();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaLiteral <em>Rosetta Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.RosettaLiteral
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaLiteral()
		 * @generated
		 */
		EClass ROSETTA_LITERAL = eINSTANCE.getRosettaLiteral();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaBooleanLiteralImpl <em>Rosetta Boolean Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaBooleanLiteralImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaBooleanLiteral()
		 * @generated
		 */
		EClass ROSETTA_BOOLEAN_LITERAL = eINSTANCE.getRosettaBooleanLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_BOOLEAN_LITERAL__VALUE = eINSTANCE.getRosettaBooleanLiteral_Value();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaStringLiteralImpl <em>Rosetta String Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaStringLiteralImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaStringLiteral()
		 * @generated
		 */
		EClass ROSETTA_STRING_LITERAL = eINSTANCE.getRosettaStringLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_STRING_LITERAL__VALUE = eINSTANCE.getRosettaStringLiteral_Value();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaNumberLiteralImpl <em>Rosetta Number Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaNumberLiteralImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaNumberLiteral()
		 * @generated
		 */
		EClass ROSETTA_NUMBER_LITERAL = eINSTANCE.getRosettaNumberLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_NUMBER_LITERAL__VALUE = eINSTANCE.getRosettaNumberLiteral_Value();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaIntLiteralImpl <em>Rosetta Int Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaIntLiteralImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaIntLiteral()
		 * @generated
		 */
		EClass ROSETTA_INT_LITERAL = eINSTANCE.getRosettaIntLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_INT_LITERAL__VALUE = eINSTANCE.getRosettaIntLiteral_Value();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaPatternLiteralImpl <em>Rosetta Pattern Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaPatternLiteralImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaPatternLiteral()
		 * @generated
		 */
		EClass ROSETTA_PATTERN_LITERAL = eINSTANCE.getRosettaPatternLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_PATTERN_LITERAL__VALUE = eINSTANCE.getRosettaPatternLiteral_Value();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ListLiteralImpl <em>List Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ListLiteralImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getListLiteral()
		 * @generated
		 */
		EClass LIST_LITERAL = eINSTANCE.getListLiteral();

		/**
		 * The meta object literal for the '<em><b>Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIST_LITERAL__ELEMENTS = eINSTANCE.getListLiteral_Elements();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaReferenceImpl <em>Rosetta Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaReferenceImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaReference()
		 * @generated
		 */
		EClass ROSETTA_REFERENCE = eINSTANCE.getRosettaReference();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaSymbolReferenceImpl <em>Rosetta Symbol Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaSymbolReferenceImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaSymbolReference()
		 * @generated
		 */
		EClass ROSETTA_SYMBOL_REFERENCE = eINSTANCE.getRosettaSymbolReference();

		/**
		 * The meta object literal for the '<em><b>Symbol</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_SYMBOL_REFERENCE__SYMBOL = eINSTANCE.getRosettaSymbolReference_Symbol();

		/**
		 * The meta object literal for the '<em><b>Explicit Arguments</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS = eINSTANCE.getRosettaSymbolReference_ExplicitArguments();

		/**
		 * The meta object literal for the '<em><b>Raw Args</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_SYMBOL_REFERENCE__RAW_ARGS = eINSTANCE.getRosettaSymbolReference_RawArgs();

		/**
		 * The meta object literal for the '<em><b>Implicit Variable Is In Context</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_SYMBOL_REFERENCE__IMPLICIT_VARIABLE_IS_IN_CONTEXT = eINSTANCE.getRosettaSymbolReference_ImplicitVariableIsInContext();

		/**
		 * The meta object literal for the '<em><b>Implicit Argument</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT = eINSTANCE.getRosettaSymbolReference_ImplicitArgument();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaImplicitVariableImpl <em>Rosetta Implicit Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaImplicitVariableImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaImplicitVariable()
		 * @generated
		 */
		EClass ROSETTA_IMPLICIT_VARIABLE = eINSTANCE.getRosettaImplicitVariable();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaFeatureCallImpl <em>Rosetta Feature Call</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaFeatureCallImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaFeatureCall()
		 * @generated
		 */
		EClass ROSETTA_FEATURE_CALL = eINSTANCE.getRosettaFeatureCall();

		/**
		 * The meta object literal for the '<em><b>Receiver</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_FEATURE_CALL__RECEIVER = eINSTANCE.getRosettaFeatureCall_Receiver();

		/**
		 * The meta object literal for the '<em><b>Feature</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_FEATURE_CALL__FEATURE = eINSTANCE.getRosettaFeatureCall_Feature();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaDeepFeatureCallImpl <em>Rosetta Deep Feature Call</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaDeepFeatureCallImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaDeepFeatureCall()
		 * @generated
		 */
		EClass ROSETTA_DEEP_FEATURE_CALL = eINSTANCE.getRosettaDeepFeatureCall();

		/**
		 * The meta object literal for the '<em><b>Receiver</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_DEEP_FEATURE_CALL__RECEIVER = eINSTANCE.getRosettaDeepFeatureCall_Receiver();

		/**
		 * The meta object literal for the '<em><b>Feature</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_DEEP_FEATURE_CALL__FEATURE = eINSTANCE.getRosettaDeepFeatureCall_Feature();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaConditionalExpressionImpl <em>Rosetta Conditional Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaConditionalExpressionImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaConditionalExpression()
		 * @generated
		 */
		EClass ROSETTA_CONDITIONAL_EXPRESSION = eINSTANCE.getRosettaConditionalExpression();

		/**
		 * The meta object literal for the '<em><b>If</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_CONDITIONAL_EXPRESSION__IF = eINSTANCE.getRosettaConditionalExpression_If();

		/**
		 * The meta object literal for the '<em><b>Ifthen</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_CONDITIONAL_EXPRESSION__IFTHEN = eINSTANCE.getRosettaConditionalExpression_Ifthen();

		/**
		 * The meta object literal for the '<em><b>Elsethen</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_CONDITIONAL_EXPRESSION__ELSETHEN = eINSTANCE.getRosettaConditionalExpression_Elsethen();

		/**
		 * The meta object literal for the '<em><b>Full</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CONDITIONAL_EXPRESSION__FULL = eINSTANCE.getRosettaConditionalExpression_Full();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaConstructorExpressionImpl <em>Rosetta Constructor Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaConstructorExpressionImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaConstructorExpression()
		 * @generated
		 */
		EClass ROSETTA_CONSTRUCTOR_EXPRESSION = eINSTANCE.getRosettaConstructorExpression();

		/**
		 * The meta object literal for the '<em><b>Values</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_CONSTRUCTOR_EXPRESSION__VALUES = eINSTANCE.getRosettaConstructorExpression_Values();

		/**
		 * The meta object literal for the '<em><b>Implicit Empty</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY = eINSTANCE.getRosettaConstructorExpression_ImplicitEmpty();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ConstructorKeyValuePairImpl <em>Constructor Key Value Pair</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ConstructorKeyValuePairImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getConstructorKeyValuePair()
		 * @generated
		 */
		EClass CONSTRUCTOR_KEY_VALUE_PAIR = eINSTANCE.getConstructorKeyValuePair();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONSTRUCTOR_KEY_VALUE_PAIR__KEY = eINSTANCE.getConstructorKeyValuePair_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONSTRUCTOR_KEY_VALUE_PAIR__VALUE = eINSTANCE.getConstructorKeyValuePair_Value();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaOperation <em>Rosetta Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.RosettaOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaOperation()
		 * @generated
		 */
		EClass ROSETTA_OPERATION = eINSTANCE.getRosettaOperation();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_OPERATION__OPERATOR = eINSTANCE.getRosettaOperation_Operator();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation <em>Rosetta Binary Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaBinaryOperation()
		 * @generated
		 */
		EClass ROSETTA_BINARY_OPERATION = eINSTANCE.getRosettaBinaryOperation();

		/**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_BINARY_OPERATION__LEFT = eINSTANCE.getRosettaBinaryOperation_Left();

		/**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_BINARY_OPERATION__RIGHT = eINSTANCE.getRosettaBinaryOperation_Right();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ArithmeticOperationImpl <em>Arithmetic Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ArithmeticOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getArithmeticOperation()
		 * @generated
		 */
		EClass ARITHMETIC_OPERATION = eINSTANCE.getArithmeticOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.DefaultOperationImpl <em>Default Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.DefaultOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getDefaultOperation()
		 * @generated
		 */
		EClass DEFAULT_OPERATION = eINSTANCE.getDefaultOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.LogicalOperationImpl <em>Logical Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.LogicalOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getLogicalOperation()
		 * @generated
		 */
		EClass LOGICAL_OPERATION = eINSTANCE.getLogicalOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation <em>Modifiable Binary Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getModifiableBinaryOperation()
		 * @generated
		 */
		EClass MODIFIABLE_BINARY_OPERATION = eINSTANCE.getModifiableBinaryOperation();

		/**
		 * The meta object literal for the '<em><b>Card Mod</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MODIFIABLE_BINARY_OPERATION__CARD_MOD = eINSTANCE.getModifiableBinaryOperation_CardMod();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.EqualityOperationImpl <em>Equality Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.EqualityOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getEqualityOperation()
		 * @generated
		 */
		EClass EQUALITY_OPERATION = eINSTANCE.getEqualityOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ComparisonOperationImpl <em>Comparison Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ComparisonOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getComparisonOperation()
		 * @generated
		 */
		EClass COMPARISON_OPERATION = eINSTANCE.getComparisonOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaContainsExpressionImpl <em>Rosetta Contains Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaContainsExpressionImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaContainsExpression()
		 * @generated
		 */
		EClass ROSETTA_CONTAINS_EXPRESSION = eINSTANCE.getRosettaContainsExpression();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaDisjointExpressionImpl <em>Rosetta Disjoint Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaDisjointExpressionImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaDisjointExpression()
		 * @generated
		 */
		EClass ROSETTA_DISJOINT_EXPRESSION = eINSTANCE.getRosettaDisjointExpression();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.JoinOperationImpl <em>Join Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.JoinOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getJoinOperation()
		 * @generated
		 */
		EClass JOIN_OPERATION = eINSTANCE.getJoinOperation();

		/**
		 * The meta object literal for the '<em><b>Explicit Separator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JOIN_OPERATION__EXPLICIT_SEPARATOR = eINSTANCE.getJoinOperation_ExplicitSeparator();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaOnlyExistsExpressionImpl <em>Rosetta Only Exists Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaOnlyExistsExpressionImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaOnlyExistsExpression()
		 * @generated
		 */
		EClass ROSETTA_ONLY_EXISTS_EXPRESSION = eINSTANCE.getRosettaOnlyExistsExpression();

		/**
		 * The meta object literal for the '<em><b>Args</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_ONLY_EXISTS_EXPRESSION__ARGS = eINSTANCE.getRosettaOnlyExistsExpression_Args();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation <em>Rosetta Unary Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaUnaryOperation()
		 * @generated
		 */
		EClass ROSETTA_UNARY_OPERATION = eINSTANCE.getRosettaUnaryOperation();

		/**
		 * The meta object literal for the '<em><b>Argument</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_UNARY_OPERATION__ARGUMENT = eINSTANCE.getRosettaUnaryOperation_Argument();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.ListOperation <em>List Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.ListOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getListOperation()
		 * @generated
		 */
		EClass LIST_OPERATION = eINSTANCE.getListOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists <em>Can Handle List Of Lists</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getCanHandleListOfLists()
		 * @generated
		 */
		EClass CAN_HANDLE_LIST_OF_LISTS = eINSTANCE.getCanHandleListOfLists();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaExistsExpressionImpl <em>Rosetta Exists Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaExistsExpressionImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaExistsExpression()
		 * @generated
		 */
		EClass ROSETTA_EXISTS_EXPRESSION = eINSTANCE.getRosettaExistsExpression();

		/**
		 * The meta object literal for the '<em><b>Modifier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROSETTA_EXISTS_EXPRESSION__MODIFIER = eINSTANCE.getRosettaExistsExpression_Modifier();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaAbsentExpressionImpl <em>Rosetta Absent Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaAbsentExpressionImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaAbsentExpression()
		 * @generated
		 */
		EClass ROSETTA_ABSENT_EXPRESSION = eINSTANCE.getRosettaAbsentExpression();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaOnlyElementImpl <em>Rosetta Only Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaOnlyElementImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaOnlyElement()
		 * @generated
		 */
		EClass ROSETTA_ONLY_ELEMENT = eINSTANCE.getRosettaOnlyElement();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaCountOperationImpl <em>Rosetta Count Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.RosettaCountOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaCountOperation()
		 * @generated
		 */
		EClass ROSETTA_COUNT_OPERATION = eINSTANCE.getRosettaCountOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.FlattenOperationImpl <em>Flatten Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.FlattenOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getFlattenOperation()
		 * @generated
		 */
		EClass FLATTEN_OPERATION = eINSTANCE.getFlattenOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.DistinctOperationImpl <em>Distinct Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.DistinctOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getDistinctOperation()
		 * @generated
		 */
		EClass DISTINCT_OPERATION = eINSTANCE.getDistinctOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ReverseOperationImpl <em>Reverse Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ReverseOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getReverseOperation()
		 * @generated
		 */
		EClass REVERSE_OPERATION = eINSTANCE.getReverseOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.FirstOperationImpl <em>First Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.FirstOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getFirstOperation()
		 * @generated
		 */
		EClass FIRST_OPERATION = eINSTANCE.getFirstOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.LastOperationImpl <em>Last Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.LastOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getLastOperation()
		 * @generated
		 */
		EClass LAST_OPERATION = eINSTANCE.getLastOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.SumOperationImpl <em>Sum Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.SumOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getSumOperation()
		 * @generated
		 */
		EClass SUM_OPERATION = eINSTANCE.getSumOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.AsKeyOperationImpl <em>As Key Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.AsKeyOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getAsKeyOperation()
		 * @generated
		 */
		EClass AS_KEY_OPERATION = eINSTANCE.getAsKeyOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.OneOfOperationImpl <em>One Of Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.OneOfOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getOneOfOperation()
		 * @generated
		 */
		EClass ONE_OF_OPERATION = eINSTANCE.getOneOfOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl <em>Choice Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ChoiceOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getChoiceOperation()
		 * @generated
		 */
		EClass CHOICE_OPERATION = eINSTANCE.getChoiceOperation();

		/**
		 * The meta object literal for the '<em><b>Necessity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHOICE_OPERATION__NECESSITY = eINSTANCE.getChoiceOperation_Necessity();

		/**
		 * The meta object literal for the '<em><b>Attributes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHOICE_OPERATION__ATTRIBUTES = eINSTANCE.getChoiceOperation_Attributes();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToStringOperationImpl <em>To String Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ToStringOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToStringOperation()
		 * @generated
		 */
		EClass TO_STRING_OPERATION = eINSTANCE.getToStringOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.ParseOperation <em>Parse Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.ParseOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getParseOperation()
		 * @generated
		 */
		EClass PARSE_OPERATION = eINSTANCE.getParseOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToNumberOperationImpl <em>To Number Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ToNumberOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToNumberOperation()
		 * @generated
		 */
		EClass TO_NUMBER_OPERATION = eINSTANCE.getToNumberOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToIntOperationImpl <em>To Int Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ToIntOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToIntOperation()
		 * @generated
		 */
		EClass TO_INT_OPERATION = eINSTANCE.getToIntOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToTimeOperationImpl <em>To Time Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ToTimeOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToTimeOperation()
		 * @generated
		 */
		EClass TO_TIME_OPERATION = eINSTANCE.getToTimeOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToEnumOperationImpl <em>To Enum Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ToEnumOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToEnumOperation()
		 * @generated
		 */
		EClass TO_ENUM_OPERATION = eINSTANCE.getToEnumOperation();

		/**
		 * The meta object literal for the '<em><b>Enumeration</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TO_ENUM_OPERATION__ENUMERATION = eINSTANCE.getToEnumOperation_Enumeration();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToDateOperationImpl <em>To Date Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ToDateOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToDateOperation()
		 * @generated
		 */
		EClass TO_DATE_OPERATION = eINSTANCE.getToDateOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToDateTimeOperationImpl <em>To Date Time Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ToDateTimeOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToDateTimeOperation()
		 * @generated
		 */
		EClass TO_DATE_TIME_OPERATION = eINSTANCE.getToDateTimeOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ToZonedDateTimeOperationImpl <em>To Zoned Date Time Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ToZonedDateTimeOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getToZonedDateTimeOperation()
		 * @generated
		 */
		EClass TO_ZONED_DATE_TIME_OPERATION = eINSTANCE.getToZonedDateTimeOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ClosureParameterImpl <em>Closure Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ClosureParameterImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getClosureParameter()
		 * @generated
		 */
		EClass CLOSURE_PARAMETER = eINSTANCE.getClosureParameter();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLOSURE_PARAMETER__FUNCTION = eINSTANCE.getClosureParameter_Function();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.InlineFunctionImpl <em>Inline Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.InlineFunctionImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getInlineFunction()
		 * @generated
		 */
		EClass INLINE_FUNCTION = eINSTANCE.getInlineFunction();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INLINE_FUNCTION__PARAMETERS = eINSTANCE.getInlineFunction_Parameters();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INLINE_FUNCTION__BODY = eINSTANCE.getInlineFunction_Body();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation <em>Rosetta Functional Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getRosettaFunctionalOperation()
		 * @generated
		 */
		EClass ROSETTA_FUNCTIONAL_OPERATION = eINSTANCE.getRosettaFunctionalOperation();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ROSETTA_FUNCTIONAL_OPERATION__FUNCTION = eINSTANCE.getRosettaFunctionalOperation_Function();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation <em>Mandatory Functional Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getMandatoryFunctionalOperation()
		 * @generated
		 */
		EClass MANDATORY_FUNCTIONAL_OPERATION = eINSTANCE.getMandatoryFunctionalOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation <em>Unary Functional Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getUnaryFunctionalOperation()
		 * @generated
		 */
		EClass UNARY_FUNCTIONAL_OPERATION = eINSTANCE.getUnaryFunctionalOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ReduceOperationImpl <em>Reduce Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ReduceOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getReduceOperation()
		 * @generated
		 */
		EClass REDUCE_OPERATION = eINSTANCE.getReduceOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.FilterOperationImpl <em>Filter Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.FilterOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getFilterOperation()
		 * @generated
		 */
		EClass FILTER_OPERATION = eINSTANCE.getFilterOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.MapOperationImpl <em>Map Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.MapOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getMapOperation()
		 * @generated
		 */
		EClass MAP_OPERATION = eINSTANCE.getMapOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.ThenOperationImpl <em>Then Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ThenOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getThenOperation()
		 * @generated
		 */
		EClass THEN_OPERATION = eINSTANCE.getThenOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation <em>Comparing Functional Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getComparingFunctionalOperation()
		 * @generated
		 */
		EClass COMPARING_FUNCTIONAL_OPERATION = eINSTANCE.getComparingFunctionalOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.SortOperationImpl <em>Sort Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.SortOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getSortOperation()
		 * @generated
		 */
		EClass SORT_OPERATION = eINSTANCE.getSortOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.MinOperationImpl <em>Min Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.MinOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getMinOperation()
		 * @generated
		 */
		EClass MIN_OPERATION = eINSTANCE.getMinOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.impl.MaxOperationImpl <em>Max Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.impl.MaxOperationImpl
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getMaxOperation()
		 * @generated
		 */
		EClass MAX_OPERATION = eINSTANCE.getMaxOperation();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.CardinalityModifier <em>Cardinality Modifier</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.CardinalityModifier
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getCardinalityModifier()
		 * @generated
		 */
		EEnum CARDINALITY_MODIFIER = eINSTANCE.getCardinalityModifier();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.ExistsModifier <em>Exists Modifier</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.ExistsModifier
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getExistsModifier()
		 * @generated
		 */
		EEnum EXISTS_MODIFIER = eINSTANCE.getExistsModifier();

		/**
		 * The meta object literal for the '{@link com.regnosys.rosetta.rosetta.expression.Necessity <em>Necessity</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.regnosys.rosetta.rosetta.expression.Necessity
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getNecessity()
		 * @generated
		 */
		EEnum NECESSITY = eINSTANCE.getNecessity();

		/**
		 * The meta object literal for the '<em>Pattern</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see java.util.regex.Pattern
		 * @see com.regnosys.rosetta.rosetta.expression.impl.ExpressionPackageImpl#getPattern()
		 * @generated
		 */
		EDataType PATTERN = eINSTANCE.getPattern();

	}

} //ExpressionPackage
