/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.expression.impl;

import com.regnosys.rosetta.rosetta.expression.*;

import java.util.regex.Pattern;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ExpressionFactoryImpl extends EFactoryImpl implements ExpressionFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ExpressionFactory init() {
		try {
			ExpressionFactory theExpressionFactory = (ExpressionFactory)EPackage.Registry.INSTANCE.getEFactory(ExpressionPackage.eNS_URI);
			if (theExpressionFactory != null) {
				return theExpressionFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new ExpressionFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case ExpressionPackage.ROSETTA_BOOLEAN_LITERAL: return createRosettaBooleanLiteral();
			case ExpressionPackage.ROSETTA_STRING_LITERAL: return createRosettaStringLiteral();
			case ExpressionPackage.ROSETTA_NUMBER_LITERAL: return createRosettaNumberLiteral();
			case ExpressionPackage.ROSETTA_INT_LITERAL: return createRosettaIntLiteral();
			case ExpressionPackage.ROSETTA_PATTERN_LITERAL: return createRosettaPatternLiteral();
			case ExpressionPackage.LIST_LITERAL: return createListLiteral();
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE: return createRosettaSymbolReference();
			case ExpressionPackage.ROSETTA_IMPLICIT_VARIABLE: return createRosettaImplicitVariable();
			case ExpressionPackage.ROSETTA_FEATURE_CALL: return createRosettaFeatureCall();
			case ExpressionPackage.ROSETTA_DEEP_FEATURE_CALL: return createRosettaDeepFeatureCall();
			case ExpressionPackage.ROSETTA_CONDITIONAL_EXPRESSION: return createRosettaConditionalExpression();
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION: return createRosettaConstructorExpression();
			case ExpressionPackage.CONSTRUCTOR_KEY_VALUE_PAIR: return createConstructorKeyValuePair();
			case ExpressionPackage.ARITHMETIC_OPERATION: return createArithmeticOperation();
			case ExpressionPackage.DEFAULT_OPERATION: return createDefaultOperation();
			case ExpressionPackage.LOGICAL_OPERATION: return createLogicalOperation();
			case ExpressionPackage.EQUALITY_OPERATION: return createEqualityOperation();
			case ExpressionPackage.COMPARISON_OPERATION: return createComparisonOperation();
			case ExpressionPackage.ROSETTA_CONTAINS_EXPRESSION: return createRosettaContainsExpression();
			case ExpressionPackage.ROSETTA_DISJOINT_EXPRESSION: return createRosettaDisjointExpression();
			case ExpressionPackage.JOIN_OPERATION: return createJoinOperation();
			case ExpressionPackage.ROSETTA_ONLY_EXISTS_EXPRESSION: return createRosettaOnlyExistsExpression();
			case ExpressionPackage.ROSETTA_EXISTS_EXPRESSION: return createRosettaExistsExpression();
			case ExpressionPackage.ROSETTA_ABSENT_EXPRESSION: return createRosettaAbsentExpression();
			case ExpressionPackage.ROSETTA_ONLY_ELEMENT: return createRosettaOnlyElement();
			case ExpressionPackage.ROSETTA_COUNT_OPERATION: return createRosettaCountOperation();
			case ExpressionPackage.FLATTEN_OPERATION: return createFlattenOperation();
			case ExpressionPackage.DISTINCT_OPERATION: return createDistinctOperation();
			case ExpressionPackage.REVERSE_OPERATION: return createReverseOperation();
			case ExpressionPackage.FIRST_OPERATION: return createFirstOperation();
			case ExpressionPackage.LAST_OPERATION: return createLastOperation();
			case ExpressionPackage.SUM_OPERATION: return createSumOperation();
			case ExpressionPackage.AS_KEY_OPERATION: return createAsKeyOperation();
			case ExpressionPackage.ONE_OF_OPERATION: return createOneOfOperation();
			case ExpressionPackage.CHOICE_OPERATION: return createChoiceOperation();
			case ExpressionPackage.TO_STRING_OPERATION: return createToStringOperation();
			case ExpressionPackage.TO_NUMBER_OPERATION: return createToNumberOperation();
			case ExpressionPackage.TO_INT_OPERATION: return createToIntOperation();
			case ExpressionPackage.TO_TIME_OPERATION: return createToTimeOperation();
			case ExpressionPackage.TO_ENUM_OPERATION: return createToEnumOperation();
			case ExpressionPackage.TO_DATE_OPERATION: return createToDateOperation();
			case ExpressionPackage.TO_DATE_TIME_OPERATION: return createToDateTimeOperation();
			case ExpressionPackage.TO_ZONED_DATE_TIME_OPERATION: return createToZonedDateTimeOperation();
			case ExpressionPackage.CLOSURE_PARAMETER: return createClosureParameter();
			case ExpressionPackage.INLINE_FUNCTION: return createInlineFunction();
			case ExpressionPackage.REDUCE_OPERATION: return createReduceOperation();
			case ExpressionPackage.FILTER_OPERATION: return createFilterOperation();
			case ExpressionPackage.MAP_OPERATION: return createMapOperation();
			case ExpressionPackage.THEN_OPERATION: return createThenOperation();
			case ExpressionPackage.SORT_OPERATION: return createSortOperation();
			case ExpressionPackage.MIN_OPERATION: return createMinOperation();
			case ExpressionPackage.MAX_OPERATION: return createMaxOperation();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case ExpressionPackage.CARDINALITY_MODIFIER:
				return createCardinalityModifierFromString(eDataType, initialValue);
			case ExpressionPackage.EXISTS_MODIFIER:
				return createExistsModifierFromString(eDataType, initialValue);
			case ExpressionPackage.NECESSITY:
				return createNecessityFromString(eDataType, initialValue);
			case ExpressionPackage.PATTERN:
				return createPatternFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case ExpressionPackage.CARDINALITY_MODIFIER:
				return convertCardinalityModifierToString(eDataType, instanceValue);
			case ExpressionPackage.EXISTS_MODIFIER:
				return convertExistsModifierToString(eDataType, instanceValue);
			case ExpressionPackage.NECESSITY:
				return convertNecessityToString(eDataType, instanceValue);
			case ExpressionPackage.PATTERN:
				return convertPatternToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaBooleanLiteral createRosettaBooleanLiteral() {
		RosettaBooleanLiteralImpl rosettaBooleanLiteral = new RosettaBooleanLiteralImpl();
		return rosettaBooleanLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaStringLiteral createRosettaStringLiteral() {
		RosettaStringLiteralImpl rosettaStringLiteral = new RosettaStringLiteralImpl();
		return rosettaStringLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaNumberLiteral createRosettaNumberLiteral() {
		RosettaNumberLiteralImpl rosettaNumberLiteral = new RosettaNumberLiteralImpl();
		return rosettaNumberLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaIntLiteral createRosettaIntLiteral() {
		RosettaIntLiteralImpl rosettaIntLiteral = new RosettaIntLiteralImpl();
		return rosettaIntLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaPatternLiteral createRosettaPatternLiteral() {
		RosettaPatternLiteralImpl rosettaPatternLiteral = new RosettaPatternLiteralImpl();
		return rosettaPatternLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ListLiteral createListLiteral() {
		ListLiteralImpl listLiteral = new ListLiteralImpl();
		return listLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaSymbolReference createRosettaSymbolReference() {
		RosettaSymbolReferenceImpl rosettaSymbolReference = new RosettaSymbolReferenceImpl();
		return rosettaSymbolReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaImplicitVariable createRosettaImplicitVariable() {
		RosettaImplicitVariableImpl rosettaImplicitVariable = new RosettaImplicitVariableImpl();
		return rosettaImplicitVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaFeatureCall createRosettaFeatureCall() {
		RosettaFeatureCallImpl rosettaFeatureCall = new RosettaFeatureCallImpl();
		return rosettaFeatureCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaDeepFeatureCall createRosettaDeepFeatureCall() {
		RosettaDeepFeatureCallImpl rosettaDeepFeatureCall = new RosettaDeepFeatureCallImpl();
		return rosettaDeepFeatureCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaConditionalExpression createRosettaConditionalExpression() {
		RosettaConditionalExpressionImpl rosettaConditionalExpression = new RosettaConditionalExpressionImpl();
		return rosettaConditionalExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaConstructorExpression createRosettaConstructorExpression() {
		RosettaConstructorExpressionImpl rosettaConstructorExpression = new RosettaConstructorExpressionImpl();
		return rosettaConstructorExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ConstructorKeyValuePair createConstructorKeyValuePair() {
		ConstructorKeyValuePairImpl constructorKeyValuePair = new ConstructorKeyValuePairImpl();
		return constructorKeyValuePair;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ArithmeticOperation createArithmeticOperation() {
		ArithmeticOperationImpl arithmeticOperation = new ArithmeticOperationImpl();
		return arithmeticOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DefaultOperation createDefaultOperation() {
		DefaultOperationImpl defaultOperation = new DefaultOperationImpl();
		return defaultOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LogicalOperation createLogicalOperation() {
		LogicalOperationImpl logicalOperation = new LogicalOperationImpl();
		return logicalOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EqualityOperation createEqualityOperation() {
		EqualityOperationImpl equalityOperation = new EqualityOperationImpl();
		return equalityOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComparisonOperation createComparisonOperation() {
		ComparisonOperationImpl comparisonOperation = new ComparisonOperationImpl();
		return comparisonOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaContainsExpression createRosettaContainsExpression() {
		RosettaContainsExpressionImpl rosettaContainsExpression = new RosettaContainsExpressionImpl();
		return rosettaContainsExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaDisjointExpression createRosettaDisjointExpression() {
		RosettaDisjointExpressionImpl rosettaDisjointExpression = new RosettaDisjointExpressionImpl();
		return rosettaDisjointExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JoinOperation createJoinOperation() {
		JoinOperationImpl joinOperation = new JoinOperationImpl();
		return joinOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaOnlyExistsExpression createRosettaOnlyExistsExpression() {
		RosettaOnlyExistsExpressionImpl rosettaOnlyExistsExpression = new RosettaOnlyExistsExpressionImpl();
		return rosettaOnlyExistsExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExistsExpression createRosettaExistsExpression() {
		RosettaExistsExpressionImpl rosettaExistsExpression = new RosettaExistsExpressionImpl();
		return rosettaExistsExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaAbsentExpression createRosettaAbsentExpression() {
		RosettaAbsentExpressionImpl rosettaAbsentExpression = new RosettaAbsentExpressionImpl();
		return rosettaAbsentExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaOnlyElement createRosettaOnlyElement() {
		RosettaOnlyElementImpl rosettaOnlyElement = new RosettaOnlyElementImpl();
		return rosettaOnlyElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaCountOperation createRosettaCountOperation() {
		RosettaCountOperationImpl rosettaCountOperation = new RosettaCountOperationImpl();
		return rosettaCountOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FlattenOperation createFlattenOperation() {
		FlattenOperationImpl flattenOperation = new FlattenOperationImpl();
		return flattenOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DistinctOperation createDistinctOperation() {
		DistinctOperationImpl distinctOperation = new DistinctOperationImpl();
		return distinctOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ReverseOperation createReverseOperation() {
		ReverseOperationImpl reverseOperation = new ReverseOperationImpl();
		return reverseOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FirstOperation createFirstOperation() {
		FirstOperationImpl firstOperation = new FirstOperationImpl();
		return firstOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LastOperation createLastOperation() {
		LastOperationImpl lastOperation = new LastOperationImpl();
		return lastOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SumOperation createSumOperation() {
		SumOperationImpl sumOperation = new SumOperationImpl();
		return sumOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AsKeyOperation createAsKeyOperation() {
		AsKeyOperationImpl asKeyOperation = new AsKeyOperationImpl();
		return asKeyOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OneOfOperation createOneOfOperation() {
		OneOfOperationImpl oneOfOperation = new OneOfOperationImpl();
		return oneOfOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ChoiceOperation createChoiceOperation() {
		ChoiceOperationImpl choiceOperation = new ChoiceOperationImpl();
		return choiceOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToStringOperation createToStringOperation() {
		ToStringOperationImpl toStringOperation = new ToStringOperationImpl();
		return toStringOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToNumberOperation createToNumberOperation() {
		ToNumberOperationImpl toNumberOperation = new ToNumberOperationImpl();
		return toNumberOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToIntOperation createToIntOperation() {
		ToIntOperationImpl toIntOperation = new ToIntOperationImpl();
		return toIntOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToTimeOperation createToTimeOperation() {
		ToTimeOperationImpl toTimeOperation = new ToTimeOperationImpl();
		return toTimeOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToEnumOperation createToEnumOperation() {
		ToEnumOperationImpl toEnumOperation = new ToEnumOperationImpl();
		return toEnumOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToDateOperation createToDateOperation() {
		ToDateOperationImpl toDateOperation = new ToDateOperationImpl();
		return toDateOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToDateTimeOperation createToDateTimeOperation() {
		ToDateTimeOperationImpl toDateTimeOperation = new ToDateTimeOperationImpl();
		return toDateTimeOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToZonedDateTimeOperation createToZonedDateTimeOperation() {
		ToZonedDateTimeOperationImpl toZonedDateTimeOperation = new ToZonedDateTimeOperationImpl();
		return toZonedDateTimeOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClosureParameter createClosureParameter() {
		ClosureParameterImpl closureParameter = new ClosureParameterImpl();
		return closureParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public InlineFunction createInlineFunction() {
		InlineFunctionImpl inlineFunction = new InlineFunctionImpl();
		return inlineFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ReduceOperation createReduceOperation() {
		ReduceOperationImpl reduceOperation = new ReduceOperationImpl();
		return reduceOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FilterOperation createFilterOperation() {
		FilterOperationImpl filterOperation = new FilterOperationImpl();
		return filterOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MapOperation createMapOperation() {
		MapOperationImpl mapOperation = new MapOperationImpl();
		return mapOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ThenOperation createThenOperation() {
		ThenOperationImpl thenOperation = new ThenOperationImpl();
		return thenOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SortOperation createSortOperation() {
		SortOperationImpl sortOperation = new SortOperationImpl();
		return sortOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MinOperation createMinOperation() {
		MinOperationImpl minOperation = new MinOperationImpl();
		return minOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MaxOperation createMaxOperation() {
		MaxOperationImpl maxOperation = new MaxOperationImpl();
		return maxOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CardinalityModifier createCardinalityModifierFromString(EDataType eDataType, String initialValue) {
		CardinalityModifier result = CardinalityModifier.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCardinalityModifierToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExistsModifier createExistsModifierFromString(EDataType eDataType, String initialValue) {
		ExistsModifier result = ExistsModifier.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertExistsModifierToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Necessity createNecessityFromString(EDataType eDataType, String initialValue) {
		Necessity result = Necessity.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertNecessityToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Pattern createPatternFromString(EDataType eDataType, String initialValue) {
		return (Pattern)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertPatternToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExpressionPackage getExpressionPackage() {
		return (ExpressionPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static ExpressionPackage getPackage() {
		return ExpressionPackage.eINSTANCE;
	}

} //ExpressionFactoryImpl
