/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.expression.impl;

import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaSymbol;

import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rosetta Symbol Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaSymbolReferenceImpl#getSymbol <em>Symbol</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaSymbolReferenceImpl#isExplicitArguments <em>Explicit Arguments</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaSymbolReferenceImpl#getRawArgs <em>Raw Args</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaSymbolReferenceImpl#isImplicitVariableIsInContext <em>Implicit Variable Is In Context</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.expression.impl.RosettaSymbolReferenceImpl#getImplicitArgument <em>Implicit Argument</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaSymbolReferenceImpl extends RosettaReferenceImpl implements RosettaSymbolReference {
	/**
	 * The cached value of the '{@link #getSymbol() <em>Symbol</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSymbol()
	 * @generated
	 * @ordered
	 */
	protected RosettaSymbol symbol;

	/**
	 * The default value of the '{@link #isExplicitArguments() <em>Explicit Arguments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExplicitArguments()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EXPLICIT_ARGUMENTS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isExplicitArguments() <em>Explicit Arguments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExplicitArguments()
	 * @generated
	 * @ordered
	 */
	protected boolean explicitArguments = EXPLICIT_ARGUMENTS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRawArgs() <em>Raw Args</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRawArgs()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaExpression> rawArgs;

	/**
	 * The default value of the '{@link #isImplicitVariableIsInContext() <em>Implicit Variable Is In Context</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isImplicitVariableIsInContext()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IMPLICIT_VARIABLE_IS_IN_CONTEXT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isImplicitVariableIsInContext() <em>Implicit Variable Is In Context</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isImplicitVariableIsInContext()
	 * @generated
	 * @ordered
	 */
	protected boolean implicitVariableIsInContext = IMPLICIT_VARIABLE_IS_IN_CONTEXT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getImplicitArgument() <em>Implicit Argument</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImplicitArgument()
	 * @generated
	 * @ordered
	 */
	protected RosettaExpression implicitArgument;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaSymbolReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaSymbol getSymbol() {
		if (symbol != null && symbol.eIsProxy()) {
			InternalEObject oldSymbol = (InternalEObject)symbol;
			symbol = (RosettaSymbol)eResolveProxy(oldSymbol);
			if (symbol != oldSymbol) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__SYMBOL, oldSymbol, symbol));
			}
		}
		return symbol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaSymbol basicGetSymbol() {
		return symbol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSymbol(RosettaSymbol newSymbol) {
		RosettaSymbol oldSymbol = symbol;
		symbol = newSymbol;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__SYMBOL, oldSymbol, symbol));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isExplicitArguments() {
		return explicitArguments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setExplicitArguments(boolean newExplicitArguments) {
		boolean oldExplicitArguments = explicitArguments;
		explicitArguments = newExplicitArguments;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS, oldExplicitArguments, explicitArguments));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaExpression> getRawArgs() {
		if (rawArgs == null) {
			rawArgs = new EObjectContainmentEList<RosettaExpression>(RosettaExpression.class, this, ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS);
		}
		return rawArgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isImplicitVariableIsInContext() {
		return implicitVariableIsInContext;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setImplicitVariableIsInContext(boolean newImplicitVariableIsInContext) {
		boolean oldImplicitVariableIsInContext = implicitVariableIsInContext;
		implicitVariableIsInContext = newImplicitVariableIsInContext;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_VARIABLE_IS_IN_CONTEXT, oldImplicitVariableIsInContext, implicitVariableIsInContext));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExpression getImplicitArgument() {
		return implicitArgument;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetImplicitArgument(RosettaExpression newImplicitArgument, NotificationChain msgs) {
		RosettaExpression oldImplicitArgument = implicitArgument;
		implicitArgument = newImplicitArgument;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT, oldImplicitArgument, newImplicitArgument);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setImplicitArgument(RosettaExpression newImplicitArgument) {
		if (newImplicitArgument != implicitArgument) {
			NotificationChain msgs = null;
			if (implicitArgument != null)
				msgs = ((InternalEObject)implicitArgument).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT, null, msgs);
			if (newImplicitArgument != null)
				msgs = ((InternalEObject)newImplicitArgument).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT, null, msgs);
			msgs = basicSetImplicitArgument(newImplicitArgument, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT, newImplicitArgument, newImplicitArgument));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaExpression> getArgs() {
		if (((((!this.isExplicitArguments()) && this.isImplicitVariableIsInContext()) && (this.getSymbol() instanceof RosettaCallableWithArgs)) && (((RosettaCallableWithArgs) this.getSymbol()).numberOfParameters() == 1))) {
			RosettaExpression _implicitArgument = this.getImplicitArgument();
			boolean _tripleEquals = (_implicitArgument == null);
			if (_tripleEquals) {
				final RosettaImplicitVariable def = ExpressionFactory.eINSTANCE.createRosettaImplicitVariable();
				def.setName("item");
				def.setGenerated(true);
				this.setImplicitArgument(def);
			}
			RosettaExpression _implicitArgument_1 = this.getImplicitArgument();
			return new BasicEList<RosettaExpression>(java.util.Collections.<RosettaExpression>unmodifiableList(org.eclipse.xtext.xbase.lib.CollectionLiterals.<RosettaExpression>newArrayList(_implicitArgument_1)));
		}
		return this.getRawArgs();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS:
				return ((InternalEList<?>)getRawArgs()).basicRemove(otherEnd, msgs);
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT:
				return basicSetImplicitArgument(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__SYMBOL:
				if (resolve) return getSymbol();
				return basicGetSymbol();
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS:
				return isExplicitArguments();
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS:
				return getRawArgs();
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_VARIABLE_IS_IN_CONTEXT:
				return isImplicitVariableIsInContext();
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT:
				return getImplicitArgument();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__SYMBOL:
				setSymbol((RosettaSymbol)newValue);
				return;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS:
				setExplicitArguments((Boolean)newValue);
				return;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS:
				getRawArgs().clear();
				getRawArgs().addAll((Collection<? extends RosettaExpression>)newValue);
				return;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_VARIABLE_IS_IN_CONTEXT:
				setImplicitVariableIsInContext((Boolean)newValue);
				return;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT:
				setImplicitArgument((RosettaExpression)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__SYMBOL:
				setSymbol((RosettaSymbol)null);
				return;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS:
				setExplicitArguments(EXPLICIT_ARGUMENTS_EDEFAULT);
				return;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS:
				getRawArgs().clear();
				return;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_VARIABLE_IS_IN_CONTEXT:
				setImplicitVariableIsInContext(IMPLICIT_VARIABLE_IS_IN_CONTEXT_EDEFAULT);
				return;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT:
				setImplicitArgument((RosettaExpression)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__SYMBOL:
				return symbol != null;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__EXPLICIT_ARGUMENTS:
				return explicitArguments != EXPLICIT_ARGUMENTS_EDEFAULT;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS:
				return rawArgs != null && !rawArgs.isEmpty();
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_VARIABLE_IS_IN_CONTEXT:
				return implicitVariableIsInContext != IMPLICIT_VARIABLE_IS_IN_CONTEXT_EDEFAULT;
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE__IMPLICIT_ARGUMENT:
				return implicitArgument != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (explicitArguments: ");
		result.append(explicitArguments);
		result.append(", implicitVariableIsInContext: ");
		result.append(implicitVariableIsInContext);
		result.append(')');
		return result.toString();
	}

} //RosettaSymbolReferenceImpl
