/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.expression.util;

import com.regnosys.rosetta.rosetta.RosettaMapTest;
import com.regnosys.rosetta.rosetta.RosettaMapTestExpression;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaTyped;

import com.regnosys.rosetta.rosetta.expression.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see com.regnosys.rosetta.rosetta.expression.ExpressionPackage
 * @generated
 */
public class ExpressionAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ExpressionPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = ExpressionPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionSwitch<Adapter> modelSwitch =
		new ExpressionSwitch<Adapter>() {
			@Override
			public Adapter caseRosettaExpression(RosettaExpression object) {
				return createRosettaExpressionAdapter();
			}
			@Override
			public Adapter caseHasGeneratedInput(HasGeneratedInput object) {
				return createHasGeneratedInputAdapter();
			}
			@Override
			public Adapter caseRosettaLiteral(RosettaLiteral object) {
				return createRosettaLiteralAdapter();
			}
			@Override
			public Adapter caseRosettaBooleanLiteral(RosettaBooleanLiteral object) {
				return createRosettaBooleanLiteralAdapter();
			}
			@Override
			public Adapter caseRosettaStringLiteral(RosettaStringLiteral object) {
				return createRosettaStringLiteralAdapter();
			}
			@Override
			public Adapter caseRosettaNumberLiteral(RosettaNumberLiteral object) {
				return createRosettaNumberLiteralAdapter();
			}
			@Override
			public Adapter caseRosettaIntLiteral(RosettaIntLiteral object) {
				return createRosettaIntLiteralAdapter();
			}
			@Override
			public Adapter caseRosettaPatternLiteral(RosettaPatternLiteral object) {
				return createRosettaPatternLiteralAdapter();
			}
			@Override
			public Adapter caseListLiteral(ListLiteral object) {
				return createListLiteralAdapter();
			}
			@Override
			public Adapter caseRosettaReference(RosettaReference object) {
				return createRosettaReferenceAdapter();
			}
			@Override
			public Adapter caseRosettaSymbolReference(RosettaSymbolReference object) {
				return createRosettaSymbolReferenceAdapter();
			}
			@Override
			public Adapter caseRosettaImplicitVariable(RosettaImplicitVariable object) {
				return createRosettaImplicitVariableAdapter();
			}
			@Override
			public Adapter caseRosettaFeatureCall(RosettaFeatureCall object) {
				return createRosettaFeatureCallAdapter();
			}
			@Override
			public Adapter caseRosettaDeepFeatureCall(RosettaDeepFeatureCall object) {
				return createRosettaDeepFeatureCallAdapter();
			}
			@Override
			public Adapter caseRosettaConditionalExpression(RosettaConditionalExpression object) {
				return createRosettaConditionalExpressionAdapter();
			}
			@Override
			public Adapter caseRosettaConstructorExpression(RosettaConstructorExpression object) {
				return createRosettaConstructorExpressionAdapter();
			}
			@Override
			public Adapter caseConstructorKeyValuePair(ConstructorKeyValuePair object) {
				return createConstructorKeyValuePairAdapter();
			}
			@Override
			public Adapter caseRosettaOperation(RosettaOperation object) {
				return createRosettaOperationAdapter();
			}
			@Override
			public Adapter caseRosettaBinaryOperation(RosettaBinaryOperation object) {
				return createRosettaBinaryOperationAdapter();
			}
			@Override
			public Adapter caseArithmeticOperation(ArithmeticOperation object) {
				return createArithmeticOperationAdapter();
			}
			@Override
			public Adapter caseDefaultOperation(DefaultOperation object) {
				return createDefaultOperationAdapter();
			}
			@Override
			public Adapter caseLogicalOperation(LogicalOperation object) {
				return createLogicalOperationAdapter();
			}
			@Override
			public Adapter caseModifiableBinaryOperation(ModifiableBinaryOperation object) {
				return createModifiableBinaryOperationAdapter();
			}
			@Override
			public Adapter caseEqualityOperation(EqualityOperation object) {
				return createEqualityOperationAdapter();
			}
			@Override
			public Adapter caseComparisonOperation(ComparisonOperation object) {
				return createComparisonOperationAdapter();
			}
			@Override
			public Adapter caseRosettaContainsExpression(RosettaContainsExpression object) {
				return createRosettaContainsExpressionAdapter();
			}
			@Override
			public Adapter caseRosettaDisjointExpression(RosettaDisjointExpression object) {
				return createRosettaDisjointExpressionAdapter();
			}
			@Override
			public Adapter caseJoinOperation(JoinOperation object) {
				return createJoinOperationAdapter();
			}
			@Override
			public Adapter caseRosettaOnlyExistsExpression(RosettaOnlyExistsExpression object) {
				return createRosettaOnlyExistsExpressionAdapter();
			}
			@Override
			public Adapter caseRosettaUnaryOperation(RosettaUnaryOperation object) {
				return createRosettaUnaryOperationAdapter();
			}
			@Override
			public Adapter caseListOperation(ListOperation object) {
				return createListOperationAdapter();
			}
			@Override
			public Adapter caseCanHandleListOfLists(CanHandleListOfLists object) {
				return createCanHandleListOfListsAdapter();
			}
			@Override
			public Adapter caseRosettaExistsExpression(RosettaExistsExpression object) {
				return createRosettaExistsExpressionAdapter();
			}
			@Override
			public Adapter caseRosettaAbsentExpression(RosettaAbsentExpression object) {
				return createRosettaAbsentExpressionAdapter();
			}
			@Override
			public Adapter caseRosettaOnlyElement(RosettaOnlyElement object) {
				return createRosettaOnlyElementAdapter();
			}
			@Override
			public Adapter caseRosettaCountOperation(RosettaCountOperation object) {
				return createRosettaCountOperationAdapter();
			}
			@Override
			public Adapter caseFlattenOperation(FlattenOperation object) {
				return createFlattenOperationAdapter();
			}
			@Override
			public Adapter caseDistinctOperation(DistinctOperation object) {
				return createDistinctOperationAdapter();
			}
			@Override
			public Adapter caseReverseOperation(ReverseOperation object) {
				return createReverseOperationAdapter();
			}
			@Override
			public Adapter caseFirstOperation(FirstOperation object) {
				return createFirstOperationAdapter();
			}
			@Override
			public Adapter caseLastOperation(LastOperation object) {
				return createLastOperationAdapter();
			}
			@Override
			public Adapter caseSumOperation(SumOperation object) {
				return createSumOperationAdapter();
			}
			@Override
			public Adapter caseAsKeyOperation(AsKeyOperation object) {
				return createAsKeyOperationAdapter();
			}
			@Override
			public Adapter caseOneOfOperation(OneOfOperation object) {
				return createOneOfOperationAdapter();
			}
			@Override
			public Adapter caseChoiceOperation(ChoiceOperation object) {
				return createChoiceOperationAdapter();
			}
			@Override
			public Adapter caseToStringOperation(ToStringOperation object) {
				return createToStringOperationAdapter();
			}
			@Override
			public Adapter caseParseOperation(ParseOperation object) {
				return createParseOperationAdapter();
			}
			@Override
			public Adapter caseToNumberOperation(ToNumberOperation object) {
				return createToNumberOperationAdapter();
			}
			@Override
			public Adapter caseToIntOperation(ToIntOperation object) {
				return createToIntOperationAdapter();
			}
			@Override
			public Adapter caseToTimeOperation(ToTimeOperation object) {
				return createToTimeOperationAdapter();
			}
			@Override
			public Adapter caseToEnumOperation(ToEnumOperation object) {
				return createToEnumOperationAdapter();
			}
			@Override
			public Adapter caseToDateOperation(ToDateOperation object) {
				return createToDateOperationAdapter();
			}
			@Override
			public Adapter caseToDateTimeOperation(ToDateTimeOperation object) {
				return createToDateTimeOperationAdapter();
			}
			@Override
			public Adapter caseToZonedDateTimeOperation(ToZonedDateTimeOperation object) {
				return createToZonedDateTimeOperationAdapter();
			}
			@Override
			public Adapter caseClosureParameter(ClosureParameter object) {
				return createClosureParameterAdapter();
			}
			@Override
			public Adapter caseInlineFunction(InlineFunction object) {
				return createInlineFunctionAdapter();
			}
			@Override
			public Adapter caseRosettaFunctionalOperation(RosettaFunctionalOperation object) {
				return createRosettaFunctionalOperationAdapter();
			}
			@Override
			public Adapter caseMandatoryFunctionalOperation(MandatoryFunctionalOperation object) {
				return createMandatoryFunctionalOperationAdapter();
			}
			@Override
			public Adapter caseUnaryFunctionalOperation(UnaryFunctionalOperation object) {
				return createUnaryFunctionalOperationAdapter();
			}
			@Override
			public Adapter caseReduceOperation(ReduceOperation object) {
				return createReduceOperationAdapter();
			}
			@Override
			public Adapter caseFilterOperation(FilterOperation object) {
				return createFilterOperationAdapter();
			}
			@Override
			public Adapter caseMapOperation(MapOperation object) {
				return createMapOperationAdapter();
			}
			@Override
			public Adapter caseThenOperation(ThenOperation object) {
				return createThenOperationAdapter();
			}
			@Override
			public Adapter caseComparingFunctionalOperation(ComparingFunctionalOperation object) {
				return createComparingFunctionalOperationAdapter();
			}
			@Override
			public Adapter caseSortOperation(SortOperation object) {
				return createSortOperationAdapter();
			}
			@Override
			public Adapter caseMinOperation(MinOperation object) {
				return createMinOperationAdapter();
			}
			@Override
			public Adapter caseMaxOperation(MaxOperation object) {
				return createMaxOperationAdapter();
			}
			@Override
			public Adapter caseRosettaMapTest(RosettaMapTest object) {
				return createRosettaMapTestAdapter();
			}
			@Override
			public Adapter caseRosettaMapTestExpression(RosettaMapTestExpression object) {
				return createRosettaMapTestExpressionAdapter();
			}
			@Override
			public Adapter caseRosettaNamed(RosettaNamed object) {
				return createRosettaNamedAdapter();
			}
			@Override
			public Adapter caseRosettaTyped(RosettaTyped object) {
				return createRosettaTypedAdapter();
			}
			@Override
			public Adapter caseRosettaSymbol(RosettaSymbol object) {
				return createRosettaSymbolAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaExpression <em>Rosetta Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaExpression
	 * @generated
	 */
	public Adapter createRosettaExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.HasGeneratedInput <em>Has Generated Input</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.HasGeneratedInput
	 * @generated
	 */
	public Adapter createHasGeneratedInputAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaLiteral <em>Rosetta Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaLiteral
	 * @generated
	 */
	public Adapter createRosettaLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral <em>Rosetta Boolean Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral
	 * @generated
	 */
	public Adapter createRosettaBooleanLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral <em>Rosetta String Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral
	 * @generated
	 */
	public Adapter createRosettaStringLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral <em>Rosetta Number Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral
	 * @generated
	 */
	public Adapter createRosettaNumberLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral <em>Rosetta Int Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral
	 * @generated
	 */
	public Adapter createRosettaIntLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaPatternLiteral <em>Rosetta Pattern Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaPatternLiteral
	 * @generated
	 */
	public Adapter createRosettaPatternLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ListLiteral <em>List Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ListLiteral
	 * @generated
	 */
	public Adapter createListLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaReference <em>Rosetta Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaReference
	 * @generated
	 */
	public Adapter createRosettaReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference <em>Rosetta Symbol Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference
	 * @generated
	 */
	public Adapter createRosettaSymbolReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable <em>Rosetta Implicit Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable
	 * @generated
	 */
	public Adapter createRosettaImplicitVariableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall <em>Rosetta Feature Call</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall
	 * @generated
	 */
	public Adapter createRosettaFeatureCallAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall <em>Rosetta Deep Feature Call</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall
	 * @generated
	 */
	public Adapter createRosettaDeepFeatureCallAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression <em>Rosetta Conditional Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression
	 * @generated
	 */
	public Adapter createRosettaConditionalExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression <em>Rosetta Constructor Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression
	 * @generated
	 */
	public Adapter createRosettaConstructorExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair <em>Constructor Key Value Pair</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair
	 * @generated
	 */
	public Adapter createConstructorKeyValuePairAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaOperation <em>Rosetta Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaOperation
	 * @generated
	 */
	public Adapter createRosettaOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation <em>Rosetta Binary Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation
	 * @generated
	 */
	public Adapter createRosettaBinaryOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ArithmeticOperation <em>Arithmetic Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ArithmeticOperation
	 * @generated
	 */
	public Adapter createArithmeticOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.DefaultOperation <em>Default Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.DefaultOperation
	 * @generated
	 */
	public Adapter createDefaultOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.LogicalOperation <em>Logical Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.LogicalOperation
	 * @generated
	 */
	public Adapter createLogicalOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation <em>Modifiable Binary Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation
	 * @generated
	 */
	public Adapter createModifiableBinaryOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.EqualityOperation <em>Equality Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.EqualityOperation
	 * @generated
	 */
	public Adapter createEqualityOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ComparisonOperation <em>Comparison Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ComparisonOperation
	 * @generated
	 */
	public Adapter createComparisonOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression <em>Rosetta Contains Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression
	 * @generated
	 */
	public Adapter createRosettaContainsExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression <em>Rosetta Disjoint Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression
	 * @generated
	 */
	public Adapter createRosettaDisjointExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.JoinOperation <em>Join Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.JoinOperation
	 * @generated
	 */
	public Adapter createJoinOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression <em>Rosetta Only Exists Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression
	 * @generated
	 */
	public Adapter createRosettaOnlyExistsExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation <em>Rosetta Unary Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation
	 * @generated
	 */
	public Adapter createRosettaUnaryOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ListOperation <em>List Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ListOperation
	 * @generated
	 */
	public Adapter createListOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists <em>Can Handle List Of Lists</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists
	 * @generated
	 */
	public Adapter createCanHandleListOfListsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression <em>Rosetta Exists Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression
	 * @generated
	 */
	public Adapter createRosettaExistsExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression <em>Rosetta Absent Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression
	 * @generated
	 */
	public Adapter createRosettaAbsentExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement <em>Rosetta Only Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement
	 * @generated
	 */
	public Adapter createRosettaOnlyElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaCountOperation <em>Rosetta Count Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaCountOperation
	 * @generated
	 */
	public Adapter createRosettaCountOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.FlattenOperation <em>Flatten Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.FlattenOperation
	 * @generated
	 */
	public Adapter createFlattenOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.DistinctOperation <em>Distinct Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.DistinctOperation
	 * @generated
	 */
	public Adapter createDistinctOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ReverseOperation <em>Reverse Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ReverseOperation
	 * @generated
	 */
	public Adapter createReverseOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.FirstOperation <em>First Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.FirstOperation
	 * @generated
	 */
	public Adapter createFirstOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.LastOperation <em>Last Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.LastOperation
	 * @generated
	 */
	public Adapter createLastOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.SumOperation <em>Sum Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.SumOperation
	 * @generated
	 */
	public Adapter createSumOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.AsKeyOperation <em>As Key Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.AsKeyOperation
	 * @generated
	 */
	public Adapter createAsKeyOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.OneOfOperation <em>One Of Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.OneOfOperation
	 * @generated
	 */
	public Adapter createOneOfOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ChoiceOperation <em>Choice Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ChoiceOperation
	 * @generated
	 */
	public Adapter createChoiceOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ToStringOperation <em>To String Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ToStringOperation
	 * @generated
	 */
	public Adapter createToStringOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ParseOperation <em>Parse Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ParseOperation
	 * @generated
	 */
	public Adapter createParseOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ToNumberOperation <em>To Number Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ToNumberOperation
	 * @generated
	 */
	public Adapter createToNumberOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ToIntOperation <em>To Int Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ToIntOperation
	 * @generated
	 */
	public Adapter createToIntOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ToTimeOperation <em>To Time Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ToTimeOperation
	 * @generated
	 */
	public Adapter createToTimeOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ToEnumOperation <em>To Enum Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ToEnumOperation
	 * @generated
	 */
	public Adapter createToEnumOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ToDateOperation <em>To Date Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ToDateOperation
	 * @generated
	 */
	public Adapter createToDateOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation <em>To Date Time Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation
	 * @generated
	 */
	public Adapter createToDateTimeOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation <em>To Zoned Date Time Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation
	 * @generated
	 */
	public Adapter createToZonedDateTimeOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ClosureParameter <em>Closure Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ClosureParameter
	 * @generated
	 */
	public Adapter createClosureParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.InlineFunction <em>Inline Function</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.InlineFunction
	 * @generated
	 */
	public Adapter createInlineFunctionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation <em>Rosetta Functional Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation
	 * @generated
	 */
	public Adapter createRosettaFunctionalOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation <em>Mandatory Functional Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.MandatoryFunctionalOperation
	 * @generated
	 */
	public Adapter createMandatoryFunctionalOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation <em>Unary Functional Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.UnaryFunctionalOperation
	 * @generated
	 */
	public Adapter createUnaryFunctionalOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ReduceOperation <em>Reduce Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ReduceOperation
	 * @generated
	 */
	public Adapter createReduceOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.FilterOperation <em>Filter Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.FilterOperation
	 * @generated
	 */
	public Adapter createFilterOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.MapOperation <em>Map Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.MapOperation
	 * @generated
	 */
	public Adapter createMapOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ThenOperation <em>Then Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ThenOperation
	 * @generated
	 */
	public Adapter createThenOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation <em>Comparing Functional Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation
	 * @generated
	 */
	public Adapter createComparingFunctionalOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.SortOperation <em>Sort Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.SortOperation
	 * @generated
	 */
	public Adapter createSortOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.MinOperation <em>Min Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.MinOperation
	 * @generated
	 */
	public Adapter createMinOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.expression.MaxOperation <em>Max Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.expression.MaxOperation
	 * @generated
	 */
	public Adapter createMaxOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapTest <em>Map Test</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTest
	 * @generated
	 */
	public Adapter createRosettaMapTestAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaMapTestExpression <em>Map Test Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaMapTestExpression
	 * @generated
	 */
	public Adapter createRosettaMapTestExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaNamed <em>Named</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaNamed
	 * @generated
	 */
	public Adapter createRosettaNamedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaTyped <em>Typed</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaTyped
	 * @generated
	 */
	public Adapter createRosettaTypedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.regnosys.rosetta.rosetta.RosettaSymbol <em>Symbol</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.regnosys.rosetta.rosetta.RosettaSymbol
	 * @generated
	 */
	public Adapter createRosettaSymbolAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //ExpressionAdapterFactory
