/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.expression.util;

import com.regnosys.rosetta.rosetta.RosettaMapTest;
import com.regnosys.rosetta.rosetta.RosettaMapTestExpression;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaTyped;

import com.regnosys.rosetta.rosetta.expression.*;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see com.regnosys.rosetta.rosetta.expression.ExpressionPackage
 * @generated
 */
public class ExpressionSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ExpressionPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionSwitch() {
		if (modelPackage == null) {
			modelPackage = ExpressionPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case ExpressionPackage.ROSETTA_EXPRESSION: {
				RosettaExpression rosettaExpression = (RosettaExpression)theEObject;
				T result = caseRosettaExpression(rosettaExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.HAS_GENERATED_INPUT: {
				HasGeneratedInput hasGeneratedInput = (HasGeneratedInput)theEObject;
				T result = caseHasGeneratedInput(hasGeneratedInput);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_LITERAL: {
				RosettaLiteral rosettaLiteral = (RosettaLiteral)theEObject;
				T result = caseRosettaLiteral(rosettaLiteral);
				if (result == null) result = caseRosettaExpression(rosettaLiteral);
				if (result == null) result = caseRosettaMapTestExpression(rosettaLiteral);
				if (result == null) result = caseRosettaMapTest(rosettaLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_BOOLEAN_LITERAL: {
				RosettaBooleanLiteral rosettaBooleanLiteral = (RosettaBooleanLiteral)theEObject;
				T result = caseRosettaBooleanLiteral(rosettaBooleanLiteral);
				if (result == null) result = caseRosettaLiteral(rosettaBooleanLiteral);
				if (result == null) result = caseRosettaExpression(rosettaBooleanLiteral);
				if (result == null) result = caseRosettaMapTestExpression(rosettaBooleanLiteral);
				if (result == null) result = caseRosettaMapTest(rosettaBooleanLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_STRING_LITERAL: {
				RosettaStringLiteral rosettaStringLiteral = (RosettaStringLiteral)theEObject;
				T result = caseRosettaStringLiteral(rosettaStringLiteral);
				if (result == null) result = caseRosettaLiteral(rosettaStringLiteral);
				if (result == null) result = caseRosettaExpression(rosettaStringLiteral);
				if (result == null) result = caseRosettaMapTestExpression(rosettaStringLiteral);
				if (result == null) result = caseRosettaMapTest(rosettaStringLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_NUMBER_LITERAL: {
				RosettaNumberLiteral rosettaNumberLiteral = (RosettaNumberLiteral)theEObject;
				T result = caseRosettaNumberLiteral(rosettaNumberLiteral);
				if (result == null) result = caseRosettaLiteral(rosettaNumberLiteral);
				if (result == null) result = caseRosettaExpression(rosettaNumberLiteral);
				if (result == null) result = caseRosettaMapTestExpression(rosettaNumberLiteral);
				if (result == null) result = caseRosettaMapTest(rosettaNumberLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_INT_LITERAL: {
				RosettaIntLiteral rosettaIntLiteral = (RosettaIntLiteral)theEObject;
				T result = caseRosettaIntLiteral(rosettaIntLiteral);
				if (result == null) result = caseRosettaLiteral(rosettaIntLiteral);
				if (result == null) result = caseRosettaExpression(rosettaIntLiteral);
				if (result == null) result = caseRosettaMapTestExpression(rosettaIntLiteral);
				if (result == null) result = caseRosettaMapTest(rosettaIntLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_PATTERN_LITERAL: {
				RosettaPatternLiteral rosettaPatternLiteral = (RosettaPatternLiteral)theEObject;
				T result = caseRosettaPatternLiteral(rosettaPatternLiteral);
				if (result == null) result = caseRosettaLiteral(rosettaPatternLiteral);
				if (result == null) result = caseRosettaExpression(rosettaPatternLiteral);
				if (result == null) result = caseRosettaMapTestExpression(rosettaPatternLiteral);
				if (result == null) result = caseRosettaMapTest(rosettaPatternLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.LIST_LITERAL: {
				ListLiteral listLiteral = (ListLiteral)theEObject;
				T result = caseListLiteral(listLiteral);
				if (result == null) result = caseRosettaExpression(listLiteral);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_REFERENCE: {
				RosettaReference rosettaReference = (RosettaReference)theEObject;
				T result = caseRosettaReference(rosettaReference);
				if (result == null) result = caseRosettaExpression(rosettaReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_SYMBOL_REFERENCE: {
				RosettaSymbolReference rosettaSymbolReference = (RosettaSymbolReference)theEObject;
				T result = caseRosettaSymbolReference(rosettaSymbolReference);
				if (result == null) result = caseRosettaReference(rosettaSymbolReference);
				if (result == null) result = caseRosettaExpression(rosettaSymbolReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_IMPLICIT_VARIABLE: {
				RosettaImplicitVariable rosettaImplicitVariable = (RosettaImplicitVariable)theEObject;
				T result = caseRosettaImplicitVariable(rosettaImplicitVariable);
				if (result == null) result = caseRosettaReference(rosettaImplicitVariable);
				if (result == null) result = caseRosettaNamed(rosettaImplicitVariable);
				if (result == null) result = caseRosettaExpression(rosettaImplicitVariable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_FEATURE_CALL: {
				RosettaFeatureCall rosettaFeatureCall = (RosettaFeatureCall)theEObject;
				T result = caseRosettaFeatureCall(rosettaFeatureCall);
				if (result == null) result = caseRosettaExpression(rosettaFeatureCall);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_DEEP_FEATURE_CALL: {
				RosettaDeepFeatureCall rosettaDeepFeatureCall = (RosettaDeepFeatureCall)theEObject;
				T result = caseRosettaDeepFeatureCall(rosettaDeepFeatureCall);
				if (result == null) result = caseRosettaExpression(rosettaDeepFeatureCall);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_CONDITIONAL_EXPRESSION: {
				RosettaConditionalExpression rosettaConditionalExpression = (RosettaConditionalExpression)theEObject;
				T result = caseRosettaConditionalExpression(rosettaConditionalExpression);
				if (result == null) result = caseRosettaExpression(rosettaConditionalExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_CONSTRUCTOR_EXPRESSION: {
				RosettaConstructorExpression rosettaConstructorExpression = (RosettaConstructorExpression)theEObject;
				T result = caseRosettaConstructorExpression(rosettaConstructorExpression);
				if (result == null) result = caseRosettaExpression(rosettaConstructorExpression);
				if (result == null) result = caseRosettaTyped(rosettaConstructorExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.CONSTRUCTOR_KEY_VALUE_PAIR: {
				ConstructorKeyValuePair constructorKeyValuePair = (ConstructorKeyValuePair)theEObject;
				T result = caseConstructorKeyValuePair(constructorKeyValuePair);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_OPERATION: {
				RosettaOperation rosettaOperation = (RosettaOperation)theEObject;
				T result = caseRosettaOperation(rosettaOperation);
				if (result == null) result = caseRosettaExpression(rosettaOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_BINARY_OPERATION: {
				RosettaBinaryOperation rosettaBinaryOperation = (RosettaBinaryOperation)theEObject;
				T result = caseRosettaBinaryOperation(rosettaBinaryOperation);
				if (result == null) result = caseRosettaOperation(rosettaBinaryOperation);
				if (result == null) result = caseHasGeneratedInput(rosettaBinaryOperation);
				if (result == null) result = caseRosettaExpression(rosettaBinaryOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ARITHMETIC_OPERATION: {
				ArithmeticOperation arithmeticOperation = (ArithmeticOperation)theEObject;
				T result = caseArithmeticOperation(arithmeticOperation);
				if (result == null) result = caseRosettaBinaryOperation(arithmeticOperation);
				if (result == null) result = caseRosettaOperation(arithmeticOperation);
				if (result == null) result = caseHasGeneratedInput(arithmeticOperation);
				if (result == null) result = caseRosettaExpression(arithmeticOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.DEFAULT_OPERATION: {
				DefaultOperation defaultOperation = (DefaultOperation)theEObject;
				T result = caseDefaultOperation(defaultOperation);
				if (result == null) result = caseRosettaBinaryOperation(defaultOperation);
				if (result == null) result = caseRosettaOperation(defaultOperation);
				if (result == null) result = caseHasGeneratedInput(defaultOperation);
				if (result == null) result = caseRosettaExpression(defaultOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.LOGICAL_OPERATION: {
				LogicalOperation logicalOperation = (LogicalOperation)theEObject;
				T result = caseLogicalOperation(logicalOperation);
				if (result == null) result = caseRosettaBinaryOperation(logicalOperation);
				if (result == null) result = caseRosettaOperation(logicalOperation);
				if (result == null) result = caseHasGeneratedInput(logicalOperation);
				if (result == null) result = caseRosettaExpression(logicalOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.MODIFIABLE_BINARY_OPERATION: {
				ModifiableBinaryOperation modifiableBinaryOperation = (ModifiableBinaryOperation)theEObject;
				T result = caseModifiableBinaryOperation(modifiableBinaryOperation);
				if (result == null) result = caseRosettaBinaryOperation(modifiableBinaryOperation);
				if (result == null) result = caseRosettaOperation(modifiableBinaryOperation);
				if (result == null) result = caseHasGeneratedInput(modifiableBinaryOperation);
				if (result == null) result = caseRosettaExpression(modifiableBinaryOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.EQUALITY_OPERATION: {
				EqualityOperation equalityOperation = (EqualityOperation)theEObject;
				T result = caseEqualityOperation(equalityOperation);
				if (result == null) result = caseModifiableBinaryOperation(equalityOperation);
				if (result == null) result = caseRosettaBinaryOperation(equalityOperation);
				if (result == null) result = caseRosettaOperation(equalityOperation);
				if (result == null) result = caseHasGeneratedInput(equalityOperation);
				if (result == null) result = caseRosettaExpression(equalityOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.COMPARISON_OPERATION: {
				ComparisonOperation comparisonOperation = (ComparisonOperation)theEObject;
				T result = caseComparisonOperation(comparisonOperation);
				if (result == null) result = caseModifiableBinaryOperation(comparisonOperation);
				if (result == null) result = caseRosettaBinaryOperation(comparisonOperation);
				if (result == null) result = caseRosettaOperation(comparisonOperation);
				if (result == null) result = caseHasGeneratedInput(comparisonOperation);
				if (result == null) result = caseRosettaExpression(comparisonOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_CONTAINS_EXPRESSION: {
				RosettaContainsExpression rosettaContainsExpression = (RosettaContainsExpression)theEObject;
				T result = caseRosettaContainsExpression(rosettaContainsExpression);
				if (result == null) result = caseRosettaBinaryOperation(rosettaContainsExpression);
				if (result == null) result = caseRosettaOperation(rosettaContainsExpression);
				if (result == null) result = caseHasGeneratedInput(rosettaContainsExpression);
				if (result == null) result = caseRosettaExpression(rosettaContainsExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_DISJOINT_EXPRESSION: {
				RosettaDisjointExpression rosettaDisjointExpression = (RosettaDisjointExpression)theEObject;
				T result = caseRosettaDisjointExpression(rosettaDisjointExpression);
				if (result == null) result = caseRosettaBinaryOperation(rosettaDisjointExpression);
				if (result == null) result = caseRosettaOperation(rosettaDisjointExpression);
				if (result == null) result = caseHasGeneratedInput(rosettaDisjointExpression);
				if (result == null) result = caseRosettaExpression(rosettaDisjointExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.JOIN_OPERATION: {
				JoinOperation joinOperation = (JoinOperation)theEObject;
				T result = caseJoinOperation(joinOperation);
				if (result == null) result = caseRosettaBinaryOperation(joinOperation);
				if (result == null) result = caseRosettaOperation(joinOperation);
				if (result == null) result = caseHasGeneratedInput(joinOperation);
				if (result == null) result = caseRosettaExpression(joinOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_ONLY_EXISTS_EXPRESSION: {
				RosettaOnlyExistsExpression rosettaOnlyExistsExpression = (RosettaOnlyExistsExpression)theEObject;
				T result = caseRosettaOnlyExistsExpression(rosettaOnlyExistsExpression);
				if (result == null) result = caseRosettaExpression(rosettaOnlyExistsExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_UNARY_OPERATION: {
				RosettaUnaryOperation rosettaUnaryOperation = (RosettaUnaryOperation)theEObject;
				T result = caseRosettaUnaryOperation(rosettaUnaryOperation);
				if (result == null) result = caseRosettaOperation(rosettaUnaryOperation);
				if (result == null) result = caseHasGeneratedInput(rosettaUnaryOperation);
				if (result == null) result = caseRosettaExpression(rosettaUnaryOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.LIST_OPERATION: {
				ListOperation listOperation = (ListOperation)theEObject;
				T result = caseListOperation(listOperation);
				if (result == null) result = caseRosettaUnaryOperation(listOperation);
				if (result == null) result = caseRosettaOperation(listOperation);
				if (result == null) result = caseHasGeneratedInput(listOperation);
				if (result == null) result = caseRosettaExpression(listOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.CAN_HANDLE_LIST_OF_LISTS: {
				CanHandleListOfLists canHandleListOfLists = (CanHandleListOfLists)theEObject;
				T result = caseCanHandleListOfLists(canHandleListOfLists);
				if (result == null) result = caseRosettaUnaryOperation(canHandleListOfLists);
				if (result == null) result = caseRosettaOperation(canHandleListOfLists);
				if (result == null) result = caseHasGeneratedInput(canHandleListOfLists);
				if (result == null) result = caseRosettaExpression(canHandleListOfLists);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_EXISTS_EXPRESSION: {
				RosettaExistsExpression rosettaExistsExpression = (RosettaExistsExpression)theEObject;
				T result = caseRosettaExistsExpression(rosettaExistsExpression);
				if (result == null) result = caseRosettaUnaryOperation(rosettaExistsExpression);
				if (result == null) result = caseRosettaOperation(rosettaExistsExpression);
				if (result == null) result = caseHasGeneratedInput(rosettaExistsExpression);
				if (result == null) result = caseRosettaExpression(rosettaExistsExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_ABSENT_EXPRESSION: {
				RosettaAbsentExpression rosettaAbsentExpression = (RosettaAbsentExpression)theEObject;
				T result = caseRosettaAbsentExpression(rosettaAbsentExpression);
				if (result == null) result = caseRosettaUnaryOperation(rosettaAbsentExpression);
				if (result == null) result = caseRosettaOperation(rosettaAbsentExpression);
				if (result == null) result = caseHasGeneratedInput(rosettaAbsentExpression);
				if (result == null) result = caseRosettaExpression(rosettaAbsentExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_ONLY_ELEMENT: {
				RosettaOnlyElement rosettaOnlyElement = (RosettaOnlyElement)theEObject;
				T result = caseRosettaOnlyElement(rosettaOnlyElement);
				if (result == null) result = caseListOperation(rosettaOnlyElement);
				if (result == null) result = caseRosettaUnaryOperation(rosettaOnlyElement);
				if (result == null) result = caseRosettaOperation(rosettaOnlyElement);
				if (result == null) result = caseHasGeneratedInput(rosettaOnlyElement);
				if (result == null) result = caseRosettaExpression(rosettaOnlyElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_COUNT_OPERATION: {
				RosettaCountOperation rosettaCountOperation = (RosettaCountOperation)theEObject;
				T result = caseRosettaCountOperation(rosettaCountOperation);
				if (result == null) result = caseRosettaUnaryOperation(rosettaCountOperation);
				if (result == null) result = caseRosettaOperation(rosettaCountOperation);
				if (result == null) result = caseHasGeneratedInput(rosettaCountOperation);
				if (result == null) result = caseRosettaExpression(rosettaCountOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.FLATTEN_OPERATION: {
				FlattenOperation flattenOperation = (FlattenOperation)theEObject;
				T result = caseFlattenOperation(flattenOperation);
				if (result == null) result = caseListOperation(flattenOperation);
				if (result == null) result = caseCanHandleListOfLists(flattenOperation);
				if (result == null) result = caseRosettaUnaryOperation(flattenOperation);
				if (result == null) result = caseRosettaOperation(flattenOperation);
				if (result == null) result = caseHasGeneratedInput(flattenOperation);
				if (result == null) result = caseRosettaExpression(flattenOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.DISTINCT_OPERATION: {
				DistinctOperation distinctOperation = (DistinctOperation)theEObject;
				T result = caseDistinctOperation(distinctOperation);
				if (result == null) result = caseListOperation(distinctOperation);
				if (result == null) result = caseRosettaUnaryOperation(distinctOperation);
				if (result == null) result = caseRosettaOperation(distinctOperation);
				if (result == null) result = caseHasGeneratedInput(distinctOperation);
				if (result == null) result = caseRosettaExpression(distinctOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.REVERSE_OPERATION: {
				ReverseOperation reverseOperation = (ReverseOperation)theEObject;
				T result = caseReverseOperation(reverseOperation);
				if (result == null) result = caseListOperation(reverseOperation);
				if (result == null) result = caseRosettaUnaryOperation(reverseOperation);
				if (result == null) result = caseRosettaOperation(reverseOperation);
				if (result == null) result = caseHasGeneratedInput(reverseOperation);
				if (result == null) result = caseRosettaExpression(reverseOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.FIRST_OPERATION: {
				FirstOperation firstOperation = (FirstOperation)theEObject;
				T result = caseFirstOperation(firstOperation);
				if (result == null) result = caseListOperation(firstOperation);
				if (result == null) result = caseRosettaUnaryOperation(firstOperation);
				if (result == null) result = caseRosettaOperation(firstOperation);
				if (result == null) result = caseHasGeneratedInput(firstOperation);
				if (result == null) result = caseRosettaExpression(firstOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.LAST_OPERATION: {
				LastOperation lastOperation = (LastOperation)theEObject;
				T result = caseLastOperation(lastOperation);
				if (result == null) result = caseListOperation(lastOperation);
				if (result == null) result = caseRosettaUnaryOperation(lastOperation);
				if (result == null) result = caseRosettaOperation(lastOperation);
				if (result == null) result = caseHasGeneratedInput(lastOperation);
				if (result == null) result = caseRosettaExpression(lastOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.SUM_OPERATION: {
				SumOperation sumOperation = (SumOperation)theEObject;
				T result = caseSumOperation(sumOperation);
				if (result == null) result = caseListOperation(sumOperation);
				if (result == null) result = caseRosettaUnaryOperation(sumOperation);
				if (result == null) result = caseRosettaOperation(sumOperation);
				if (result == null) result = caseHasGeneratedInput(sumOperation);
				if (result == null) result = caseRosettaExpression(sumOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.AS_KEY_OPERATION: {
				AsKeyOperation asKeyOperation = (AsKeyOperation)theEObject;
				T result = caseAsKeyOperation(asKeyOperation);
				if (result == null) result = caseRosettaUnaryOperation(asKeyOperation);
				if (result == null) result = caseRosettaOperation(asKeyOperation);
				if (result == null) result = caseHasGeneratedInput(asKeyOperation);
				if (result == null) result = caseRosettaExpression(asKeyOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ONE_OF_OPERATION: {
				OneOfOperation oneOfOperation = (OneOfOperation)theEObject;
				T result = caseOneOfOperation(oneOfOperation);
				if (result == null) result = caseRosettaUnaryOperation(oneOfOperation);
				if (result == null) result = caseRosettaOperation(oneOfOperation);
				if (result == null) result = caseHasGeneratedInput(oneOfOperation);
				if (result == null) result = caseRosettaExpression(oneOfOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.CHOICE_OPERATION: {
				ChoiceOperation choiceOperation = (ChoiceOperation)theEObject;
				T result = caseChoiceOperation(choiceOperation);
				if (result == null) result = caseRosettaUnaryOperation(choiceOperation);
				if (result == null) result = caseRosettaOperation(choiceOperation);
				if (result == null) result = caseHasGeneratedInput(choiceOperation);
				if (result == null) result = caseRosettaExpression(choiceOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.TO_STRING_OPERATION: {
				ToStringOperation toStringOperation = (ToStringOperation)theEObject;
				T result = caseToStringOperation(toStringOperation);
				if (result == null) result = caseRosettaUnaryOperation(toStringOperation);
				if (result == null) result = caseRosettaOperation(toStringOperation);
				if (result == null) result = caseHasGeneratedInput(toStringOperation);
				if (result == null) result = caseRosettaExpression(toStringOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.PARSE_OPERATION: {
				ParseOperation parseOperation = (ParseOperation)theEObject;
				T result = caseParseOperation(parseOperation);
				if (result == null) result = caseRosettaUnaryOperation(parseOperation);
				if (result == null) result = caseRosettaOperation(parseOperation);
				if (result == null) result = caseHasGeneratedInput(parseOperation);
				if (result == null) result = caseRosettaExpression(parseOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.TO_NUMBER_OPERATION: {
				ToNumberOperation toNumberOperation = (ToNumberOperation)theEObject;
				T result = caseToNumberOperation(toNumberOperation);
				if (result == null) result = caseParseOperation(toNumberOperation);
				if (result == null) result = caseRosettaUnaryOperation(toNumberOperation);
				if (result == null) result = caseRosettaOperation(toNumberOperation);
				if (result == null) result = caseHasGeneratedInput(toNumberOperation);
				if (result == null) result = caseRosettaExpression(toNumberOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.TO_INT_OPERATION: {
				ToIntOperation toIntOperation = (ToIntOperation)theEObject;
				T result = caseToIntOperation(toIntOperation);
				if (result == null) result = caseParseOperation(toIntOperation);
				if (result == null) result = caseRosettaUnaryOperation(toIntOperation);
				if (result == null) result = caseRosettaOperation(toIntOperation);
				if (result == null) result = caseHasGeneratedInput(toIntOperation);
				if (result == null) result = caseRosettaExpression(toIntOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.TO_TIME_OPERATION: {
				ToTimeOperation toTimeOperation = (ToTimeOperation)theEObject;
				T result = caseToTimeOperation(toTimeOperation);
				if (result == null) result = caseParseOperation(toTimeOperation);
				if (result == null) result = caseRosettaUnaryOperation(toTimeOperation);
				if (result == null) result = caseRosettaOperation(toTimeOperation);
				if (result == null) result = caseHasGeneratedInput(toTimeOperation);
				if (result == null) result = caseRosettaExpression(toTimeOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.TO_ENUM_OPERATION: {
				ToEnumOperation toEnumOperation = (ToEnumOperation)theEObject;
				T result = caseToEnumOperation(toEnumOperation);
				if (result == null) result = caseParseOperation(toEnumOperation);
				if (result == null) result = caseRosettaUnaryOperation(toEnumOperation);
				if (result == null) result = caseRosettaOperation(toEnumOperation);
				if (result == null) result = caseHasGeneratedInput(toEnumOperation);
				if (result == null) result = caseRosettaExpression(toEnumOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.TO_DATE_OPERATION: {
				ToDateOperation toDateOperation = (ToDateOperation)theEObject;
				T result = caseToDateOperation(toDateOperation);
				if (result == null) result = caseParseOperation(toDateOperation);
				if (result == null) result = caseRosettaUnaryOperation(toDateOperation);
				if (result == null) result = caseRosettaOperation(toDateOperation);
				if (result == null) result = caseHasGeneratedInput(toDateOperation);
				if (result == null) result = caseRosettaExpression(toDateOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.TO_DATE_TIME_OPERATION: {
				ToDateTimeOperation toDateTimeOperation = (ToDateTimeOperation)theEObject;
				T result = caseToDateTimeOperation(toDateTimeOperation);
				if (result == null) result = caseParseOperation(toDateTimeOperation);
				if (result == null) result = caseRosettaUnaryOperation(toDateTimeOperation);
				if (result == null) result = caseRosettaOperation(toDateTimeOperation);
				if (result == null) result = caseHasGeneratedInput(toDateTimeOperation);
				if (result == null) result = caseRosettaExpression(toDateTimeOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.TO_ZONED_DATE_TIME_OPERATION: {
				ToZonedDateTimeOperation toZonedDateTimeOperation = (ToZonedDateTimeOperation)theEObject;
				T result = caseToZonedDateTimeOperation(toZonedDateTimeOperation);
				if (result == null) result = caseParseOperation(toZonedDateTimeOperation);
				if (result == null) result = caseRosettaUnaryOperation(toZonedDateTimeOperation);
				if (result == null) result = caseRosettaOperation(toZonedDateTimeOperation);
				if (result == null) result = caseHasGeneratedInput(toZonedDateTimeOperation);
				if (result == null) result = caseRosettaExpression(toZonedDateTimeOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.CLOSURE_PARAMETER: {
				ClosureParameter closureParameter = (ClosureParameter)theEObject;
				T result = caseClosureParameter(closureParameter);
				if (result == null) result = caseRosettaSymbol(closureParameter);
				if (result == null) result = caseRosettaNamed(closureParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.INLINE_FUNCTION: {
				InlineFunction inlineFunction = (InlineFunction)theEObject;
				T result = caseInlineFunction(inlineFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.ROSETTA_FUNCTIONAL_OPERATION: {
				RosettaFunctionalOperation rosettaFunctionalOperation = (RosettaFunctionalOperation)theEObject;
				T result = caseRosettaFunctionalOperation(rosettaFunctionalOperation);
				if (result == null) result = caseRosettaUnaryOperation(rosettaFunctionalOperation);
				if (result == null) result = caseRosettaOperation(rosettaFunctionalOperation);
				if (result == null) result = caseHasGeneratedInput(rosettaFunctionalOperation);
				if (result == null) result = caseRosettaExpression(rosettaFunctionalOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.MANDATORY_FUNCTIONAL_OPERATION: {
				MandatoryFunctionalOperation mandatoryFunctionalOperation = (MandatoryFunctionalOperation)theEObject;
				T result = caseMandatoryFunctionalOperation(mandatoryFunctionalOperation);
				if (result == null) result = caseRosettaFunctionalOperation(mandatoryFunctionalOperation);
				if (result == null) result = caseRosettaUnaryOperation(mandatoryFunctionalOperation);
				if (result == null) result = caseRosettaOperation(mandatoryFunctionalOperation);
				if (result == null) result = caseHasGeneratedInput(mandatoryFunctionalOperation);
				if (result == null) result = caseRosettaExpression(mandatoryFunctionalOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.UNARY_FUNCTIONAL_OPERATION: {
				UnaryFunctionalOperation unaryFunctionalOperation = (UnaryFunctionalOperation)theEObject;
				T result = caseUnaryFunctionalOperation(unaryFunctionalOperation);
				if (result == null) result = caseRosettaFunctionalOperation(unaryFunctionalOperation);
				if (result == null) result = caseRosettaUnaryOperation(unaryFunctionalOperation);
				if (result == null) result = caseRosettaOperation(unaryFunctionalOperation);
				if (result == null) result = caseHasGeneratedInput(unaryFunctionalOperation);
				if (result == null) result = caseRosettaExpression(unaryFunctionalOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.REDUCE_OPERATION: {
				ReduceOperation reduceOperation = (ReduceOperation)theEObject;
				T result = caseReduceOperation(reduceOperation);
				if (result == null) result = caseMandatoryFunctionalOperation(reduceOperation);
				if (result == null) result = caseListOperation(reduceOperation);
				if (result == null) result = caseRosettaFunctionalOperation(reduceOperation);
				if (result == null) result = caseRosettaUnaryOperation(reduceOperation);
				if (result == null) result = caseRosettaOperation(reduceOperation);
				if (result == null) result = caseHasGeneratedInput(reduceOperation);
				if (result == null) result = caseRosettaExpression(reduceOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.FILTER_OPERATION: {
				FilterOperation filterOperation = (FilterOperation)theEObject;
				T result = caseFilterOperation(filterOperation);
				if (result == null) result = caseMandatoryFunctionalOperation(filterOperation);
				if (result == null) result = caseUnaryFunctionalOperation(filterOperation);
				if (result == null) result = caseCanHandleListOfLists(filterOperation);
				if (result == null) result = caseRosettaFunctionalOperation(filterOperation);
				if (result == null) result = caseRosettaUnaryOperation(filterOperation);
				if (result == null) result = caseRosettaOperation(filterOperation);
				if (result == null) result = caseHasGeneratedInput(filterOperation);
				if (result == null) result = caseRosettaExpression(filterOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.MAP_OPERATION: {
				MapOperation mapOperation = (MapOperation)theEObject;
				T result = caseMapOperation(mapOperation);
				if (result == null) result = caseMandatoryFunctionalOperation(mapOperation);
				if (result == null) result = caseUnaryFunctionalOperation(mapOperation);
				if (result == null) result = caseCanHandleListOfLists(mapOperation);
				if (result == null) result = caseRosettaFunctionalOperation(mapOperation);
				if (result == null) result = caseRosettaUnaryOperation(mapOperation);
				if (result == null) result = caseRosettaOperation(mapOperation);
				if (result == null) result = caseHasGeneratedInput(mapOperation);
				if (result == null) result = caseRosettaExpression(mapOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.THEN_OPERATION: {
				ThenOperation thenOperation = (ThenOperation)theEObject;
				T result = caseThenOperation(thenOperation);
				if (result == null) result = caseMandatoryFunctionalOperation(thenOperation);
				if (result == null) result = caseUnaryFunctionalOperation(thenOperation);
				if (result == null) result = caseCanHandleListOfLists(thenOperation);
				if (result == null) result = caseRosettaFunctionalOperation(thenOperation);
				if (result == null) result = caseRosettaUnaryOperation(thenOperation);
				if (result == null) result = caseRosettaOperation(thenOperation);
				if (result == null) result = caseHasGeneratedInput(thenOperation);
				if (result == null) result = caseRosettaExpression(thenOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.COMPARING_FUNCTIONAL_OPERATION: {
				ComparingFunctionalOperation comparingFunctionalOperation = (ComparingFunctionalOperation)theEObject;
				T result = caseComparingFunctionalOperation(comparingFunctionalOperation);
				if (result == null) result = caseUnaryFunctionalOperation(comparingFunctionalOperation);
				if (result == null) result = caseRosettaFunctionalOperation(comparingFunctionalOperation);
				if (result == null) result = caseRosettaUnaryOperation(comparingFunctionalOperation);
				if (result == null) result = caseRosettaOperation(comparingFunctionalOperation);
				if (result == null) result = caseHasGeneratedInput(comparingFunctionalOperation);
				if (result == null) result = caseRosettaExpression(comparingFunctionalOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.SORT_OPERATION: {
				SortOperation sortOperation = (SortOperation)theEObject;
				T result = caseSortOperation(sortOperation);
				if (result == null) result = caseComparingFunctionalOperation(sortOperation);
				if (result == null) result = caseListOperation(sortOperation);
				if (result == null) result = caseUnaryFunctionalOperation(sortOperation);
				if (result == null) result = caseRosettaFunctionalOperation(sortOperation);
				if (result == null) result = caseRosettaUnaryOperation(sortOperation);
				if (result == null) result = caseRosettaOperation(sortOperation);
				if (result == null) result = caseHasGeneratedInput(sortOperation);
				if (result == null) result = caseRosettaExpression(sortOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.MIN_OPERATION: {
				MinOperation minOperation = (MinOperation)theEObject;
				T result = caseMinOperation(minOperation);
				if (result == null) result = caseComparingFunctionalOperation(minOperation);
				if (result == null) result = caseListOperation(minOperation);
				if (result == null) result = caseUnaryFunctionalOperation(minOperation);
				if (result == null) result = caseRosettaFunctionalOperation(minOperation);
				if (result == null) result = caseRosettaUnaryOperation(minOperation);
				if (result == null) result = caseRosettaOperation(minOperation);
				if (result == null) result = caseHasGeneratedInput(minOperation);
				if (result == null) result = caseRosettaExpression(minOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExpressionPackage.MAX_OPERATION: {
				MaxOperation maxOperation = (MaxOperation)theEObject;
				T result = caseMaxOperation(maxOperation);
				if (result == null) result = caseComparingFunctionalOperation(maxOperation);
				if (result == null) result = caseListOperation(maxOperation);
				if (result == null) result = caseUnaryFunctionalOperation(maxOperation);
				if (result == null) result = caseRosettaFunctionalOperation(maxOperation);
				if (result == null) result = caseRosettaUnaryOperation(maxOperation);
				if (result == null) result = caseRosettaOperation(maxOperation);
				if (result == null) result = caseHasGeneratedInput(maxOperation);
				if (result == null) result = caseRosettaExpression(maxOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExpression(RosettaExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Has Generated Input</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Has Generated Input</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHasGeneratedInput(HasGeneratedInput object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaLiteral(RosettaLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Boolean Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Boolean Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaBooleanLiteral(RosettaBooleanLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta String Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta String Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaStringLiteral(RosettaStringLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Number Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Number Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaNumberLiteral(RosettaNumberLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Int Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Int Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaIntLiteral(RosettaIntLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Pattern Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Pattern Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaPatternLiteral(RosettaPatternLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>List Literal</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>List Literal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseListLiteral(ListLiteral object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaReference(RosettaReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Symbol Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Symbol Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSymbolReference(RosettaSymbolReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Implicit Variable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Implicit Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaImplicitVariable(RosettaImplicitVariable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Feature Call</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Feature Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaFeatureCall(RosettaFeatureCall object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Deep Feature Call</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Deep Feature Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaDeepFeatureCall(RosettaDeepFeatureCall object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Conditional Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Conditional Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaConditionalExpression(RosettaConditionalExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Constructor Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Constructor Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaConstructorExpression(RosettaConstructorExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constructor Key Value Pair</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constructor Key Value Pair</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstructorKeyValuePair(ConstructorKeyValuePair object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaOperation(RosettaOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Binary Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Binary Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaBinaryOperation(RosettaBinaryOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Arithmetic Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Arithmetic Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArithmeticOperation(ArithmeticOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Default Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Default Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDefaultOperation(DefaultOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Logical Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Logical Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLogicalOperation(LogicalOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Modifiable Binary Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Modifiable Binary Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModifiableBinaryOperation(ModifiableBinaryOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Equality Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Equality Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEqualityOperation(EqualityOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Comparison Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Comparison Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComparisonOperation(ComparisonOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Contains Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Contains Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaContainsExpression(RosettaContainsExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Disjoint Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Disjoint Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaDisjointExpression(RosettaDisjointExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Join Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Join Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJoinOperation(JoinOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Only Exists Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Only Exists Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaOnlyExistsExpression(RosettaOnlyExistsExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Unary Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Unary Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaUnaryOperation(RosettaUnaryOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>List Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>List Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseListOperation(ListOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Can Handle List Of Lists</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Can Handle List Of Lists</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCanHandleListOfLists(CanHandleListOfLists object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Exists Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Exists Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaExistsExpression(RosettaExistsExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Absent Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Absent Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaAbsentExpression(RosettaAbsentExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Only Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Only Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaOnlyElement(RosettaOnlyElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Count Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Count Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaCountOperation(RosettaCountOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Flatten Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Flatten Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFlattenOperation(FlattenOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Distinct Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Distinct Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDistinctOperation(DistinctOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reverse Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reverse Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReverseOperation(ReverseOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>First Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>First Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFirstOperation(FirstOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Last Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Last Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLastOperation(LastOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sum Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sum Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSumOperation(SumOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>As Key Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>As Key Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAsKeyOperation(AsKeyOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>One Of Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>One Of Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOneOfOperation(OneOfOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Choice Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Choice Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseChoiceOperation(ChoiceOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>To String Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>To String Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToStringOperation(ToStringOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parse Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parse Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParseOperation(ParseOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>To Number Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>To Number Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToNumberOperation(ToNumberOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>To Int Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>To Int Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToIntOperation(ToIntOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>To Time Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>To Time Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToTimeOperation(ToTimeOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>To Enum Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>To Enum Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToEnumOperation(ToEnumOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>To Date Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>To Date Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToDateOperation(ToDateOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>To Date Time Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>To Date Time Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToDateTimeOperation(ToDateTimeOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>To Zoned Date Time Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>To Zoned Date Time Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToZonedDateTimeOperation(ToZonedDateTimeOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Closure Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Closure Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClosureParameter(ClosureParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Inline Function</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Inline Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInlineFunction(InlineFunction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Functional Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Functional Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaFunctionalOperation(RosettaFunctionalOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mandatory Functional Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mandatory Functional Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMandatoryFunctionalOperation(MandatoryFunctionalOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unary Functional Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unary Functional Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnaryFunctionalOperation(UnaryFunctionalOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reduce Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reduce Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReduceOperation(ReduceOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Filter Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Filter Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFilterOperation(FilterOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMapOperation(MapOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Then Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Then Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseThenOperation(ThenOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Comparing Functional Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Comparing Functional Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComparingFunctionalOperation(ComparingFunctionalOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sort Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sort Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSortOperation(SortOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Min Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Min Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMinOperation(MinOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Max Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Max Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMaxOperation(MaxOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Test</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Test</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapTest(RosettaMapTest object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Map Test Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Map Test Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaMapTestExpression(RosettaMapTestExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaNamed(RosettaNamed object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Typed</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Typed</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaTyped(RosettaTyped object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Symbol</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Symbol</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSymbol(RosettaSymbol object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //ExpressionSwitch
