/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.google.common.collect.Iterables;

import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalEnum;
import com.regnosys.rosetta.rosetta.RosettaExternalRef;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaPackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>External Annotation Source</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.ExternalAnnotationSourceImpl#getModel <em>Model</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.ExternalAnnotationSourceImpl#getName <em>Name</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.ExternalAnnotationSourceImpl#getExternalClasses <em>External Classes</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.ExternalAnnotationSourceImpl#getExternalEnums <em>External Enums</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class ExternalAnnotationSourceImpl extends MinimalEObjectImpl.Container implements ExternalAnnotationSource {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getExternalClasses() <em>External Classes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExternalClasses()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaExternalClass> externalClasses;

	/**
	 * The cached value of the '{@link #getExternalEnums() <em>External Enums</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExternalEnums()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaExternalEnum> externalEnums;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalAnnotationSourceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.EXTERNAL_ANNOTATION_SOURCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaModel getModel() {
		if (eContainerFeatureID() != RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL) return null;
		return (RosettaModel)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaModel basicGetModel() {
		if (eContainerFeatureID() != RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL) return null;
		return (RosettaModel)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModel(RosettaModel newModel, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newModel, RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModel(RosettaModel newModel) {
		if (newModel != eInternalContainer() || (eContainerFeatureID() != RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL && newModel != null)) {
			if (EcoreUtil.isAncestor(this, newModel))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newModel != null)
				msgs = ((InternalEObject)newModel).eInverseAdd(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
			msgs = basicSetModel(newModel, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL, newModel, newModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaExternalClass> getExternalClasses() {
		if (externalClasses == null) {
			externalClasses = new EObjectContainmentEList<RosettaExternalClass>(RosettaExternalClass.class, this, RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES);
		}
		return externalClasses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaExternalEnum> getExternalEnums() {
		if (externalEnums == null) {
			externalEnums = new EObjectContainmentEList<RosettaExternalEnum>(RosettaExternalEnum.class, this, RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS);
		}
		return externalEnums;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaExternalRef> getExternalRefs() {
		return ECollections.<RosettaExternalRef>toEList(Iterables.<RosettaExternalRef>concat(this.getExternalClasses(), this.getExternalEnums()));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetModel((RosettaModel)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL:
				return basicSetModel(null, msgs);
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES:
				return ((InternalEList<?>)getExternalClasses()).basicRemove(otherEnd, msgs);
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS:
				return ((InternalEList<?>)getExternalEnums()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL:
				return eInternalContainer().eInverseRemove(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL:
				if (resolve) return getModel();
				return basicGetModel();
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__NAME:
				return getName();
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES:
				return getExternalClasses();
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS:
				return getExternalEnums();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL:
				setModel((RosettaModel)newValue);
				return;
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__NAME:
				setName((String)newValue);
				return;
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES:
				getExternalClasses().clear();
				getExternalClasses().addAll((Collection<? extends RosettaExternalClass>)newValue);
				return;
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS:
				getExternalEnums().clear();
				getExternalEnums().addAll((Collection<? extends RosettaExternalEnum>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL:
				setModel((RosettaModel)null);
				return;
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES:
				getExternalClasses().clear();
				return;
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS:
				getExternalEnums().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__MODEL:
				return basicGetModel() != null;
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_CLASSES:
				return externalClasses != null && !externalClasses.isEmpty();
			case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__EXTERNAL_ENUMS:
				return externalEnums != null && !externalEnums.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaNamed.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__NAME: return RosettaPackage.ROSETTA_NAMED__NAME;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaNamed.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_NAMED__NAME: return RosettaPackage.EXTERNAL_ANNOTATION_SOURCE__NAME;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //ExternalAnnotationSourceImpl
