/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.RegulatoryDocumentReference;
import com.regnosys.rosetta.rosetta.RosettaBody;
import com.regnosys.rosetta.rosetta.RosettaCorpus;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaSegmentRef;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Regulatory Document Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RegulatoryDocumentReferenceImpl#getBody <em>Body</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RegulatoryDocumentReferenceImpl#getCorpusList <em>Corpus List</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RegulatoryDocumentReferenceImpl#getSegments <em>Segments</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RegulatoryDocumentReferenceImpl extends MinimalEObjectImpl.Container implements RegulatoryDocumentReference {
	/**
	 * The cached value of the '{@link #getBody() <em>Body</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBody()
	 * @generated
	 * @ordered
	 */
	protected RosettaBody body;

	/**
	 * The cached value of the '{@link #getCorpusList() <em>Corpus List</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorpusList()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaCorpus> corpusList;

	/**
	 * The cached value of the '{@link #getSegments() <em>Segments</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSegments()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaSegmentRef> segments;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RegulatoryDocumentReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.REGULATORY_DOCUMENT_REFERENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaBody getBody() {
		if (body != null && body.eIsProxy()) {
			InternalEObject oldBody = (InternalEObject)body;
			body = (RosettaBody)eResolveProxy(oldBody);
			if (body != oldBody) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__BODY, oldBody, body));
			}
		}
		return body;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaBody basicGetBody() {
		return body;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBody(RosettaBody newBody) {
		RosettaBody oldBody = body;
		body = newBody;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__BODY, oldBody, body));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaCorpus> getCorpusList() {
		if (corpusList == null) {
			corpusList = new EObjectResolvingEList<RosettaCorpus>(RosettaCorpus.class, this, RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__CORPUS_LIST);
		}
		return corpusList;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaSegmentRef> getSegments() {
		if (segments == null) {
			segments = new EObjectContainmentEList<RosettaSegmentRef>(RosettaSegmentRef.class, this, RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__SEGMENTS);
		}
		return segments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__SEGMENTS:
				return ((InternalEList<?>)getSegments()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__BODY:
				if (resolve) return getBody();
				return basicGetBody();
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__CORPUS_LIST:
				return getCorpusList();
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__SEGMENTS:
				return getSegments();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__BODY:
				setBody((RosettaBody)newValue);
				return;
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__CORPUS_LIST:
				getCorpusList().clear();
				getCorpusList().addAll((Collection<? extends RosettaCorpus>)newValue);
				return;
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__SEGMENTS:
				getSegments().clear();
				getSegments().addAll((Collection<? extends RosettaSegmentRef>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__BODY:
				setBody((RosettaBody)null);
				return;
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__CORPUS_LIST:
				getCorpusList().clear();
				return;
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__SEGMENTS:
				getSegments().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__BODY:
				return body != null;
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__CORPUS_LIST:
				return corpusList != null && !corpusList.isEmpty();
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE__SEGMENTS:
				return segments != null && !segments.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //RegulatoryDocumentReferenceImpl
