/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaSynonym;
import com.regnosys.rosetta.rosetta.RosettaType;

import com.regnosys.rosetta.rosetta.simple.References;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Enumeration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl#getModel <em>Model</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl#getName <em>Name</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl#getDefinition <em>Definition</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl#getReferences <em>References</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl#getSuperType <em>Super Type</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl#getSynonyms <em>Synonyms</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaEnumerationImpl#getEnumValues <em>Enum Values</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaEnumerationImpl extends MinimalEObjectImpl.Container implements RosettaEnumeration {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected static final String DEFINITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected String definition = DEFINITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getReferences() <em>References</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferences()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaDocReference> references;

	/**
	 * The cached value of the '{@link #getSuperType() <em>Super Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSuperType()
	 * @generated
	 * @ordered
	 */
	protected RosettaEnumeration superType;

	/**
	 * The cached value of the '{@link #getSynonyms() <em>Synonyms</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSynonyms()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaSynonym> synonyms;

	/**
	 * The cached value of the '{@link #getEnumValues() <em>Enum Values</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnumValues()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaEnumValue> enumValues;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaEnumerationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.ROSETTA_ENUMERATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaModel getModel() {
		if (eContainerFeatureID() != RosettaPackage.ROSETTA_ENUMERATION__MODEL) return null;
		return (RosettaModel)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaModel basicGetModel() {
		if (eContainerFeatureID() != RosettaPackage.ROSETTA_ENUMERATION__MODEL) return null;
		return (RosettaModel)eInternalContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetModel(RosettaModel newModel, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newModel, RosettaPackage.ROSETTA_ENUMERATION__MODEL, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModel(RosettaModel newModel) {
		if (newModel != eInternalContainer() || (eContainerFeatureID() != RosettaPackage.ROSETTA_ENUMERATION__MODEL && newModel != null)) {
			if (EcoreUtil.isAncestor(this, newModel))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newModel != null)
				msgs = ((InternalEObject)newModel).eInverseAdd(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
			msgs = basicSetModel(newModel, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_ENUMERATION__MODEL, newModel, newModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_ENUMERATION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDefinition() {
		return definition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDefinition(String newDefinition) {
		String oldDefinition = definition;
		definition = newDefinition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_ENUMERATION__DEFINITION, oldDefinition, definition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaDocReference> getReferences() {
		if (references == null) {
			references = new EObjectContainmentEList<RosettaDocReference>(RosettaDocReference.class, this, RosettaPackage.ROSETTA_ENUMERATION__REFERENCES);
		}
		return references;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaEnumeration getSuperType() {
		if (superType != null && superType.eIsProxy()) {
			InternalEObject oldSuperType = (InternalEObject)superType;
			superType = (RosettaEnumeration)eResolveProxy(oldSuperType);
			if (superType != oldSuperType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RosettaPackage.ROSETTA_ENUMERATION__SUPER_TYPE, oldSuperType, superType));
			}
		}
		return superType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaEnumeration basicGetSuperType() {
		return superType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSuperType(RosettaEnumeration newSuperType) {
		RosettaEnumeration oldSuperType = superType;
		superType = newSuperType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_ENUMERATION__SUPER_TYPE, oldSuperType, superType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaSynonym> getSynonyms() {
		if (synonyms == null) {
			synonyms = new EObjectContainmentEList<RosettaSynonym>(RosettaSynonym.class, this, RosettaPackage.ROSETTA_ENUMERATION__SYNONYMS);
		}
		return synonyms;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaEnumValue> getEnumValues() {
		if (enumValues == null) {
			enumValues = new EObjectContainmentWithInverseEList<RosettaEnumValue>(RosettaEnumValue.class, this, RosettaPackage.ROSETTA_ENUMERATION__ENUM_VALUES, RosettaPackage.ROSETTA_ENUM_VALUE__ENUMERATION);
		}
		return enumValues;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_ENUMERATION__MODEL:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetModel((RosettaModel)otherEnd, msgs);
			case RosettaPackage.ROSETTA_ENUMERATION__ENUM_VALUES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getEnumValues()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_ENUMERATION__MODEL:
				return basicSetModel(null, msgs);
			case RosettaPackage.ROSETTA_ENUMERATION__REFERENCES:
				return ((InternalEList<?>)getReferences()).basicRemove(otherEnd, msgs);
			case RosettaPackage.ROSETTA_ENUMERATION__SYNONYMS:
				return ((InternalEList<?>)getSynonyms()).basicRemove(otherEnd, msgs);
			case RosettaPackage.ROSETTA_ENUMERATION__ENUM_VALUES:
				return ((InternalEList<?>)getEnumValues()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case RosettaPackage.ROSETTA_ENUMERATION__MODEL:
				return eInternalContainer().eInverseRemove(this, RosettaPackage.ROSETTA_MODEL__ELEMENTS, RosettaModel.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_ENUMERATION__MODEL:
				if (resolve) return getModel();
				return basicGetModel();
			case RosettaPackage.ROSETTA_ENUMERATION__NAME:
				return getName();
			case RosettaPackage.ROSETTA_ENUMERATION__DEFINITION:
				return getDefinition();
			case RosettaPackage.ROSETTA_ENUMERATION__REFERENCES:
				return getReferences();
			case RosettaPackage.ROSETTA_ENUMERATION__SUPER_TYPE:
				if (resolve) return getSuperType();
				return basicGetSuperType();
			case RosettaPackage.ROSETTA_ENUMERATION__SYNONYMS:
				return getSynonyms();
			case RosettaPackage.ROSETTA_ENUMERATION__ENUM_VALUES:
				return getEnumValues();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_ENUMERATION__MODEL:
				setModel((RosettaModel)newValue);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__NAME:
				setName((String)newValue);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__DEFINITION:
				setDefinition((String)newValue);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__REFERENCES:
				getReferences().clear();
				getReferences().addAll((Collection<? extends RosettaDocReference>)newValue);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__SUPER_TYPE:
				setSuperType((RosettaEnumeration)newValue);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__SYNONYMS:
				getSynonyms().clear();
				getSynonyms().addAll((Collection<? extends RosettaSynonym>)newValue);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__ENUM_VALUES:
				getEnumValues().clear();
				getEnumValues().addAll((Collection<? extends RosettaEnumValue>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_ENUMERATION__MODEL:
				setModel((RosettaModel)null);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__DEFINITION:
				setDefinition(DEFINITION_EDEFAULT);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__REFERENCES:
				getReferences().clear();
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__SUPER_TYPE:
				setSuperType((RosettaEnumeration)null);
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__SYNONYMS:
				getSynonyms().clear();
				return;
			case RosettaPackage.ROSETTA_ENUMERATION__ENUM_VALUES:
				getEnumValues().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_ENUMERATION__MODEL:
				return basicGetModel() != null;
			case RosettaPackage.ROSETTA_ENUMERATION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case RosettaPackage.ROSETTA_ENUMERATION__DEFINITION:
				return DEFINITION_EDEFAULT == null ? definition != null : !DEFINITION_EDEFAULT.equals(definition);
			case RosettaPackage.ROSETTA_ENUMERATION__REFERENCES:
				return references != null && !references.isEmpty();
			case RosettaPackage.ROSETTA_ENUMERATION__SUPER_TYPE:
				return superType != null;
			case RosettaPackage.ROSETTA_ENUMERATION__SYNONYMS:
				return synonyms != null && !synonyms.isEmpty();
			case RosettaPackage.ROSETTA_ENUMERATION__ENUM_VALUES:
				return enumValues != null && !enumValues.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaNamed.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_ENUMERATION__NAME: return RosettaPackage.ROSETTA_NAMED__NAME;
				default: return -1;
			}
		}
		if (baseClass == RosettaType.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RosettaDefinable.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_ENUMERATION__DEFINITION: return RosettaPackage.ROSETTA_DEFINABLE__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (derivedFeatureID) {
				case RosettaPackage.ROSETTA_ENUMERATION__REFERENCES: return SimplePackage.REFERENCES__REFERENCES;
				default: return -1;
			}
		}
		if (baseClass == RosettaSymbol.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaNamed.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_NAMED__NAME: return RosettaPackage.ROSETTA_ENUMERATION__NAME;
				default: return -1;
			}
		}
		if (baseClass == RosettaType.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == RosettaDefinable.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_DEFINABLE__DEFINITION: return RosettaPackage.ROSETTA_ENUMERATION__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (baseFeatureID) {
				case SimplePackage.REFERENCES__REFERENCES: return RosettaPackage.ROSETTA_ENUMERATION__REFERENCES;
				default: return -1;
			}
		}
		if (baseClass == RosettaSymbol.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", definition: ");
		result.append(definition);
		result.append(')');
		return result.toString();
	}

} //RosettaEnumerationImpl
