/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaType;

import com.regnosys.rosetta.rosetta.simple.Data;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>External Class</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalClassImpl#getData <em>Data</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalClassImpl#getExternalClassSynonyms <em>External Class Synonyms</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalClassImpl#getRegularAttributes <em>Regular Attributes</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaExternalClassImpl extends RosettaExternalRefImpl implements RosettaExternalClass {
	/**
	 * The cached value of the '{@link #getData() <em>Data</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getData()
	 * @generated
	 * @ordered
	 */
	protected Data data;

	/**
	 * The cached value of the '{@link #getExternalClassSynonyms() <em>External Class Synonyms</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExternalClassSynonyms()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaExternalClassSynonym> externalClassSynonyms;

	/**
	 * The cached value of the '{@link #getRegularAttributes() <em>Regular Attributes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRegularAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaExternalRegularAttribute> regularAttributes;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaExternalClassImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.ROSETTA_EXTERNAL_CLASS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Data getData() {
		if (data != null && data.eIsProxy()) {
			InternalEObject oldData = (InternalEObject)data;
			data = (Data)eResolveProxy(oldData);
			if (data != oldData) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RosettaPackage.ROSETTA_EXTERNAL_CLASS__DATA, oldData, data));
			}
		}
		return data;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Data basicGetData() {
		return data;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setData(Data newData) {
		Data oldData = data;
		data = newData;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RosettaPackage.ROSETTA_EXTERNAL_CLASS__DATA, oldData, data));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaExternalClassSynonym> getExternalClassSynonyms() {
		if (externalClassSynonyms == null) {
			externalClassSynonyms = new EObjectContainmentEList<RosettaExternalClassSynonym>(RosettaExternalClassSynonym.class, this, RosettaPackage.ROSETTA_EXTERNAL_CLASS__EXTERNAL_CLASS_SYNONYMS);
		}
		return externalClassSynonyms;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaExternalRegularAttribute> getRegularAttributes() {
		if (regularAttributes == null) {
			regularAttributes = new EObjectContainmentEList<RosettaExternalRegularAttribute>(RosettaExternalRegularAttribute.class, this, RosettaPackage.ROSETTA_EXTERNAL_CLASS__REGULAR_ATTRIBUTES);
		}
		return regularAttributes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaType getTypeRef() {
		return this.getData();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__EXTERNAL_CLASS_SYNONYMS:
				return ((InternalEList<?>)getExternalClassSynonyms()).basicRemove(otherEnd, msgs);
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__REGULAR_ATTRIBUTES:
				return ((InternalEList<?>)getRegularAttributes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__DATA:
				if (resolve) return getData();
				return basicGetData();
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__EXTERNAL_CLASS_SYNONYMS:
				return getExternalClassSynonyms();
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__REGULAR_ATTRIBUTES:
				return getRegularAttributes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__DATA:
				setData((Data)newValue);
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__EXTERNAL_CLASS_SYNONYMS:
				getExternalClassSynonyms().clear();
				getExternalClassSynonyms().addAll((Collection<? extends RosettaExternalClassSynonym>)newValue);
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__REGULAR_ATTRIBUTES:
				getRegularAttributes().clear();
				getRegularAttributes().addAll((Collection<? extends RosettaExternalRegularAttribute>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__DATA:
				setData((Data)null);
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__EXTERNAL_CLASS_SYNONYMS:
				getExternalClassSynonyms().clear();
				return;
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__REGULAR_ATTRIBUTES:
				getRegularAttributes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__DATA:
				return data != null;
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__EXTERNAL_CLASS_SYNONYMS:
				return externalClassSynonyms != null && !externalClassSynonyms.isEmpty();
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS__REGULAR_ATTRIBUTES:
				return regularAttributes != null && !regularAttributes.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //RosettaExternalClassImpl
