/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.google.common.collect.Iterables;

import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaPackage;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>External Rule Source</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.impl.RosettaExternalRuleSourceImpl#getSuperSources <em>Super Sources</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RosettaExternalRuleSourceImpl extends ExternalAnnotationSourceImpl implements RosettaExternalRuleSource {
	/**
	 * The cached value of the '{@link #getSuperSources() <em>Super Sources</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSuperSources()
	 * @generated
	 * @ordered
	 */
	protected EList<ExternalAnnotationSource> superSources;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RosettaExternalRuleSourceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ExternalAnnotationSource> getSuperSources() {
		if (superSources == null) {
			superSources = new EObjectResolvingEList<ExternalAnnotationSource>(ExternalAnnotationSource.class, this, RosettaPackage.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES);
		}
		return superSources;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalRuleSource getSuperRuleSource() {
		return IterableExtensions.<RosettaExternalRuleSource>head(Iterables.<RosettaExternalRuleSource>filter(this.getSuperSources(), RosettaExternalRuleSource.class));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES:
				return getSuperSources();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES:
				getSuperSources().clear();
				getSuperSources().addAll((Collection<? extends ExternalAnnotationSource>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES:
				getSuperSources().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RosettaPackage.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES:
				return superSources != null && !superSources.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //RosettaExternalRuleSourceImpl
