/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.impl;

import com.regnosys.rosetta.rosetta.*;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class RosettaFactoryImpl extends EFactoryImpl implements RosettaFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RosettaFactory init() {
		try {
			RosettaFactory theRosettaFactory = (RosettaFactory)EPackage.Registry.INSTANCE.getEFactory(RosettaPackage.eNS_URI);
			if (theRosettaFactory != null) {
				return theRosettaFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new RosettaFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case RosettaPackage.ROSETTA_MODEL: return createRosettaModel();
			case RosettaPackage.IMPORT: return createImport();
			case RosettaPackage.ROSETTA_FEATURE: return createRosettaFeature();
			case RosettaPackage.ROSETTA_TYPED_FEATURE: return createRosettaTypedFeature();
			case RosettaPackage.TYPE_CALL: return createTypeCall();
			case RosettaPackage.TYPE_CALL_ARGUMENT: return createTypeCallArgument();
			case RosettaPackage.ROSETTA_BASIC_TYPE: return createRosettaBasicType();
			case RosettaPackage.TYPE_PARAMETER: return createTypeParameter();
			case RosettaPackage.ROSETTA_SYNONYM_SOURCE: return createRosettaSynonymSource();
			case RosettaPackage.ROSETTA_RECORD_TYPE: return createRosettaRecordType();
			case RosettaPackage.ROSETTA_RECORD_FEATURE: return createRosettaRecordFeature();
			case RosettaPackage.ROSETTA_EXTERNAL_FUNCTION: return createRosettaExternalFunction();
			case RosettaPackage.ROSETTA_PARAMETER: return createRosettaParameter();
			case RosettaPackage.ROSETTA_TYPE_ALIAS: return createRosettaTypeAlias();
			case RosettaPackage.ROSETTA_META_TYPE: return createRosettaMetaType();
			case RosettaPackage.ROSETTA_ENUMERATION: return createRosettaEnumeration();
			case RosettaPackage.ROSETTA_ENUM_VALUE: return createRosettaEnumValue();
			case RosettaPackage.ROSETTA_ENUM_VALUE_REFERENCE: return createRosettaEnumValueReference();
			case RosettaPackage.ROSETTA_CARDINALITY: return createRosettaCardinality();
			case RosettaPackage.ROSETTA_SYNONYM_VALUE_BASE: return createRosettaSynonymValueBase();
			case RosettaPackage.ROSETTA_CLASS_SYNONYM: return createRosettaClassSynonym();
			case RosettaPackage.ROSETTA_SYNONYM: return createRosettaSynonym();
			case RosettaPackage.ROSETTA_SYNONYM_BODY: return createRosettaSynonymBody();
			case RosettaPackage.ROSETTA_MERGE_SYNONYM_VALUE: return createRosettaMergeSynonymValue();
			case RosettaPackage.ROSETTA_ENUM_SYNONYM: return createRosettaEnumSynonym();
			case RosettaPackage.ROSETTA_DOC_REFERENCE: return createRosettaDocReference();
			case RosettaPackage.REGULATORY_DOCUMENT_REFERENCE: return createRegulatoryDocumentReference();
			case RosettaPackage.ROSETTA_SEGMENT_REF: return createRosettaSegmentRef();
			case RosettaPackage.DOCUMENT_RATIONALE: return createDocumentRationale();
			case RosettaPackage.ROSETTA_BODY: return createRosettaBody();
			case RosettaPackage.ROSETTA_CORPUS: return createRosettaCorpus();
			case RosettaPackage.ROSETTA_SEGMENT: return createRosettaSegment();
			case RosettaPackage.ROSETTA_MAP_PATH_VALUE: return createRosettaMapPathValue();
			case RosettaPackage.ROSETTA_MAP_TEST_EXISTS_EXPRESSION: return createRosettaMapTestExistsExpression();
			case RosettaPackage.ROSETTA_MAP_TEST_ABSENT_EXPRESSION: return createRosettaMapTestAbsentExpression();
			case RosettaPackage.ROSETTA_MAP_TEST_EQUALITY_OPERATION: return createRosettaMapTestEqualityOperation();
			case RosettaPackage.ROSETTA_MAP_TEST_FUNC: return createRosettaMapTestFunc();
			case RosettaPackage.ROSETTA_DATA_REFERENCE: return createRosettaDataReference();
			case RosettaPackage.ROSETTA_ATTRIBUTE_REFERENCE: return createRosettaAttributeReference();
			case RosettaPackage.ROSETTA_MAPPING: return createRosettaMapping();
			case RosettaPackage.ROSETTA_MAPPING_INSTANCE: return createRosettaMappingInstance();
			case RosettaPackage.ROSETTA_MAPPING_PATH_TESTS: return createRosettaMappingPathTests();
			case RosettaPackage.ROSETTA_MAP_PATH: return createRosettaMapPath();
			case RosettaPackage.ROSETTA_MAP_ROSETTA_PATH: return createRosettaMapRosettaPath();
			case RosettaPackage.ROSETTA_QUALIFIABLE_CONFIGURATION: return createRosettaQualifiableConfiguration();
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS: return createRosettaExternalClass();
			case RosettaPackage.ROSETTA_EXTERNAL_ENUM: return createRosettaExternalEnum();
			case RosettaPackage.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE: return createRosettaExternalRegularAttribute();
			case RosettaPackage.ROSETTA_EXTERNAL_ENUM_VALUE: return createRosettaExternalEnumValue();
			case RosettaPackage.ROSETTA_EXTERNAL_CLASS_SYNONYM: return createRosettaExternalClassSynonym();
			case RosettaPackage.ROSETTA_EXTERNAL_SYNONYM: return createRosettaExternalSynonym();
			case RosettaPackage.ROSETTA_EXTERNAL_SYNONYM_SOURCE: return createRosettaExternalSynonymSource();
			case RosettaPackage.ROSETTA_EXTERNAL_RULE_SOURCE: return createRosettaExternalRuleSource();
			case RosettaPackage.ROSETTA_REPORT: return createRosettaReport();
			case RosettaPackage.ROSETTA_RULE: return createRosettaRule();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case RosettaPackage.ROSETTA_SYNONYM_REF:
				return createRosettaSynonymRefFromString(eDataType, initialValue);
			case RosettaPackage.ROSETTA_QUALIFIABLE_TYPE:
				return createRosettaQualifiableTypeFromString(eDataType, initialValue);
			case RosettaPackage.EXTERNAL_VALUE_OPERATOR:
				return createExternalValueOperatorFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case RosettaPackage.ROSETTA_SYNONYM_REF:
				return convertRosettaSynonymRefToString(eDataType, instanceValue);
			case RosettaPackage.ROSETTA_QUALIFIABLE_TYPE:
				return convertRosettaQualifiableTypeToString(eDataType, instanceValue);
			case RosettaPackage.EXTERNAL_VALUE_OPERATOR:
				return convertExternalValueOperatorToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaModel createRosettaModel() {
		RosettaModelImpl rosettaModel = new RosettaModelImpl();
		return rosettaModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Import createImport() {
		ImportImpl import_ = new ImportImpl();
		return import_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaFeature createRosettaFeature() {
		RosettaFeatureImpl rosettaFeature = new RosettaFeatureImpl();
		return rosettaFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaTypedFeature createRosettaTypedFeature() {
		RosettaTypedFeatureImpl rosettaTypedFeature = new RosettaTypedFeatureImpl();
		return rosettaTypedFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TypeCall createTypeCall() {
		TypeCallImpl typeCall = new TypeCallImpl();
		return typeCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TypeCallArgument createTypeCallArgument() {
		TypeCallArgumentImpl typeCallArgument = new TypeCallArgumentImpl();
		return typeCallArgument;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaBasicType createRosettaBasicType() {
		RosettaBasicTypeImpl rosettaBasicType = new RosettaBasicTypeImpl();
		return rosettaBasicType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TypeParameter createTypeParameter() {
		TypeParameterImpl typeParameter = new TypeParameterImpl();
		return typeParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaSynonymSource createRosettaSynonymSource() {
		RosettaSynonymSourceImpl rosettaSynonymSource = new RosettaSynonymSourceImpl();
		return rosettaSynonymSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaRecordType createRosettaRecordType() {
		RosettaRecordTypeImpl rosettaRecordType = new RosettaRecordTypeImpl();
		return rosettaRecordType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaRecordFeature createRosettaRecordFeature() {
		RosettaRecordFeatureImpl rosettaRecordFeature = new RosettaRecordFeatureImpl();
		return rosettaRecordFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalFunction createRosettaExternalFunction() {
		RosettaExternalFunctionImpl rosettaExternalFunction = new RosettaExternalFunctionImpl();
		return rosettaExternalFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaParameter createRosettaParameter() {
		RosettaParameterImpl rosettaParameter = new RosettaParameterImpl();
		return rosettaParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaTypeAlias createRosettaTypeAlias() {
		RosettaTypeAliasImpl rosettaTypeAlias = new RosettaTypeAliasImpl();
		return rosettaTypeAlias;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMetaType createRosettaMetaType() {
		RosettaMetaTypeImpl rosettaMetaType = new RosettaMetaTypeImpl();
		return rosettaMetaType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaEnumeration createRosettaEnumeration() {
		RosettaEnumerationImpl rosettaEnumeration = new RosettaEnumerationImpl();
		return rosettaEnumeration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaEnumValue createRosettaEnumValue() {
		RosettaEnumValueImpl rosettaEnumValue = new RosettaEnumValueImpl();
		return rosettaEnumValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaEnumValueReference createRosettaEnumValueReference() {
		RosettaEnumValueReferenceImpl rosettaEnumValueReference = new RosettaEnumValueReferenceImpl();
		return rosettaEnumValueReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaCardinality createRosettaCardinality() {
		RosettaCardinalityImpl rosettaCardinality = new RosettaCardinalityImpl();
		return rosettaCardinality;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaSynonymValueBase createRosettaSynonymValueBase() {
		RosettaSynonymValueBaseImpl rosettaSynonymValueBase = new RosettaSynonymValueBaseImpl();
		return rosettaSynonymValueBase;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaClassSynonym createRosettaClassSynonym() {
		RosettaClassSynonymImpl rosettaClassSynonym = new RosettaClassSynonymImpl();
		return rosettaClassSynonym;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaSynonym createRosettaSynonym() {
		RosettaSynonymImpl rosettaSynonym = new RosettaSynonymImpl();
		return rosettaSynonym;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaSynonymBody createRosettaSynonymBody() {
		RosettaSynonymBodyImpl rosettaSynonymBody = new RosettaSynonymBodyImpl();
		return rosettaSynonymBody;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMergeSynonymValue createRosettaMergeSynonymValue() {
		RosettaMergeSynonymValueImpl rosettaMergeSynonymValue = new RosettaMergeSynonymValueImpl();
		return rosettaMergeSynonymValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaEnumSynonym createRosettaEnumSynonym() {
		RosettaEnumSynonymImpl rosettaEnumSynonym = new RosettaEnumSynonymImpl();
		return rosettaEnumSynonym;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaDocReference createRosettaDocReference() {
		RosettaDocReferenceImpl rosettaDocReference = new RosettaDocReferenceImpl();
		return rosettaDocReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RegulatoryDocumentReference createRegulatoryDocumentReference() {
		RegulatoryDocumentReferenceImpl regulatoryDocumentReference = new RegulatoryDocumentReferenceImpl();
		return regulatoryDocumentReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaSegmentRef createRosettaSegmentRef() {
		RosettaSegmentRefImpl rosettaSegmentRef = new RosettaSegmentRefImpl();
		return rosettaSegmentRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentRationale createDocumentRationale() {
		DocumentRationaleImpl documentRationale = new DocumentRationaleImpl();
		return documentRationale;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaBody createRosettaBody() {
		RosettaBodyImpl rosettaBody = new RosettaBodyImpl();
		return rosettaBody;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaCorpus createRosettaCorpus() {
		RosettaCorpusImpl rosettaCorpus = new RosettaCorpusImpl();
		return rosettaCorpus;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaSegment createRosettaSegment() {
		RosettaSegmentImpl rosettaSegment = new RosettaSegmentImpl();
		return rosettaSegment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMapPathValue createRosettaMapPathValue() {
		RosettaMapPathValueImpl rosettaMapPathValue = new RosettaMapPathValueImpl();
		return rosettaMapPathValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMapTestExistsExpression createRosettaMapTestExistsExpression() {
		RosettaMapTestExistsExpressionImpl rosettaMapTestExistsExpression = new RosettaMapTestExistsExpressionImpl();
		return rosettaMapTestExistsExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMapTestAbsentExpression createRosettaMapTestAbsentExpression() {
		RosettaMapTestAbsentExpressionImpl rosettaMapTestAbsentExpression = new RosettaMapTestAbsentExpressionImpl();
		return rosettaMapTestAbsentExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMapTestEqualityOperation createRosettaMapTestEqualityOperation() {
		RosettaMapTestEqualityOperationImpl rosettaMapTestEqualityOperation = new RosettaMapTestEqualityOperationImpl();
		return rosettaMapTestEqualityOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMapTestFunc createRosettaMapTestFunc() {
		RosettaMapTestFuncImpl rosettaMapTestFunc = new RosettaMapTestFuncImpl();
		return rosettaMapTestFunc;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaDataReference createRosettaDataReference() {
		RosettaDataReferenceImpl rosettaDataReference = new RosettaDataReferenceImpl();
		return rosettaDataReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaAttributeReference createRosettaAttributeReference() {
		RosettaAttributeReferenceImpl rosettaAttributeReference = new RosettaAttributeReferenceImpl();
		return rosettaAttributeReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMapping createRosettaMapping() {
		RosettaMappingImpl rosettaMapping = new RosettaMappingImpl();
		return rosettaMapping;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMappingInstance createRosettaMappingInstance() {
		RosettaMappingInstanceImpl rosettaMappingInstance = new RosettaMappingInstanceImpl();
		return rosettaMappingInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMappingPathTests createRosettaMappingPathTests() {
		RosettaMappingPathTestsImpl rosettaMappingPathTests = new RosettaMappingPathTestsImpl();
		return rosettaMappingPathTests;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMapPath createRosettaMapPath() {
		RosettaMapPathImpl rosettaMapPath = new RosettaMapPathImpl();
		return rosettaMapPath;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaMapRosettaPath createRosettaMapRosettaPath() {
		RosettaMapRosettaPathImpl rosettaMapRosettaPath = new RosettaMapRosettaPathImpl();
		return rosettaMapRosettaPath;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaQualifiableConfiguration createRosettaQualifiableConfiguration() {
		RosettaQualifiableConfigurationImpl rosettaQualifiableConfiguration = new RosettaQualifiableConfigurationImpl();
		return rosettaQualifiableConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalClass createRosettaExternalClass() {
		RosettaExternalClassImpl rosettaExternalClass = new RosettaExternalClassImpl();
		return rosettaExternalClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalEnum createRosettaExternalEnum() {
		RosettaExternalEnumImpl rosettaExternalEnum = new RosettaExternalEnumImpl();
		return rosettaExternalEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalRegularAttribute createRosettaExternalRegularAttribute() {
		RosettaExternalRegularAttributeImpl rosettaExternalRegularAttribute = new RosettaExternalRegularAttributeImpl();
		return rosettaExternalRegularAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalEnumValue createRosettaExternalEnumValue() {
		RosettaExternalEnumValueImpl rosettaExternalEnumValue = new RosettaExternalEnumValueImpl();
		return rosettaExternalEnumValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalClassSynonym createRosettaExternalClassSynonym() {
		RosettaExternalClassSynonymImpl rosettaExternalClassSynonym = new RosettaExternalClassSynonymImpl();
		return rosettaExternalClassSynonym;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalSynonym createRosettaExternalSynonym() {
		RosettaExternalSynonymImpl rosettaExternalSynonym = new RosettaExternalSynonymImpl();
		return rosettaExternalSynonym;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalSynonymSource createRosettaExternalSynonymSource() {
		RosettaExternalSynonymSourceImpl rosettaExternalSynonymSource = new RosettaExternalSynonymSourceImpl();
		return rosettaExternalSynonymSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExternalRuleSource createRosettaExternalRuleSource() {
		RosettaExternalRuleSourceImpl rosettaExternalRuleSource = new RosettaExternalRuleSourceImpl();
		return rosettaExternalRuleSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaReport createRosettaReport() {
		RosettaReportImpl rosettaReport = new RosettaReportImpl();
		return rosettaReport;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaRule createRosettaRule() {
		RosettaRuleImpl rosettaRule = new RosettaRuleImpl();
		return rosettaRule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaSynonymRef createRosettaSynonymRefFromString(EDataType eDataType, String initialValue) {
		RosettaSynonymRef result = RosettaSynonymRef.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertRosettaSynonymRefToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RosettaQualifiableType createRosettaQualifiableTypeFromString(EDataType eDataType, String initialValue) {
		RosettaQualifiableType result = RosettaQualifiableType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertRosettaQualifiableTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalValueOperator createExternalValueOperatorFromString(EDataType eDataType, String initialValue) {
		ExternalValueOperator result = ExternalValueOperator.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertExternalValueOperatorToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaPackage getRosettaPackage() {
		return (RosettaPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static RosettaPackage getPackage() {
		return RosettaPackage.eINSTANCE;
	}

} //RosettaFactoryImpl
