/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.simple.impl;

import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaPackage;

import com.regnosys.rosetta.rosetta.expression.RosettaExpression;

import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.References;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Condition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl#getDefinition <em>Definition</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl#getName <em>Name</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl#getReferences <em>References</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl#isPostCondition <em>Post Condition</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.ConditionImpl#getExpression <em>Expression</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ConditionImpl extends MinimalEObjectImpl.Container implements Condition {
	/**
	 * The default value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected static final String DEFINITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected String definition = DEFINITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<AnnotationRef> annotations;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getReferences() <em>References</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferences()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaDocReference> references;

	/**
	 * The default value of the '{@link #isPostCondition() <em>Post Condition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPostCondition()
	 * @generated
	 * @ordered
	 */
	protected static final boolean POST_CONDITION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isPostCondition() <em>Post Condition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPostCondition()
	 * @generated
	 * @ordered
	 */
	protected boolean postCondition = POST_CONDITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getExpression() <em>Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExpression()
	 * @generated
	 * @ordered
	 */
	protected RosettaExpression expression;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SimplePackage.Literals.CONDITION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDefinition() {
		return definition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDefinition(String newDefinition) {
		String oldDefinition = definition;
		definition = newDefinition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.CONDITION__DEFINITION, oldDefinition, definition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<AnnotationRef> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<AnnotationRef>(AnnotationRef.class, this, SimplePackage.CONDITION__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.CONDITION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaDocReference> getReferences() {
		if (references == null) {
			references = new EObjectContainmentEList<RosettaDocReference>(RosettaDocReference.class, this, SimplePackage.CONDITION__REFERENCES);
		}
		return references;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isPostCondition() {
		return postCondition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPostCondition(boolean newPostCondition) {
		boolean oldPostCondition = postCondition;
		postCondition = newPostCondition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.CONDITION__POST_CONDITION, oldPostCondition, postCondition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RosettaExpression getExpression() {
		return expression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExpression(RosettaExpression newExpression, NotificationChain msgs) {
		RosettaExpression oldExpression = expression;
		expression = newExpression;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SimplePackage.CONDITION__EXPRESSION, oldExpression, newExpression);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setExpression(RosettaExpression newExpression) {
		if (newExpression != expression) {
			NotificationChain msgs = null;
			if (expression != null)
				msgs = ((InternalEObject)expression).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SimplePackage.CONDITION__EXPRESSION, null, msgs);
			if (newExpression != null)
				msgs = ((InternalEObject)newExpression).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SimplePackage.CONDITION__EXPRESSION, null, msgs);
			msgs = basicSetExpression(newExpression, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.CONDITION__EXPRESSION, newExpression, newExpression));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SimplePackage.CONDITION__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
			case SimplePackage.CONDITION__REFERENCES:
				return ((InternalEList<?>)getReferences()).basicRemove(otherEnd, msgs);
			case SimplePackage.CONDITION__EXPRESSION:
				return basicSetExpression(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SimplePackage.CONDITION__DEFINITION:
				return getDefinition();
			case SimplePackage.CONDITION__ANNOTATIONS:
				return getAnnotations();
			case SimplePackage.CONDITION__NAME:
				return getName();
			case SimplePackage.CONDITION__REFERENCES:
				return getReferences();
			case SimplePackage.CONDITION__POST_CONDITION:
				return isPostCondition();
			case SimplePackage.CONDITION__EXPRESSION:
				return getExpression();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SimplePackage.CONDITION__DEFINITION:
				setDefinition((String)newValue);
				return;
			case SimplePackage.CONDITION__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends AnnotationRef>)newValue);
				return;
			case SimplePackage.CONDITION__NAME:
				setName((String)newValue);
				return;
			case SimplePackage.CONDITION__REFERENCES:
				getReferences().clear();
				getReferences().addAll((Collection<? extends RosettaDocReference>)newValue);
				return;
			case SimplePackage.CONDITION__POST_CONDITION:
				setPostCondition((Boolean)newValue);
				return;
			case SimplePackage.CONDITION__EXPRESSION:
				setExpression((RosettaExpression)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SimplePackage.CONDITION__DEFINITION:
				setDefinition(DEFINITION_EDEFAULT);
				return;
			case SimplePackage.CONDITION__ANNOTATIONS:
				getAnnotations().clear();
				return;
			case SimplePackage.CONDITION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case SimplePackage.CONDITION__REFERENCES:
				getReferences().clear();
				return;
			case SimplePackage.CONDITION__POST_CONDITION:
				setPostCondition(POST_CONDITION_EDEFAULT);
				return;
			case SimplePackage.CONDITION__EXPRESSION:
				setExpression((RosettaExpression)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SimplePackage.CONDITION__DEFINITION:
				return DEFINITION_EDEFAULT == null ? definition != null : !DEFINITION_EDEFAULT.equals(definition);
			case SimplePackage.CONDITION__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
			case SimplePackage.CONDITION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case SimplePackage.CONDITION__REFERENCES:
				return references != null && !references.isEmpty();
			case SimplePackage.CONDITION__POST_CONDITION:
				return postCondition != POST_CONDITION_EDEFAULT;
			case SimplePackage.CONDITION__EXPRESSION:
				return expression != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Annotated.class) {
			switch (derivedFeatureID) {
				case SimplePackage.CONDITION__ANNOTATIONS: return SimplePackage.ANNOTATED__ANNOTATIONS;
				default: return -1;
			}
		}
		if (baseClass == RosettaNamed.class) {
			switch (derivedFeatureID) {
				case SimplePackage.CONDITION__NAME: return RosettaPackage.ROSETTA_NAMED__NAME;
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (derivedFeatureID) {
				case SimplePackage.CONDITION__REFERENCES: return SimplePackage.REFERENCES__REFERENCES;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Annotated.class) {
			switch (baseFeatureID) {
				case SimplePackage.ANNOTATED__ANNOTATIONS: return SimplePackage.CONDITION__ANNOTATIONS;
				default: return -1;
			}
		}
		if (baseClass == RosettaNamed.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_NAMED__NAME: return SimplePackage.CONDITION__NAME;
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (baseFeatureID) {
				case SimplePackage.REFERENCES__REFERENCES: return SimplePackage.CONDITION__REFERENCES;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (definition: ");
		result.append(definition);
		result.append(", name: ");
		result.append(name);
		result.append(", postCondition: ");
		result.append(postCondition);
		result.append(')');
		return result.toString();
	}

} //ConditionImpl
