/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.simple.impl;

import com.regnosys.rosetta.rosetta.RosettaClassSynonym;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaPackage;

import com.regnosys.rosetta.rosetta.impl.RosettaTypeImpl;

import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.References;
import com.regnosys.rosetta.rosetta.simple.RootElement;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.DataImpl#getDefinition <em>Definition</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.DataImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.DataImpl#getReferences <em>References</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.DataImpl#getSuperType <em>Super Type</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.DataImpl#getSynonyms <em>Synonyms</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.DataImpl#getAttributes <em>Attributes</em>}</li>
 *   <li>{@link com.regnosys.rosetta.rosetta.simple.impl.DataImpl#getConditions <em>Conditions</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DataImpl extends RosettaTypeImpl implements Data {
	/**
	 * The default value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected static final String DEFINITION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDefinition() <em>Definition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefinition()
	 * @generated
	 * @ordered
	 */
	protected String definition = DEFINITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList<AnnotationRef> annotations;

	/**
	 * The cached value of the '{@link #getReferences() <em>References</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferences()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaDocReference> references;

	/**
	 * The cached value of the '{@link #getSuperType() <em>Super Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSuperType()
	 * @generated
	 * @ordered
	 */
	protected Data superType;

	/**
	 * The cached value of the '{@link #getSynonyms() <em>Synonyms</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSynonyms()
	 * @generated
	 * @ordered
	 */
	protected EList<RosettaClassSynonym> synonyms;

	/**
	 * The cached value of the '{@link #getAttributes() <em>Attributes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList<Attribute> attributes;

	/**
	 * The cached value of the '{@link #getConditions() <em>Conditions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConditions()
	 * @generated
	 * @ordered
	 */
	protected EList<Condition> conditions;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SimplePackage.Literals.DATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDefinition() {
		return definition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDefinition(String newDefinition) {
		String oldDefinition = definition;
		definition = newDefinition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.DATA__DEFINITION, oldDefinition, definition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<AnnotationRef> getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList<AnnotationRef>(AnnotationRef.class, this, SimplePackage.DATA__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaDocReference> getReferences() {
		if (references == null) {
			references = new EObjectContainmentEList<RosettaDocReference>(RosettaDocReference.class, this, SimplePackage.DATA__REFERENCES);
		}
		return references;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Data getSuperType() {
		if (superType != null && superType.eIsProxy()) {
			InternalEObject oldSuperType = (InternalEObject)superType;
			superType = (Data)eResolveProxy(oldSuperType);
			if (superType != oldSuperType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SimplePackage.DATA__SUPER_TYPE, oldSuperType, superType));
			}
		}
		return superType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Data basicGetSuperType() {
		return superType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSuperType(Data newSuperType) {
		Data oldSuperType = superType;
		superType = newSuperType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimplePackage.DATA__SUPER_TYPE, oldSuperType, superType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RosettaClassSynonym> getSynonyms() {
		if (synonyms == null) {
			synonyms = new EObjectContainmentEList<RosettaClassSynonym>(RosettaClassSynonym.class, this, SimplePackage.DATA__SYNONYMS);
		}
		return synonyms;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Attribute> getAttributes() {
		if (attributes == null) {
			attributes = new EObjectContainmentEList<Attribute>(Attribute.class, this, SimplePackage.DATA__ATTRIBUTES);
		}
		return attributes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Condition> getConditions() {
		if (conditions == null) {
			conditions = new EObjectContainmentEList<Condition>(Condition.class, this, SimplePackage.DATA__CONDITIONS);
		}
		return conditions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean hasSuperType() {
		Data _superType = this.getSuperType();
		return (_superType != null);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SimplePackage.DATA__ANNOTATIONS:
				return ((InternalEList<?>)getAnnotations()).basicRemove(otherEnd, msgs);
			case SimplePackage.DATA__REFERENCES:
				return ((InternalEList<?>)getReferences()).basicRemove(otherEnd, msgs);
			case SimplePackage.DATA__SYNONYMS:
				return ((InternalEList<?>)getSynonyms()).basicRemove(otherEnd, msgs);
			case SimplePackage.DATA__ATTRIBUTES:
				return ((InternalEList<?>)getAttributes()).basicRemove(otherEnd, msgs);
			case SimplePackage.DATA__CONDITIONS:
				return ((InternalEList<?>)getConditions()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SimplePackage.DATA__DEFINITION:
				return getDefinition();
			case SimplePackage.DATA__ANNOTATIONS:
				return getAnnotations();
			case SimplePackage.DATA__REFERENCES:
				return getReferences();
			case SimplePackage.DATA__SUPER_TYPE:
				if (resolve) return getSuperType();
				return basicGetSuperType();
			case SimplePackage.DATA__SYNONYMS:
				return getSynonyms();
			case SimplePackage.DATA__ATTRIBUTES:
				return getAttributes();
			case SimplePackage.DATA__CONDITIONS:
				return getConditions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SimplePackage.DATA__DEFINITION:
				setDefinition((String)newValue);
				return;
			case SimplePackage.DATA__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection<? extends AnnotationRef>)newValue);
				return;
			case SimplePackage.DATA__REFERENCES:
				getReferences().clear();
				getReferences().addAll((Collection<? extends RosettaDocReference>)newValue);
				return;
			case SimplePackage.DATA__SUPER_TYPE:
				setSuperType((Data)newValue);
				return;
			case SimplePackage.DATA__SYNONYMS:
				getSynonyms().clear();
				getSynonyms().addAll((Collection<? extends RosettaClassSynonym>)newValue);
				return;
			case SimplePackage.DATA__ATTRIBUTES:
				getAttributes().clear();
				getAttributes().addAll((Collection<? extends Attribute>)newValue);
				return;
			case SimplePackage.DATA__CONDITIONS:
				getConditions().clear();
				getConditions().addAll((Collection<? extends Condition>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SimplePackage.DATA__DEFINITION:
				setDefinition(DEFINITION_EDEFAULT);
				return;
			case SimplePackage.DATA__ANNOTATIONS:
				getAnnotations().clear();
				return;
			case SimplePackage.DATA__REFERENCES:
				getReferences().clear();
				return;
			case SimplePackage.DATA__SUPER_TYPE:
				setSuperType((Data)null);
				return;
			case SimplePackage.DATA__SYNONYMS:
				getSynonyms().clear();
				return;
			case SimplePackage.DATA__ATTRIBUTES:
				getAttributes().clear();
				return;
			case SimplePackage.DATA__CONDITIONS:
				getConditions().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SimplePackage.DATA__DEFINITION:
				return DEFINITION_EDEFAULT == null ? definition != null : !DEFINITION_EDEFAULT.equals(definition);
			case SimplePackage.DATA__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
			case SimplePackage.DATA__REFERENCES:
				return references != null && !references.isEmpty();
			case SimplePackage.DATA__SUPER_TYPE:
				return superType != null;
			case SimplePackage.DATA__SYNONYMS:
				return synonyms != null && !synonyms.isEmpty();
			case SimplePackage.DATA__ATTRIBUTES:
				return attributes != null && !attributes.isEmpty();
			case SimplePackage.DATA__CONDITIONS:
				return conditions != null && !conditions.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaDefinable.class) {
			switch (derivedFeatureID) {
				case SimplePackage.DATA__DEFINITION: return RosettaPackage.ROSETTA_DEFINABLE__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == Annotated.class) {
			switch (derivedFeatureID) {
				case SimplePackage.DATA__ANNOTATIONS: return SimplePackage.ANNOTATED__ANNOTATIONS;
				default: return -1;
			}
		}
		if (baseClass == RootElement.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (derivedFeatureID) {
				case SimplePackage.DATA__REFERENCES: return SimplePackage.REFERENCES__REFERENCES;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == RosettaDefinable.class) {
			switch (baseFeatureID) {
				case RosettaPackage.ROSETTA_DEFINABLE__DEFINITION: return SimplePackage.DATA__DEFINITION;
				default: return -1;
			}
		}
		if (baseClass == Annotated.class) {
			switch (baseFeatureID) {
				case SimplePackage.ANNOTATED__ANNOTATIONS: return SimplePackage.DATA__ANNOTATIONS;
				default: return -1;
			}
		}
		if (baseClass == RootElement.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		if (baseClass == References.class) {
			switch (baseFeatureID) {
				case SimplePackage.REFERENCES__REFERENCES: return SimplePackage.DATA__REFERENCES;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (definition: ");
		result.append(definition);
		result.append(')');
		return result.toString();
	}

} //DataImpl
