/**
 * Copyright (c) REGnosys 2017 (www.regnosys.com)
 */
package com.regnosys.rosetta.rosetta.simple.util;

import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTyped;
import com.regnosys.rosetta.rosetta.RosettaTypedFeature;

import com.regnosys.rosetta.rosetta.simple.*;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see com.regnosys.rosetta.rosetta.simple.SimplePackage
 * @generated
 */
public class SimpleSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static SimplePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimpleSwitch() {
		if (modelPackage == null) {
			modelPackage = SimplePackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case SimplePackage.ROOT_ELEMENT: {
				RootElement rootElement = (RootElement)theEObject;
				T result = caseRootElement(rootElement);
				if (result == null) result = caseRosettaRootElement(rootElement);
				if (result == null) result = caseRosettaNamed(rootElement);
				if (result == null) result = caseRosettaDefinable(rootElement);
				if (result == null) result = caseAnnotated(rootElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.ANNOTATION: {
				Annotation annotation = (Annotation)theEObject;
				T result = caseAnnotation(annotation);
				if (result == null) result = caseRootElement(annotation);
				if (result == null) result = caseRosettaRootElement(annotation);
				if (result == null) result = caseRosettaNamed(annotation);
				if (result == null) result = caseRosettaDefinable(annotation);
				if (result == null) result = caseAnnotated(annotation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.ANNOTATED: {
				Annotated annotated = (Annotated)theEObject;
				T result = caseAnnotated(annotated);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.ANNOTATION_QUALIFIER: {
				AnnotationQualifier annotationQualifier = (AnnotationQualifier)theEObject;
				T result = caseAnnotationQualifier(annotationQualifier);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.ANNOTATION_REF: {
				AnnotationRef annotationRef = (AnnotationRef)theEObject;
				T result = caseAnnotationRef(annotationRef);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.ASSIGN_PATH_ROOT: {
				AssignPathRoot assignPathRoot = (AssignPathRoot)theEObject;
				T result = caseAssignPathRoot(assignPathRoot);
				if (result == null) result = caseRosettaSymbol(assignPathRoot);
				if (result == null) result = caseRosettaNamed(assignPathRoot);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.ATTRIBUTE: {
				Attribute attribute = (Attribute)theEObject;
				T result = caseAttribute(attribute);
				if (result == null) result = caseRosettaTypedFeature(attribute);
				if (result == null) result = caseRosettaDefinable(attribute);
				if (result == null) result = caseAnnotated(attribute);
				if (result == null) result = caseAssignPathRoot(attribute);
				if (result == null) result = caseReferences(attribute);
				if (result == null) result = caseRosettaFeature(attribute);
				if (result == null) result = caseRosettaTyped(attribute);
				if (result == null) result = caseRosettaSymbol(attribute);
				if (result == null) result = caseRosettaNamed(attribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.DATA: {
				Data data = (Data)theEObject;
				T result = caseData(data);
				if (result == null) result = caseRosettaType(data);
				if (result == null) result = caseRootElement(data);
				if (result == null) result = caseReferences(data);
				if (result == null) result = caseRosettaRootElement(data);
				if (result == null) result = caseRosettaNamed(data);
				if (result == null) result = caseRosettaDefinable(data);
				if (result == null) result = caseAnnotated(data);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.CHOICE: {
				Choice choice = (Choice)theEObject;
				T result = caseChoice(choice);
				if (result == null) result = caseData(choice);
				if (result == null) result = caseRosettaType(choice);
				if (result == null) result = caseRootElement(choice);
				if (result == null) result = caseReferences(choice);
				if (result == null) result = caseRosettaRootElement(choice);
				if (result == null) result = caseRosettaNamed(choice);
				if (result == null) result = caseRosettaDefinable(choice);
				if (result == null) result = caseAnnotated(choice);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.CHOICE_OPTION: {
				ChoiceOption choiceOption = (ChoiceOption)theEObject;
				T result = caseChoiceOption(choiceOption);
				if (result == null) result = caseAttribute(choiceOption);
				if (result == null) result = caseRosettaTypedFeature(choiceOption);
				if (result == null) result = caseRosettaDefinable(choiceOption);
				if (result == null) result = caseAnnotated(choiceOption);
				if (result == null) result = caseAssignPathRoot(choiceOption);
				if (result == null) result = caseReferences(choiceOption);
				if (result == null) result = caseRosettaFeature(choiceOption);
				if (result == null) result = caseRosettaTyped(choiceOption);
				if (result == null) result = caseRosettaSymbol(choiceOption);
				if (result == null) result = caseRosettaNamed(choiceOption);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.FUNCTION: {
				Function function = (Function)theEObject;
				T result = caseFunction(function);
				if (result == null) result = caseRootElement(function);
				if (result == null) result = caseRosettaCallableWithArgs(function);
				if (result == null) result = caseReferences(function);
				if (result == null) result = caseRosettaRootElement(function);
				if (result == null) result = caseRosettaDefinable(function);
				if (result == null) result = caseAnnotated(function);
				if (result == null) result = caseRosettaSymbol(function);
				if (result == null) result = caseRosettaNamed(function);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.FUNCTION_DISPATCH: {
				FunctionDispatch functionDispatch = (FunctionDispatch)theEObject;
				T result = caseFunctionDispatch(functionDispatch);
				if (result == null) result = caseFunction(functionDispatch);
				if (result == null) result = caseRootElement(functionDispatch);
				if (result == null) result = caseRosettaCallableWithArgs(functionDispatch);
				if (result == null) result = caseReferences(functionDispatch);
				if (result == null) result = caseRosettaRootElement(functionDispatch);
				if (result == null) result = caseRosettaDefinable(functionDispatch);
				if (result == null) result = caseAnnotated(functionDispatch);
				if (result == null) result = caseRosettaSymbol(functionDispatch);
				if (result == null) result = caseRosettaNamed(functionDispatch);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.CONDITION: {
				Condition condition = (Condition)theEObject;
				T result = caseCondition(condition);
				if (result == null) result = caseRosettaDefinable(condition);
				if (result == null) result = caseAnnotated(condition);
				if (result == null) result = caseRosettaNamed(condition);
				if (result == null) result = caseReferences(condition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.OPERATION: {
				Operation operation = (Operation)theEObject;
				T result = caseOperation(operation);
				if (result == null) result = caseRosettaDefinable(operation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.SEGMENT: {
				Segment segment = (Segment)theEObject;
				T result = caseSegment(segment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.SHORTCUT_DECLARATION: {
				ShortcutDeclaration shortcutDeclaration = (ShortcutDeclaration)theEObject;
				T result = caseShortcutDeclaration(shortcutDeclaration);
				if (result == null) result = caseRosettaDefinable(shortcutDeclaration);
				if (result == null) result = caseAssignPathRoot(shortcutDeclaration);
				if (result == null) result = caseRosettaSymbol(shortcutDeclaration);
				if (result == null) result = caseRosettaNamed(shortcutDeclaration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.REFERENCES: {
				References references = (References)theEObject;
				T result = caseReferences(references);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimplePackage.ROSETTA_RULE_REFERENCE: {
				RosettaRuleReference rosettaRuleReference = (RosettaRuleReference)theEObject;
				T result = caseRosettaRuleReference(rosettaRuleReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Root Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Root Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRootElement(RootElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Annotation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Annotation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnnotation(Annotation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Annotated</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Annotated</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnnotated(Annotated object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Annotation Qualifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Annotation Qualifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnnotationQualifier(AnnotationQualifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Annotation Ref</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Annotation Ref</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnnotationRef(AnnotationRef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Assign Path Root</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Assign Path Root</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssignPathRoot(AssignPathRoot object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttribute(Attribute object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseData(Data object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Choice</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Choice</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseChoice(Choice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Choice Option</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Choice Option</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseChoiceOption(ChoiceOption object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Function</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFunction(Function object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Function Dispatch</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Function Dispatch</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFunctionDispatch(FunctionDispatch object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Condition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Condition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCondition(Condition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOperation(Operation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Segment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSegment(Segment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Shortcut Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Shortcut Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseShortcutDeclaration(ShortcutDeclaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>References</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>References</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReferences(References object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rosetta Rule Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rosetta Rule Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaRuleReference(RosettaRuleReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Root Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Root Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaRootElement(RosettaRootElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaNamed(RosettaNamed object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Definable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Definable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaDefinable(RosettaDefinable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Symbol</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Symbol</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaSymbol(RosettaSymbol object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Feature</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Feature</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaFeature(RosettaFeature object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Typed</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Typed</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaTyped(RosettaTyped object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Typed Feature</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Typed Feature</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaTypedFeature(RosettaTypedFeature object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaType(RosettaType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Callable With Args</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Callable With Args</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRosettaCallableWithArgs(RosettaCallableWithArgs object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //SimpleSwitch
