package com.regnosys.rosetta.types;

import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.TypeParameter;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.CanHandleListOfLists;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.DistinctOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FirstOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.LastOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.MaxOperation;
import com.regnosys.rosetta.rosetta.expression.MinOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.ReverseOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.expression.SortOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToEnumOperation;
import com.regnosys.rosetta.rosetta.expression.ToIntOperation;
import com.regnosys.rosetta.rosetta.expression.ToNumberOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.ToTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.RosettaExpressionSwitch;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class CardinalityProvider extends RosettaExpressionSwitch<Boolean, Boolean> {
  private static Logger LOGGER = LoggerFactory.getLogger(CardinalityProvider.class);

  @Inject
  @Extension
  private ImplicitVariableUtil _implicitVariableUtil;

  @Inject
  private RosettaTypeProvider typeProvider;

  public boolean isMulti(final RosettaExpression expr) {
    return this.isMulti(expr, false);
  }

  public boolean isMulti(final RosettaExpression expr, final boolean breakOnClosureParameter) {
    Boolean _xblockexpression = null;
    {
      if ((expr == null)) {
        return false;
      }
      _xblockexpression = this.doSwitch(expr, Boolean.valueOf(breakOnClosureParameter));
    }
    return (_xblockexpression).booleanValue();
  }

  public boolean isSymbolMulti(final RosettaSymbol symbol) {
    return this.isSymbolMulti(symbol, false);
  }

  public boolean isFeatureMulti(final RosettaFeature symbol) {
    return this.isFeatureMulti(symbol, false);
  }

  public boolean isSymbolMulti(final RosettaSymbol symbol, final boolean breakOnClosureParameter) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (symbol instanceof RosettaFeature) {
      _matched=true;
      _switchResult = this.isFeatureMulti(((RosettaFeature) symbol), breakOnClosureParameter);
    }
    if (!_matched) {
      if (symbol instanceof ClosureParameter) {
        _matched=true;
        _switchResult = this.isClosureParameterMulti(((ClosureParameter)symbol).getFunction());
      }
    }
    if (!_matched) {
      if (symbol instanceof RosettaEnumeration) {
        _matched=true;
        _switchResult = false;
      }
    }
    if (!_matched) {
      if (symbol instanceof Function) {
        _matched=true;
        boolean _xifexpression = false;
        Attribute _output = ((Function)symbol).getOutput();
        boolean _tripleNotEquals = (_output != null);
        if (_tripleNotEquals) {
          Attribute _output_1 = ((Function)symbol).getOutput();
          _xifexpression = this.isFeatureMulti(((RosettaFeature) _output_1), breakOnClosureParameter);
        } else {
          _xifexpression = false;
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      if (symbol instanceof RosettaRule) {
        _matched=true;
        boolean _xifexpression = false;
        RosettaExpression _expression = ((RosettaRule)symbol).getExpression();
        boolean _tripleNotEquals = (_expression != null);
        if (_tripleNotEquals) {
          _xifexpression = this.isMulti(((RosettaRule)symbol).getExpression(), breakOnClosureParameter);
        } else {
          _xifexpression = false;
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      if (symbol instanceof RosettaExternalFunction) {
        _matched=true;
        _switchResult = false;
      }
    }
    if (!_matched) {
      if (symbol instanceof ShortcutDeclaration) {
        _matched=true;
        _switchResult = this.isMulti(((ShortcutDeclaration)symbol).getExpression(), breakOnClosureParameter);
      }
    }
    if (!_matched) {
      if (symbol instanceof TypeParameter) {
        _matched=true;
        _switchResult = false;
      }
    }
    if (!_matched) {
      boolean _xblockexpression = false;
      {
        EClass _eClass = null;
        if (symbol!=null) {
          _eClass=symbol.eClass();
        }
        String _name = null;
        if (_eClass!=null) {
          _name=_eClass.getName();
        }
        String _plus = ("Cardinality not defined for symbol: " + _name);
        CardinalityProvider.LOGGER.error(_plus);
        _xblockexpression = false;
      }
      _switchResult = _xblockexpression;
    }
    return _switchResult;
  }

  public boolean isFeatureMulti(final RosettaFeature feature, final boolean breakOnClosureParameter) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (feature instanceof Attribute) {
      _matched=true;
      boolean _xifexpression = false;
      RosettaCardinality _card = ((Attribute)feature).getCard();
      boolean _tripleEquals = (_card == null);
      if (_tripleEquals) {
        _xifexpression = false;
      } else {
        _xifexpression = ((Attribute)feature).getCard().isIsMany();
      }
      _switchResult = _xifexpression;
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }

  public Boolean isImplicitVariableMulti(final EObject context) {
    return this.isImplicitVariableMulti(context, false);
  }

  public Boolean isImplicitVariableMulti(final EObject context, final boolean breakOnClosureParameter) {
    Boolean _xblockexpression = null;
    {
      final Optional<EObject> definingContainer = this._implicitVariableUtil.findContainerDefiningImplicitVariable(context);
      final java.util.function.Function<EObject, Boolean> _function = (EObject it) -> {
        boolean _xifexpression = false;
        if ((it instanceof Data)) {
          _xifexpression = false;
        } else {
          boolean _xifexpression_1 = false;
          if ((it instanceof RosettaFunctionalOperation)) {
            _xifexpression_1 = this.isClosureParameterMulti(((RosettaFunctionalOperation)it).getFunction());
          } else {
            boolean _xifexpression_2 = false;
            if ((it instanceof RosettaRule)) {
              _xifexpression_2 = false;
            } else {
              _xifexpression_2 = false;
            }
            _xifexpression_1 = _xifexpression_2;
          }
          _xifexpression = _xifexpression_1;
        }
        return Boolean.valueOf(_xifexpression);
      };
      _xblockexpression = definingContainer.<Boolean>map(_function).orElse(Boolean.valueOf(false));
    }
    return _xblockexpression;
  }

  private boolean isFeatureOfImplicitVariable(final EObject context, final RosettaFeature feature) {
    return IterableExtensions.contains(this.typeProvider.findFeaturesOfImplicitVariable(context), feature);
  }

  private boolean isClosureParameterMulti(final InlineFunction obj) {
    final EObject op = obj.eContainer();
    if ((op instanceof RosettaFunctionalOperation)) {
      if ((op instanceof ThenOperation)) {
        return this.isMulti(((ThenOperation)op).getArgument());
      }
      return this.isOutputListOfLists(((RosettaFunctionalOperation)op).getArgument());
    }
    return false;
  }

  public boolean isItemMulti(final InlineFunction op) {
    return this.isClosureParameterMulti(op);
  }

  /**
   * Does the body of the previous list operation result in a list.
   */
  public boolean isPreviousOperationBodyMulti(final RosettaUnaryOperation expr) {
    final RosettaExpression previousOperation = expr.getArgument();
    if ((previousOperation instanceof RosettaUnaryOperation)) {
      boolean _matched = false;
      if (previousOperation instanceof ThenOperation) {
        _matched=true;
        return this.isMulti(previousOperation);
      }
      if (!_matched) {
        if (previousOperation instanceof MapOperation) {
          _matched=true;
          return this.isMulti(((MapOperation)previousOperation).getFunction().getBody(), false);
        }
      }
      if (!_matched) {
        if (previousOperation instanceof FlattenOperation) {
          _matched=true;
          return false;
        }
      }
      return this.isPreviousOperationBodyMulti(((RosettaUnaryOperation)previousOperation));
    }
    return false;
  }

  /**
   * List MAP/FILTER/Extract-all operations can handle a list of lists, however it cannot be handled anywhere else (e.g. a list of list cannot be assigned to a func output or alias)
   */
  public boolean isOutputListOfLists(final RosettaExpression op) {
    Boolean _xifexpression = null;
    if ((op instanceof FlattenOperation)) {
      _xifexpression = Boolean.valueOf(false);
    } else {
      Boolean _xifexpression_1 = null;
      if ((op instanceof MapOperation)) {
        boolean _xifexpression_2 = false;
        InlineFunction _function = ((MapOperation)op).getFunction();
        boolean _tripleEquals = (_function == null);
        if (_tripleEquals) {
          _xifexpression_2 = false;
        } else {
          boolean _xifexpression_3 = false;
          boolean _isItemMulti = this.isItemMulti(((MapOperation)op).getFunction());
          if (_isItemMulti) {
            _xifexpression_3 = this.isBodyExpressionMulti(((MapOperation)op).getFunction());
          } else {
            _xifexpression_3 = (this.isBodyExpressionMulti(((MapOperation)op).getFunction()) && this.isPreviousOperationMulti(((RosettaUnaryOperation)op)));
          }
          _xifexpression_2 = _xifexpression_3;
        }
        _xifexpression_1 = Boolean.valueOf(_xifexpression_2);
      } else {
        Boolean _xifexpression_4 = null;
        if ((op instanceof ThenOperation)) {
          boolean _xblockexpression = false;
          {
            final InlineFunction f = ((ThenOperation)op).getFunction();
            boolean _switchResult = false;
            boolean _matched = false;
            if (f instanceof InlineFunction) {
              _matched=true;
              _switchResult = this.isOutputListOfLists(f.getBody());
            }
            if (!_matched) {
              _switchResult = false;
            }
            _xblockexpression = _switchResult;
          }
          _xifexpression_4 = Boolean.valueOf(_xblockexpression);
        } else {
          Boolean _xifexpression_5 = null;
          if ((op instanceof RosettaSymbolReference)) {
            boolean _xblockexpression_1 = false;
            {
              final RosettaSymbol s = ((RosettaSymbolReference)op).getSymbol();
              boolean _xifexpression_6 = false;
              if ((s instanceof ClosureParameter)) {
                boolean _xblockexpression_2 = false;
                {
                  final InlineFunction f = ((ClosureParameter)s).getFunction();
                  final EObject enclosed = f.eContainer();
                  boolean _xifexpression_7 = false;
                  if ((enclosed instanceof ThenOperation)) {
                    return this.isOutputListOfLists(((ThenOperation)enclosed).getArgument());
                  } else {
                    _xifexpression_7 = false;
                  }
                  _xblockexpression_2 = _xifexpression_7;
                }
                _xifexpression_6 = _xblockexpression_2;
              } else {
                _xifexpression_6 = false;
              }
              _xblockexpression_1 = _xifexpression_6;
            }
            _xifexpression_5 = Boolean.valueOf(_xblockexpression_1);
          } else {
            Boolean _xifexpression_6 = null;
            if ((op instanceof RosettaImplicitVariable)) {
              Boolean _xblockexpression_2 = null;
              {
                final Optional<EObject> definingContainer = this._implicitVariableUtil.findContainerDefiningImplicitVariable(op);
                final java.util.function.Function<EObject, Boolean> _function_1 = (EObject it) -> {
                  boolean _xifexpression_7 = false;
                  if ((it instanceof ThenOperation)) {
                    _xifexpression_7 = this.isOutputListOfLists(((RosettaFunctionalOperation) it).getArgument());
                  } else {
                    _xifexpression_7 = false;
                  }
                  return Boolean.valueOf(_xifexpression_7);
                };
                _xblockexpression_2 = definingContainer.<Boolean>map(_function_1).orElse(Boolean.valueOf(false));
              }
              _xifexpression_6 = _xblockexpression_2;
            } else {
              boolean _xifexpression_7 = false;
              if ((op instanceof CanHandleListOfLists)) {
                boolean _xblockexpression_3 = false;
                {
                  final RosettaExpression previousListOp = ((CanHandleListOfLists)op).getArgument();
                  _xblockexpression_3 = this.isOutputListOfLists(previousListOp);
                }
                _xifexpression_7 = _xblockexpression_3;
              } else {
                _xifexpression_7 = false;
              }
              _xifexpression_6 = Boolean.valueOf(_xifexpression_7);
            }
            _xifexpression_5 = _xifexpression_6;
          }
          _xifexpression_4 = _xifexpression_5;
        }
        _xifexpression_1 = _xifexpression_4;
      }
      _xifexpression = _xifexpression_1;
    }
    return (_xifexpression).booleanValue();
  }

  public boolean isPreviousOperationMulti(final RosettaUnaryOperation op) {
    return this.isMulti(op.getArgument());
  }

  public boolean isBodyExpressionMulti(final InlineFunction op) {
    return ((op.getBody() != null) && this.isMulti(op.getBody(), false));
  }

  /**
   * Nothing handles a list of list of list
   */
  public boolean isOutputListOfListOfLists(final RosettaExpression op) {
    return false;
  }

  /**
   * Does the list operation body expression increase the cardinality?
   * 
   * E.g.,
   * - from single to list, or from list to list of lists, would return true.
   * - from single to single, or from list to list, or from list to single, would return false.
   */
  public boolean isBodyExpressionWithSingleInputMulti(final InlineFunction op) {
    return ((op.getBody() != null) && this.isMulti(op.getBody(), true));
  }

  @Override
  protected Boolean caseAbsentOperation(final RosettaAbsentExpression expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseAddOperation(final ArithmeticOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseAndOperation(final LogicalOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseAsKeyOperation(final AsKeyOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(this.isMulti(expr.getArgument(), (breakOnClosureParameter).booleanValue()));
  }

  @Override
  protected Boolean caseBooleanLiteral(final RosettaBooleanLiteral expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseChoiceOperation(final ChoiceOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseConditionalExpression(final RosettaConditionalExpression expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf((this.isMulti(expr.getIfthen(), (breakOnClosureParameter).booleanValue()) || this.isMulti(expr.getElsethen(), (breakOnClosureParameter).booleanValue())));
  }

  @Override
  protected Boolean caseContainsOperation(final RosettaContainsExpression expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseCountOperation(final RosettaCountOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseDisjointOperation(final RosettaDisjointExpression expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseDefaultOperation(final DefaultOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseDistinctOperation(final DistinctOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(this.isMulti(expr.getArgument(), (breakOnClosureParameter).booleanValue()));
  }

  @Override
  protected Boolean caseDivideOperation(final ArithmeticOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseEqualsOperation(final EqualityOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseExistsOperation(final RosettaExistsExpression expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseFeatureCall(final RosettaFeatureCall expr, final Boolean breakOnClosureParameter) {
    boolean _xifexpression = false;
    boolean _isFeatureMulti = this.isFeatureMulti(expr.getFeature(), (breakOnClosureParameter).booleanValue());
    if (_isFeatureMulti) {
      _xifexpression = true;
    } else {
      _xifexpression = this.isMulti(expr.getReceiver(), (breakOnClosureParameter).booleanValue());
    }
    return Boolean.valueOf(_xifexpression);
  }

  @Override
  protected Boolean caseDeepFeatureCall(final RosettaDeepFeatureCall expr, final Boolean breakOnClosureParameter) {
    boolean _xifexpression = false;
    boolean _isFeatureMulti = this.isFeatureMulti(expr.getFeature(), (breakOnClosureParameter).booleanValue());
    if (_isFeatureMulti) {
      _xifexpression = true;
    } else {
      _xifexpression = this.isMulti(expr.getReceiver(), (breakOnClosureParameter).booleanValue());
    }
    return Boolean.valueOf(_xifexpression);
  }

  @Override
  protected Boolean caseFilterOperation(final FilterOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(this.isMulti(expr.getArgument(), (breakOnClosureParameter).booleanValue()));
  }

  @Override
  protected Boolean caseFirstOperation(final FirstOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseFlattenOperation(final FlattenOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(true);
  }

  @Override
  protected Boolean caseGreaterThanOperation(final ComparisonOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseGreaterThanOrEqualOperation(final ComparisonOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseImplicitVariable(final RosettaImplicitVariable expr, final Boolean breakOnClosureParameter) {
    return this.isImplicitVariableMulti(expr, (breakOnClosureParameter).booleanValue());
  }

  @Override
  protected Boolean caseIntLiteral(final RosettaIntLiteral expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseJoinOperation(final JoinOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseLastOperation(final LastOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseLessThanOperation(final ComparisonOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseLessThanOrEqualOperation(final ComparisonOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseListLiteral(final ListLiteral expr, final Boolean breakOnClosureParameter) {
    int _size = expr.getElements().size();
    return Boolean.valueOf((_size > 0));
  }

  @Override
  protected Boolean caseMapOperation(final MapOperation expr, final Boolean breakOnClosureParameter) {
    boolean _xifexpression = false;
    if (((expr.getFunction() != null) && this.isMulti(expr.getFunction().getBody(), (breakOnClosureParameter).booleanValue()))) {
      _xifexpression = true;
    } else {
      _xifexpression = this.isMulti(expr.getArgument(), (breakOnClosureParameter).booleanValue());
    }
    return Boolean.valueOf(_xifexpression);
  }

  @Override
  protected Boolean caseMaxOperation(final MaxOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseMinOperation(final MinOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseMultiplyOperation(final ArithmeticOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseNotEqualsOperation(final EqualityOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseNumberLiteral(final RosettaNumberLiteral expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseOneOfOperation(final OneOfOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseOnlyElementOperation(final RosettaOnlyElement expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseOnlyExists(final RosettaOnlyExistsExpression expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseOrOperation(final LogicalOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseReduceOperation(final ReduceOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseReverseOperation(final ReverseOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(true);
  }

  @Override
  protected Boolean caseSortOperation(final SortOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(true);
  }

  @Override
  protected Boolean caseStringLiteral(final RosettaStringLiteral expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseSubtractOperation(final ArithmeticOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseSumOperation(final SumOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseSymbolReference(final RosettaSymbolReference expr, final Boolean breakOnClosureParameter) {
    final RosettaSymbol s = expr.getSymbol();
    if ((s instanceof RosettaFeature)) {
      if ((this.isFeatureOfImplicitVariable(expr, ((RosettaFeature)s)) && (this.isImplicitVariableMulti(expr, (breakOnClosureParameter).booleanValue())).booleanValue())) {
        return Boolean.valueOf(true);
      }
    }
    return Boolean.valueOf(this.isSymbolMulti(s, (breakOnClosureParameter).booleanValue()));
  }

  @Override
  protected Boolean caseThenOperation(final ThenOperation expr, final Boolean breakOnClosureParameter) {
    boolean _xifexpression = false;
    InlineFunction _function = expr.getFunction();
    boolean _tripleNotEquals = (_function != null);
    if (_tripleNotEquals) {
      _xifexpression = this.isMulti(expr.getFunction().getBody(), (breakOnClosureParameter).booleanValue());
    } else {
      _xifexpression = false;
    }
    return Boolean.valueOf(_xifexpression);
  }

  @Override
  protected Boolean caseToEnumOperation(final ToEnumOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseToIntOperation(final ToIntOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseToNumberOperation(final ToNumberOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseToStringOperation(final ToStringOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseToTimeOperation(final ToTimeOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseConstructorExpression(final RosettaConstructorExpression expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseToDateOperation(final ToDateOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseToDateTimeOperation(final ToDateTimeOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }

  @Override
  protected Boolean caseToZonedDateTimeOperation(final ToZonedDateTimeOperation expr, final Boolean breakOnClosureParameter) {
    return Boolean.valueOf(false);
  }
}
