package com.regnosys.rosetta.types;

import com.google.common.base.Objects;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaParameter;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class RosettaExpectedTypeProvider {
  @Inject
  @Extension
  private RosettaTypeProvider _rosettaTypeProvider;

  @Inject
  @Extension
  private RBuiltinTypeService _rBuiltinTypeService;

  @Inject
  @Extension
  private TypeSystem _typeSystem;

  public RType getExpectedType(final EObject owner, final EReference reference, final int idx) {
    RType _switchResult = null;
    boolean _matched = false;
    if (owner instanceof RosettaConditionalExpression) {
      boolean _equals = Objects.equal(reference, ExpressionPackage.Literals.ROSETTA_CONDITIONAL_EXPRESSION__IF);
      if (_equals) {
        _matched=true;
        _switchResult = this._rBuiltinTypeService.BOOLEAN;
      }
    }
    if (!_matched) {
      if (owner instanceof RosettaSymbolReference) {
        boolean _equals = Objects.equal(reference, ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__RAW_ARGS);
        if (_equals) {
          _matched=true;
          RType _xifexpression = null;
          if (((idx >= 0) && (((RosettaSymbolReference)owner).getSymbol() instanceof RosettaExternalFunction))) {
            RType _xblockexpression = null;
            {
              RosettaSymbol _symbol = ((RosettaSymbolReference)owner).getSymbol();
              final RosettaExternalFunction fun = ((RosettaExternalFunction) _symbol);
              RType _xifexpression_1 = null;
              int _size = fun.getParameters().size();
              boolean _greaterEqualsThan = (idx >= _size);
              if (_greaterEqualsThan) {
                _xifexpression_1 = null;
              } else {
                RType _xblockexpression_1 = null;
                {
                  final RosettaParameter targetParam = fun.getParameters().get(idx);
                  _xblockexpression_1 = this._typeSystem.typeCallToRType(targetParam.getTypeCall());
                }
                _xifexpression_1 = _xblockexpression_1;
              }
              _xblockexpression = _xifexpression_1;
            }
            _xifexpression = _xblockexpression;
          }
          _switchResult = _xifexpression;
        }
      }
    }
    if (!_matched) {
      if (owner instanceof Operation) {
        boolean _equals = Objects.equal(reference, SimplePackage.Literals.OPERATION__EXPRESSION);
        if (_equals) {
          _matched=true;
          RType _xifexpression = null;
          Segment _path = ((Operation)owner).getPath();
          boolean _tripleEquals = (_path == null);
          if (_tripleEquals) {
            _xifexpression = this._rosettaTypeProvider.getRTypeOfSymbol(((Operation)owner).getAssignRoot());
          } else {
            Segment _last = IterableExtensions.<Segment>last(((Operation)owner).pathAsSegmentList());
            Attribute _attribute = null;
            if (_last!=null) {
              _attribute=_last.getAttribute();
            }
            RType _rTypeOfSymbol = null;
            if (_attribute!=null) {
              _rTypeOfSymbol=this._rosettaTypeProvider.getRTypeOfSymbol(_attribute);
            }
            _xifexpression = _rTypeOfSymbol;
          }
          _switchResult = _xifexpression;
        }
      }
    }
    return _switchResult;
  }

  public RType getExpectedType(final EObject owner, final EReference reference) {
    return this.getExpectedType(owner, reference, (-1));
  }
}
