package com.regnosys.rosetta.types;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.utils.BigDecimalInterval;
import com.regnosys.rosetta.utils.OptionalUtil;
import com.regnosys.rosetta.utils.PositiveIntegerInterval;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class RosettaOperators {
  public static final List<String> ARITHMETIC_OPS = Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("+", "-", "*", "/"));

  public static final List<String> COMPARISON_OPS = Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("<", "<=", ">", ">="));

  public static final List<String> EQUALITY_OPS = Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("=", "<>", "contains", "disjoint"));

  public static final List<String> LOGICAL_OPS = Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("and", "or"));

  public static final String JOIN_OP = "join";

  public static final String DEFAULT_OP = "default";

  @Inject
  @Extension
  private RBuiltinTypeService service;

  @Inject
  @Extension
  private TypeSystem _typeSystem;

  public RType resultType(final String op, final RType left, final RType right) {
    RType _xifexpression = null;
    boolean _equals = Objects.equal(op, "+");
    if (_equals) {
      RType _xifexpression_1 = null;
      if ((this._typeSystem.isSubtypeOf(left, this.service.DATE) && this._typeSystem.isSubtypeOf(right, this.service.TIME))) {
        _xifexpression_1 = this.service.DATE_TIME;
      } else {
        RType _xifexpression_2 = null;
        if ((this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_STRING) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_STRING))) {
          final BiFunction<RType, RType, RType> _function = (RType l, RType r) -> {
            RStringType _xblockexpression = null;
            {
              final RStringType s1 = ((RStringType) l);
              final RStringType s2 = ((RStringType) r);
              final PositiveIntegerInterval newInterval = s1.getInterval().add(s2.getInterval());
              Optional<Pattern> _empty = Optional.<Pattern>empty();
              _xblockexpression = new RStringType(newInterval, _empty);
            }
            return _xblockexpression;
          };
          _xifexpression_2 = this._typeSystem.keepTypeAliasIfPossible(left, right, _function);
        } else {
          RType _xifexpression_3 = null;
          if ((this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_NUMBER) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_NUMBER))) {
            final BiFunction<RType, RType, RType> _function_1 = (RType l, RType r) -> {
              RNumberType _xblockexpression = null;
              {
                final RNumberType n1 = ((RNumberType) l);
                final RNumberType n2 = ((RNumberType) r);
                final BiFunction<Integer, Integer, Integer> _function_2 = (Integer a, Integer b) -> {
                  return Integer.valueOf(Math.max((a).intValue(), (b).intValue()));
                };
                final Optional<Integer> newFractionalDigits = OptionalUtil.<Integer, Integer>zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_2);
                final BigDecimalInterval newInterval = n1.getInterval().add(n2.getInterval());
                Optional<Integer> _empty = Optional.<Integer>empty();
                Optional<BigDecimal> _empty_1 = Optional.<BigDecimal>empty();
                _xblockexpression = new RNumberType(_empty, newFractionalDigits, newInterval, _empty_1);
              }
              return _xblockexpression;
            };
            _xifexpression_3 = this._typeSystem.keepTypeAliasIfPossible(left, right, _function_1);
          }
          _xifexpression_2 = _xifexpression_3;
        }
        _xifexpression_1 = _xifexpression_2;
      }
      _xifexpression = _xifexpression_1;
    } else {
      RType _xifexpression_4 = null;
      boolean _equals_1 = Objects.equal(op, "-");
      if (_equals_1) {
        RType _xifexpression_5 = null;
        if ((this._typeSystem.isSubtypeOf(left, this.service.DATE) && this._typeSystem.isSubtypeOf(right, this.service.DATE))) {
          _xifexpression_5 = this.service.UNCONSTRAINED_INT;
        } else {
          RType _xifexpression_6 = null;
          if ((this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_NUMBER) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_NUMBER))) {
            final BiFunction<RType, RType, RType> _function_2 = (RType l, RType r) -> {
              RNumberType _xblockexpression = null;
              {
                final RNumberType n1 = ((RNumberType) l);
                final RNumberType n2 = ((RNumberType) r);
                final BiFunction<Integer, Integer, Integer> _function_3 = (Integer a, Integer b) -> {
                  return Integer.valueOf(Math.max((a).intValue(), (b).intValue()));
                };
                final Optional<Integer> newFractionalDigits = OptionalUtil.<Integer, Integer>zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_3);
                final BigDecimalInterval newInterval = n1.getInterval().subtract(n2.getInterval());
                Optional<Integer> _empty = Optional.<Integer>empty();
                Optional<BigDecimal> _empty_1 = Optional.<BigDecimal>empty();
                _xblockexpression = new RNumberType(_empty, newFractionalDigits, newInterval, _empty_1);
              }
              return _xblockexpression;
            };
            _xifexpression_6 = this._typeSystem.keepTypeAliasIfPossible(left, right, _function_2);
          }
          _xifexpression_5 = _xifexpression_6;
        }
        _xifexpression_4 = _xifexpression_5;
      } else {
        RType _xifexpression_7 = null;
        boolean _equals_2 = Objects.equal(op, "*");
        if (_equals_2) {
          RType _xifexpression_8 = null;
          if ((this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_NUMBER) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_NUMBER))) {
            final BiFunction<RType, RType, RType> _function_3 = (RType l, RType r) -> {
              RNumberType _xblockexpression = null;
              {
                final RNumberType n1 = ((RNumberType) l);
                final RNumberType n2 = ((RNumberType) r);
                final BiFunction<Integer, Integer, Integer> _function_4 = (Integer a, Integer b) -> {
                  return Integer.valueOf(((a).intValue() + (b).intValue()));
                };
                final Optional<Integer> newFractionalDigits = OptionalUtil.<Integer, Integer>zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_4);
                final BigDecimalInterval newInterval = n1.getInterval().multiply(n2.getInterval());
                Optional<Integer> _empty = Optional.<Integer>empty();
                Optional<BigDecimal> _empty_1 = Optional.<BigDecimal>empty();
                _xblockexpression = new RNumberType(_empty, newFractionalDigits, newInterval, _empty_1);
              }
              return _xblockexpression;
            };
            _xifexpression_8 = this._typeSystem.keepTypeAliasIfPossible(left, right, _function_3);
          }
          _xifexpression_7 = _xifexpression_8;
        } else {
          RType _xifexpression_9 = null;
          boolean _equals_3 = Objects.equal(op, "/");
          if (_equals_3) {
            RNumberType _xifexpression_10 = null;
            if ((this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_NUMBER) && this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_NUMBER))) {
              _xifexpression_10 = this.service.UNCONSTRAINED_NUMBER;
            }
            _xifexpression_9 = _xifexpression_10;
          } else {
            RType _xifexpression_11 = null;
            if ((RosettaOperators.COMPARISON_OPS.contains(op) || RosettaOperators.EQUALITY_OPS.contains(op))) {
              RBasicType _xifexpression_12 = null;
              if ((((left == null) || (right == null)) || this._typeSystem.isComparable(left, right))) {
                _xifexpression_12 = this.service.BOOLEAN;
              }
              _xifexpression_11 = _xifexpression_12;
            } else {
              RType _xifexpression_13 = null;
              boolean _equals_4 = Objects.equal(op, RosettaOperators.JOIN_OP);
              if (_equals_4) {
                return this.bothString(left, right, op);
              } else {
                RType _xifexpression_14 = null;
                boolean _contains = RosettaOperators.LOGICAL_OPS.contains(op);
                if (_contains) {
                  return this.bothBoolean(left, right, op);
                } else {
                  RType _xifexpression_15 = null;
                  boolean _equals_5 = Objects.equal(op, RosettaOperators.DEFAULT_OP);
                  if (_equals_5) {
                    RType _xblockexpression = null;
                    {
                      final RType result = this._typeSystem.join(left, right);
                      RType _xifexpression_16 = null;
                      boolean _notEquals = (!Objects.equal(result, this.service.ANY));
                      if (_notEquals) {
                        _xifexpression_16 = result;
                      }
                      _xblockexpression = _xifexpression_16;
                    }
                    _xifexpression_15 = _xblockexpression;
                  }
                  _xifexpression_14 = _xifexpression_15;
                }
                _xifexpression_13 = _xifexpression_14;
              }
              _xifexpression_11 = _xifexpression_13;
            }
            _xifexpression_9 = _xifexpression_11;
          }
          _xifexpression_7 = _xifexpression_9;
        }
        _xifexpression_4 = _xifexpression_7;
      }
      _xifexpression = _xifexpression_4;
    }
    final RType resultType = _xifexpression;
    if ((resultType == null)) {
      String _name = left.getName();
      String _plus = ((("Incompatible types: cannot use operator \'" + op) + "\' with ") + _name);
      String _plus_1 = (_plus + " and ");
      String _name_1 = right.getName();
      String _plus_2 = (_plus_1 + _name_1);
      String _plus_3 = (_plus_2 + ".");
      return new RErrorType(_plus_3);
    } else {
      return resultType;
    }
  }

  private RType bothBoolean(final RType left, final RType right, final String op) {
    boolean _isSubtypeOf = this._typeSystem.isSubtypeOf(left, this.service.BOOLEAN);
    boolean _not = (!_isSubtypeOf);
    if (_not) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Left hand side of \'");
      _builder.append(op);
      _builder.append("\' expression must be boolean");
      return new RErrorType(_builder.toString());
    }
    boolean _isSubtypeOf_1 = this._typeSystem.isSubtypeOf(right, this.service.BOOLEAN);
    boolean _not_1 = (!_isSubtypeOf_1);
    if (_not_1) {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("Right hand side of \'");
      _builder_1.append(op);
      _builder_1.append("\' expression must be boolean");
      return new RErrorType(_builder_1.toString());
    }
    return this.service.BOOLEAN;
  }

  private RType bothString(final RType left, final RType right, final String op) {
    boolean _isSubtypeOf = this._typeSystem.isSubtypeOf(left, this.service.UNCONSTRAINED_STRING);
    boolean _not = (!_isSubtypeOf);
    if (_not) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Left hand side of \'");
      _builder.append(op);
      _builder.append("\' expression must be string");
      return new RErrorType(_builder.toString());
    }
    boolean _isSubtypeOf_1 = this._typeSystem.isSubtypeOf(right, this.service.UNCONSTRAINED_STRING);
    boolean _not_1 = (!_isSubtypeOf_1);
    if (_not_1) {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("Right hand side of \'");
      _builder_1.append(op);
      _builder_1.append("\' expression must be string");
      return new RErrorType(_builder_1.toString());
    }
    return this.service.UNCONSTRAINED_STRING;
  }
}
