package com.regnosys.rosetta.types;

import com.google.common.base.Objects;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment;
import com.regnosys.rosetta.rosetta.RosettaDataReference;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaTypedFeature;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.DistinctOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FirstOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.LastOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.MaxOperation;
import com.regnosys.rosetta.rosetta.expression.MinOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.ReverseOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.SortOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToEnumOperation;
import com.regnosys.rosetta.rosetta.expression.ToIntOperation;
import com.regnosys.rosetta.rosetta.expression.ToNumberOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.ToTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.RosettaExpressionSwitch;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@SuppressWarnings("all")
public class RosettaTypeProvider extends RosettaExpressionSwitch<RType, Map<EObject, RType>> {
  public static String EXPRESSION_RTYPE_CACHE_KEY = (RosettaTypeProvider.class.getCanonicalName() + ".EXPRESSION_RTYPE");

  public static boolean EXPRESSION_RTYPE_CACHE_KEY_ENABLED = Boolean.getBoolean("EXPRESSION_RTYPE_CACHE_KEY_ENABLED");

  @Inject
  @Extension
  private RosettaOperators _rosettaOperators;

  @Inject
  private IQualifiedNameProvider qNames;

  @Inject
  private RosettaExtensions extensions;

  @Inject
  @Extension
  private ImplicitVariableUtil _implicitVariableUtil;

  @Inject
  @Extension
  private TypeSystem _typeSystem;

  @Inject
  @Extension
  private TypeFactory _typeFactory;

  @Inject
  @Extension
  private RBuiltinTypeService _rBuiltinTypeService;

  public RType getRType(final RosettaExpression expression) {
    return this.safeRType(expression, CollectionLiterals.<EObject, RType>newHashMap());
  }

  public RType getRTypeOfFeature(final RosettaFeature feature) {
    return this.safeRType(feature, CollectionLiterals.<EObject, RType>newHashMap());
  }

  public RType getRTypeOfSymbol(final RosettaSymbol feature) {
    return this.safeRType(feature, CollectionLiterals.<EObject, RType>newHashMap());
  }

  public RType getRTypeOfAttributeReference(final RosettaAttributeReferenceSegment seg) {
    RType _switchResult = null;
    boolean _matched = false;
    if (seg instanceof RosettaAttributeReference) {
      _matched=true;
      _switchResult = this._typeSystem.typeCallToRType(((RosettaAttributeReference)seg).getAttribute().getTypeCall());
    }
    if (!_matched) {
      if (seg instanceof RosettaDataReference) {
        _matched=true;
        RBasicType _xifexpression = null;
        boolean _isResolved = this.extensions.isResolved(((RosettaDataReference)seg).getData());
        if (_isResolved) {
          Data _data = ((RosettaDataReference)seg).getData();
          return new RDataType(_data);
        } else {
          _xifexpression = this._rBuiltinTypeService.NOTHING;
        }
        _switchResult = _xifexpression;
      }
    }
    return _switchResult;
  }

  public Iterable<? extends RosettaFeature> findFeaturesOfImplicitVariable(final EObject context) {
    return this.extensions.allFeatures(this.typeOfImplicitVariable(context), context);
  }

  private RType safeRType(final RosettaSymbol symbol, final Map<EObject, RType> cycleTracker) {
    RType _switchResult = null;
    boolean _matched = false;
    if (symbol instanceof RosettaFeature) {
      _matched=true;
      _switchResult = this.safeRType(((RosettaFeature) symbol), cycleTracker);
    }
    if (!_matched) {
      if (symbol instanceof ClosureParameter) {
        _matched=true;
        RType _xblockexpression = null;
        {
          EObject _eContainer = ((ClosureParameter)symbol).getFunction().eContainer();
          final RosettaFunctionalOperation setOp = ((RosettaFunctionalOperation) _eContainer);
          RType _xifexpression = null;
          if ((setOp != null)) {
            _xifexpression = this.safeRType(setOp.getArgument(), cycleTracker);
          } else {
            _xifexpression = this._rBuiltinTypeService.MISSING;
          }
          _xblockexpression = _xifexpression;
        }
        _switchResult = _xblockexpression;
      }
    }
    if (!_matched) {
      if (symbol instanceof RosettaEnumeration) {
        _matched=true;
        _switchResult = new REnumType(((RosettaEnumeration)symbol));
      }
    }
    if (!_matched) {
      if (symbol instanceof Function) {
        _matched=true;
        RType _xifexpression = null;
        Attribute _output = ((Function)symbol).getOutput();
        boolean _tripleNotEquals = (_output != null);
        if (_tripleNotEquals) {
          Attribute _output_1 = ((Function)symbol).getOutput();
          _xifexpression = this.safeRType(((RosettaFeature) _output_1), cycleTracker);
        } else {
          _xifexpression = this._rBuiltinTypeService.MISSING;
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      if (symbol instanceof RosettaRule) {
        _matched=true;
        RType _xifexpression = null;
        RosettaExpression _expression = ((RosettaRule)symbol).getExpression();
        boolean _tripleNotEquals = (_expression != null);
        if (_tripleNotEquals) {
          _xifexpression = this.safeRType(((RosettaRule)symbol).getExpression(), cycleTracker);
        } else {
          _xifexpression = this._rBuiltinTypeService.MISSING;
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      if (symbol instanceof RosettaExternalFunction) {
        _matched=true;
        _switchResult = this._typeSystem.typeCallToRType(((RosettaExternalFunction)symbol).getTypeCall());
      }
    }
    if (!_matched) {
      if (symbol instanceof ShortcutDeclaration) {
        _matched=true;
        RType _xblockexpression = null;
        {
          cycleTracker.put(symbol, null);
          final RType type = this.safeRType(((ShortcutDeclaration)symbol).getExpression(), cycleTracker);
          cycleTracker.put(symbol, type);
          _xblockexpression = type;
        }
        _switchResult = _xblockexpression;
      }
    }
    return _switchResult;
  }

  private RType safeRType(final RosettaFeature feature, final Map<EObject, RType> cycleTracker) {
    RType _switchResult = null;
    boolean _matched = false;
    if (feature instanceof RosettaTypedFeature) {
      _matched=true;
      RType _xblockexpression = null;
      {
        RType _xifexpression = null;
        boolean _isIsTypeInferred = ((RosettaTypedFeature)feature).isIsTypeInferred();
        if (_isIsTypeInferred) {
          _xifexpression = new RErrorType("Cannot infer type of feature.");
        } else {
          _xifexpression = this._typeSystem.typeCallToRType(((RosettaTypedFeature)feature).getTypeCall());
        }
        final RType featureType = _xifexpression;
        if ((feature instanceof Annotated)) {
          if ((featureType instanceof RAnnotateType)) {
            ((RAnnotateType)featureType).setWithMeta(this.extensions.hasMetaDataAnnotations(((Annotated)feature)));
          }
        }
        _xblockexpression = featureType;
      }
      _switchResult = _xblockexpression;
    }
    if (!_matched) {
      if (feature instanceof RosettaEnumValue) {
        _matched=true;
        RosettaEnumeration _enumeration = ((RosettaEnumValue)feature).getEnumeration();
        _switchResult = new REnumType(_enumeration);
      }
    }
    if (!_matched) {
      _switchResult = new RErrorType("Cannot infer type of feature.");
    }
    return _switchResult;
  }

  private RType safeRType(final RosettaExpression expression, final Map<EObject, RType> cycleTracker) {
    final Provider<RType> _function = () -> {
      RType _xblockexpression = null;
      {
        boolean _containsKey = cycleTracker.containsKey(expression);
        if (_containsKey) {
          final RType computed = cycleTracker.get(expression);
          if ((computed == null)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Can\'t infer type due to a cyclic reference of ");
            QualifiedName _fullyQualifiedName = this.qNames.getFullyQualifiedName(expression);
            _builder.append(_fullyQualifiedName);
            return new RErrorType(_builder.toString());
          } else {
            return computed;
          }
        }
        boolean _isResolved = this.extensions.isResolved(expression);
        boolean _not = (!_isResolved);
        if (_not) {
          return null;
        }
        _xblockexpression = this.doSwitch(expression, cycleTracker);
      }
      return _xblockexpression;
    };
    return this.getRTypeFromCache(RosettaTypeProvider.EXPRESSION_RTYPE_CACHE_KEY, expression, _function);
  }

  private RType getRTypeFromCache(final String cacheKey, final EObject object, final Provider<RType> typeProvider) {
    RType _xblockexpression = null;
    {
      if ((!RosettaTypeProvider.EXPRESSION_RTYPE_CACHE_KEY_ENABLED)) {
        return typeProvider.get();
      }
      if ((object == null)) {
        return typeProvider.get();
      }
      final Resource resource = object.eResource();
      RType _xifexpression = null;
      if ((resource instanceof XtextResource)) {
        IResourceScopeCache _cache = ((XtextResource)resource).getCache();
        Pair<String, EObject> _mappedTo = Pair.<String, EObject>of(cacheKey, object);
        final com.google.inject.Provider<RType> _function = () -> {
          return typeProvider.get();
        };
        _xifexpression = _cache.<RType>get(_mappedTo, resource, _function);
      } else {
        _xifexpression = typeProvider.get();
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  public RType typeOfImplicitVariable(final EObject context) {
    return this.safeTypeOfImplicitVariable(context, CollectionLiterals.<EObject, RType>newHashMap());
  }

  private RType safeTypeOfImplicitVariable(final EObject context, final Map<EObject, RType> cycleTracker) {
    RType _xblockexpression = null;
    {
      final Optional<EObject> definingContainer = this._implicitVariableUtil.findContainerDefiningImplicitVariable(context);
      final java.util.function.Function<EObject, RType> _function = (EObject it) -> {
        RType _xifexpression = null;
        if ((it instanceof Data)) {
          _xifexpression = new RDataType(((Data)it));
        } else {
          RType _xifexpression_1 = null;
          if ((it instanceof RosettaFunctionalOperation)) {
            _xifexpression_1 = this.safeRType(((RosettaFunctionalOperation)it).getArgument(), cycleTracker);
          } else {
            RType _xifexpression_2 = null;
            if ((it instanceof RosettaRule)) {
              RType _elvis = null;
              TypeCall _input = ((RosettaRule)it).getInput();
              RType _typeCallToRType = null;
              if (_input!=null) {
                _typeCallToRType=this._typeSystem.typeCallToRType(_input);
              }
              if (_typeCallToRType != null) {
                _elvis = _typeCallToRType;
              } else {
                _elvis = this._rBuiltinTypeService.MISSING;
              }
              _xifexpression_2 = _elvis;
            }
            _xifexpression_1 = _xifexpression_2;
          }
          _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
      };
      _xblockexpression = definingContainer.<RType>map(_function).orElse(this._rBuiltinTypeService.MISSING);
    }
    return _xblockexpression;
  }

  private RType caseBinaryOperation(final RosettaBinaryOperation expr, final Map<EObject, RType> context) {
    RType _xblockexpression = null;
    {
      final RosettaExpression left = expr.getLeft();
      RType leftType = this.safeRType(left, context);
      if (((leftType == null) || (leftType instanceof RErrorType))) {
        return leftType;
      }
      final RosettaExpression right = expr.getRight();
      RType rightType = this.safeRType(right, context);
      if (((rightType == null) || (rightType instanceof RErrorType))) {
        return rightType;
      }
      _xblockexpression = this._rosettaOperators.resultType(expr.getOperator(), leftType, rightType);
    }
    return _xblockexpression;
  }

  @Override
  protected RType caseAbsentOperation(final RosettaAbsentExpression expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.BOOLEAN;
  }

  @Override
  protected RType caseAddOperation(final ArithmeticOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseAndOperation(final LogicalOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseAsKeyOperation(final AsKeyOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseBooleanLiteral(final RosettaBooleanLiteral expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.BOOLEAN;
  }

  @Override
  protected RType caseChoiceOperation(final ChoiceOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.BOOLEAN;
  }

  @Override
  protected RType caseConditionalExpression(final RosettaConditionalExpression expr, final Map<EObject, RType> context) {
    RType _xblockexpression = null;
    {
      final RType ifT = this.safeRType(expr.getIfthen(), context);
      final RType elseT = this.safeRType(expr.getElsethen(), context);
      RType _xifexpression = null;
      if (((ifT == null) || (ifT instanceof RErrorType))) {
        _xifexpression = elseT;
      } else {
        RType _xifexpression_1 = null;
        if (((elseT == null) || (elseT instanceof RErrorType))) {
          _xifexpression_1 = ifT;
        } else {
          RType _xblockexpression_1 = null;
          {
            final RType joined = this._typeSystem.join(ifT, elseT);
            RType _xifexpression_2 = null;
            boolean _equals = Objects.equal(joined, this._rBuiltinTypeService.ANY);
            if (_equals) {
              String _name = ifT.getName();
              String _plus = ("Can not infer common type for \'" + _name);
              String _plus_1 = (_plus + "\' and ");
              String _name_1 = elseT.getName();
              String _plus_2 = (_plus_1 + _name_1);
              String _plus_3 = (_plus_2 + "\'.");
              _xifexpression_2 = new RErrorType(_plus_3);
            } else {
              _xifexpression_2 = joined;
            }
            _xblockexpression_1 = _xifexpression_2;
          }
          _xifexpression_1 = _xblockexpression_1;
        }
        _xifexpression = _xifexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  @Override
  protected RType caseContainsOperation(final RosettaContainsExpression expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseDefaultOperation(final DefaultOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseCountOperation(final RosettaCountOperation expr, final Map<EObject, RType> context) {
    return this._typeFactory.constrainedInt(Optional.<Integer>empty(), Optional.<BigInteger>of(BigInteger.ZERO), Optional.<BigInteger>empty());
  }

  @Override
  protected RType caseDisjointOperation(final RosettaDisjointExpression expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseDistinctOperation(final DistinctOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseDivideOperation(final ArithmeticOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseEqualsOperation(final EqualityOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseExistsOperation(final RosettaExistsExpression expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.BOOLEAN;
  }

  @Override
  protected RType caseFeatureCall(final RosettaFeatureCall expr, final Map<EObject, RType> context) {
    RType _xblockexpression = null;
    {
      final RosettaFeature feature = expr.getFeature();
      boolean _isResolved = this.extensions.isResolved(feature);
      boolean _not = (!_isResolved);
      if (_not) {
        return null;
      }
      RType _xifexpression = null;
      if ((feature instanceof RosettaEnumValue)) {
        _xifexpression = this.safeRType(expr.getReceiver(), context);
      } else {
        _xifexpression = this.safeRType(feature, context);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  @Override
  protected RType caseDeepFeatureCall(final RosettaDeepFeatureCall expr, final Map<EObject, RType> context) {
    RType _xblockexpression = null;
    {
      final Attribute feature = expr.getFeature();
      boolean _isResolved = this.extensions.isResolved(feature);
      boolean _not = (!_isResolved);
      if (_not) {
        return null;
      }
      _xblockexpression = this.safeRType(((RosettaFeature) feature), context);
    }
    return _xblockexpression;
  }

  @Override
  protected RType caseFilterOperation(final FilterOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseFirstOperation(final FirstOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseFlattenOperation(final FlattenOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseGreaterThanOperation(final ComparisonOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseGreaterThanOrEqualOperation(final ComparisonOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseImplicitVariable(final RosettaImplicitVariable expr, final Map<EObject, RType> context) {
    return this.safeTypeOfImplicitVariable(expr, context);
  }

  @Override
  protected RType caseIntLiteral(final RosettaIntLiteral expr, final Map<EObject, RType> context) {
    int _xifexpression = (int) 0;
    int _signum = expr.getValue().signum();
    boolean _greaterEqualsThan = (_signum >= 0);
    if (_greaterEqualsThan) {
      _xifexpression = expr.getValue().toString().length();
    } else {
      int _length = expr.getValue().toString().length();
      _xifexpression = (_length - 1);
    }
    return this._typeFactory.constrainedInt(_xifexpression, expr.getValue(), expr.getValue());
  }

  @Override
  protected RType caseJoinOperation(final JoinOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.UNCONSTRAINED_STRING;
  }

  @Override
  protected RType caseLastOperation(final LastOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseLessThanOperation(final ComparisonOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseLessThanOrEqualOperation(final ComparisonOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseListLiteral(final ListLiteral expr, final Map<EObject, RType> context) {
    RType _xblockexpression = null;
    {
      final Function1<RosettaExpression, RType> _function = (RosettaExpression it) -> {
        return this.getRType(it);
      };
      final Function1<RType, Boolean> _function_1 = (RType it) -> {
        return Boolean.valueOf((it != null));
      };
      final Iterable<RType> types = IterableExtensions.<RType>filter(ListExtensions.<RosettaExpression, RType>map(expr.getElements(), _function), _function_1);
      final RType joined = this._typeSystem.join(types);
      RType _xifexpression = null;
      boolean _equals = Objects.equal(joined, this._rBuiltinTypeService.ANY);
      if (_equals) {
        final Function1<RType, String> _function_2 = (RType it) -> {
          return it.getName();
        };
        String _join = IterableExtensions.join(IterableExtensions.<String, RType>groupBy(types, _function_2).keySet(), ", ");
        _xifexpression = new RErrorType(_join);
      } else {
        _xifexpression = joined;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  @Override
  protected RType caseMapOperation(final MapOperation expr, final Map<EObject, RType> context) {
    InlineFunction _function = expr.getFunction();
    RosettaExpression _body = null;
    if (_function!=null) {
      _body=_function.getBody();
    }
    RType _safeRType = null;
    if (_body!=null) {
      _safeRType=this.safeRType(_body, context);
    }
    return _safeRType;
  }

  @Override
  protected RType caseMaxOperation(final MaxOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseMinOperation(final MinOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseMultiplyOperation(final ArithmeticOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseNotEqualsOperation(final EqualityOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseNumberLiteral(final RosettaNumberLiteral expr, final Map<EObject, RType> context) {
    return this._typeFactory.constrainedNumber(expr.getValue().toPlainString().replaceAll("\\.|\\-", "").length(), Math.max(0, expr.getValue().scale()), expr.getValue(), expr.getValue());
  }

  @Override
  protected RType caseOneOfOperation(final OneOfOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.BOOLEAN;
  }

  @Override
  protected RType caseOnlyElementOperation(final RosettaOnlyElement expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseOnlyExists(final RosettaOnlyExistsExpression expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.BOOLEAN;
  }

  @Override
  protected RType caseOrOperation(final LogicalOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseReduceOperation(final ReduceOperation expr, final Map<EObject, RType> context) {
    InlineFunction _function = expr.getFunction();
    RosettaExpression _body = null;
    if (_function!=null) {
      _body=_function.getBody();
    }
    RType _safeRType = null;
    if (_body!=null) {
      _safeRType=this.safeRType(_body, context);
    }
    return _safeRType;
  }

  @Override
  protected RType caseReverseOperation(final ReverseOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseSortOperation(final SortOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseStringLiteral(final RosettaStringLiteral expr, final Map<EObject, RType> context) {
    return this._typeFactory.constrainedString(expr.getValue().length(), expr.getValue().length());
  }

  @Override
  protected RType caseSubtractOperation(final ArithmeticOperation expr, final Map<EObject, RType> context) {
    return this.caseBinaryOperation(expr, context);
  }

  @Override
  protected RType caseSumOperation(final SumOperation expr, final Map<EObject, RType> context) {
    return this.safeRType(expr.getArgument(), context);
  }

  @Override
  protected RType caseSymbolReference(final RosettaSymbolReference expr, final Map<EObject, RType> context) {
    RType _xifexpression = null;
    RosettaSymbol _symbol = expr.getSymbol();
    if ((_symbol instanceof RosettaExternalFunction)) {
      RType _xblockexpression = null;
      {
        RosettaSymbol _symbol_1 = expr.getSymbol();
        final RosettaExternalFunction fun = ((RosettaExternalFunction) _symbol_1);
        final RType returnType = this.safeRType(fun, context);
        final Function1<RosettaExpression, RType> _function = (RosettaExpression it) -> {
          return this.safeRType(it, context);
        };
        final List<RType> argTypes = ListExtensions.<RosettaExpression, RType>map(expr.getArgs(), _function);
        RType _xifexpression_1 = null;
        final Function1<RType, Boolean> _function_1 = (RType it) -> {
          return Boolean.valueOf(this._typeSystem.isSubtypeOf(it, returnType));
        };
        boolean _forall = IterableExtensions.<RType>forall(argTypes, _function_1);
        if (_forall) {
          _xifexpression_1 = this._typeSystem.join(argTypes);
        } else {
          _xifexpression_1 = returnType;
        }
        _xblockexpression = _xifexpression_1;
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = this.safeRType(expr.getSymbol(), context);
    }
    return _xifexpression;
  }

  @Override
  protected RType caseThenOperation(final ThenOperation expr, final Map<EObject, RType> context) {
    InlineFunction _function = expr.getFunction();
    RosettaExpression _body = null;
    if (_function!=null) {
      _body=_function.getBody();
    }
    RType _safeRType = null;
    if (_body!=null) {
      _safeRType=this.safeRType(_body, context);
    }
    return _safeRType;
  }

  @Override
  protected RType caseToEnumOperation(final ToEnumOperation expr, final Map<EObject, RType> context) {
    RosettaEnumeration _enumeration = expr.getEnumeration();
    return new REnumType(_enumeration);
  }

  @Override
  protected RType caseToIntOperation(final ToIntOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.UNCONSTRAINED_INT;
  }

  @Override
  protected RType caseToNumberOperation(final ToNumberOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.UNCONSTRAINED_NUMBER;
  }

  @Override
  protected RType caseToStringOperation(final ToStringOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.UNCONSTRAINED_STRING;
  }

  @Override
  protected RType caseToTimeOperation(final ToTimeOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.TIME;
  }

  @Override
  protected RType caseConstructorExpression(final RosettaConstructorExpression expr, final Map<EObject, RType> context) {
    return this._typeSystem.typeCallToRType(expr.getTypeCall());
  }

  @Override
  protected RType caseToDateOperation(final ToDateOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.DATE;
  }

  @Override
  protected RType caseToDateTimeOperation(final ToDateTimeOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.DATE_TIME;
  }

  @Override
  protected RType caseToZonedDateTimeOperation(final ToZonedDateTimeOperation expr, final Map<EObject, RType> context) {
    return this._rBuiltinTypeService.ZONED_DATE_TIME;
  }
}
