package com.regnosys.rosetta.typing;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.regnosys.rosetta.interpreter.RosettaInterpreter;
import com.regnosys.rosetta.interpreter.RosettaInterpreterContext;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaBuiltinType;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.RosettaTypedFeature;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.TypeCallArgument;
import com.regnosys.rosetta.rosetta.TypeParameter;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaPatternLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RListType;
import com.regnosys.rosetta.types.RParametrizedType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RTypeFunction;
import com.regnosys.rosetta.types.TypeFactory;
import com.regnosys.rosetta.types.TypeValidationUtil;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.utils.BigDecimalInterval;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.OptionalUtil;
import com.regnosys.rosetta.utils.PositiveIntegerInterval;
import com.regnosys.rosetta.utils.RosettaSimpleSystemSolver;
import com.rosetta.util.DottedPath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xsemantics.runtime.XsemanticsProvider;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class RosettaTyping extends RosettaTypingAuxiliary {
  public static final String COMPARABLE = "com.regnosys.rosetta.typing.Comparable";

  public static final String LISTCOMPARABLE = "com.regnosys.rosetta.typing.ListComparable";

  public static final String SYMBOLLISTTYPE = "com.regnosys.rosetta.typing.SymbolListType";

  public static final String FUNCTIONALOPERATIONITEMTYPE = "com.regnosys.rosetta.typing.FunctionalOperationItemType";

  public static final String TYPEOFIMPLICITVARIABLE = "com.regnosys.rosetta.typing.TypeOfImplicitVariable";

  public static final String TYPEFUNCTIONOFTYPEALIAS = "com.regnosys.rosetta.typing.TypeFunctionOfTypeAlias";

  public static final String TYPECALLTORTYPE = "com.regnosys.rosetta.typing.TypeCallToRType";

  public static final String ATTRIBUTELISTTYPE = "com.regnosys.rosetta.typing.AttributeListType";

  public static final String SDATA = "com.regnosys.rosetta.typing.SData";

  public static final String SNUMBER = "com.regnosys.rosetta.typing.SNumber";

  public static final String SSTRING = "com.regnosys.rosetta.typing.SString";

  public static final String SBASIC = "com.regnosys.rosetta.typing.SBasic";

  public static final String SNOTHING = "com.regnosys.rosetta.typing.SNothing";

  public static final String SANY = "com.regnosys.rosetta.typing.SAny";

  public static final String SALIASBOTH = "com.regnosys.rosetta.typing.SAliasBoth";

  public static final String SALIASLEFT = "com.regnosys.rosetta.typing.SAliasLeft";

  public static final String SALIASRIGHT = "com.regnosys.rosetta.typing.SAliasRight";

  public static final String SALIASBASIC = "com.regnosys.rosetta.typing.SAliasBasic";

  public static final String SBASICALIAS = "com.regnosys.rosetta.typing.SBasicAlias";

  public static final String SREFL = "com.regnosys.rosetta.typing.SRefl";

  public static final String SLIST = "com.regnosys.rosetta.typing.SList";

  public static final String TBOOLEAN = "com.regnosys.rosetta.typing.TBoolean";

  public static final String TSTRING = "com.regnosys.rosetta.typing.TString";

  public static final String TNUMBER = "com.regnosys.rosetta.typing.TNumber";

  public static final String TINT = "com.regnosys.rosetta.typing.TInt";

  public static final String TPATTERN = "com.regnosys.rosetta.typing.TPattern";

  public static final String TVAR = "com.regnosys.rosetta.typing.TVar";

  public static final String TIT = "com.regnosys.rosetta.typing.TIt";

  public static final String TARITHMETIC = "com.regnosys.rosetta.typing.TArithmetic";

  public static final String TEQUALITY = "com.regnosys.rosetta.typing.TEquality";

  public static final String TLOGICAL = "com.regnosys.rosetta.typing.TLogical";

  public static final String TCOMPARISON = "com.regnosys.rosetta.typing.TComparison";

  public static final String TIF = "com.regnosys.rosetta.typing.TIf";

  public static final String TLIST = "com.regnosys.rosetta.typing.TList";

  public static final String TPROJECT = "com.regnosys.rosetta.typing.TProject";

  public static final String TEXISTS = "com.regnosys.rosetta.typing.TExists";

  public static final String TABSENT = "com.regnosys.rosetta.typing.TAbsent";

  public static final String TONLYEXISTS = "com.regnosys.rosetta.typing.TOnlyExists";

  public static final String TCOUNT = "com.regnosys.rosetta.typing.TCount";

  public static final String TONLYELEMENT = "com.regnosys.rosetta.typing.TOnlyElement";

  public static final String TASKEY = "com.regnosys.rosetta.typing.TAsKey";

  public static final String TONEOF = "com.regnosys.rosetta.typing.TOneOf";

  public static final String TCHOICE = "com.regnosys.rosetta.typing.TChoice";

  @Extension
  @Inject
  private TypeFactory typeFactory;

  @Extension
  @Inject
  private TypeValidationUtil util;

  @Extension
  @Inject
  private ExpressionHelper exprHelper;

  @Extension
  @Inject
  private ImplicitVariableUtil implicitVarUtil;

  @Extension
  @Inject
  private RBuiltinTypeService builtinTypes;

  @Inject
  private RosettaInterpreter interpreter;

  @Inject
  private RosettaSimpleSystemSolver systemSolver;

  private PolymorphicDispatcher<Boolean> comparableDispatcher;

  private PolymorphicDispatcher<Boolean> listComparableDispatcher;

  private PolymorphicDispatcher<RListType> symbolListTypeDispatcher;

  private PolymorphicDispatcher<RListType> functionalOperationItemTypeDispatcher;

  private PolymorphicDispatcher<Optional<RListType>> typeOfImplicitVariableDispatcher;

  private PolymorphicDispatcher<RTypeFunction> typeFunctionOfTypeAliasDispatcher;

  private PolymorphicDispatcher<RType> typeCallToRTypeDispatcher;

  private PolymorphicDispatcher<RListType> attributeListTypeDispatcher;

  private PolymorphicDispatcher<Result<RListType>> inferTypeDispatcher;

  private PolymorphicDispatcher<Result<Boolean>> subtypeDispatcher;

  private PolymorphicDispatcher<Result<Boolean>> listSubtypeDispatcher;

  public RosettaTyping() {
    init();
  }

  @Override
  public void init() {
    super.init();
    inferTypeDispatcher = buildPolymorphicDispatcher1(
    	"inferTypeImpl", 3, "|-", ":");
    subtypeDispatcher = buildPolymorphicDispatcher1(
    	"subtypeImpl", 4, "|-", "<:");
    listSubtypeDispatcher = buildPolymorphicDispatcher1(
    	"listSubtypeImpl", 4, "|-", "<|");
    comparableDispatcher = buildPolymorphicDispatcher(
    	"comparableImpl", 3);
    listComparableDispatcher = buildPolymorphicDispatcher(
    	"listComparableImpl", 3);
    symbolListTypeDispatcher = buildPolymorphicDispatcher(
    	"symbolListTypeImpl", 2);
    functionalOperationItemTypeDispatcher = buildPolymorphicDispatcher(
    	"functionalOperationItemTypeImpl", 2);
    typeOfImplicitVariableDispatcher = buildPolymorphicDispatcher(
    	"typeOfImplicitVariableImpl", 2);
    typeFunctionOfTypeAliasDispatcher = buildPolymorphicDispatcher(
    	"typeFunctionOfTypeAliasImpl", 2);
    typeCallToRTypeDispatcher = buildPolymorphicDispatcher(
    	"typeCallToRTypeImpl", 3);
    attributeListTypeDispatcher = buildPolymorphicDispatcher(
    	"attributeListTypeImpl", 2);
  }

  public TypeFactory getTypeFactory() {
    return this.typeFactory;
  }

  public void setTypeFactory(final TypeFactory typeFactory) {
    this.typeFactory = typeFactory;
  }

  public TypeValidationUtil getUtil() {
    return this.util;
  }

  public void setUtil(final TypeValidationUtil util) {
    this.util = util;
  }

  public ExpressionHelper getExprHelper() {
    return this.exprHelper;
  }

  public void setExprHelper(final ExpressionHelper exprHelper) {
    this.exprHelper = exprHelper;
  }

  public ImplicitVariableUtil getImplicitVarUtil() {
    return this.implicitVarUtil;
  }

  public void setImplicitVarUtil(final ImplicitVariableUtil implicitVarUtil) {
    this.implicitVarUtil = implicitVarUtil;
  }

  public RBuiltinTypeService getBuiltinTypes() {
    return this.builtinTypes;
  }

  public void setBuiltinTypes(final RBuiltinTypeService builtinTypes) {
    this.builtinTypes = builtinTypes;
  }

  public RosettaInterpreter getInterpreter() {
    return this.interpreter;
  }

  public void setInterpreter(final RosettaInterpreter interpreter) {
    this.interpreter = interpreter;
  }

  public RosettaSimpleSystemSolver getSystemSolver() {
    return this.systemSolver;
  }

  public void setSystemSolver(final RosettaSimpleSystemSolver systemSolver) {
    this.systemSolver = systemSolver;
  }

  public Boolean comparable(final RType t1, final RType t2) throws RuleFailedException {
    return comparable(null, t1, t2);
  }

  public Boolean comparable(final RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
    try {
    	return comparableInternal(_trace_, t1, t2);
    } catch (Exception _e_comparable) {
    	throw extractRuleFailedException(_e_comparable);
    }
  }

  public Boolean listComparable(final RListType t1, final RListType t2) throws RuleFailedException {
    return listComparable(null, t1, t2);
  }

  public Boolean listComparable(final RuleApplicationTrace _trace_, final RListType t1, final RListType t2) throws RuleFailedException {
    try {
    	return listComparableInternal(_trace_, t1, t2);
    } catch (Exception _e_listComparable) {
    	throw extractRuleFailedException(_e_listComparable);
    }
  }

  public RListType symbolListType(final RosettaSymbol c) throws RuleFailedException {
    return symbolListType(null, c);
  }

  public RListType symbolListType(final RuleApplicationTrace _trace_, final RosettaSymbol c) throws RuleFailedException {
    try {
    	return symbolListTypeInternal(_trace_, c);
    } catch (Exception _e_symbolListType) {
    	throw extractRuleFailedException(_e_symbolListType);
    }
  }

  public RListType functionalOperationItemType(final RosettaFunctionalOperation op) throws RuleFailedException {
    return functionalOperationItemType(null, op);
  }

  public RListType functionalOperationItemType(final RuleApplicationTrace _trace_, final RosettaFunctionalOperation op) throws RuleFailedException {
    try {
    	return functionalOperationItemTypeInternal(_trace_, op);
    } catch (Exception _e_functionalOperationItemType) {
    	throw extractRuleFailedException(_e_functionalOperationItemType);
    }
  }

  public Optional<RListType> typeOfImplicitVariable(final EObject context) throws RuleFailedException {
    return typeOfImplicitVariable(null, context);
  }

  public Optional<RListType> typeOfImplicitVariable(final RuleApplicationTrace _trace_, final EObject context) throws RuleFailedException {
    try {
    	return typeOfImplicitVariableInternal(_trace_, context);
    } catch (Exception _e_typeOfImplicitVariable) {
    	throw extractRuleFailedException(_e_typeOfImplicitVariable);
    }
  }

  public RTypeFunction typeFunctionOfTypeAlias(final RosettaTypeAlias typeAlias) throws RuleFailedException {
    return typeFunctionOfTypeAlias(null, typeAlias);
  }

  public RTypeFunction typeFunctionOfTypeAlias(final RuleApplicationTrace _trace_, final RosettaTypeAlias typeAlias) throws RuleFailedException {
    try {
    	return typeFunctionOfTypeAliasInternal(_trace_, typeAlias);
    } catch (Exception _e_typeFunctionOfTypeAlias) {
    	throw extractRuleFailedException(_e_typeFunctionOfTypeAlias);
    }
  }

  public RType typeCallToRType(final TypeCall rt, final RosettaInterpreterContext context) throws RuleFailedException {
    return typeCallToRType(null, rt, context);
  }

  public RType typeCallToRType(final RuleApplicationTrace _trace_, final TypeCall rt, final RosettaInterpreterContext context) throws RuleFailedException {
    try {
    	return typeCallToRTypeInternal(_trace_, rt, context);
    } catch (Exception _e_typeCallToRType) {
    	throw extractRuleFailedException(_e_typeCallToRType);
    }
  }

  public RListType attributeListType(final Attribute a) throws RuleFailedException {
    return attributeListType(null, a);
  }

  public RListType attributeListType(final RuleApplicationTrace _trace_, final Attribute a) throws RuleFailedException {
    try {
    	return attributeListTypeInternal(_trace_, a);
    } catch (Exception _e_attributeListType) {
    	throw extractRuleFailedException(_e_attributeListType);
    }
  }

  public Result<RListType> inferType(final RosettaExpression expression) {
    return inferType(new RuleEnvironment(), null, expression);
  }

  public Result<RListType> inferType(final RuleEnvironment _environment_, final RosettaExpression expression) {
    return inferType(_environment_, null, expression);
  }

  public Result<RListType> inferType(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RosettaExpression expression) {
    return getFromCache("inferType", _environment_, _trace_,
    	new XsemanticsProvider<Result<RListType>>(_environment_, _trace_) {
    		public Result<RListType> doGet() {
    			try {
    				return inferTypeInternal(_environment_, _trace_, expression);
    			} catch (Exception _e_inferType) {
    				return resultForFailure(_e_inferType);
    			}
    		}
    	}, expression);
  }

  public Result<Boolean> subtype(final RType subtype, final RType supertype) {
    return subtype(new RuleEnvironment(), null, subtype, supertype);
  }

  public Result<Boolean> subtype(final RuleEnvironment _environment_, final RType subtype, final RType supertype) {
    return subtype(_environment_, null, subtype, supertype);
  }

  public Result<Boolean> subtype(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RType subtype, final RType supertype) {
    try {
    	return subtypeInternal(_environment_, _trace_, subtype, supertype);
    } catch (Exception _e_subtype) {
    	return resultForFailure(_e_subtype);
    }
  }

  public Boolean subtypeSucceeded(final RType subtype, final RType supertype) {
    return subtypeSucceeded(new RuleEnvironment(), null, subtype, supertype);
  }

  public Boolean subtypeSucceeded(final RuleEnvironment _environment_, final RType subtype, final RType supertype) {
    return subtypeSucceeded(_environment_, null, subtype, supertype);
  }

  public Boolean subtypeSucceeded(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RType subtype, final RType supertype) {
    try {
    	subtypeInternal(_environment_, _trace_, subtype, supertype);
    	return true;
    } catch (Exception _e_subtype) {
    	return false;
    }
  }

  public Result<Boolean> listSubtype(final RListType subtype, final RListType supertype) {
    return listSubtype(new RuleEnvironment(), null, subtype, supertype);
  }

  public Result<Boolean> listSubtype(final RuleEnvironment _environment_, final RListType subtype, final RListType supertype) {
    return listSubtype(_environment_, null, subtype, supertype);
  }

  public Result<Boolean> listSubtype(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RListType subtype, final RListType supertype) {
    try {
    	return listSubtypeInternal(_environment_, _trace_, subtype, supertype);
    } catch (Exception _e_listSubtype) {
    	return resultForFailure(_e_listSubtype);
    }
  }

  public Boolean listSubtypeSucceeded(final RListType subtype, final RListType supertype) {
    return listSubtypeSucceeded(new RuleEnvironment(), null, subtype, supertype);
  }

  public Boolean listSubtypeSucceeded(final RuleEnvironment _environment_, final RListType subtype, final RListType supertype) {
    return listSubtypeSucceeded(_environment_, null, subtype, supertype);
  }

  public Boolean listSubtypeSucceeded(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RListType subtype, final RListType supertype) {
    try {
    	listSubtypeInternal(_environment_, _trace_, subtype, supertype);
    	return true;
    } catch (Exception _e_listSubtype) {
    	return false;
    }
  }

  protected Boolean comparableInternal(final RuleApplicationTrace _trace_, final RType t1, final RType t2) {
    try {
    	checkParamsNotNull(t1, t2);
    	return comparableDispatcher.invoke(_trace_, t1, t2);
    } catch (Exception _e_comparable) {
    	sneakyThrowRuleFailedException(_e_comparable);
    	return false;
    }
  }

  protected void comparableThrowException(final String _error, final String _issue, final Exception _ex, final RType t1, final RType t2, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Boolean listComparableInternal(final RuleApplicationTrace _trace_, final RListType t1, final RListType t2) {
    try {
    	checkParamsNotNull(t1, t2);
    	return listComparableDispatcher.invoke(_trace_, t1, t2);
    } catch (Exception _e_listComparable) {
    	sneakyThrowRuleFailedException(_e_listComparable);
    	return false;
    }
  }

  protected void listComparableThrowException(final String _error, final String _issue, final Exception _ex, final RListType t1, final RListType t2, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected RListType symbolListTypeInternal(final RuleApplicationTrace _trace_, final RosettaSymbol c) {
    try {
    	checkParamsNotNull(c);
    	return symbolListTypeDispatcher.invoke(_trace_, c);
    } catch (Exception _e_symbolListType) {
    	sneakyThrowRuleFailedException(_e_symbolListType);
    	return null;
    }
  }

  protected void symbolListTypeThrowException(final String _error, final String _issue, final Exception _ex, final RosettaSymbol c, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected RListType functionalOperationItemTypeInternal(final RuleApplicationTrace _trace_, final RosettaFunctionalOperation op) {
    try {
    	checkParamsNotNull(op);
    	return functionalOperationItemTypeDispatcher.invoke(_trace_, op);
    } catch (Exception _e_functionalOperationItemType) {
    	sneakyThrowRuleFailedException(_e_functionalOperationItemType);
    	return null;
    }
  }

  protected void functionalOperationItemTypeThrowException(final String _error, final String _issue, final Exception _ex, final RosettaFunctionalOperation op, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Optional<RListType> typeOfImplicitVariableInternal(final RuleApplicationTrace _trace_, final EObject context) {
    try {
    	checkParamsNotNull(context);
    	return typeOfImplicitVariableDispatcher.invoke(_trace_, context);
    } catch (Exception _e_typeOfImplicitVariable) {
    	sneakyThrowRuleFailedException(_e_typeOfImplicitVariable);
    	return null;
    }
  }

  protected void typeOfImplicitVariableThrowException(final String _error, final String _issue, final Exception _ex, final EObject context, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected RTypeFunction typeFunctionOfTypeAliasInternal(final RuleApplicationTrace _trace_, final RosettaTypeAlias typeAlias) {
    return getFromCache("typeFunctionOfTypeAliasInternal", (RuleEnvironment)null, _trace_,
    	new XsemanticsProvider<RTypeFunction>(null, _trace_) {
    		public RTypeFunction doGet() {
    			try {
    				checkParamsNotNull(typeAlias);
    				return typeFunctionOfTypeAliasDispatcher.invoke(_trace_, typeAlias);
    			} catch (Exception _e_typeFunctionOfTypeAlias) {
    				sneakyThrowRuleFailedException(_e_typeFunctionOfTypeAlias);
    				return null;
    			}
    		}
    	}, typeAlias);
  }

  protected void typeFunctionOfTypeAliasThrowException(final String _error, final String _issue, final Exception _ex, final RosettaTypeAlias typeAlias, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected RType typeCallToRTypeInternal(final RuleApplicationTrace _trace_, final TypeCall rt, final RosettaInterpreterContext context) {
    try {
    	checkParamsNotNull(rt, context);
    	return typeCallToRTypeDispatcher.invoke(_trace_, rt, context);
    } catch (Exception _e_typeCallToRType) {
    	sneakyThrowRuleFailedException(_e_typeCallToRType);
    	return null;
    }
  }

  protected void typeCallToRTypeThrowException(final String _error, final String _issue, final Exception _ex, final TypeCall rt, final RosettaInterpreterContext context, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected RListType attributeListTypeInternal(final RuleApplicationTrace _trace_, final Attribute a) {
    try {
    	checkParamsNotNull(a);
    	return attributeListTypeDispatcher.invoke(_trace_, a);
    } catch (Exception _e_attributeListType) {
    	sneakyThrowRuleFailedException(_e_attributeListType);
    	return null;
    }
  }

  protected void attributeListTypeThrowException(final String _error, final String _issue, final Exception _ex, final Attribute a, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    throwRuleFailedException(_error, _issue, _ex, _errorInformations);
  }

  protected Result<RListType> inferTypeInternal(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RosettaExpression expression) {
    return getFromCache("inferTypeInternal", _environment_, _trace_,
    	new XsemanticsProvider<Result<RListType>>(_environment_, _trace_) {
    		public Result<RListType> doGet() {
    			try {
    				checkParamsNotNull(expression);
    				return inferTypeDispatcher.invoke(_environment_, _trace_, expression);
    			} catch (Exception _e_inferType) {
    				sneakyThrowRuleFailedException(_e_inferType);
    				return null;
    			}
    		}
    	}, expression);
  }

  protected void inferTypeThrowException(final String _error, final String _issue, final Exception _ex, final RosettaExpression expression, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    String _stringRep = this.stringRep(expression);
    String _plus = ("Cannot type " + _stringRep);
    String _plus_1 = (_plus + ".");
    String error = _plus_1;
    EObject source = expression;
    throwRuleFailedException(error,
    	_issue, _ex, new ErrorInformation(source, null));
  }

  protected Result<Boolean> subtypeInternal(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RType subtype, final RType supertype) {
    try {
    	checkParamsNotNull(subtype, supertype);
    	return subtypeDispatcher.invoke(_environment_, _trace_, subtype, supertype);
    } catch (Exception _e_subtype) {
    	sneakyThrowRuleFailedException(_e_subtype);
    	return null;
    }
  }

  protected void subtypeThrowException(final String _error, final String _issue, final Exception _ex, final RType subtype, final RType supertype, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    String _plus = (subtype + " is not a subtype of ");
    String _plus_1 = (_plus + supertype);
    String error = _plus_1;
    throwRuleFailedException(error,
    	_issue, _ex, new ErrorInformation(null, null));
  }

  protected Result<Boolean> listSubtypeInternal(final RuleEnvironment _environment_, final RuleApplicationTrace _trace_, final RListType subtype, final RListType supertype) {
    try {
    	checkParamsNotNull(subtype, supertype);
    	return listSubtypeDispatcher.invoke(_environment_, _trace_, subtype, supertype);
    } catch (Exception _e_listSubtype) {
    	sneakyThrowRuleFailedException(_e_listSubtype);
    	return null;
    }
  }

  protected void listSubtypeThrowException(final String _error, final String _issue, final Exception _ex, final RListType subtype, final RListType supertype, final ErrorInformation[] _errorInformations) throws RuleFailedException {
    String _plus = (subtype + " is not a list subtype of ");
    String _plus_1 = (_plus + supertype);
    String error = _plus_1;
    throwRuleFailedException(error,
    	_issue, _ex, new ErrorInformation(null, null));
  }

  protected Boolean comparableImpl(final RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunComparable(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("comparable") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunComparable) {
    	comparableThrowException(auxFunName("comparable") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		COMPARABLE,
    		e_applyAuxFunComparable, t1, t2, new ErrorInformation[] {});
    	return false;
    }
  }

  protected Boolean applyAuxFunComparable(final RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
    /* empty |- t1 <: t2 or empty |- t2 <: t1 or return false */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- t1 <: t2 */
        subtypeInternal(emptyEnvironment(), _trace_, t1, t2);
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        /* empty |- t2 <: t1 or return false */
        {
          try {
            /* empty |- t2 <: t1 */
            subtypeInternal(emptyEnvironment(), _trace_, t2, t1);
          } catch (Exception e_1) {
            previousFailure = extractRuleFailedException(e_1);
            return Boolean.valueOf(false);
          }
        }
      }
    }
    return true;
  }

  protected Boolean listComparableImpl(final RuleApplicationTrace _trace_, final RListType t1, final RListType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Boolean _result_ = applyAuxFunListComparable(_subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("listComparable") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunListComparable) {
    	listComparableThrowException(auxFunName("listComparable") + "(" + stringRep(t1) + ", " + stringRep(t2)+ ")",
    		LISTCOMPARABLE,
    		e_applyAuxFunListComparable, t1, t2, new ErrorInformation[] {});
    	return false;
    }
  }

  protected Boolean applyAuxFunListComparable(final RuleApplicationTrace _trace_, final RListType t1, final RListType t2) throws RuleFailedException {
    Boolean _comparable = this.comparableInternal(_trace_, t1.getItemType(), t2.getItemType());
    /* comparable(t1.itemType, t2.itemType) */
    if (!_comparable) {
      sneakyThrowRuleFailedException("comparable(t1.itemType, t2.itemType)");
    }
    Boolean _overlap = this.overlapInternal(_trace_, t1.getConstraint(), t2.getConstraint());
    /* overlap(t1.constraint, t2.constraint) */
    if (!_overlap) {
      sneakyThrowRuleFailedException("overlap(t1.constraint, t2.constraint)");
    }
    return true;
  }

  protected RListType symbolListTypeImpl(final RuleApplicationTrace _trace_, final Attribute c) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunSymbolListType(_subtrace_, c);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("symbolListType") + "(" + stringRep(c)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunSymbolListType) {
    	symbolListTypeThrowException(auxFunName("symbolListType") + "(" + stringRep(c)+ ")",
    		SYMBOLLISTTYPE,
    		e_applyAuxFunSymbolListType, c, new ErrorInformation[] {new ErrorInformation(c)});
    	return null;
    }
  }

  protected RListType applyAuxFunSymbolListType(final RuleApplicationTrace _trace_, final Attribute c) throws RuleFailedException {
    return this.attributeListTypeInternal(_trace_, c);
  }

  protected RListType symbolListTypeImpl(final RuleApplicationTrace _trace_, final ClosureParameter c) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunSymbolListType(_subtrace_, c);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("symbolListType") + "(" + stringRep(c)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunSymbolListType) {
    	symbolListTypeThrowException(auxFunName("symbolListType") + "(" + stringRep(c)+ ")",
    		SYMBOLLISTTYPE,
    		e_applyAuxFunSymbolListType, c, new ErrorInformation[] {new ErrorInformation(c)});
    	return null;
    }
  }

  protected RListType applyAuxFunSymbolListType(final RuleApplicationTrace _trace_, final ClosureParameter c) throws RuleFailedException {
    final InlineFunction f = c.getFunction();
    EObject _eContainer = f.eContainer();
    final RosettaFunctionalOperation op = ((RosettaFunctionalOperation) _eContainer);
    return this.functionalOperationItemTypeInternal(_trace_, op);
  }

  protected RListType symbolListTypeImpl(final RuleApplicationTrace _trace_, final RosettaEnumeration c) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunSymbolListType(_subtrace_, c);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("symbolListType") + "(" + stringRep(c)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunSymbolListType) {
    	symbolListTypeThrowException(auxFunName("symbolListType") + "(" + stringRep(c)+ ")",
    		SYMBOLLISTTYPE,
    		e_applyAuxFunSymbolListType, c, new ErrorInformation[] {new ErrorInformation(c)});
    	return null;
    }
  }

  protected RListType applyAuxFunSymbolListType(final RuleApplicationTrace _trace_, final RosettaEnumeration c) throws RuleFailedException {
    REnumType _rEnumType = new REnumType(c);
    return this.typeFactory.createListType(_rEnumType, this.typeFactory.single);
  }

  protected RListType symbolListTypeImpl(final RuleApplicationTrace _trace_, final ShortcutDeclaration c) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunSymbolListType(_subtrace_, c);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("symbolListType") + "(" + stringRep(c)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunSymbolListType) {
    	symbolListTypeThrowException(auxFunName("symbolListType") + "(" + stringRep(c)+ ")",
    		SYMBOLLISTTYPE,
    		e_applyAuxFunSymbolListType, c, new ErrorInformation[] {new ErrorInformation(c)});
    	return null;
    }
  }

  protected RListType applyAuxFunSymbolListType(final RuleApplicationTrace _trace_, final ShortcutDeclaration c) throws RuleFailedException {
    /* empty |- c.expression : var RListType t */
    RosettaExpression _expression = c.getExpression();
    RListType t = null;
    Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _expression);
    checkAssignableTo(result.getFirst(), RListType.class);
    t = (RListType) result.getFirst();
    
    return t;
  }

  protected RListType symbolListTypeImpl(final RuleApplicationTrace _trace_, final RosettaExternalFunction c) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunSymbolListType(_subtrace_, c);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("symbolListType") + "(" + stringRep(c)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunSymbolListType) {
    	symbolListTypeThrowException(auxFunName("symbolListType") + "(" + stringRep(c)+ ")",
    		SYMBOLLISTTYPE,
    		e_applyAuxFunSymbolListType, c, new ErrorInformation[] {new ErrorInformation(c)});
    	return null;
    }
  }

  protected RListType applyAuxFunSymbolListType(final RuleApplicationTrace _trace_, final RosettaExternalFunction c) throws RuleFailedException {
    TypeCall _typeCall = c.getTypeCall();
    RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
    return this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall, _rosettaInterpreterContext), 1, 1);
  }

  protected RListType symbolListTypeImpl(final RuleApplicationTrace _trace_, final Function c) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunSymbolListType(_subtrace_, c);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("symbolListType") + "(" + stringRep(c)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunSymbolListType) {
    	symbolListTypeThrowException(auxFunName("symbolListType") + "(" + stringRep(c)+ ")",
    		SYMBOLLISTTYPE,
    		e_applyAuxFunSymbolListType, c, new ErrorInformation[] {new ErrorInformation(c)});
    	return null;
    }
  }

  protected RListType applyAuxFunSymbolListType(final RuleApplicationTrace _trace_, final Function c) throws RuleFailedException {
    TypeCall _typeCall = c.getOutput().getTypeCall();
    RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
    return this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall, _rosettaInterpreterContext), c.getOutput().getCard());
  }

  protected RListType symbolListTypeImpl(final RuleApplicationTrace _trace_, final RosettaRule c) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunSymbolListType(_subtrace_, c);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("symbolListType") + "(" + stringRep(c)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunSymbolListType) {
    	symbolListTypeThrowException(auxFunName("symbolListType") + "(" + stringRep(c)+ ")",
    		SYMBOLLISTTYPE,
    		e_applyAuxFunSymbolListType, c, new ErrorInformation[] {new ErrorInformation(c)});
    	return null;
    }
  }

  protected RListType applyAuxFunSymbolListType(final RuleApplicationTrace _trace_, final RosettaRule c) throws RuleFailedException {
    /* empty |- c.expression : var RListType t */
    RosettaExpression _expression = c.getExpression();
    RListType t = null;
    Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _expression);
    checkAssignableTo(result.getFirst(), RListType.class);
    t = (RListType) result.getFirst();
    
    return t;
  }

  protected RListType functionalOperationItemTypeImpl(final RuleApplicationTrace _trace_, final RosettaFunctionalOperation op) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunFunctionalOperationItemType(_subtrace_, op);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("functionalOperationItemType") + "(" + stringRep(op)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunFunctionalOperationItemType) {
    	functionalOperationItemTypeThrowException(auxFunName("functionalOperationItemType") + "(" + stringRep(op)+ ")",
    		FUNCTIONALOPERATIONITEMTYPE,
    		e_applyAuxFunFunctionalOperationItemType, op, new ErrorInformation[] {new ErrorInformation(op)});
    	return null;
    }
  }

  protected RListType applyAuxFunFunctionalOperationItemType(final RuleApplicationTrace _trace_, final RosettaFunctionalOperation op) throws RuleFailedException {
    RListType receiverType = null;
    /* empty |- op.argument : receiverType or receiverType = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- op.argument : receiverType */
        RosettaExpression _argument = op.getArgument();
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _argument);
        checkAssignableTo(result.getFirst(), RListType.class);
        receiverType = (RListType) result.getFirst();
        
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        receiverType = null;
      }
    }
    if ((receiverType != null)) {
      if ((op instanceof ThenOperation)) {
        return receiverType;
      } else {
        return this.typeFactory.createListType(receiverType.getItemType(), this.typeFactory.single);
      }
    }
    return null;
  }

  protected Optional<RListType> typeOfImplicitVariableImpl(final RuleApplicationTrace _trace_, final EObject c) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Optional<RListType> _result_ = applyAuxFunTypeOfImplicitVariable(_subtrace_, c);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("typeOfImplicitVariable") + "(" + stringRep(c)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunTypeOfImplicitVariable) {
    	typeOfImplicitVariableThrowException(auxFunName("typeOfImplicitVariable") + "(" + stringRep(c)+ ")",
    		TYPEOFIMPLICITVARIABLE,
    		e_applyAuxFunTypeOfImplicitVariable, c, new ErrorInformation[] {new ErrorInformation(c)});
    	return null;
    }
  }

  protected Optional<RListType> applyAuxFunTypeOfImplicitVariable(final RuleApplicationTrace _trace_, final EObject c) throws RuleFailedException {
    Optional<RListType> _xblockexpression = null;
    {
      final Optional<EObject> definingContainer = this.implicitVarUtil.findContainerDefiningImplicitVariable(c);
      final java.util.function.Function<EObject, RListType> _function = (EObject it) -> {
        RListType _xifexpression = null;
        if ((it instanceof Data)) {
          RDataType _rDataType = new RDataType(((Data)it));
          _xifexpression = this.typeFactory.createListType(_rDataType, this.typeFactory.single);
        } else {
          RListType _xifexpression_1 = null;
          if ((it instanceof RosettaFunctionalOperation)) {
            _xifexpression_1 = this.functionalOperationItemTypeInternal(_trace_, ((RosettaFunctionalOperation)it));
          } else {
            RListType _xifexpression_2 = null;
            if ((it instanceof RosettaRule)) {
              TypeCall _input = ((RosettaRule)it).getInput();
              RType _typeCallToRType = null;
              if (_input!=null) {
                RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
                _typeCallToRType=this.typeCallToRTypeInternal(_trace_, _input, _rosettaInterpreterContext);
              }
              RListType _createListType = null;
              if (_typeCallToRType!=null) {
                _createListType=this.typeFactory.createListType(_typeCallToRType, this.typeFactory.single);
              }
              _xifexpression_2 = _createListType;
            }
            _xifexpression_1 = _xifexpression_2;
          }
          _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
      };
      _xblockexpression = (definingContainer.<RListType>map(_function));
    }
    return _xblockexpression;
  }

  protected RTypeFunction typeFunctionOfTypeAliasImpl(final RuleApplicationTrace _trace_, final RosettaTypeAlias typeAlias) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RTypeFunction _result_ = applyAuxFunTypeFunctionOfTypeAlias(_subtrace_, typeAlias);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("typeFunctionOfTypeAlias") + "(" + stringRep(typeAlias)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunTypeFunctionOfTypeAlias) {
    	typeFunctionOfTypeAliasThrowException(auxFunName("typeFunctionOfTypeAlias") + "(" + stringRep(typeAlias)+ ")",
    		TYPEFUNCTIONOFTYPEALIAS,
    		e_applyAuxFunTypeFunctionOfTypeAlias, typeAlias, new ErrorInformation[] {new ErrorInformation(typeAlias)});
    	return null;
    }
  }

  protected RTypeFunction applyAuxFunTypeFunctionOfTypeAlias(final RuleApplicationTrace _trace_, final RosettaTypeAlias typeAlias) throws RuleFailedException {
    String _name = typeAlias.getName();
    boolean _equals = Objects.equal(_name, this.builtinTypes.INT_NAME);
    if (_equals) {
      return this.builtinTypes.INT_FUNCTION;
    }
    final EList<TypeParameter> parameters = typeAlias.getParameters();
    final DottedPath namespace = DottedPath.splitOnDots(typeAlias.getModel().getName());
    final Function1<TypeCallArgument, RosettaSimpleSystemSolver.Equation> _function = (TypeCallArgument arg) -> {
      final RosettaSymbolReference ref = ExpressionFactory.eINSTANCE.createRosettaSymbolReference();
      ref.setGenerated(true);
      ref.setSymbol(arg.getParameter());
      RosettaExpression _value = arg.getValue();
      return new RosettaSimpleSystemSolver.Equation(ref, _value);
    };
    final List<RosettaSimpleSystemSolver.Equation> equations = IterableExtensions.<RosettaSimpleSystemSolver.Equation>toList(ListExtensions.<TypeCallArgument, RosettaSimpleSystemSolver.Equation>map(typeAlias.getTypeCall().getArguments(), _function));
    final java.util.function.Function<RosettaSimpleSystemSolver.SolutionSet, RTypeFunction> _function_1 = (RosettaSimpleSystemSolver.SolutionSet solutionSet) -> {
      final java.util.function.Function<Map<String, RosettaValue>, RType> _function_2 = (Map<String, RosettaValue> arguments) -> {
        return this.typeCallToRTypeInternal(_trace_, typeAlias.getTypeCall(), RosettaInterpreterContext.of(arguments));
      };
      final java.util.function.Function<RType, Optional<LinkedHashMap<String, RosettaValue>>> _function_3 = (RType type) -> {
        if ((!(type instanceof RParametrizedType))) {
          return Optional.<LinkedHashMap<String, RosettaValue>>empty();
        }
        final RosettaInterpreterContext context = RosettaInterpreterContext.of(((RParametrizedType) type).getArguments());
        final java.util.function.Function<Map<RosettaSymbol, RosettaValue>, LinkedHashMap<String, RosettaValue>> _function_4 = (Map<RosettaSymbol, RosettaValue> solution) -> {
          final LinkedHashMap<String, RosettaValue> newArgs = CollectionLiterals.<String, RosettaValue>newLinkedHashMap();
          final Consumer<TypeParameter> _function_5 = (TypeParameter p) -> {
            newArgs.put(p.getName(), solution.get(p));
          };
          parameters.forEach(_function_5);
          return newArgs;
        };
        return solutionSet.getSolution(context).<LinkedHashMap<String, RosettaValue>>map(_function_4);
      };
      return RTypeFunction.create(namespace, typeAlias.getName(), _function_2, _function_3);
    };
    final Supplier<RTypeFunction> _function_2 = () -> {
      final java.util.function.Function<Map<String, RosettaValue>, RType> _function_3 = (Map<String, RosettaValue> arguments) -> {
        return this.typeCallToRTypeInternal(_trace_, typeAlias.getTypeCall(), RosettaInterpreterContext.of(arguments));
      };
      final java.util.function.Function<RType, Optional<LinkedHashMap<String, RosettaValue>>> _function_4 = (RType it) -> {
        return Optional.<LinkedHashMap<String, RosettaValue>>empty();
      };
      return RTypeFunction.create(namespace, typeAlias.getName(), _function_3, _function_4);
    };
    return this.systemSolver.solve(equations, IterableExtensions.<TypeParameter>toSet(parameters)).<RTypeFunction>map(_function_1).orElseGet(_function_2);
  }

  protected RType typeCallToRTypeImpl(final RuleApplicationTrace _trace_, final TypeCall call, final RosettaInterpreterContext context) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RType _result_ = applyAuxFunTypeCallToRType(_subtrace_, call, context);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("typeCallToRType") + "(" + stringRep(call) + ", " + stringRep(context)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunTypeCallToRType) {
    	typeCallToRTypeThrowException(auxFunName("typeCallToRType") + "(" + stringRep(call) + ", " + stringRep(context)+ ")",
    		TYPECALLTORTYPE,
    		e_applyAuxFunTypeCallToRType, call, context, new ErrorInformation[] {new ErrorInformation(call)});
    	return null;
    }
  }

  protected RType applyAuxFunTypeCallToRType(final RuleApplicationTrace _trace_, final TypeCall call, final RosettaInterpreterContext context) throws RuleFailedException {
    RType _xblockexpression = null;
    {
      final RosettaType t = call.getType();
      RType _switchResult = null;
      boolean _matched = false;
      if (t instanceof Data) {
        _matched=true;
        _switchResult = new RDataType(((Data)t));
      }
      if (!_matched) {
        if (t instanceof RosettaBuiltinType) {
          _matched=true;
          RType _xblockexpression_1 = null;
          {
            final Function1<TypeCallArgument, String> _function = (TypeCallArgument it) -> {
              return it.getParameter().getName();
            };
            final Function1<TypeCallArgument, RosettaValue> _function_1 = (TypeCallArgument it) -> {
              return this.interpreter.interpret(it.getValue(), context);
            };
            final Map<String, RosettaValue> argMap = IterableExtensions.<TypeCallArgument, String, RosettaValue>toMap(call.getArguments(), _function, _function_1);
            _xblockexpression_1 = (this.builtinTypes.getType(((RosettaBuiltinType)t).getName(), argMap).orElse(null));
          }
          _switchResult = _xblockexpression_1;
        }
      }
      if (!_matched) {
        if (t instanceof RosettaEnumeration) {
          _matched=true;
          _switchResult = new REnumType(((RosettaEnumeration)t));
        }
      }
      if (!_matched) {
        if (t instanceof RosettaMetaType) {
          _matched=true;
          RType _xblockexpression_1 = null;
          {
            final Function1<TypeCallArgument, String> _function = (TypeCallArgument it) -> {
              return it.getParameter().getName();
            };
            final Function1<TypeCallArgument, RosettaValue> _function_1 = (TypeCallArgument it) -> {
              return this.interpreter.interpret(it.getValue(), context);
            };
            final Map<String, RosettaValue> argMap = IterableExtensions.<TypeCallArgument, String, RosettaValue>toMap(call.getArguments(), _function, _function_1);
            final Optional<RType> builtinResult = this.builtinTypes.getType(((RosettaMetaType)t).getName(), argMap);
            RType _xifexpression = null;
            boolean _isPresent = builtinResult.isPresent();
            if (_isPresent) {
              _xifexpression = builtinResult.get();
            } else {
              _xifexpression = this.typeCallToRTypeInternal(_trace_, ((RosettaMetaType)t).getTypeCall(), context);
            }
            _xblockexpression_1 = (_xifexpression);
          }
          _switchResult = _xblockexpression_1;
        }
      }
      if (!_matched) {
        if (t instanceof RosettaTypeAlias) {
          _matched=true;
          RAliasType _xblockexpression_1 = null;
          {
            final LinkedHashMap<String, RosettaValue> args = CollectionLiterals.<String, RosettaValue>newLinkedHashMap();
            final Set<TypeParameter> absentParameters = IterableExtensions.<TypeParameter>toSet(((RosettaTypeAlias)t).getParameters());
            final Consumer<TypeCallArgument> _function = (TypeCallArgument arg) -> {
              final RosettaValue eval = this.interpreter.interpret(arg.getValue(), context);
              args.put(arg.getParameter().getName(), eval);
              absentParameters.remove(arg.getParameter());
            };
            call.getArguments().forEach(_function);
            final Consumer<TypeParameter> _function_1 = (TypeParameter it) -> {
              args.put(it.getName(), RosettaValue.empty());
            };
            absentParameters.forEach(_function_1);
            final RType refersTo = this.typeCallToRTypeInternal(_trace_, ((RosettaTypeAlias)t).getTypeCall(), RosettaInterpreterContext.of(args));
            RTypeFunction _typeFunctionOfTypeAlias = this.typeFunctionOfTypeAliasInternal(_trace_, ((RosettaTypeAlias)t));
            _xblockexpression_1 = (new RAliasType(_typeFunctionOfTypeAlias, args, refersTo));
          }
          _switchResult = _xblockexpression_1;
        }
      }
      _xblockexpression = (_switchResult);
    }
    return _xblockexpression;
  }

  protected RListType attributeListTypeImpl(final RuleApplicationTrace _trace_, final Attribute a) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final RListType _result_ = applyAuxFunAttributeListType(_subtrace_, a);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return auxFunName("attributeListType") + "(" + stringRep(a)+ ")" + " = " + stringRep(_result_);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyAuxFunAttributeListType) {
    	attributeListTypeThrowException(auxFunName("attributeListType") + "(" + stringRep(a)+ ")",
    		ATTRIBUTELISTTYPE,
    		e_applyAuxFunAttributeListType, a, new ErrorInformation[] {new ErrorInformation(a)});
    	return null;
    }
  }

  protected RListType applyAuxFunAttributeListType(final RuleApplicationTrace _trace_, final Attribute a) throws RuleFailedException {
    TypeCall _typeCall = a.getTypeCall();
    RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
    return this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall, _rosettaInterpreterContext), a.getCard());
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RDataType t1, final RDataType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSData(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SData") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSData) {
    	subtypeThrowException(ruleName("SData") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SDATA,
    		e_applyRuleSData, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSData(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RDataType t1, final RDataType t2) throws RuleFailedException {
    /* { t1 == t2 } or { ancestors(t1.^data).contains(t2.^data) } */
    {
      RuleFailedException previousFailure = null;
      try {
        /* t1 == t2 */
        if (!Objects.equal(t1, t2)) {
          sneakyThrowRuleFailedException("t1 == t2");
        }
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        /* ancestors(t1.^data).contains(t2.^data) */
        if (!this.ancestorsInternal(_trace_, t1.getData()).contains(t2.getData())) {
          sneakyThrowRuleFailedException("ancestors(t1.^data).contains(t2.^data)");
        }
      }
    }
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RNumberType t1, final RNumberType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSNumber(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SNumber") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSNumber) {
    	subtypeThrowException(ruleName("SNumber") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SNUMBER,
    		e_applyRuleSNumber, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSNumber(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RNumberType t1, final RNumberType t2) throws RuleFailedException {
    /* true */
    if (!true) {
      sneakyThrowRuleFailedException("true");
    }
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RStringType t1, final RStringType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSString(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SString") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSString) {
    	subtypeThrowException(ruleName("SString") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SSTRING,
    		e_applyRuleSString, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSString(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RStringType t1, final RStringType t2) throws RuleFailedException {
    /* true */
    if (!true) {
      sneakyThrowRuleFailedException("true");
    }
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RBasicType t1, final RBasicType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSBasic(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SBasic") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSBasic) {
    	subtypeThrowException(ruleName("SBasic") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SBASIC,
    		e_applyRuleSBasic, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSBasic(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RBasicType t1, final RBasicType t2) throws RuleFailedException {
    /* { t1 == t2 } or { t1 == NOTHING } or { t2 == ANY } */
    {
      RuleFailedException previousFailure = null;
      try {
        /* t1 == t2 */
        if (!Objects.equal(t1, t2)) {
          sneakyThrowRuleFailedException("t1 == t2");
        }
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        /* { t1 == NOTHING } or { t2 == ANY } */
        {
          try {
            /* t1 == NOTHING */
            if (!Objects.equal(t1, this.builtinTypes.NOTHING)) {
              sneakyThrowRuleFailedException("t1 == NOTHING");
            }
          } catch (Exception e_1) {
            previousFailure = extractRuleFailedException(e_1);
            /* t2 == ANY */
            if (!Objects.equal(t2, this.builtinTypes.ANY)) {
              sneakyThrowRuleFailedException("t2 == ANY");
            }
          }
        }
      }
    }
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RBasicType t1, final RType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSNothing(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SNothing") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSNothing) {
    	subtypeThrowException(ruleName("SNothing") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SNOTHING,
    		e_applyRuleSNothing, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSNothing(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RBasicType t1, final RType t2) throws RuleFailedException {
    /* { t1 == t2 } or { t1 == NOTHING } */
    {
      RuleFailedException previousFailure = null;
      try {
        /* t1 == t2 */
        if (!Objects.equal(t1, t2)) {
          sneakyThrowRuleFailedException("t1 == t2");
        }
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        /* t1 == NOTHING */
        if (!Objects.equal(t1, this.builtinTypes.NOTHING)) {
          sneakyThrowRuleFailedException("t1 == NOTHING");
        }
      }
    }
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RType t1, final RBasicType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSAny(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SAny") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSAny) {
    	subtypeThrowException(ruleName("SAny") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SANY,
    		e_applyRuleSAny, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSAny(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RType t1, final RBasicType t2) throws RuleFailedException {
    /* { t1 == t2 } or { t2 == ANY } */
    {
      RuleFailedException previousFailure = null;
      try {
        /* t1 == t2 */
        if (!Objects.equal(t1, t2)) {
          sneakyThrowRuleFailedException("t1 == t2");
        }
      } catch (Exception e) {
        previousFailure = extractRuleFailedException(e);
        /* t2 == ANY */
        if (!Objects.equal(t2, this.builtinTypes.ANY)) {
          sneakyThrowRuleFailedException("t2 == ANY");
        }
      }
    }
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RAliasType t1, final RAliasType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSAliasBoth(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SAliasBoth") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSAliasBoth) {
    	subtypeThrowException(ruleName("SAliasBoth") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SALIASBOTH,
    		e_applyRuleSAliasBoth, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSAliasBoth(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RAliasType t1, final RAliasType t2) throws RuleFailedException {
    /* G |- t1.refersTo <: t2.refersTo */
    RType _refersTo = t1.getRefersTo();
    RType _refersTo_1 = t2.getRefersTo();
    subtypeInternal(G, _trace_, _refersTo, _refersTo_1);
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RAliasType t1, final RType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSAliasLeft(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SAliasLeft") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSAliasLeft) {
    	subtypeThrowException(ruleName("SAliasLeft") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SALIASLEFT,
    		e_applyRuleSAliasLeft, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSAliasLeft(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RAliasType t1, final RType t2) throws RuleFailedException {
    /* G |- t1.refersTo <: t2 */
    RType _refersTo = t1.getRefersTo();
    subtypeInternal(G, _trace_, _refersTo, t2);
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RType t1, final RAliasType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSAliasRight(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SAliasRight") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSAliasRight) {
    	subtypeThrowException(ruleName("SAliasRight") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SALIASRIGHT,
    		e_applyRuleSAliasRight, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSAliasRight(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RType t1, final RAliasType t2) throws RuleFailedException {
    /* G |- t1 <: t2.refersTo */
    RType _refersTo = t2.getRefersTo();
    subtypeInternal(G, _trace_, t1, _refersTo);
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RAliasType t1, final RBasicType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSAliasBasic(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SAliasBasic") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSAliasBasic) {
    	subtypeThrowException(ruleName("SAliasBasic") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SALIASBASIC,
    		e_applyRuleSAliasBasic, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSAliasBasic(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RAliasType t1, final RBasicType t2) throws RuleFailedException {
    /* G |- t1.refersTo <: t2 */
    RType _refersTo = t1.getRefersTo();
    subtypeInternal(G, _trace_, _refersTo, t2);
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RBasicType t1, final RAliasType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSBasicAlias(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SBasicAlias") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSBasicAlias) {
    	subtypeThrowException(ruleName("SBasicAlias") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SBASICALIAS,
    		e_applyRuleSBasicAlias, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSBasicAlias(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RBasicType t1, final RAliasType t2) throws RuleFailedException {
    /* G |- t1 <: t2.refersTo */
    RType _refersTo = t2.getRefersTo();
    subtypeInternal(G, _trace_, t1, _refersTo);
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> subtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSRefl(G, _subtrace_, t1, t2);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SRefl") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSRefl) {
    	subtypeThrowException(ruleName("SRefl") + stringRepForEnv(G) + " |- " + stringRep(t1) + " <: " + stringRep(t2),
    		SREFL,
    		e_applyRuleSRefl, t1, t2, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSRefl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RType t1, final RType t2) throws RuleFailedException {
    /* t1 == t2 */
    if (!Objects.equal(t1, t2)) {
      sneakyThrowRuleFailedException("t1 == t2");
    }
    return new Result<Boolean>(true);
  }

  protected Result<Boolean> listSubtypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RListType s, final RListType t) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<Boolean> _result_ = applyRuleSList(G, _subtrace_, s, t);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("SList") + stringRepForEnv(G) + " |- " + stringRep(s) + " <| " + stringRep(t);
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleSList) {
    	listSubtypeThrowException(ruleName("SList") + stringRepForEnv(G) + " |- " + stringRep(s) + " <| " + stringRep(t),
    		SLIST,
    		e_applyRuleSList, s, t, new ErrorInformation[] {});
    	return null;
    }
  }

  protected Result<Boolean> applyRuleSList(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RListType s, final RListType t) throws RuleFailedException {
    /* G |- s.itemType <: t.itemType */
    RType _itemType = s.getItemType();
    RType _itemType_1 = t.getItemType();
    subtypeInternal(G, _trace_, _itemType, _itemType_1);
    /* s.constraint.isSubconstraintOf(t.constraint) */
    if (!s.getConstraint().isSubconstraintOf(t.getConstraint())) {
      sneakyThrowRuleFailedException("s.constraint.isSubconstraintOf(t.constraint)");
    }
    return new Result<Boolean>(true);
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaBooleanLiteral bool) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTBoolean(G, _subtrace_, bool);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TBoolean") + stringRepForEnv(G) + " |- " + stringRep(bool) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTBoolean) {
    	inferTypeThrowException(ruleName("TBoolean") + stringRepForEnv(G) + " |- " + stringRep(bool) + " : " + "RListType",
    		TBOOLEAN,
    		e_applyRuleTBoolean, bool, new ErrorInformation[] {new ErrorInformation(bool)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTBoolean(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaBooleanLiteral bool) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTBoolean_1(G, bool));
  }

  private RListType _applyRuleTBoolean_1(final RuleEnvironment G, final RosettaBooleanLiteral bool) throws RuleFailedException {
    return this.typeFactory.singleBoolean;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaStringLiteral str) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTString(G, _subtrace_, str);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TString") + stringRepForEnv(G) + " |- " + stringRep(str) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTString) {
    	inferTypeThrowException(ruleName("TString") + stringRepForEnv(G) + " |- " + stringRep(str) + " : " + "RListType",
    		TSTRING,
    		e_applyRuleTString, str, new ErrorInformation[] {new ErrorInformation(str)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTString(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaStringLiteral str) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTString_1(G, str));
  }

  private RListType _applyRuleTString_1(final RuleEnvironment G, final RosettaStringLiteral str) throws RuleFailedException {
    RListType _singleString = this.typeFactory.singleString(str.getValue().length(), str.getValue().length());
    return _singleString;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaNumberLiteral num) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTNumber(G, _subtrace_, num);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TNumber") + stringRepForEnv(G) + " |- " + stringRep(num) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTNumber) {
    	inferTypeThrowException(ruleName("TNumber") + stringRepForEnv(G) + " |- " + stringRep(num) + " : " + "RListType",
    		TNUMBER,
    		e_applyRuleTNumber, num, new ErrorInformation[] {new ErrorInformation(num)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTNumber(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaNumberLiteral num) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTNumber_1(G, num));
  }

  private RListType _applyRuleTNumber_1(final RuleEnvironment G, final RosettaNumberLiteral num) throws RuleFailedException {
    RListType _singleNumber = this.typeFactory.singleNumber(num.getValue().toPlainString().replaceAll("\\.|\\-", "").length(), Math.max(0, num.getValue().scale()), num.getValue(), num.getValue());
    return _singleNumber;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaIntLiteral i) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTInt(G, _subtrace_, i);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TInt") + stringRepForEnv(G) + " |- " + stringRep(i) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTInt) {
    	inferTypeThrowException(ruleName("TInt") + stringRepForEnv(G) + " |- " + stringRep(i) + " : " + "RListType",
    		TINT,
    		e_applyRuleTInt, i, new ErrorInformation[] {new ErrorInformation(i)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTInt(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaIntLiteral i) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTInt_1(G, i));
  }

  private RListType _applyRuleTInt_1(final RuleEnvironment G, final RosettaIntLiteral i) throws RuleFailedException {
    int _xifexpression = (int) 0;
    int _signum = i.getValue().signum();
    boolean _greaterEqualsThan = (_signum >= 0);
    if (_greaterEqualsThan) {
      _xifexpression = i.getValue().toString().length();
    } else {
      int _length = i.getValue().toString().length();
      _xifexpression = (_length - 1);
    }
    RListType _singleInt = this.typeFactory.singleInt(_xifexpression, i.getValue(), i.getValue());
    return _singleInt;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaPatternLiteral p) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTPattern(G, _subtrace_, p);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TPattern") + stringRepForEnv(G) + " |- " + stringRep(p) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTPattern) {
    	inferTypeThrowException(ruleName("TPattern") + stringRepForEnv(G) + " |- " + stringRep(p) + " : " + "RListType",
    		TPATTERN,
    		e_applyRuleTPattern, p, new ErrorInformation[] {new ErrorInformation(p)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTPattern(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaPatternLiteral p) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTPattern_1(G, p));
  }

  private RListType _applyRuleTPattern_1(final RuleEnvironment G, final RosettaPatternLiteral p) throws RuleFailedException {
    return this.typeFactory.singlePattern;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaSymbolReference ref) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTVar(G, _subtrace_, ref);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TVar") + stringRepForEnv(G) + " |- " + stringRep(ref) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTVar) {
    	inferTypeThrowException(ruleName("TVar") + stringRepForEnv(G) + " |- " + stringRep(ref) + " : " + "RListType",
    		TVAR,
    		e_applyRuleTVar, ref, new ErrorInformation[] {new ErrorInformation(ref)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTVar(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaSymbolReference ref) throws RuleFailedException {
    RListType t = null; // output parameter
    t = this.symbolListTypeInternal(_trace_, ref.getSymbol());
    final Optional<RListType> itType = this.typeOfImplicitVariableInternal(_trace_, ref);
    boolean _isPresent = itType.isPresent();
    if (_isPresent) {
      RType _itemType = itType.get().getItemType();
      Resource _eResource = ref.eResource();
      ResourceSet _resourceSet = null;
      if (_eResource!=null) {
        _resourceSet=_eResource.getResourceSet();
      }
      boolean _contains = IterableExtensions.contains(this.allFeaturesInternal(_trace_, _itemType, _resourceSet), ref.getSymbol());
      if (_contains) {
        RType _itemType_1 = t.getItemType();
        RosettaCardinality _constraint = t.getConstraint();
        RosettaCardinality _constraint_1 = itType.get().getConstraint();
        RosettaCardinality _multiply = _constraint.operator_multiply(_constraint_1);
        t = this.typeFactory.createListType(_itemType_1, _multiply);
      }
    }
    return new Result<RListType>(t);
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaImplicitVariable c) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTIt(G, _subtrace_, c);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TIt") + stringRepForEnv(G) + " |- " + stringRep(c) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTIt) {
    	inferTypeThrowException(ruleName("TIt") + stringRepForEnv(G) + " |- " + stringRep(c) + " : " + "RListType",
    		TIT,
    		e_applyRuleTIt, c, new ErrorInformation[] {new ErrorInformation(c)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTIt(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaImplicitVariable c) throws RuleFailedException {
    RListType t = null; // output parameter
    t = this.typeOfImplicitVariableInternal(_trace_, c).orElse(null);
    return new Result<RListType>(t);
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final ArithmeticOperation op) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTArithmetic(G, _subtrace_, op);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TArithmetic") + stringRepForEnv(G) + " |- " + stringRep(op) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTArithmetic) {
    	inferTypeThrowException(ruleName("TArithmetic") + stringRepForEnv(G) + " |- " + stringRep(op) + " : " + "RListType",
    		TARITHMETIC,
    		e_applyRuleTArithmetic, op, new ErrorInformation[] {new ErrorInformation(op)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTArithmetic(final RuleEnvironment G, final RuleApplicationTrace _trace_, final ArithmeticOperation op) throws RuleFailedException {
    RListType lt = null; // output parameter
    /* G |- op.left : var RListType t1 */
    RosettaExpression _left = op.getLeft();
    RListType t1 = null;
    Result<RListType> result = inferTypeInternal(G, _trace_, _left);
    checkAssignableTo(result.getFirst(), RListType.class);
    t1 = (RListType) result.getFirst();
    
    /* G |- op.right : var RListType t2 */
    RosettaExpression _right = op.getRight();
    RListType t2 = null;
    Result<RListType> result_1 = inferTypeInternal(G, _trace_, _right);
    checkAssignableTo(result_1.getFirst(), RListType.class);
    t2 = (RListType) result_1.getFirst();
    
    if (((t1 != null) && (t2 != null))) {
      final RType item1 = t1.getItemType();
      final RType item2 = t2.getItemType();
      String _operator = op.getOperator();
      boolean _equals = Objects.equal(_operator, "+");
      if (_equals) {
        /* G |- item1 <: DATE */
        boolean _ruleinvocation = subtypeSucceeded(G, _trace_, item1, this.builtinTypes.DATE);
        if (_ruleinvocation) {
          lt = this.typeFactory.singleDateTime;
        } else {
          boolean _and = false;
          /* G |- item1 <: UNCONSTRAINED_STRING */
          boolean _ruleinvocation_1 = subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_STRING);
          if (!_ruleinvocation_1) {
            _and = false;
          } else {
            /* G |- item2 <: UNCONSTRAINED_STRING */
            boolean _ruleinvocation_2 = subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_STRING);
            _and = _ruleinvocation_2;
          }
          if (_and) {
            final BiFunction<RType, RType, RType> _function = (RType l, RType r) -> {
              RStringType _xblockexpression = null;
              {
                final RStringType s1 = ((RStringType) l);
                final RStringType s2 = ((RStringType) r);
                final PositiveIntegerInterval newInterval = s1.getInterval().add(s2.getInterval());
                _xblockexpression = this.typeFactory.constrainedString(newInterval, Optional.<Pattern>empty());
              }
              return _xblockexpression;
            };
            lt = this.typeFactory.createListType(this.keepTypeAliasIfPossibleInternal(_trace_, item1, item2, _function), this.typeFactory.single);
          } else {
            boolean _and_1 = false;
            /* G |- item1 <: UNCONSTRAINED_NUMBER */
            boolean _ruleinvocation_3 = subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_NUMBER);
            if (!_ruleinvocation_3) {
              _and_1 = false;
            } else {
              /* G |- item2 <: UNCONSTRAINED_NUMBER */
              boolean _ruleinvocation_4 = subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_NUMBER);
              _and_1 = _ruleinvocation_4;
            }
            if (_and_1) {
              final BiFunction<RType, RType, RType> _function_1 = (RType l, RType r) -> {
                RNumberType _xblockexpression = null;
                {
                  final RNumberType n1 = ((RNumberType) l);
                  final RNumberType n2 = ((RNumberType) r);
                  final BiFunction<Integer, Integer, Integer> _function_2 = (Integer a, Integer b) -> {
                    return Integer.valueOf(Math.max((a).intValue(), (b).intValue()));
                  };
                  final Optional<Integer> newFractionalDigits = OptionalUtil.<Integer, Integer>zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_2);
                  final BigDecimalInterval newInterval = n1.getInterval().add(n2.getInterval());
                  _xblockexpression = this.typeFactory.constrainedNumber(Optional.<Integer>empty(), newFractionalDigits, newInterval, Optional.<BigDecimal>empty());
                }
                return _xblockexpression;
              };
              lt = this.typeFactory.createListType(this.keepTypeAliasIfPossibleInternal(_trace_, item1, item2, _function_1), this.typeFactory.single);
            }
          }
        }
      } else {
        String _operator_1 = op.getOperator();
        boolean _equals_1 = Objects.equal(_operator_1, "-");
        if (_equals_1) {
          boolean _or = false;
          /* G |- item1 <: DATE */
          boolean _ruleinvocation_5 = subtypeSucceeded(G, _trace_, item1, this.builtinTypes.DATE);
          if (_ruleinvocation_5) {
            _or = true;
          } else {
            /* G |- item2 <: DATE */
            boolean _ruleinvocation_6 = subtypeSucceeded(G, _trace_, item2, this.builtinTypes.DATE);
            _or = _ruleinvocation_6;
          }
          if (_or) {
            lt = this.typeFactory.singleUnconstrainedInt;
          } else {
            boolean _and_2 = false;
            /* G |- item1 <: UNCONSTRAINED_NUMBER */
            boolean _ruleinvocation_7 = subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_NUMBER);
            if (!_ruleinvocation_7) {
              _and_2 = false;
            } else {
              /* G |- item2 <: UNCONSTRAINED_NUMBER */
              boolean _ruleinvocation_8 = subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_NUMBER);
              _and_2 = _ruleinvocation_8;
            }
            if (_and_2) {
              final BiFunction<RType, RType, RType> _function_2 = (RType l, RType r) -> {
                RNumberType _xblockexpression = null;
                {
                  final RNumberType n1 = ((RNumberType) l);
                  final RNumberType n2 = ((RNumberType) r);
                  final BiFunction<Integer, Integer, Integer> _function_3 = (Integer a, Integer b) -> {
                    return Integer.valueOf(Math.max((a).intValue(), (b).intValue()));
                  };
                  final Optional<Integer> newFractionalDigits = OptionalUtil.<Integer, Integer>zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_3);
                  final BigDecimalInterval newInterval = n1.getInterval().subtract(n2.getInterval());
                  _xblockexpression = this.typeFactory.constrainedNumber(Optional.<Integer>empty(), newFractionalDigits, newInterval, Optional.<BigDecimal>empty());
                }
                return _xblockexpression;
              };
              lt = this.typeFactory.createListType(this.keepTypeAliasIfPossibleInternal(_trace_, item1, item2, _function_2), this.typeFactory.single);
            }
          }
        } else {
          String _operator_2 = op.getOperator();
          boolean _equals_2 = Objects.equal(_operator_2, "*");
          if (_equals_2) {
            boolean _and_3 = false;
            /* G |- item1 <: UNCONSTRAINED_NUMBER */
            boolean _ruleinvocation_9 = subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_NUMBER);
            if (!_ruleinvocation_9) {
              _and_3 = false;
            } else {
              /* G |- item2 <: UNCONSTRAINED_NUMBER */
              boolean _ruleinvocation_10 = subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_NUMBER);
              _and_3 = _ruleinvocation_10;
            }
            if (_and_3) {
              final BiFunction<RType, RType, RType> _function_3 = (RType l, RType r) -> {
                RNumberType _xblockexpression = null;
                {
                  final RNumberType n1 = ((RNumberType) l);
                  final RNumberType n2 = ((RNumberType) r);
                  final BiFunction<Integer, Integer, Integer> _function_4 = (Integer a, Integer b) -> {
                    return Integer.valueOf(((a).intValue() + (b).intValue()));
                  };
                  final Optional<Integer> newFractionalDigits = OptionalUtil.<Integer, Integer>zipWith(n1.getFractionalDigits(), n2.getFractionalDigits(), _function_4);
                  final BigDecimalInterval newInterval = n1.getInterval().multiply(n2.getInterval());
                  _xblockexpression = this.typeFactory.constrainedNumber(Optional.<Integer>empty(), newFractionalDigits, newInterval, Optional.<BigDecimal>empty());
                }
                return _xblockexpression;
              };
              lt = this.typeFactory.createListType(this.keepTypeAliasIfPossibleInternal(_trace_, item1, item2, _function_3), this.typeFactory.single);
            }
          } else {
            String _operator_3 = op.getOperator();
            boolean _equals_3 = Objects.equal(_operator_3, "/");
            if (_equals_3) {
              boolean _and_4 = false;
              /* G |- item1 <: UNCONSTRAINED_NUMBER */
              boolean _ruleinvocation_11 = subtypeSucceeded(G, _trace_, item1, this.builtinTypes.UNCONSTRAINED_NUMBER);
              if (!_ruleinvocation_11) {
                _and_4 = false;
              } else {
                /* G |- item2 <: UNCONSTRAINED_NUMBER */
                boolean _ruleinvocation_12 = subtypeSucceeded(G, _trace_, item2, this.builtinTypes.UNCONSTRAINED_NUMBER);
                _and_4 = _ruleinvocation_12;
              }
              if (_and_4) {
                lt = this.typeFactory.singleUnconstrainedNumber;
              }
            }
          }
        }
      }
    }
    return new Result<RListType>(lt);
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final EqualityOperation op) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTEquality(G, _subtrace_, op);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TEquality") + stringRepForEnv(G) + " |- " + stringRep(op) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTEquality) {
    	inferTypeThrowException(ruleName("TEquality") + stringRepForEnv(G) + " |- " + stringRep(op) + " : " + "RListType",
    		TEQUALITY,
    		e_applyRuleTEquality, op, new ErrorInformation[] {new ErrorInformation(op)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTEquality(final RuleEnvironment G, final RuleApplicationTrace _trace_, final EqualityOperation op) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTEquality_1(G, op));
  }

  private RListType _applyRuleTEquality_1(final RuleEnvironment G, final EqualityOperation op) throws RuleFailedException {
    return this.typeFactory.singleBoolean;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final LogicalOperation op) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTLogical(G, _subtrace_, op);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TLogical") + stringRepForEnv(G) + " |- " + stringRep(op) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTLogical) {
    	inferTypeThrowException(ruleName("TLogical") + stringRepForEnv(G) + " |- " + stringRep(op) + " : " + "RListType",
    		TLOGICAL,
    		e_applyRuleTLogical, op, new ErrorInformation[] {new ErrorInformation(op)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTLogical(final RuleEnvironment G, final RuleApplicationTrace _trace_, final LogicalOperation op) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTLogical_1(G, op));
  }

  private RListType _applyRuleTLogical_1(final RuleEnvironment G, final LogicalOperation op) throws RuleFailedException {
    return this.typeFactory.singleBoolean;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final ComparisonOperation op) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTComparison(G, _subtrace_, op);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TComparison") + stringRepForEnv(G) + " |- " + stringRep(op) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTComparison) {
    	inferTypeThrowException(ruleName("TComparison") + stringRepForEnv(G) + " |- " + stringRep(op) + " : " + "RListType",
    		TCOMPARISON,
    		e_applyRuleTComparison, op, new ErrorInformation[] {new ErrorInformation(op)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTComparison(final RuleEnvironment G, final RuleApplicationTrace _trace_, final ComparisonOperation op) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTComparison_1(G, op));
  }

  private RListType _applyRuleTComparison_1(final RuleEnvironment G, final ComparisonOperation op) throws RuleFailedException {
    return this.typeFactory.singleBoolean;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaConditionalExpression e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTIf(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TIf") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTIf) {
    	inferTypeThrowException(ruleName("TIf") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TIF,
    		e_applyRuleTIf, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTIf(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaConditionalExpression e) throws RuleFailedException {
    RListType t = null; // output parameter
    RListType tthen = null;
    RListType telse = null;
    /* empty |- e.ifthen : tthen or tthen = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- e.ifthen : tthen */
        RosettaExpression _ifthen = e.getIfthen();
        Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, _ifthen);
        checkAssignableTo(result.getFirst(), RListType.class);
        tthen = (RListType) result.getFirst();
        
      } catch (Exception e_1) {
        previousFailure = extractRuleFailedException(e_1);
        tthen = null;
      }
    }
    /* empty |- e.elsethen : telse or telse = null */
    {
      RuleFailedException previousFailure = null;
      try {
        /* empty |- e.elsethen : telse */
        RosettaExpression _elsethen = e.getElsethen();
        Result<RListType> result_1 = inferTypeInternal(emptyEnvironment(), _trace_, _elsethen);
        checkAssignableTo(result_1.getFirst(), RListType.class);
        telse = (RListType) result_1.getFirst();
        
      } catch (Exception e_2) {
        previousFailure = extractRuleFailedException(e_2);
        telse = null;
      }
    }
    if (((tthen != null) && (telse != null))) {
      t = this.listJoinInternal(_trace_, tthen, telse);
    }
    return new Result<RListType>(t);
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final ListLiteral e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTList(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TList") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTList) {
    	inferTypeThrowException(ruleName("TList") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TLIST,
    		e_applyRuleTList, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTList(final RuleEnvironment G, final RuleApplicationTrace _trace_, final ListLiteral e) throws RuleFailedException {
    RListType t = null; // output parameter
    final ArrayList<RListType> telems = CollectionLiterals.<RListType>newArrayList();
    final Function1<RosettaExpression, Boolean> _function = (RosettaExpression it) -> {
      boolean _xblockexpression = false;
      {
        RListType telem = null;
        /* empty |- it : telem or telem = null */
        {
          RuleFailedException previousFailure = null;
          try {
            /* empty |- it : telem */
            Result<RListType> result = inferTypeInternal(emptyEnvironment(), _trace_, it);
            checkAssignableTo(result.getFirst(), RListType.class);
            telem = (RListType) result.getFirst();
            
          } catch (Exception e_1) {
            previousFailure = extractRuleFailedException(e_1);
            telem = null;
          }
        }
        boolean _xifexpression = false;
        if ((telem == null)) {
          /* false */
          if (!Boolean.valueOf(false)) {
            sneakyThrowRuleFailedException("false");
          }
          _xifexpression = false;
        } else {
          boolean _xblockexpression_1 = false;
          {
            boolean _add = telems.add(telem);
            /* telems.add(telem) */
            if (!_add) {
              sneakyThrowRuleFailedException("telems.add(telem)");
            }
            /* true */
            if (!Boolean.valueOf(true)) {
              sneakyThrowRuleFailedException("true");
            }
            _xblockexpression_1 = (true);
          }
          _xifexpression = _xblockexpression_1;
        }
        _xblockexpression = _xifexpression;
      }
      return Boolean.valueOf(_xblockexpression);
    };
    boolean _forall = IterableExtensions.<RosettaExpression>forall(e.getElements(), _function);
    if (_forall) {
      final Function2<RListType, RListType, RListType> _function_1 = (RListType acc, RListType telem) -> {
        RListType _xifexpression = null;
        if ((acc == null)) {
          _xifexpression = null;
        } else {
          RListType _xblockexpression = null;
          {
            final RType sup = this.joinInternal(_trace_, telem.getItemType(), acc.getItemType());
            RListType _xifexpression_1 = null;
            /* G |- ANY <: sup */
            boolean _ruleinvocation = subtypeSucceeded(G, _trace_, this.builtinTypes.ANY, sup);
            if (_ruleinvocation) {
              _xifexpression_1 = null;
            } else {
              RosettaCardinality _constraint = telem.getConstraint();
              RosettaCardinality _constraint_1 = acc.getConstraint();
              RosettaCardinality _plus = _constraint.operator_plus(_constraint_1);
              _xifexpression_1 = this.typeFactory.createListType(sup, _plus);
            }
            _xblockexpression = (_xifexpression_1);
          }
          _xifexpression = _xblockexpression;
        }
        return _xifexpression;
      };
      t = IterableExtensions.<RListType, RListType>fold(telems, this.typeFactory.emptyNothing, _function_1);
    }
    return new Result<RListType>(t);
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaFeatureCall e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTProject(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TProject") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTProject) {
    	inferTypeThrowException(ruleName("TProject") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TPROJECT,
    		e_applyRuleTProject, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTProject(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaFeatureCall e) throws RuleFailedException {
    RListType t = null; // output parameter
    /* G |- e.receiver : var RListType dt */
    RosettaExpression _receiver = e.getReceiver();
    RListType dt = null;
    Result<RListType> result = inferTypeInternal(G, _trace_, _receiver);
    checkAssignableTo(result.getFirst(), RListType.class);
    dt = (RListType) result.getFirst();
    
    if ((dt != null)) {
      final RosettaFeature a = e.getFeature();
      boolean _matched = false;
      if (a instanceof Attribute) {
        _matched=true;
        final RListType at = this.attributeListTypeInternal(_trace_, ((Attribute)a));
        RType _itemType = at.getItemType();
        RosettaCardinality _constraint = dt.getConstraint();
        RosettaCardinality _constraint_1 = at.getConstraint();
        RosettaCardinality _multiply = _constraint.operator_multiply(_constraint_1);
        t = this.typeFactory.createListType(_itemType, _multiply);
      }
      if (!_matched) {
        if (a instanceof RosettaTypedFeature) {
          _matched=true;
          TypeCall _typeCall = ((RosettaTypedFeature)a).getTypeCall();
          boolean _tripleEquals = (_typeCall == null);
          if (_tripleEquals) {
            /* fail error "Unsupported by the type system." */
            String error = "Unsupported by the type system.";
            throwForExplicitFail(error, new ErrorInformation(null, null));
          } else {
            TypeCall _typeCall_1 = ((RosettaTypedFeature)a).getTypeCall();
            RosettaInterpreterContext _rosettaInterpreterContext = new RosettaInterpreterContext();
            t = this.typeFactory.createListType(this.typeCallToRTypeInternal(_trace_, _typeCall_1, _rosettaInterpreterContext), dt.getConstraint());
          }
        }
      }
      if (!_matched) {
        if (a instanceof RosettaEnumValue) {
          _matched=true;
          t = dt;
        }
      }
    }
    return new Result<RListType>(t);
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaExistsExpression e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTExists(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TExists") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTExists) {
    	inferTypeThrowException(ruleName("TExists") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TEXISTS,
    		e_applyRuleTExists, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTExists(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaExistsExpression e) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTExists_1(G, e));
  }

  private RListType _applyRuleTExists_1(final RuleEnvironment G, final RosettaExistsExpression e) throws RuleFailedException {
    return this.typeFactory.singleBoolean;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaAbsentExpression e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTAbsent(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TAbsent") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTAbsent) {
    	inferTypeThrowException(ruleName("TAbsent") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TABSENT,
    		e_applyRuleTAbsent, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTAbsent(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaAbsentExpression e) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTAbsent_1(G, e));
  }

  private RListType _applyRuleTAbsent_1(final RuleEnvironment G, final RosettaAbsentExpression e) throws RuleFailedException {
    return this.typeFactory.singleBoolean;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaOnlyExistsExpression e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTOnlyExists(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TOnlyExists") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTOnlyExists) {
    	inferTypeThrowException(ruleName("TOnlyExists") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TONLYEXISTS,
    		e_applyRuleTOnlyExists, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTOnlyExists(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaOnlyExistsExpression e) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTOnlyExists_1(G, e));
  }

  private RListType _applyRuleTOnlyExists_1(final RuleEnvironment G, final RosettaOnlyExistsExpression e) throws RuleFailedException {
    return this.typeFactory.singleBoolean;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaCountOperation e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTCount(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TCount") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTCount) {
    	inferTypeThrowException(ruleName("TCount") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TCOUNT,
    		e_applyRuleTCount, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTCount(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaCountOperation e) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTCount_1(G, e));
  }

  private RListType _applyRuleTCount_1(final RuleEnvironment G, final RosettaCountOperation e) throws RuleFailedException {
    RListType _singleInt = this.typeFactory.singleInt(Optional.<Integer>empty(), Optional.<BigInteger>of(BigInteger.ZERO), Optional.<BigInteger>empty());
    return _singleInt;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaOnlyElement e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTOnlyElement(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TOnlyElement") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTOnlyElement) {
    	inferTypeThrowException(ruleName("TOnlyElement") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TONLYELEMENT,
    		e_applyRuleTOnlyElement, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTOnlyElement(final RuleEnvironment G, final RuleApplicationTrace _trace_, final RosettaOnlyElement e) throws RuleFailedException {
    RListType t = null; // output parameter
    /* G |- e.argument : var RListType targ */
    RosettaExpression _argument = e.getArgument();
    RListType targ = null;
    Result<RListType> result = inferTypeInternal(G, _trace_, _argument);
    checkAssignableTo(result.getFirst(), RListType.class);
    targ = (RListType) result.getFirst();
    
    if ((targ != null)) {
      t = this.typeFactory.createListType(targ.getItemType(), 0, 1);
    }
    return new Result<RListType>(t);
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final AsKeyOperation e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTAsKey(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TAsKey") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTAsKey) {
    	inferTypeThrowException(ruleName("TAsKey") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TASKEY,
    		e_applyRuleTAsKey, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTAsKey(final RuleEnvironment G, final RuleApplicationTrace _trace_, final AsKeyOperation e) throws RuleFailedException {
    RListType t = null; // output parameter
    /* G |- e.argument : t */
    RosettaExpression _argument = e.getArgument();
    Result<RListType> result = inferTypeInternal(G, _trace_, _argument);
    checkAssignableTo(result.getFirst(), RListType.class);
    t = (RListType) result.getFirst();
    
    return new Result<RListType>(t);
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final OneOfOperation e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTOneOf(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TOneOf") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTOneOf) {
    	inferTypeThrowException(ruleName("TOneOf") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TONEOF,
    		e_applyRuleTOneOf, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTOneOf(final RuleEnvironment G, final RuleApplicationTrace _trace_, final OneOfOperation e) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTOneOf_1(G, e));
  }

  private RListType _applyRuleTOneOf_1(final RuleEnvironment G, final OneOfOperation e) throws RuleFailedException {
    return this.typeFactory.singleBoolean;
  }

  protected Result<RListType> inferTypeImpl(final RuleEnvironment G, final RuleApplicationTrace _trace_, final ChoiceOperation e) throws RuleFailedException {
    try {
    	final RuleApplicationTrace _subtrace_ = newTrace(_trace_);
    	final Result<RListType> _result_ = applyRuleTChoice(G, _subtrace_, e);
    	addToTrace(_trace_, new Provider<Object>() {
    		public Object get() {
    			return ruleName("TChoice") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + stringRep(_result_.getFirst());
    		}
    	});
    	addAsSubtrace(_trace_, _subtrace_);
    	return _result_;
    } catch (Exception e_applyRuleTChoice) {
    	inferTypeThrowException(ruleName("TChoice") + stringRepForEnv(G) + " |- " + stringRep(e) + " : " + "RListType",
    		TCHOICE,
    		e_applyRuleTChoice, e, new ErrorInformation[] {new ErrorInformation(e)});
    	return null;
    }
  }

  protected Result<RListType> applyRuleTChoice(final RuleEnvironment G, final RuleApplicationTrace _trace_, final ChoiceOperation e) throws RuleFailedException {
    
    return new Result<RListType>(_applyRuleTChoice_1(G, e));
  }

  private RListType _applyRuleTChoice_1(final RuleEnvironment G, final ChoiceOperation e) throws RuleFailedException {
    return this.typeFactory.singleBoolean;
  }
}
