package com.regnosys.rosetta.typing.validation;

import com.google.inject.Inject;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.typing.RosettaTypingChecking;
import org.eclipse.xtext.validation.Check;

@SuppressWarnings("all")
public class RosettaTypingCheckingValidator extends RosettaTypingValidator {
  @Inject
  protected RosettaTypingChecking xsemanticsSystem;

  @Override
  protected RosettaTypingChecking getXsemanticsSystem() {
    return this.xsemanticsSystem;
  }

  @Check
  public void checkLeftArithmetic(final ArithmeticOperation op) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkLeftArithmetic(op),
    		op);
  }

  @Check
  public void checkRightArithmetic(final ArithmeticOperation op) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkRightArithmetic(op),
    		op);
  }

  @Check
  public void checkAddition(final ArithmeticOperation op) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkAddition(op),
    		op);
  }

  @Check
  public void checkEqualityOperation(final EqualityOperation op) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkEqualityOperation(op),
    		op);
  }

  @Check
  public void checkLeftLogical(final LogicalOperation op) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkLeftLogical(op),
    		op);
  }

  @Check
  public void checkRightLogical(final LogicalOperation op) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkRightLogical(op),
    		op);
  }

  @Check
  public void checkLeftComparison(final ComparisonOperation op) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkLeftComparison(op),
    		op);
  }

  @Check
  public void checkRightComparison(final ComparisonOperation op) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkRightComparison(op),
    		op);
  }

  @Check
  public void checkComparison(final ComparisonOperation op) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkComparison(op),
    		op);
  }

  @Check
  public void checkIfConditionalExpression(final RosettaConditionalExpression e) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkIfConditionalExpression(e),
    		e);
  }

  @Check
  public void checkBodyConditionalExpression(final RosettaConditionalExpression e) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkBodyConditionalExpression(e),
    		e);
  }

  @Check
  public void checkListLiteral(final ListLiteral e) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkListLiteral(e),
    		e);
  }

  @Check
  public void checkRosettaSymbolReference(final RosettaSymbolReference e) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkRosettaSymbolReference(e),
    		e);
  }

  @Check
  public void checkExistsExpression(final RosettaExistsExpression e) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkExistsExpression(e),
    		e);
  }

  @Check
  public void checkAbsentExpression(final RosettaAbsentExpression e) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkAbsentExpression(e),
    		e);
  }

  @Check
  public void checkOnlyExistsExpression(final RosettaOnlyExistsExpression e) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkOnlyExistsExpression(e),
    		e);
  }

  @Check
  public void checkOneOfOperation(final OneOfOperation e) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkOneOfOperation(e),
    		e);
  }

  @Check
  public void checkChoiceOperation(final ChoiceOperation e) {
    errorGenerator.generateErrors(this,
    	getXsemanticsSystem().checkChoiceOperation(e),
    		e);
  }
}
