/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaRecordType;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSynonym;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.RosettaRuleReference;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.utils.ExternalAnnotationUtil;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class RosettaExtensions {
    @Inject
    private ExternalAnnotationUtil externalAnn;
    @Inject
    private RBuiltinTypeService builtins;

    public boolean isResolved(EObject obj) {
        return obj != null && !obj.eIsProxy();
    }

    public Iterable<? extends RosettaFeature> allFeatures(RType t, EObject context) {
        Resource _eResource = null;
        if (context != null) {
            _eResource = context.eResource();
        }
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        return this.allFeatures(t, _resourceSet);
    }

    public Iterable<? extends RosettaFeature> allFeatures(RType t, ResourceSet resourceSet) {
        Iterable<RosettaDefinable> _switchResult = null;
        boolean _matched = false;
        if (t instanceof RDataType) {
            _matched = true;
            _switchResult = this.getAllAttributes(((RDataType)t).getData());
        }
        if (!_matched && t instanceof REnumType) {
            _matched = true;
            _switchResult = this.getAllEnumValues(((REnumType)t).getEnumeration());
        }
        if (!_matched && t instanceof RRecordType) {
            _matched = true;
            List<Object> _xifexpression = null;
            _xifexpression = resourceSet != null ? this.builtins.toRosettaType(t, RosettaRecordType.class, resourceSet).getFeatures() : Collections.unmodifiableList(CollectionLiterals.newArrayList());
            _switchResult = _xifexpression;
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _switchResult;
    }

    public Set<Data> getAllSuperTypes(Data clazz) {
        return this.doGetSuperTypes(clazz, CollectionLiterals.newLinkedHashSet());
    }

    private Set<Data> doGetSuperTypes(Data clazz, Set<Data> seenClasses) {
        if (clazz != null && seenClasses.add(clazz)) {
            this.doGetSuperTypes(clazz.getSuperType(), seenClasses);
        }
        return seenClasses;
    }

    public Iterable<Attribute> getAllAttributes(Data clazz) {
        Functions.Function1 _function = it -> it.getAttributes();
        return Iterables.concat((Iterable)IterableExtensions.map(this.getAllSuperTypes(clazz), (Functions.Function1)_function));
    }

    public Set<RosettaEnumeration> getAllSuperEnumerations(RosettaEnumeration e) {
        return this.doGetSuperEnumerations(e, CollectionLiterals.newLinkedHashSet());
    }

    public List<Attribute> allNonOverridesAttributes(Data data) {
        ArrayList atts = CollectionLiterals.newArrayList();
        atts.addAll(data.getAttributes());
        boolean _hasSuperType = data.hasSuperType();
        if (_hasSuperType) {
            List<Attribute> attsWithSuper = this.allNonOverridesAttributes(data.getSuperType());
            ArrayList result = CollectionLiterals.newArrayList();
            Consumer<Attribute> _function = it -> {
                Functions.Function1 _function_1 = att -> {
                    String _name = att.getName();
                    String _name_1 = it.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                };
                Attribute overridenAtt = (Attribute)IterableExtensions.findFirst((Iterable)atts, (Functions.Function1)_function_1);
                if (overridenAtt != null) {
                    result.add(overridenAtt);
                } else {
                    result.add(it);
                }
            };
            attsWithSuper.forEach(_function);
            Functions.Function1 _function_1 = att -> {
                boolean _contains = result.contains(att);
                return !_contains;
            };
            result.addAll(IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)atts, (Functions.Function1)_function_1)));
            return result;
        }
        return atts;
    }

    private Set<RosettaEnumeration> doGetSuperEnumerations(RosettaEnumeration e, Set<RosettaEnumeration> seenEnums) {
        if (e != null && seenEnums.add(e)) {
            this.doGetSuperEnumerations(e.getSuperType(), seenEnums);
        }
        return seenEnums;
    }

    public Iterable<RosettaEnumValue> getAllEnumValues(RosettaEnumeration e) {
        Functions.Function1 _function = it -> it.getEnumValues();
        return Iterables.concat((Iterable)IterableExtensions.map(this.getAllSuperEnumerations(e), (Functions.Function1)_function));
    }

    public Set<RosettaSynonym> getAllSynonyms(RosettaSynonym s) {
        return this.doGetSynonyms(s, CollectionLiterals.newLinkedHashSet());
    }

    private Set<RosettaSynonym> doGetSynonyms(RosettaSynonym s, Set<RosettaSynonym> seenSynonyms) {
        if (s != null && seenSynonyms.add(s)) {
            this.doGetSynonyms(s, seenSynonyms);
        }
        return seenSynonyms;
    }

    public void collectExpressions(RosettaExpression expr, Procedures.Procedure1<? super RosettaExpression> visitor) {
        if (expr instanceof RosettaBinaryOperation) {
            if (((RosettaBinaryOperation)expr).getOperator().equals("or") || ((RosettaBinaryOperation)expr).getOperator().equals("and")) {
                this.collectExpressions(((RosettaBinaryOperation)expr).getLeft(), visitor);
                this.collectExpressions(((RosettaBinaryOperation)expr).getRight(), visitor);
            } else {
                visitor.apply((Object)expr);
            }
        }
        if (expr instanceof RosettaConditionalExpression) {
            this.collectExpressions(((RosettaConditionalExpression)expr).getIfthen(), visitor);
            this.collectExpressions(((RosettaConditionalExpression)expr).getElsethen(), visitor);
        } else {
            visitor.apply((Object)expr);
        }
    }

    public boolean isProjectLocal(URI platformResourceURI, URI candidateUri) {
        boolean _not;
        boolean _isPlatformResource = platformResourceURI.isPlatformResource();
        boolean bl = _not = !_isPlatformResource;
        if (_not) {
            return true;
        }
        String projectName = platformResourceURI.segment(1);
        boolean _isPlatformResource_1 = candidateUri.isPlatformResource();
        if (_isPlatformResource_1) {
            String _segment = candidateUri.segment(1);
            return Objects.equal((Object)projectName, (Object)_segment);
        }
        return false;
    }

    public Iterable<AnnotationRef> metaAnnotations(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Annotation _annotation = it_1.getAnnotation();
            String _name = null;
            if (_annotation != null) {
                _name = _annotation.getName();
            }
            return Objects.equal((Object)_name, (Object)"metadata");
        };
        return IterableExtensions.filter(this.allAnnotations(it), (Functions.Function1)_function);
    }

    public boolean hasKeyedAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equal((Object)_name, (Object)"key");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    public boolean hasTemplateAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equal((Object)_name, (Object)"template");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    public boolean hasMetaDataAnnotations(RAttribute attribute) {
        Functions.Function1 _function = it -> Objects.equal((Object)it.getName(), (Object)"reference") || Objects.equal((Object)it.getName(), (Object)"location") || Objects.equal((Object)it.getName(), (Object)"scheme") || Objects.equal((Object)it.getName(), (Object)"id");
        return IterableExtensions.exists(attribute.getMetaAnnotations(), (Functions.Function1)_function);
    }

    public boolean hasMetaDataAnnotations(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            boolean _equals;
            boolean _or = false;
            boolean _or_1 = false;
            boolean _or_2 = false;
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            if (_equals = Objects.equal((Object)_name, (Object)"reference")) {
                _or_2 = true;
            } else {
                boolean _equals_1;
                Attribute _attribute_1 = it_1.getAttribute();
                String _name_1 = null;
                if (_attribute_1 != null) {
                    _name_1 = _attribute_1.getName();
                }
                _or_2 = _equals_1 = Objects.equal((Object)_name_1, (Object)"location");
            }
            if (_or_2) {
                _or_1 = true;
            } else {
                boolean _equals_2;
                Attribute _attribute_2 = it_1.getAttribute();
                String _name_2 = null;
                if (_attribute_2 != null) {
                    _name_2 = _attribute_2.getName();
                }
                _or_1 = _equals_2 = Objects.equal((Object)_name_2, (Object)"scheme");
            }
            if (_or_1) {
                _or = true;
            } else {
                boolean _equals_3;
                Attribute _attribute_3 = it_1.getAttribute();
                String _name_3 = null;
                if (_attribute_3 != null) {
                    _name_3 = _attribute_3.getName();
                }
                _or = _equals_3 = Objects.equal((Object)_name_3, (Object)"id");
            }
            return _or;
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    public boolean hasMetaFieldAnnotations(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            boolean _notEquals;
            boolean _and = false;
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            boolean bl = _notEquals = !Objects.equal((Object)_name, (Object)"reference");
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _notEquals_1;
                Attribute _attribute_1 = it_1.getAttribute();
                String _name_1 = null;
                if (_attribute_1 != null) {
                    _name_1 = _attribute_1.getName();
                }
                _and = _notEquals_1 = !Objects.equal((Object)_name_1, (Object)"address");
            }
            return _and;
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    public boolean hasMetaDataAddress(RAttribute attribute) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)"address");
        };
        return IterableExtensions.exists(attribute.getMetaAnnotations(), (Functions.Function1)_function);
    }

    public boolean hasMetaDataAddress(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equal((Object)_name, (Object)"address");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    public boolean hasIdAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equal((Object)_name, (Object)"id");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    public boolean hasReferenceAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equal((Object)_name, (Object)"reference");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    public boolean hasCalculationAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Annotation _annotation = it_1.getAnnotation();
            String _name = null;
            if (_annotation != null) {
                _name = _annotation.getName();
            }
            return Objects.equal((Object)_name, (Object)"calculation");
        };
        return IterableExtensions.exists(this.allAnnotations(it), (Functions.Function1)_function);
    }

    public boolean isReference(Attribute attribute) {
        return this.hasMetaDataAnnotations(attribute) || this.hasMetaDataAddress(attribute);
    }

    public boolean isReference(RAttribute attribute) {
        return this.hasMetaDataAnnotations(attribute) || this.hasMetaDataAddress(attribute);
    }

    private Iterable<AnnotationRef> allAnnotations(Annotated withAnnotations) {
        EList<AnnotationRef> _annotations = null;
        if (withAnnotations != null) {
            _annotations = withAnnotations.getAnnotations();
        }
        Iterable _filter = null;
        if (_annotations != null) {
            Functions.Function1 _function = it -> this.isResolved(it.getAnnotation());
            _filter = IterableExtensions.filter(_annotations, (Functions.Function1)_function);
        }
        return _filter;
    }

    public String conditionName(Condition cond, Data data) {
        return this.conditionName(cond, data.getName(), (Collection<Condition>)data.getConditions());
    }

    public String conditionName(Condition cond, Function func) {
        return this.conditionName(cond, func.getName(), (Collection<Condition>)func.getConditions());
    }

    public boolean isConstraintCondition(Condition cond) {
        return this.isOneOf(cond) || this.isChoice(cond);
    }

    private boolean isOneOf(Condition cond) {
        RosettaExpression _expression = cond.getExpression();
        return _expression instanceof OneOfOperation;
    }

    private boolean isChoice(Condition cond) {
        RosettaExpression _expression = cond.getExpression();
        return _expression instanceof ChoiceOperation;
    }

    private String conditionName(Condition cond, String containerName, Collection<Condition> conditions) {
        boolean _not;
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)cond.getName());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _xifexpression = cond.getName();
        } else {
            String _xblockexpression = null;
            Functions.Function1 _function = it -> StringExtensions.isNullOrEmpty((String)it.getName());
            int idx = IterableExtensions.toList((Iterable)IterableExtensions.filter(conditions, (Functions.Function1)_function)).indexOf(cond);
            String _xifexpression_1 = null;
            boolean _isOneOf = this.isOneOf(cond);
            if (_isOneOf) {
                _xifexpression_1 = "OneOf";
            } else {
                String _xifexpression_2 = null;
                boolean _isChoice = this.isChoice(cond);
                _xifexpression_2 = _isChoice ? "Choice" : "DataRule";
                _xifexpression_1 = _xifexpression_2;
            }
            String type = _xifexpression_1;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(type);
            _builder.append((Object)idx);
            _xifexpression = _xblockexpression = _builder.toString();
        }
        String name = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(containerName);
        _builder.append(name);
        return _builder.toString();
    }

    public String toConditionJavaType(String conditionName) {
        String allUnderscore = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, conditionName);
        String camel = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, allUnderscore);
        return camel;
    }

    public HashMap<PathAttribute, RosettaRule> getAllReportingRules(RosettaReport report) {
        return this.getAllReportingRules(report.getReportType(), Optional.ofNullable(report.getRuleSource()));
    }

    public HashMap<PathAttribute, RosettaRule> getAllReportingRules(Data type, Optional<RosettaExternalRuleSource> ruleSource) {
        HashMap _xblockexpression = null;
        HashMap rules = CollectionLiterals.newHashMap();
        RosettaPath path = RosettaPath.valueOf((String)type.getName());
        this.collectReportingRules(type, path, ruleSource, rules, CollectionLiterals.newHashSet());
        _xblockexpression = rules;
        return _xblockexpression;
    }

    private void collectReportingRules(Data dataType, RosettaPath path, Optional<RosettaExternalRuleSource> ruleSource, Map<PathAttribute, RosettaRule> visitor, Set<Data> collectedTypes) {
        Map<RosettaFeature, RosettaRuleReference> attrRules = this.externalAnn.getAllRuleReferencesForType(ruleSource, dataType);
        Consumer<Attribute> _function = attr -> {
            RosettaType attrType = attr.getTypeCall().getType();
            ExpandedAttribute attrEx = RosettaAttributeExtensions.toExpandedAttribute(attr);
            RosettaRuleReference rule = (RosettaRuleReference)attrRules.get(attr);
            if (attrEx.builtInType() || attrEx.isEnum()) {
                if (rule != null) {
                    PathAttribute _pathAttribute = new PathAttribute(path, (Attribute)attr);
                    visitor.put(_pathAttribute, rule.getReportingRule());
                }
            } else if (attrType instanceof Data) {
                boolean _add;
                if (rule != null) {
                    PathAttribute _pathAttribute_1 = new PathAttribute(path, (Attribute)attr);
                    visitor.put(_pathAttribute_1, rule.getReportingRule());
                }
                if (_add = collectedTypes.add((Data)attrType)) {
                    RosettaPath _xifexpression = null;
                    boolean _isMultiple = attrEx.isMultiple();
                    _xifexpression = _isMultiple ? path.newSubPath(attr.getName(), 0) : path.newSubPath(attr.getName());
                    RosettaPath subPath = _xifexpression;
                    this.collectReportingRules((Data)attrType, subPath, ruleSource, visitor, collectedTypes);
                }
            } else {
                throw new IllegalArgumentException("Did not collect reporting rules from type " + attrType);
            }
        };
        this.allNonOverridesAttributes(dataType).forEach(_function);
    }

    @org.eclipse.xtend.lib.annotations.Data
    public static class PathAttribute {
        private final RosettaPath path;
        private final Attribute attr;

        public PathAttribute(RosettaPath path, Attribute attr) {
            this.path = path;
            this.attr = attr;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return 31 * result + (this.attr == null ? 0 : this.attr.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathAttribute other = (PathAttribute)obj;
            if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
                return false;
            }
            return !(this.attr == null ? other.attr != null : !this.attr.equals(other.attr));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("path", (Object)this.path);
            b.add("attr", (Object)this.attr);
            return b.toString();
        }

        @Pure
        public RosettaPath getPath() {
            return this.path;
        }

        @Pure
        public Attribute getAttr() {
            return this.attr;
        }
    }
}

