/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.builtin;

import com.regnosys.rosetta.rosetta.RosettaModel;
import java.net.URL;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class RosettaBuiltinsService {
    private final String[] basicTypesPath = new String[]{"model", "basictypes.rosetta"};
    private final String[] annotationsPath = new String[]{"model", "annotations.rosetta"};
    public final URI basicTypesURI = URI.createHierarchicalURI((String)"classpath", null, null, (String[])this.basicTypesPath, null, null);
    public final URI annotationsURI = URI.createHierarchicalURI((String)"classpath", null, null, (String[])this.annotationsPath, null, null);
    public final URL basicTypesURL = Objects.requireNonNull(this.getClass().getResource(this.basicTypesURI.path()));
    public final URL annotationsURL = Objects.requireNonNull(this.getClass().getResource(this.annotationsURI.path()));

    private RosettaModel getModel(ResourceSet resourceSet, URI uri) {
        Resource resource = resourceSet.getResource(uri, false);
        if (resource == null) {
            String[] pathParts = uri.path().split("/");
            String uriFile = pathParts[pathParts.length - 1];
            resource = resourceSet.getResources().stream().filter(r -> r.getURI().path().endsWith(uriFile)).findAny().orElseThrow();
        }
        return (RosettaModel)resource.getContents().get(0);
    }

    public RosettaModel getBasicTypesModel(ResourceSet resourceSet) {
        return this.getModel(resourceSet, this.basicTypesURI);
    }

    public RosettaModel getAnnotationsResource(ResourceSet resourceSet) {
        return this.getModel(resourceSet, this.annotationsURI);
    }
}

