/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.config.file;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.regnosys.rosetta.config.DefaultRosettaConfigurationProvider;
import com.regnosys.rosetta.config.RosettaConfiguration;
import com.regnosys.rosetta.config.RosettaGeneratorsConfiguration;
import com.regnosys.rosetta.config.RosettaModelConfiguration;
import com.regnosys.rosetta.config.file.NamespaceFilter;
import com.regnosys.rosetta.config.file.RosettaConfigurationFileProvider;
import com.regnosys.rosetta.config.file.RosettaConfigurationMixin;
import com.regnosys.rosetta.config.file.RosettaGeneratorsConfigurationMixin;
import com.regnosys.rosetta.config.file.RosettaModelConfigurationMixin;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedRosettaConfigurationProvider
implements Provider<RosettaConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedRosettaConfigurationProvider.class);
    private final Provider<RosettaConfiguration> fallback;
    private final Provider<URL> fileProvider;
    private final ObjectMapper mapper;

    @Inject
    public FileBasedRosettaConfigurationProvider(DefaultRosettaConfigurationProvider fallback, RosettaConfigurationFileProvider fileProvider) {
        this.fallback = fallback;
        this.fileProvider = fileProvider;
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).addMixIn(RosettaConfiguration.class, RosettaConfigurationMixin.class).addMixIn(RosettaModelConfiguration.class, RosettaModelConfigurationMixin.class).addMixIn(RosettaGeneratorsConfiguration.class, RosettaGeneratorsConfigurationMixin.class);
        this.mapper.configOverride(RosettaGeneratorsConfiguration.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.AS_EMPTY));
        this.mapper.configOverride(NamespaceFilter.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.AS_EMPTY));
        this.mapper.configOverride(List.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.AS_EMPTY));
    }

    public RosettaConfiguration get() {
        RosettaConfiguration config = this.readConfigFromFile();
        if (config != null) {
            return config;
        }
        return (RosettaConfiguration)this.fallback.get();
    }

    protected RosettaConfiguration readConfigFromFile() {
        try {
            URL file = (URL)this.fileProvider.get();
            if (file != null) {
                return (RosettaConfiguration)this.mapper.readValue(file, RosettaConfiguration.class);
            }
            LOGGER.debug("No configuration file was found. Falling back to the default configuration.");
            return null;
        }
        catch (IOException e) {
            LOGGER.error("Could not read Rosetta configuration.", (Throwable)e);
            return null;
        }
    }
}

