/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.config.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.rosetta.util.DottedPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class NamespaceFilter
implements Predicate<String> {
    private final List<DottedPath> genericNamespaces = new ArrayList<DottedPath>();
    private final List<DottedPath> specificNamespaces = new ArrayList<DottedPath>();

    public NamespaceFilter() {
        this(Collections.emptyList());
    }

    @JsonCreator
    public NamespaceFilter(List<DottedPath> allowedNamespacePatterns) {
        for (DottedPath namespacePattern : allowedNamespacePatterns) {
            if (namespacePattern.last().equals("*")) {
                this.genericNamespaces.add(namespacePattern.parent());
                continue;
            }
            this.specificNamespaces.add(namespacePattern);
        }
    }

    @Override
    public boolean test(String t) {
        if (this.genericNamespaces.isEmpty() && this.specificNamespaces.isEmpty()) {
            return true;
        }
        DottedPath namespace = DottedPath.splitOnDots((String)t);
        return this.genericNamespaces.stream().anyMatch(n -> namespace.startsWith(n)) || this.specificNamespaces.contains(namespace);
    }
}

