/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator;

import com.google.common.collect.LinkedListMultimap;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public abstract class GeneratorScope<Scope extends GeneratorScope<Scope>> {
    private final Optional<Scope> parent;
    private final Map<Object, GeneratedIdentifier> identifiers = new LinkedHashMap<Object, GeneratedIdentifier>();
    private final Map<Object, Object> keySynonyms = new HashMap<Object, Object>();
    private boolean isClosed = false;
    private Map<GeneratedIdentifier, String> actualNames = null;
    private final String description;

    public GeneratorScope(String description) {
        this.description = description;
        this.parent = Optional.empty();
    }

    protected GeneratorScope(String description, Scope parent) {
        this.description = description;
        this.parent = Optional.of(parent);
    }

    public abstract Scope childScope(String var1);

    public abstract boolean isValidIdentifier(String var1);

    public String escapeName(String name) {
        return "_" + name;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Optional<Scope> getParent() {
        return this.parent;
    }

    public String getDebugInfo() {
        StringBuilder b = new StringBuilder();
        b.append(this.description);
        if (!this.isClosed) {
            b.append(" <unclosed>");
        }
        b.append(":");
        if (this.identifiers.isEmpty()) {
            b.append(" <no identifiers>");
        } else {
            this.identifiers.entrySet().forEach(e -> b.append("\n\t").append(this.normalizeKey(e.getKey())).append(" -> \"").append(((GeneratedIdentifier)e.getValue()).getDesiredName()).append("\""));
        }
        this.keySynonyms.entrySet().forEach(e -> b.append("\n\t").append("(keySynonym): ").append(this.normalizeKey(e.getKey())).append(" -> ").append(this.normalizeKey(e.getValue())));
        this.parent.ifPresent(p -> b.append("\n").append(p.getDebugInfo().replaceAll("(?m)^", "\t")));
        return b.toString();
    }

    private String normalizeKey(Object key) {
        return key.toString().replace("\n", "\\n");
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("=========== Scope Description ==========\n");
        b.append(this.getDebugInfo());
        b.append("\n========================================\n");
        return b.toString();
    }

    public Set<GeneratedIdentifier> getIdentifiers() {
        Set result = this.parent.map(p -> p.getIdentifiers()).orElseGet(() -> new HashSet());
        result.addAll(this.identifiers.values());
        return result;
    }

    public Optional<GeneratedIdentifier> getIdentifier(Object obj) {
        return this.parent.flatMap(p -> p.getIdentifier(obj)).or(() -> Optional.ofNullable(this.identifiers.get(obj))).or(() -> Optional.ofNullable(this.keySynonyms.get(obj)).flatMap(key -> this.getIdentifier(key)));
    }

    public GeneratedIdentifier getIdentifierOrThrow(Object obj) {
        return this.getIdentifier(obj).orElseThrow(() -> new NoSuchElementException("No identifier defined for " + this.normalizeKey(obj) + " in scope.\n" + this));
    }

    protected GeneratedIdentifier overwriteIdentifier(Object obj, String name) {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot create a new identifier in a closed scope. (" + this.normalizeKey(obj) + " -> " + name + ")\n" + this);
        }
        GeneratedIdentifier id = new GeneratedIdentifier(this, name);
        this.identifiers.put(obj, id);
        return id;
    }

    public GeneratedIdentifier createIdentifier(Object obj, String name) {
        if (this.getIdentifier(obj).isPresent()) {
            throw new IllegalStateException("There is already a name defined for object `" + this.normalizeKey(obj) + "`.\n" + this);
        }
        return this.overwriteIdentifier(obj, name);
    }

    public GeneratedIdentifier createIdentifier(RosettaNamed obj) {
        return this.createIdentifier(obj, obj.getName());
    }

    public GeneratedIdentifier createUniqueIdentifier(final String name) {
        Object token = new Object(){

            public String toString() {
                return "{unique token for \"" + name + "\"}";
            }
        };
        return this.createIdentifier(token, name);
    }

    public GeneratedIdentifier getOrCreateIdentifier(Object obj, String name) {
        return this.getIdentifier(obj).orElseGet(() -> this.createIdentifier(obj, name));
    }

    public GeneratedIdentifier getOrCreateIdentifier(RosettaNamed obj) {
        return this.getOrCreateIdentifier(obj, obj.getName());
    }

    public void createKeySynonym(Object key, Object keyWithIdentifier) {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot create a new key synonym in a closed scope. (" + this.normalizeKey(key) + " -> " + this.normalizeKey(keyWithIdentifier) + ")\n" + this);
        }
        if (this.getIdentifier(key).isPresent()) {
            throw new IllegalStateException("There is already a name defined for key `" + this.normalizeKey(key) + "`.\n" + this);
        }
        if (this.getIdentifier(keyWithIdentifier).isEmpty()) {
            throw new IllegalStateException("There is no name defined for key `" + this.normalizeKey(keyWithIdentifier) + "`.\n" + this);
        }
        this.keySynonyms.put(key, keyWithIdentifier);
    }

    public void createSynonym(Object key, GeneratedIdentifier identifier) {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot create a new synonym in a closed scope. (" + this.normalizeKey(key) + " -> " + this.normalizeKey(identifier) + ")\n" + this);
        }
        if (this.getIdentifier(key).isPresent()) {
            throw new IllegalStateException("There is already a name defined for key `" + this.normalizeKey(key) + "`.\n" + this);
        }
        this.identifiers.put(key, identifier);
    }

    public void close() {
        if (this.isClosed) {
            throw new IllegalStateException("The scope is already closed.\n" + this);
        }
        this.isClosed = true;
    }

    public Optional<String> getActualName(GeneratedIdentifier identifier) {
        if (!this.isClosed) {
            this.close();
        }
        return this.parent.flatMap(p -> p.getActualName(identifier)).or(() -> {
            if (this.actualNames == null) {
                this.computeActualNames();
            }
            return Optional.ofNullable(this.actualNames.get(identifier));
        });
    }

    private void computeActualNames() {
        this.actualNames = new HashMap<GeneratedIdentifier, String>();
        Set takenNames = this.parent.map(p -> p.getTakenNames()).orElseGet(() -> new HashSet());
        LinkedListMultimap<String, GeneratedIdentifier> idsByDesiredName = this.localIdentifiersByDesiredName();
        for (String desiredName : idsByDesiredName.keySet()) {
            List ids = idsByDesiredName.get((Object)desiredName);
            for (int i = 0; i < ids.size(); ++i) {
                GeneratedIdentifier id = (GeneratedIdentifier)ids.get(i);
                Object name = desiredName;
                if (ids.size() > 1) {
                    name = (String)name + i;
                }
                boolean lastWasValid = true;
                while (true) {
                    boolean isValid = this.isValidIdentifier((String)name);
                    if (!lastWasValid && !isValid) {
                        throw new RuntimeException("Tried escaping the identifier `" + (String)name + "`, but it is still not a valid identifier.");
                    }
                    if (!takenNames.contains(name) && isValid) break;
                    name = this.escapeName((String)name);
                    lastWasValid = isValid;
                }
                takenNames.add(name);
                this.actualNames.put(id, (String)name);
            }
        }
    }

    private LinkedListMultimap<String, GeneratedIdentifier> localIdentifiersByDesiredName() {
        LinkedListMultimap result = LinkedListMultimap.create();
        this.identifiers.values().stream().distinct().forEach(id -> result.put((Object)id.getDesiredName(), id));
        return result;
    }

    protected Set<String> getTakenNames() {
        Set result = this.parent.map(p -> p.getTakenNames()).orElseGet(() -> new HashSet());
        if (this.actualNames == null) {
            this.computeActualNames();
        }
        result.addAll(this.actualNames.values());
        return result;
    }
}

