/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.enums;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.enums.EnumHelper;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.rosetta.RosettaEnumSynonym;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaSynonymSource;
import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import com.rosetta.model.lib.annotations.RosettaSynonym;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;

public class EnumGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;

    public void generate(RosettaJavaPackages.RootPackage root, IFileSystemAccess2 fsa, List<RosettaRootElement> elements, String version) {
        Consumer<RosettaEnumeration> _function = it -> {
            String _withForwardSlashes = root.withForwardSlashes();
            String _plus = _withForwardSlashes + "/";
            String _name = it.getName();
            String _plus_1 = _plus + _name;
            String _plus_2 = _plus_1 + ".java";
            fsa.generateFile(_plus_2, (CharSequence)this.toJava((RosettaEnumeration)it, root, version));
        };
        Iterables.filter(elements, RosettaEnumeration.class).forEach(_function);
    }

    private ArrayList<com.regnosys.rosetta.rosetta.RosettaEnumValue> allEnumsValues(RosettaEnumeration enumeration) {
        ArrayList<com.regnosys.rosetta.rosetta.RosettaEnumValue> enumValues = new ArrayList<com.regnosys.rosetta.rosetta.RosettaEnumValue>();
        for (RosettaEnumeration e = enumeration; e != null; e = e.getSuperType()) {
            Consumer<com.regnosys.rosetta.rosetta.RosettaEnumValue> _function = it -> enumValues.add((com.regnosys.rosetta.rosetta.RosettaEnumValue)it);
            e.getEnumValues().forEach(_function);
        }
        return enumValues;
    }

    private String toJava(final RosettaEnumeration e, RosettaJavaPackages.RootPackage root, final String version) {
        StringConcatenationClient _client;
        String _xblockexpression = null;
        JavaScope scope = new JavaScope(root);
        StringConcatenationClient classBody = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _javadoc = ModelGeneratorUtil.javadoc(e, version);
                _builder.append((Object)_javadoc);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"@");
                _builder.append(RosettaEnum.class);
                _builder.append((Object)"(\"");
                String _name = e.getName();
                _builder.append((Object)_name);
                _builder.append((Object)"\")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"public enum ");
                String _name_1 = e.getName();
                _builder.append((Object)_name_1);
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                ArrayList<com.regnosys.rosetta.rosetta.RosettaEnumValue> _allEnumsValues = EnumGenerator.this.allEnumsValues(e);
                boolean _hasElements = false;
                for (com.regnosys.rosetta.rosetta.RosettaEnumValue value : _allEnumsValues) {
                    boolean _tripleNotEquals;
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",\n", "\t");
                    }
                    _builder.append((Object)"\t");
                    CharSequence _javadoc_1 = ModelGeneratorUtil.javadoc(value);
                    _builder.append((Object)_javadoc_1, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    StringConcatenationClient _contributeAnnotations = EnumGenerator.this.contributeAnnotations(value);
                    _builder.append((Object)_contributeAnnotations, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@");
                    _builder.append(RosettaEnumValue.class, "\t");
                    _builder.append((Object)"(value = \"");
                    String _name_2 = value.getName();
                    _builder.append((Object)_name_2, "\t");
                    _builder.append((Object)"\"");
                    String _display = value.getDisplay();
                    boolean bl = _tripleNotEquals = _display != null;
                    if (_tripleNotEquals) {
                        _builder.append((Object)", displayName = \"");
                        String _display_1 = value.getDisplay();
                        _builder.append((Object)_display_1, "\t");
                        _builder.append((Object)"\"");
                    }
                    _builder.append((Object)") ");
                    String _convertValuesWithDisplay = EnumHelper.convertValuesWithDisplay(value);
                    _builder.append((Object)_convertValuesWithDisplay, "\t");
                    _builder.newLineIfNotEmpty();
                }
                if (_hasElements) {
                    _builder.append((Object)";", "\t");
                }
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"private static ");
                _builder.append(Map.class, "\t");
                _builder.append((Object)"<");
                _builder.append(String.class, "\t");
                _builder.append((Object)", ");
                String _name_3 = e.getName();
                _builder.append((Object)_name_3, "\t");
                _builder.append((Object)"> values;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"static {");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append(Map.class, "        ");
                _builder.append((Object)"<");
                _builder.append(String.class, "        ");
                _builder.append((Object)", ");
                String _name_4 = e.getName();
                _builder.append((Object)_name_4, "        ");
                _builder.append((Object)"> map = new ");
                _builder.append(ConcurrentHashMap.class, "        ");
                _builder.append((Object)"<>();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"for (");
                String _name_5 = e.getName();
                _builder.append((Object)_name_5, "\t\t");
                _builder.append((Object)" instance : ");
                String _name_6 = e.getName();
                _builder.append((Object)_name_6, "\t\t");
                _builder.append((Object)".values()) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"map.put(instance.toDisplayString(), instance);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"values = ");
                _builder.append(Collections.class, "\t\t");
                _builder.append((Object)".unmodifiableMap(map);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"private final ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" rosettaName;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private final ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" displayName;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                String _name_7 = e.getName();
                _builder.append((Object)_name_7, "\t");
                _builder.append((Object)"(");
                _builder.append(String.class, "\t");
                _builder.append((Object)" rosettaName) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this(rosettaName, null);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                String _name_8 = e.getName();
                _builder.append((Object)_name_8, "\t");
                _builder.append((Object)"(");
                _builder.append(String.class, "\t");
                _builder.append((Object)" rosettaName, ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" displayName) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this.rosettaName = rosettaName;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this.displayName = displayName;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public static ");
                String _name_9 = e.getName();
                _builder.append((Object)_name_9, "\t");
                _builder.append((Object)" fromDisplayName(String name) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                String _name_10 = e.getName();
                _builder.append((Object)_name_10, "\t\t");
                _builder.append((Object)" value = values.get(name);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (value == null) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"throw new ");
                _builder.append(IllegalArgumentException.class, "\t\t\t");
                _builder.append((Object)"(\"No enum constant with display name \\\"\" + name + \"\\\".\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return value;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" toString() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return toDisplayString();");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(String.class, "\t");
                _builder.append((Object)" toDisplayString() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return displayName != null ?  displayName : rosettaName;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        _xblockexpression = this._importManagerExtension.buildClass(root, classBody, scope);
        return _xblockexpression;
    }

    private StringConcatenationClient contributeAnnotations(final com.regnosys.rosetta.rosetta.RosettaEnumValue e) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                EList<RosettaEnumSynonym> _enumSynonyms = e.getEnumSynonyms();
                for (RosettaEnumSynonym synonym : _enumSynonyms) {
                    EList<RosettaSynonymSource> _sources = synonym.getSources();
                    for (RosettaSynonymSource source : _sources) {
                        _builder.append((Object)"@");
                        _builder.append(RosettaSynonym.class);
                        _builder.append((Object)"(value = \"");
                        String _synonymValue = synonym.getSynonymValue();
                        _builder.append((Object)_synonymValue);
                        _builder.append((Object)"\", source = \"");
                        String _name = source.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\")");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
        };
        return _client;
    }
}

