/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.enums;

import com.google.common.base.CaseFormat;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.xtend2.lib.StringConcatenation;

public class EnumHelper {
    public static String convertValuesWithDisplay(RosettaEnumValue enumValue) {
        boolean _tripleNotEquals;
        String _formatEnumName = EnumHelper.formatEnumName(enumValue.getName());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(\"");
        String _name = enumValue.getName();
        _builder.append(_name);
        _builder.append("\"");
        String _display = enumValue.getDisplay();
        boolean bl = _tripleNotEquals = _display != null;
        if (_tripleNotEquals) {
            _builder.append(", \"");
            String _display_1 = enumValue.getDisplay();
            _builder.append(_display_1);
            _builder.append("\"");
        }
        _builder.append(")");
        return _formatEnumName + _builder;
    }

    public static String convertValues(RosettaEnumValue enumValue) {
        return EnumHelper.formatEnumName(enumValue.getName());
    }

    public static String formatEnumName(String name) {
        boolean _noFormattingRequired = EnumHelper.noFormattingRequired(name);
        if (_noFormattingRequired) {
            return name;
        }
        Function<String, List> _function = it -> EnumHelper.splitAtUnderscore(it);
        Function<List, Stream> _function_1 = it -> it.stream();
        Function<String, List> _function_2 = it -> EnumHelper.splitAtCamelCase(it);
        Function<List, Stream> _function_3 = it -> it.stream();
        Function<String, String> _function_4 = it -> EnumHelper.camelCaseToUpperUnderscoreCase(it);
        Function<String, String> _function_5 = it -> it.toUpperCase();
        List parts = Arrays.asList(EnumHelper.splitAtNumbers(EnumHelper.replaceSeparatorsWithUnderscores(name))).stream().map(_function).flatMap(_function_1).map(_function_2).flatMap(_function_3).map(_function_4).map(_function_5).collect(Collectors.toList());
        return EnumHelper.removeDuplicateUnderscores(EnumHelper.prefixWithUnderscoreIfStartsWithNumber(String.join((CharSequence)"_", parts)));
    }

    private static boolean noFormattingRequired(String name) {
        return name.matches("^[A-Z0-9_]*$");
    }

    private static String replaceSeparatorsWithUnderscores(String name) {
        return name.replace(".", "_").replace("-", "_").replace(" ", "_");
    }

    private static List<String> splitAtCamelCase(String namePart) {
        return Arrays.asList(namePart.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])"));
    }

    private static List<String> splitAtUnderscore(String namePart) {
        return Arrays.asList(namePart.split("_"));
    }

    private static String[] splitAtNumbers(String namePart) {
        return namePart.split("(?=[X])(?<=[^X])|(?=[^X])(?<=[X])".replace("X", "\\d"));
    }

    private static String camelCaseToUpperUnderscoreCase(String namePart) {
        if (!namePart.isEmpty() && Character.isUpperCase(namePart.charAt(0)) && Character.isLowerCase(namePart.charAt(namePart.length() - 1))) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, namePart);
        }
        return namePart;
    }

    private static String removeDuplicateUnderscores(String name) {
        return name.replace("__", "_");
    }

    private static String prefixWithUnderscoreIfStartsWithNumber(String name) {
        boolean _isDigit = Character.isDigit(name.charAt(0));
        if (_isDigit) {
            return "_" + name;
        }
        return name;
    }
}

