/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.object;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.regnosys.rosetta.config.RosettaGeneratorsConfiguration;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.object.ModelObjectGenerator;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.impl.RosettaFactoryImpl;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimpleFactory;
import com.regnosys.rosetta.types.TypeSystem;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.meta.BasicRosettaMetaData;
import com.rosetta.model.lib.meta.FieldWithMeta;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.MetaDataFields;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.meta.TemplateFields;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class MetaFieldGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private ModelObjectGenerator _modelObjectGenerator;
    @Inject
    private RosettaJavaPackages packages;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private TypeSystem _typeSystem;
    @Inject
    private RosettaGeneratorsConfiguration config;

    public void generate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext ctx) {
        boolean _isNullOrEmpty;
        RosettaModel model = (RosettaModel)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), RosettaModel.class));
        String _name = null;
        if (model != null) {
            _name = model.getName();
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
            return;
        }
        Functions.Function1 _function = it -> it.getContents();
        List allModels = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)resource.getResourceSet().getResources(), (Functions.Function1)_function), RosettaModel.class));
        Functions.Function1 _function_1 = it -> it.getElements();
        List allMetaTypes = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)allModels, (Functions.Function1)_function_1), RosettaMetaType.class));
        StringConcatenation _builder = new StringConcatenation();
        String _withForwardSlashes = this.packages.basicMetafields().withForwardSlashes();
        _builder.append(_withForwardSlashes);
        _builder.append("/MetaFields.java");
        fsa.generateFile(_builder.toString(), (CharSequence)this.metaFields("MetaFields", CollectionLiterals.newArrayList((Object[])new Object[]{GlobalKeyFields.class}), this.getMetaFieldTypes(allMetaTypes)));
        StringConcatenation _builder_1 = new StringConcatenation();
        String _withForwardSlashes_1 = this.packages.basicMetafields().withForwardSlashes();
        _builder_1.append(_withForwardSlashes_1);
        _builder_1.append("/MetaAndTemplateFields.java");
        fsa.generateFile(_builder_1.toString(), (CharSequence)this.metaFields("MetaAndTemplateFields", CollectionLiterals.newArrayList((Object[])new Object[]{GlobalKeyFields.class, TemplateFields.class}), this.getMetaAndTemplateFieldTypes(allMetaTypes)));
        Functions.Function1 _function_2 = it -> it instanceof Data;
        Iterable modelClasses = IterableExtensions.filter(model.getElements(), (Functions.Function1)_function_2);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)modelClasses);
        if (_isEmpty) {
            return;
        }
        Function _function_3 = c -> this.namespace((RosettaRootElement)c);
        ImmutableMap namespaceClasses = Multimaps.index((Iterable)modelClasses, (Function)_function_3).asMap();
        ImmutableSet _entrySet = namespaceClasses.entrySet();
        for (Map.Entry nsc : _entrySet) {
            boolean _isCanceled = ctx.getCancelIndicator().isCanceled();
            if (_isCanceled) {
                return;
            }
            Functions.Function1 _function_4 = it -> RosettaAttributeExtensions.getExpandedAttributes(it);
            Functions.Function1 _function_5 = it -> it.hasMetas() && IterableExtensions.exists(it.getMetas(), it_1 -> Objects.equal((Object)it_1.getName(), (Object)"reference") || Objects.equal((Object)it_1.getName(), (Object)"address"));
            Set refs = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)((Iterable)nsc.getValue()), Data.class), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
            for (ExpandedAttribute ref : refs) {
                RosettaModel targetModel = ref.getType().getModel();
                boolean _shouldGenerate = this.shouldGenerate(targetModel);
                if (!_shouldGenerate) continue;
                RosettaJavaPackages.RootPackage targetPackage = new RosettaJavaPackages.RootPackage(targetModel);
                JavaClass<?> metaJt = this._javaTypeTranslator.toMetaJavaType(ref);
                boolean _isCanceled_1 = ctx.getCancelIndicator().isCanceled();
                if (_isCanceled_1) {
                    return;
                }
                StringConcatenation _builder_2 = new StringConcatenation();
                String _withForwardSlashes_2 = metaJt.getCanonicalName().withForwardSlashes();
                _builder_2.append(_withForwardSlashes_2);
                _builder_2.append(".java");
                fsa.generateFile(_builder_2.toString(), (CharSequence)this.referenceWithMeta(targetPackage, metaJt, ref.getRosettaType()));
            }
            Functions.Function1 _function_6 = it -> RosettaAttributeExtensions.getExpandedAttributes(it);
            Functions.Function1 _function_7 = it -> it.hasMetas() && !IterableExtensions.exists(it.getMetas(), it_1 -> Objects.equal((Object)it_1.getName(), (Object)"reference") || Objects.equal((Object)it_1.getName(), (Object)"address"));
            Set metas = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)((Iterable)nsc.getValue()), Data.class), (Functions.Function1)_function_6), (Functions.Function1)_function_7));
            for (ExpandedAttribute meta : metas) {
                RosettaModel targetModel = meta.getType().getModel();
                boolean _shouldGenerate = this.shouldGenerate(targetModel);
                if (!_shouldGenerate) continue;
                RosettaJavaPackages.RootPackage targetPackage = new RosettaJavaPackages.RootPackage(targetModel);
                JavaClass<?> metaJt = this._javaTypeTranslator.toMetaJavaType(meta);
                boolean _isCanceled_1 = ctx.getCancelIndicator().isCanceled();
                if (_isCanceled_1) {
                    return;
                }
                StringConcatenation _builder_2 = new StringConcatenation();
                String _withForwardSlashes_2 = metaJt.getCanonicalName().withForwardSlashes();
                _builder_2.append(_withForwardSlashes_2);
                _builder_2.append(".java");
                fsa.generateFile(_builder_2.toString(), this.fieldWithMeta(targetPackage, metaJt, meta.getRosettaType()));
            }
        }
    }

    public TypeCall toTypeCall(RosettaType t) {
        TypeCall typeCall = RosettaFactoryImpl.eINSTANCE.createTypeCall();
        typeCall.setType(t);
        return typeCall;
    }

    public TypeCall getStringType() {
        RosettaMetaType stringType = RosettaFactoryImpl.eINSTANCE.createRosettaMetaType();
        stringType.setName("string");
        return this.toTypeCall(stringType);
    }

    public RosettaCardinality getCardSingle() {
        RosettaCardinality _xblockexpression = null;
        RosettaCardinality cardSingle = RosettaFactory.eINSTANCE.createRosettaCardinality();
        cardSingle.setInf(0);
        cardSingle.setSup(1);
        _xblockexpression = cardSingle;
        return _xblockexpression;
    }

    public List<Attribute> getMetaFieldTypes(Collection<RosettaMetaType> utypes) {
        RosettaCardinality cardMult = RosettaFactory.eINSTANCE.createRosettaCardinality();
        cardMult.setInf(0);
        cardMult.setSup(1000);
        cardMult.setUnbounded(true);
        Attribute globalKeyAttribute = SimpleFactory.eINSTANCE.createAttribute();
        globalKeyAttribute.setName("globalKey");
        globalKeyAttribute.setCard(this.getCardSingle());
        globalKeyAttribute.setTypeCall(this.getStringType());
        Attribute externalKeyAttribute = SimpleFactory.eINSTANCE.createAttribute();
        externalKeyAttribute.setName("externalKey");
        externalKeyAttribute.setCard(this.getCardSingle());
        externalKeyAttribute.setTypeCall(this.getStringType());
        Data keysType = SimpleFactory.eINSTANCE.createData();
        keysType.setName("Key");
        keysType.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
        RosettaModel _model = keysType.getModel();
        _model.setName("com.rosetta.model.lib.meta");
        Attribute keysAttribute = SimpleFactory.eINSTANCE.createAttribute();
        keysAttribute.setName("key");
        keysAttribute.setTypeCall(this.toTypeCall(keysType));
        keysAttribute.setCard(cardMult);
        Functions.Function1 _function = t -> !Objects.equal((Object)t.getName(), (Object)"key") && !Objects.equal((Object)t.getName(), (Object)"id") && !Objects.equal((Object)t.getName(), (Object)"reference");
        Set filteredTypes = IterableExtensions.toSet((Iterable)IterableExtensions.filter(utypes, (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> this.toAttribute((RosettaMetaType)it);
        List result = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)filteredTypes, (Functions.Function1)_function_1));
        result.addAll(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Attribute[]{globalKeyAttribute, externalKeyAttribute, keysAttribute})));
        return result;
    }

    public Attribute toAttribute(RosettaMetaType type) {
        Attribute newAttribute = SimpleFactory.eINSTANCE.createAttribute();
        newAttribute.setCard(this.getCardSingle());
        newAttribute.setName(type.getName());
        newAttribute.setTypeCall(this.toTypeCall(type));
        return newAttribute;
    }

    public List<Attribute> getMetaAndTemplateFieldTypes(Collection<RosettaMetaType> utypes) {
        RosettaMetaType templateGlobalReferenceType = RosettaFactoryImpl.eINSTANCE.createRosettaMetaType();
        templateGlobalReferenceType.setName("templateGlobalReference");
        templateGlobalReferenceType.setTypeCall(this.getStringType());
        RosettaModel libModel = RosettaFactory.eINSTANCE.createRosettaModel();
        libModel.setName("com.rosetta.model");
        templateGlobalReferenceType.setModel(libModel);
        ArrayList<RosettaMetaType> plusTypes = new ArrayList<RosettaMetaType>(utypes);
        plusTypes.add(templateGlobalReferenceType);
        List<Attribute> metaFieldTypes = this.getMetaFieldTypes(plusTypes);
        return metaFieldTypes;
    }

    public String metaFields(final String name, final Collection<Object> interfaces, Collection<Attribute> attributes) {
        StringConcatenationClient _client;
        String _xblockexpression = null;
        Functions.Function1 _function = t -> {
            String _name = t.getName();
            return Objects.equal((Object)_name, (Object)"scheme");
        };
        boolean _exists = IterableExtensions.exists(attributes, (Functions.Function1)_function);
        if (_exists) {
            interfaces.add(MetaDataFields.class);
        }
        final Data d = SimpleFactory.eINSTANCE.createData();
        d.setName(name);
        d.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
        RosettaModel _model = d.getModel();
        _model.setName(this.packages.basicMetafields().withDots());
        d.getAttributes().addAll(attributes);
        DottedPath _basicMetafields = this.packages.basicMetafields();
        final JavaScope scope = new JavaScope(_basicMetafields);
        StringConcatenationClient body = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                DottedPath _basicMetafields = MetaFieldGenerator.this.packages.basicMetafields();
                String _name = d.getName();
                String _plus = _name + "Meta";
                GeneratedJavaClass _generatedJavaClass = new GeneratedJavaClass(_basicMetafields, _plus, Object.class);
                StringConcatenationClient _classBody = MetaFieldGenerator.this._modelObjectGenerator.classBody(d, scope, (JavaClass<?>)_generatedJavaClass, "1", interfaces);
                _builder.append((Object)_classBody);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"class ");
                _builder.append((Object)name);
                _builder.append((Object)"Meta extends ");
                _builder.append(BasicRosettaMetaData.class);
                _builder.append((Object)"<");
                _builder.append((Object)name);
                _builder.append((Object)">{");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        _xblockexpression = this._importManagerExtension.buildClass(this.packages.basicMetafields(), body, scope);
        return _xblockexpression;
    }

    public CharSequence fieldWithMeta(RosettaJavaPackages.RootPackage root, final JavaClass<?> metaJavaType, TypeCall typeCall) {
        StringConcatenationClient _client;
        String _xblockexpression = null;
        Attribute valueAttribute = SimpleFactory.eINSTANCE.createAttribute();
        valueAttribute.setCard(this.getCardSingle());
        valueAttribute.setName("value");
        valueAttribute.setTypeCall((TypeCall)EcoreUtil2.copy((EObject)typeCall));
        Data metaType = SimpleFactory.eINSTANCE.createData();
        metaType.setName("MetaFields");
        metaType.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
        RosettaModel _model = metaType.getModel();
        _model.setName(this.packages.basicMetafields().withDots());
        Attribute metaAttribute = SimpleFactory.eINSTANCE.createAttribute();
        metaAttribute.setName("meta");
        metaAttribute.setTypeCall(this.toTypeCall(metaType));
        metaAttribute.setCard(this.getCardSingle());
        final Data d = SimpleFactory.eINSTANCE.createData();
        d.setName(metaJavaType.getSimpleName());
        d.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
        RosettaModel _model_1 = d.getModel();
        _model_1.setName(metaJavaType.getPackageName().withDots());
        d.getAttributes().addAll(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Attribute[]{valueAttribute, metaAttribute})));
        final JavaParameterizedType FWMType = JavaParameterizedType.from((TypeReference)new TypeReference<FieldWithMeta<?>>(){}, (JavaTypeArgument[])new JavaTypeArgument[]{this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.typeCallToRType(typeCall))});
        DottedPath _packageName = metaJavaType.getPackageName();
        final JavaScope scope = new JavaScope(_packageName);
        StringConcatenationClient body = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                DottedPath _packageName = metaJavaType.getPackageName();
                String _name = d.getName();
                String _plus = _name + "Meta";
                GeneratedJavaClass _generatedJavaClass = new GeneratedJavaClass(_packageName, _plus, Object.class);
                StringConcatenationClient _classBody = MetaFieldGenerator.this._modelObjectGenerator.classBody(d, scope, (JavaClass<?>)_generatedJavaClass, "1", (Collection<Object>)Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{GlobalKey.class, FWMType})));
                _builder.append((Object)_classBody);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"class ");
                String _simpleName = metaJavaType.getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)"Meta extends ");
                _builder.append(BasicRosettaMetaData.class);
                _builder.append((Object)"<");
                String _simpleName_1 = metaJavaType.getSimpleName();
                _builder.append((Object)_simpleName_1);
                _builder.append((Object)">{");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        _xblockexpression = this._importManagerExtension.buildClass(metaJavaType.getPackageName(), body, scope);
        return _xblockexpression;
    }

    public List<Attribute> referenceAttributes(TypeCall typeCall) {
        List<Attribute> _xblockexpression = null;
        Attribute valueAttribute = SimpleFactory.eINSTANCE.createAttribute();
        valueAttribute.setCard(this.getCardSingle());
        valueAttribute.setName("value");
        valueAttribute.setTypeCall((TypeCall)EcoreUtil2.copy((EObject)typeCall));
        Attribute globalRefAttribute = SimpleFactory.eINSTANCE.createAttribute();
        globalRefAttribute.setName("globalReference");
        globalRefAttribute.setCard(this.getCardSingle());
        globalRefAttribute.setTypeCall(this.getStringType());
        Attribute externalRefAttribute = SimpleFactory.eINSTANCE.createAttribute();
        externalRefAttribute.setName("externalReference");
        externalRefAttribute.setCard(this.getCardSingle());
        externalRefAttribute.setTypeCall(this.getStringType());
        Data refType = SimpleFactory.eINSTANCE.createData();
        refType.setName("Reference");
        refType.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
        RosettaModel _model = refType.getModel();
        _model.setName("com.rosetta.model.lib.meta");
        Attribute refAttribute = SimpleFactory.eINSTANCE.createAttribute();
        refAttribute.setName("reference");
        refAttribute.setTypeCall(this.toTypeCall(refType));
        refAttribute.setCard(this.getCardSingle());
        _xblockexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Attribute[]{valueAttribute, globalRefAttribute, externalRefAttribute, refAttribute}));
        return _xblockexpression;
    }

    public String referenceWithMeta(final RosettaJavaPackages.RootPackage root, final JavaClass<?> metaJavaType, TypeCall typeCall) {
        StringConcatenationClient _client;
        String _xblockexpression = null;
        final Data d = SimpleFactory.eINSTANCE.createData();
        d.setName(metaJavaType.getSimpleName());
        d.setModel(RosettaFactory.eINSTANCE.createRosettaModel());
        RosettaModel _model = d.getModel();
        _model.setName(metaJavaType.getPackageName().withDots());
        d.getAttributes().addAll(this.referenceAttributes(typeCall));
        final JavaParameterizedType refInterface = JavaParameterizedType.from((TypeReference)new TypeReference<ReferenceWithMeta<?>>(){}, (JavaTypeArgument[])new JavaTypeArgument[]{this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.typeCallToRType(typeCall))});
        DottedPath _metaField = root.metaField();
        final JavaScope scope = new JavaScope(_metaField);
        StringConcatenationClient body = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                DottedPath _metaField = root.metaField();
                String _name = d.getName();
                String _plus = _name + "Meta";
                GeneratedJavaClass _generatedJavaClass = new GeneratedJavaClass(_metaField, _plus, Object.class);
                StringConcatenationClient _classBody = MetaFieldGenerator.this._modelObjectGenerator.classBody(d, scope, (JavaClass<?>)_generatedJavaClass, "1", (Collection<Object>)Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{refInterface})));
                _builder.append((Object)_classBody);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"class ");
                String _simpleName = metaJavaType.getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)"Meta extends ");
                _builder.append(BasicRosettaMetaData.class);
                _builder.append((Object)"<");
                String _simpleName_1 = metaJavaType.getSimpleName();
                _builder.append((Object)_simpleName_1);
                _builder.append((Object)">{");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        _xblockexpression = this._importManagerExtension.buildClass(root.metaField(), body, scope);
        return _xblockexpression;
    }

    private String namespace(RosettaRootElement rc) {
        return rc.getModel().getName();
    }

    private boolean shouldGenerate(RosettaModel model) {
        return this.config.getNamespaceFilter().test(model.getName()) || model.isOverridden();
    }

    public static class MarkerAdapterFactory
    extends AdapterFactoryImpl {
        private final String namespace;

        public MarkerAdapterFactory(String namespace) {
            this.namespace = namespace;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

