/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.reports;

import com.fasterxml.jackson.core.type.TypeReference;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.function.FunctionGenerator;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.rosetta.RosettaCorpus;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RObjectFactory;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import java.util.Collections;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ReportGenerator {
    @Inject
    @Extension
    private RObjectFactory _rObjectFactory;
    @Inject
    private FunctionGenerator functionGenerator;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;

    public void generate(RosettaJavaPackages.RootPackage root, IFileSystemAccess2 fsa, RosettaReport report, String version) {
        RFunction rFunction = this._rObjectFactory.buildRFunction(report);
        JavaClass<? extends RosettaFunction> clazz = this._javaTypeTranslator.toFunctionJavaClass(rFunction);
        DottedPath _packageName = clazz.getPackageName();
        JavaScope topScope = new JavaScope(_packageName);
        JavaParameterizedType baseInterface = JavaParameterizedType.from((TypeReference)new TypeReference<ReportFunction<?, ?>>(){}, (JavaTypeArgument[])new JavaTypeArgument[]{this._javaTypeTranslator.attributeToJavaType((RAttribute)IterableExtensions.head(rFunction.getInputs())), this._javaTypeTranslator.attributeToJavaType(rFunction.getOutput())});
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("namespace=\"");
        String _name = report.getModel().getName();
        _builder.append(_name);
        _builder.append("\", body=\"");
        String _name_1 = report.getRegulatoryBody().getBody().getName();
        _builder.append(_name_1);
        _builder.append("\", corpusList={");
        EList<RosettaCorpus> _corpusList = report.getRegulatoryBody().getCorpusList();
        boolean _hasElements = false;
        for (RosettaCorpus corpus : _corpusList) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append("\"");
            String _name_2 = corpus.getName();
            _builder.append(_name_2);
            _builder.append("\"");
        }
        _builder.append("}");
        String reportAnnotationArguments = _builder.toString();
        Pair _mappedTo = Pair.of(com.rosetta.model.lib.annotations.RosettaReport.class, (Object)reportAnnotationArguments);
        StringConcatenationClient classBody = this.functionGenerator.rBuildClass(rFunction, false, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new JavaType[]{baseInterface})), Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})), true, topScope);
        String content = this._importManagerExtension.buildClass(clazz.getPackageName(), classBody, topScope);
        String _withForwardSlashes = clazz.getCanonicalName().withForwardSlashes();
        String _plus = _withForwardSlashes + ".java";
        fsa.generateFile(_plus, (CharSequence)content);
    }
}

