/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.reports;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.reports.Tabulator;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class TabulatorGenerator {
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    @Extension
    private JavaTypeTranslator typeTranslator;
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private RosettaExtensions extensions;
    @Inject
    @Extension
    private JavaTypeUtil _javaTypeUtil;

    public void generate(IFileSystemAccess2 fsa, RosettaReport report) {
        JavaClass<Tabulator<?>> tabulatorClass = this.typeTranslator.toReportTabulatorJavaClass(report);
        DottedPath _packageName = tabulatorClass.getPackageName();
        JavaScope topScope = new JavaScope(_packageName);
        ReportTabulatorContext context = this.getContext(report.getReportType(), Optional.ofNullable(report.getRuleSource()));
        StringConcatenationClient classBody = this.mainTabulatorClassBody(report.getReportType(), context, topScope, tabulatorClass);
        String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
        String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
        String _plus = _withForwardSlashes + ".java";
        fsa.generateFile(_plus, (CharSequence)content);
    }

    public void generate(IFileSystemAccess2 fsa, Data type, Optional<RosettaExternalRuleSource> ruleSource) {
        ReportTabulatorContext context = this.getContext(type, ruleSource);
        boolean _needsTabulator = context.needsTabulator(type);
        if (_needsTabulator) {
            JavaClass<Tabulator<?>> tabulatorClass = this.typeTranslator.toTabulatorJavaClass(type, ruleSource);
            DottedPath _packageName = tabulatorClass.getPackageName();
            JavaScope topScope = new JavaScope(_packageName);
            StringConcatenationClient classBody = this.tabulatorClassBody(type, context, topScope, tabulatorClass);
            String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
            String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
            String _plus = _withForwardSlashes + ".java";
            fsa.generateFile(_plus, (CharSequence)content);
        }
    }

    public void generate(IFileSystemAccess2 fsa, com.regnosys.rosetta.rosetta.simple.Function func) {
        boolean _isProjection = this.isProjection(func);
        if (_isProjection) {
            JavaClass<Tabulator<?>> tabulatorClass = this.typeTranslator.toProjectionTabulatorJavaClass(func);
            DottedPath _packageName = tabulatorClass.getPackageName();
            JavaScope topScope = new JavaScope(_packageName);
            RType projectionType = this.typeProvider.getRTypeOfSymbol(func.getOutput());
            if (projectionType instanceof RDataType) {
                ProjectionTabulatorContext context = new ProjectionTabulatorContext(this.typeTranslator, func);
                StringConcatenationClient classBody = this.mainTabulatorClassBody(((RDataType)projectionType).getData(), context, topScope, tabulatorClass);
                String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
                String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
                String _plus = _withForwardSlashes + ".java";
                fsa.generateFile(_plus, (CharSequence)content);
                this.recursivelyGenerateProjectionTypeTabulators(fsa, ((RDataType)projectionType).getData(), context, CollectionLiterals.newHashSet());
            }
        }
    }

    private void recursivelyGenerateProjectionTypeTabulators(IFileSystemAccess2 fsa, Data type, ProjectionTabulatorContext context, Set<Data> visited) {
        boolean _add = visited.add(type);
        if (_add) {
            JavaClass<Tabulator<?>> tabulatorClass = this.typeTranslator.toTabulatorJavaClass(type, context.projection);
            DottedPath _packageName = tabulatorClass.getPackageName();
            JavaScope topScope = new JavaScope(_packageName);
            StringConcatenationClient classBody = this.tabulatorClassBody(type, context, topScope, tabulatorClass);
            String content = this._importManagerExtension.buildClass(tabulatorClass.getPackageName(), classBody, topScope);
            String _withForwardSlashes = tabulatorClass.getCanonicalName().withForwardSlashes();
            String _plus = _withForwardSlashes + ".java";
            fsa.generateFile(_plus, (CharSequence)content);
            Functions.Function1 _function = it -> this.typeProvider.getRTypeOfSymbol((RosettaSymbol)it);
            Consumer<RDataType> _function_1 = it -> this.recursivelyGenerateProjectionTypeTabulators(fsa, it.getData(), context, visited);
            Iterables.filter((Iterable)ListExtensions.map(this.extensions.allNonOverridesAttributes(type), (Functions.Function1)_function), RDataType.class).forEach(_function_1);
        }
    }

    private ReportTabulatorContext getContext(Data type, Optional<RosettaExternalRuleSource> ruleSource) {
        ReportTabulatorContext _xblockexpression = null;
        HashMap ruleMap = CollectionLiterals.newHashMap();
        BiConsumer<RosettaExtensions.PathAttribute, RosettaRule> _function = (key, rule) -> ruleMap.put(key.getAttr(), rule);
        this.extensions.getAllReportingRules(type, ruleSource).forEach(_function);
        _xblockexpression = new ReportTabulatorContext(this.extensions, this.typeTranslator, ruleMap, ruleSource);
        return _xblockexpression;
    }

    private boolean isProjection(com.regnosys.rosetta.rosetta.simple.Function func) {
        Functions.Function1 _function = it -> {
            String _name = it.getAnnotation().getName();
            return Objects.equal((Object)_name, (Object)"projection");
        };
        AnnotationRef _findFirst = (AnnotationRef)IterableExtensions.findFirst((Iterable)func.getAnnotations(), (Functions.Function1)_function);
        return _findFirst != null;
    }

    private StringConcatenationClient mainTabulatorClassBody(Data inputType, TabulatorContext context, JavaScope topScope, final JavaClass<Tabulator<?>> tabulatorClass) {
        StringConcatenationClient _xblockexpression = null;
        final JavaReferenceType inputClass = this.typeTranslator.toJavaReferenceType(new RDataType(inputType));
        JavaScope classScope = topScope.classScope(tabulatorClass.getSimpleName());
        JavaScope tabulateScope = classScope.methodScope("tabulate");
        final GeneratedIdentifier inputParam = tabulateScope.createUniqueIdentifier("input");
        StringConcatenationClient _xifexpression = null;
        boolean _needsTabulator = context.needsTabulator(inputType);
        if (_needsTabulator) {
            StringConcatenationClient _client;
            StringConcatenationClient _xblockexpression_1 = null;
            final JavaClass<Tabulator<?>> innerTabulatorClass = context.toTabulatorJavaClass(inputType);
            final GeneratedIdentifier innerTabulatorInstance = classScope.createUniqueIdentifier("tabulator");
            _xifexpression = _xblockexpression_1 = (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"public class ");
                    _builder.append((Object)tabulatorClass);
                    _builder.append((Object)" implements ");
                    _builder.append(Tabulator.class);
                    _builder.append((Object)"<");
                    _builder.append((Object)inputClass);
                    _builder.append((Object)"> {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"private final ");
                    _builder.append((Object)innerTabulatorClass, "\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)innerTabulatorInstance, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@");
                    _builder.append(Inject.class, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"public ");
                    _builder.append((Object)tabulatorClass, "\t");
                    _builder.append((Object)"(");
                    _builder.append((Object)innerTabulatorClass, "\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)innerTabulatorInstance, "\t");
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"this.");
                    _builder.append((Object)innerTabulatorInstance, "\t\t");
                    _builder.append((Object)" = ");
                    _builder.append((Object)innerTabulatorInstance, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"public ");
                    _builder.append(List.class, "\t");
                    _builder.append((Object)"<");
                    _builder.append(Tabulator.Field.class, "\t");
                    _builder.append((Object)"> getFields() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return ");
                    _builder.append((Object)innerTabulatorInstance, "\t\t");
                    _builder.append((Object)".getFields();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"public ");
                    _builder.append(List.class, "\t");
                    _builder.append((Object)"<");
                    _builder.append(Tabulator.FieldValue.class, "\t");
                    _builder.append((Object)"> tabulate(");
                    _builder.append((Object)inputClass, "\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)inputParam, "\t");
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return ");
                    _builder.append((Object)innerTabulatorInstance, "\t\t");
                    _builder.append((Object)".tabulate(");
                    _builder.append((Object)inputParam, "\t\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            });
        } else {
            StringConcatenationClient _client;
            _xifexpression = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"public class ");
                    _builder.append((Object)tabulatorClass);
                    _builder.append((Object)" implements ");
                    _builder.append(Tabulator.class);
                    _builder.append((Object)"<");
                    _builder.append((Object)inputClass);
                    _builder.append((Object)"> {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"public ");
                    _builder.append(List.class, "\t");
                    _builder.append((Object)"<");
                    _builder.append(Tabulator.Field.class, "\t");
                    _builder.append((Object)"> getFields() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return ");
                    _builder.append(Arrays.class, "\t\t");
                    _builder.append((Object)".asList();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"public ");
                    _builder.append(List.class, "\t");
                    _builder.append((Object)"<");
                    _builder.append(Tabulator.FieldValue.class, "\t");
                    _builder.append((Object)"> tabulate(");
                    _builder.append((Object)inputClass, "\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)inputParam, "\t");
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return ");
                    _builder.append(Arrays.class, "\t\t");
                    _builder.append((Object)".asList();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private StringConcatenationClient tabulatorClassBody(final Data inputType, final TabulatorContext context, JavaScope topScope, final JavaClass<Tabulator<?>> tabulatorClass) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final JavaReferenceType inputClass = this.typeTranslator.toJavaReferenceType(new RDataType(inputType));
        final JavaScope classScope = topScope.classScope(tabulatorClass.getSimpleName());
        final List<Attribute> tabulatedFields = this.findTabulatedFieldsAndCreateIdentifiers(inputType, context, classScope);
        final Set<NestedTabulatorInstance> nestedTabulatorInstances = this.findNestedTabulatorsAndCreateIdentifiers(inputType, context, classScope);
        final JavaScope tabulateScope = classScope.methodScope("tabulate");
        final GeneratedIdentifier inputParam = tabulateScope.createUniqueIdentifier("input");
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _not_1;
                boolean _not;
                _builder.append((Object)"public class ");
                _builder.append((Object)tabulatorClass);
                _builder.append((Object)" implements ");
                _builder.append(Tabulator.class);
                _builder.append((Object)"<");
                _builder.append((Object)inputClass);
                _builder.append((Object)"> {");
                _builder.newLineIfNotEmpty();
                List<Attribute> _allNonOverridesAttributes = TabulatorGenerator.this.extensions.allNonOverridesAttributes(inputType);
                for (Attribute attribute : _allNonOverridesAttributes) {
                    boolean _isTabulated = context.isTabulated(attribute);
                    if (!_isTabulated) continue;
                    _builder.append((Object)"\t");
                    GeneratedIdentifier fieldId = classScope.getIdentifierOrThrow(attribute);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"private final ");
                    _builder.append(Tabulator.Field.class, "\t");
                    _builder.append((Object)" ");
                    _builder.append((Object)fieldId, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                boolean _isEmpty = nestedTabulatorInstances.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    for (NestedTabulatorInstance tabInst : nestedTabulatorInstances) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"private final ");
                        JavaClass<Tabulator<?>> _tabulatorJavaClass = context.toTabulatorJavaClass(tabInst.type);
                        _builder.append(_tabulatorJavaClass, "\t");
                        _builder.append((Object)" ");
                        GeneratedIdentifier _identifierOrThrow = classScope.getIdentifierOrThrow(tabInst);
                        _builder.append((Object)_identifierOrThrow, "\t");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                boolean _isEmpty_1 = nestedTabulatorInstances.isEmpty();
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    _builder.append((Object)"@");
                    _builder.append(Inject.class, "\t");
                }
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append((Object)tabulatorClass, "\t");
                _builder.append((Object)"(");
                boolean _hasElements = false;
                for (NestedTabulatorInstance nestedTabulatorInstance : nestedTabulatorInstances) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    JavaClass<Tabulator<?>> _tabulatorJavaClass_1 = context.toTabulatorJavaClass(nestedTabulatorInstance.type);
                    _builder.append(_tabulatorJavaClass_1, "\t");
                    _builder.append((Object)" ");
                    GeneratedIdentifier _identifierOrThrow_1 = classScope.getIdentifierOrThrow(nestedTabulatorInstance);
                    _builder.append((Object)_identifierOrThrow_1, "\t");
                }
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                for (NestedTabulatorInstance tabInst_2 : nestedTabulatorInstances) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"this.");
                    GeneratedIdentifier generatedIdentifier = classScope.getIdentifierOrThrow(tabInst_2);
                    _builder.append((Object)generatedIdentifier, "\t\t");
                    _builder.append((Object)" = ");
                    GeneratedIdentifier _identifierOrThrow_3 = classScope.getIdentifierOrThrow(tabInst_2);
                    _builder.append((Object)_identifierOrThrow_3, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t");
                StringConcatenationClient _initializeFields = TabulatorGenerator.this.initializeFields(inputType, context, classScope);
                _builder.append((Object)_initializeFields, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(Tabulator.Field.class, "\t");
                _builder.append((Object)"> getFields() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                _builder.append(Arrays.class, "\t\t");
                _builder.append((Object)".asList(");
                boolean _hasElements_1 = false;
                for (Attribute field : tabulatedFields) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t");
                    }
                    GeneratedIdentifier _identifierOrThrow_4 = classScope.getIdentifierOrThrow(field);
                    _builder.append((Object)_identifierOrThrow_4, "\t\t");
                }
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(Tabulator.FieldValue.class, "\t");
                _builder.append((Object)"> tabulate(");
                _builder.append((Object)inputClass, "\t");
                _builder.append((Object)" ");
                _builder.append((Object)inputParam, "\t");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                StringConcatenationClient _computeFieldValues = TabulatorGenerator.this.computeFieldValues(inputType, inputParam, context, tabulateScope);
                _builder.append((Object)_computeFieldValues, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                StringConcatenationClient stringConcatenationClient = TabulatorGenerator.this.fieldValuesAsList(inputType, context, tabulateScope);
                _builder.append((Object)stringConcatenationClient, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    private List<Attribute> findTabulatedFieldsAndCreateIdentifiers(Data type, TabulatorContext context, JavaScope scope) {
        Functions.Function1 _function = it -> context.isTabulated((Attribute)it);
        Functions.Function1 _function_1 = it -> {
            Attribute _xblockexpression = null;
            String _name = it.getName();
            String _plus = _name + "Field";
            scope.createIdentifier(it, _plus);
            _xblockexpression = it;
            return _xblockexpression;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.extensions.allNonOverridesAttributes(type), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    private StringConcatenationClient initializeFields(final Data type, final TabulatorContext context, final JavaScope scope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                List<Attribute> _allNonOverridesAttributes = TabulatorGenerator.this.extensions.allNonOverridesAttributes(type);
                for (Attribute attr : _allNonOverridesAttributes) {
                    boolean _isTabulated = context.isTabulated(attr);
                    if (!_isTabulated) continue;
                    GeneratedIdentifier fieldId = scope.getIdentifierOrThrow(attr);
                    _builder.newLineIfNotEmpty();
                    Optional<RosettaRule> rule = context.getRule(attr);
                    _builder.newLineIfNotEmpty();
                    RosettaType attrType = attr.getTypeCall().getType();
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"this.");
                    _builder.append((Object)fieldId);
                    _builder.append((Object)" = new ");
                    _builder.append(Tabulator.FieldImpl.class);
                    _builder.append((Object)"(");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\"");
                    String _escapeJava = StringEscapeUtils.escapeJava((String)attr.getName());
                    _builder.append((Object)_escapeJava, "\t");
                    _builder.append((Object)"\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    boolean _isIsMany = attr.getCard().isIsMany();
                    _builder.append((Object)_isIsMany, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    Function<RosettaRule, RosettaModel> _function = it -> it.getModel();
                    Function<RosettaModel, String> _function_1 = it -> it.getName();
                    Function<String, StringConcatenationClient> _function_2 = it -> {
                        DottedPath _splitOnDots = DottedPath.splitOnDots((String)it);
                        String _name = ((RosettaRule)rule.get()).getName();
                        return TabulatorGenerator.this.toModelSymbolCode(new ModelSymbolId(_splitOnDots, _name));
                    };
                    StringConcatenationClient _optionalCode = TabulatorGenerator.this.toOptionalCode(rule.map(_function).map(_function_1).map(_function_2));
                    _builder.append((Object)_optionalCode, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    Function<RosettaRule, String> _function_3 = it -> it.getIdentifier();
                    Function<String, String> _function_4 = it -> "\"" + it + "\"";
                    StringConcatenationClient _optionalCode_1 = TabulatorGenerator.this.toOptionalCode(rule.map(_function_3).map(_function_4));
                    _builder.append((Object)_optionalCode_1, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    if (attrType instanceof Data) {
                        _builder.append((Object)"\t");
                        GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(TabulatorGenerator.this.toNestedTabulatorInstance((Data)attrType));
                        _builder.append((Object)_identifierOrThrow, "\t");
                        _builder.append((Object)".getFields()");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append(Arrays.class, "\t");
                        _builder.append((Object)".asList()");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)");");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    private Set<NestedTabulatorInstance> findNestedTabulatorsAndCreateIdentifiers(Data type, TabulatorContext context, JavaScope scope) {
        Set _xblockexpression = null;
        Functions.Function1 _function = it -> context.isTabulated((Attribute)it);
        Functions.Function1 _function_1 = it -> it.getTypeCall().getType();
        Functions.Function1 _function_2 = it -> this.toNestedTabulatorInstance((Data)it);
        Set result = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.extensions.allNonOverridesAttributes(type), (Functions.Function1)_function), (Functions.Function1)_function_1), Data.class), (Functions.Function1)_function_2));
        Consumer<NestedTabulatorInstance> _function_3 = it -> scope.createIdentifier(it, StringExtensions.toFirstLower((String)context.toTabulatorJavaClass(it.type).getSimpleName()));
        result.forEach(_function_3);
        _xblockexpression = result;
        return _xblockexpression;
    }

    private StringConcatenationClient computeFieldValues(final Data type, final GeneratedIdentifier inputParam, final TabulatorContext context, final JavaScope scope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                List<Attribute> _allNonOverridesAttributes = TabulatorGenerator.this.extensions.allNonOverridesAttributes(type);
                for (Attribute attr : _allNonOverridesAttributes) {
                    boolean _isTabulated = context.isTabulated(attr);
                    if (!_isTabulated) continue;
                    StringConcatenationClient _fieldValue = TabulatorGenerator.this.fieldValue(attr, inputParam, scope);
                    _builder.append((Object)_fieldValue);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return _client;
    }

    private StringConcatenationClient fieldValue(final Attribute attr, final GeneratedIdentifier inputParam, JavaScope scope) {
        StringConcatenationClient _xblockexpression = null;
        RType rType = this.typeProvider.getRTypeOfSymbol(attr);
        final GeneratedIdentifier resultId = scope.createIdentifier(this.toComputedField(attr), attr.getName());
        JavaScope lambdaScope = scope.lambdaScope();
        final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier("x");
        JavaScope nestedLambdaScope = lambdaScope.lambdaScope();
        final GeneratedIdentifier nestedLambdaParam = nestedLambdaScope.createUniqueIdentifier("x");
        StringConcatenationClient _xifexpression = null;
        if (rType instanceof RDataType) {
            StringConcatenationClient _client;
            StringConcatenationClient _xblockexpression_1 = null;
            JavaParameterizedType<List<?>> _xifexpression_1 = null;
            boolean _isIsMany = attr.getCard().isIsMany();
            _xifexpression_1 = _isIsMany ? this._javaTypeUtil.wrap(this._javaTypeUtil.LIST, (JavaType)this._javaTypeUtil.wrap(this._javaTypeUtil.LIST, (JavaType)JavaClass.from(Tabulator.FieldValue.class))) : this._javaTypeUtil.wrap(this._javaTypeUtil.LIST, (JavaType)JavaClass.from(Tabulator.FieldValue.class));
            final JavaParameterizedType<List<?>> resultType = _xifexpression_1;
            this.typeTranslator.toPolymorphicListOrSingleJavaType(rType, attr.getCard().isIsMany());
            Data attrType = ((RDataType)rType).getData();
            final GeneratedIdentifier nestedTabulator = scope.getIdentifierOrThrow(this.toNestedTabulatorInstance(attrType));
            _xifexpression = _xblockexpression_1 = (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(Optional.class);
                    _builder.append((Object)"<");
                    _builder.append((Object)resultType);
                    _builder.append((Object)"> ");
                    _builder.append((Object)resultId);
                    _builder.append((Object)" = ");
                    _builder.append(Optional.class);
                    _builder.append((Object)".ofNullable(");
                    _builder.append((Object)inputParam);
                    _builder.append((Object)".get");
                    String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
                    _builder.append((Object)_firstUpper);
                    _builder.append((Object)"())");
                    _builder.newLineIfNotEmpty();
                    boolean _isIsMany = attr.getCard().isIsMany();
                    if (_isIsMany) {
                        boolean _not;
                        _builder.append((Object)"\t");
                        _builder.append((Object)".map(");
                        _builder.append((Object)lambdaParam, "\t");
                        _builder.append((Object)" -> ");
                        _builder.append((Object)lambdaParam, "\t");
                        _builder.append((Object)".stream()");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)".map(");
                        _builder.append((Object)nestedLambdaParam, "\t\t");
                        _builder.append((Object)" -> ");
                        _builder.append((Object)nestedTabulator, "\t\t");
                        _builder.append((Object)".tabulate(");
                        _builder.append((Object)nestedLambdaParam, "\t\t");
                        boolean _isEmpty = IterableExtensions.isEmpty(TabulatorGenerator.this.extensions.metaAnnotations(attr));
                        boolean bl = _not = !_isEmpty;
                        if (_not) {
                            _builder.append((Object)".getValue()");
                        }
                        _builder.append((Object)"))");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)".collect(");
                        _builder.append(Collectors.class, "\t\t");
                        _builder.append((Object)".toList()));");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _not_1;
                        _builder.append((Object)"\t");
                        _builder.append((Object)".map(");
                        _builder.append((Object)lambdaParam, "\t");
                        _builder.append((Object)" -> ");
                        _builder.append((Object)nestedTabulator, "\t");
                        _builder.append((Object)".tabulate(");
                        _builder.append((Object)lambdaParam, "\t");
                        boolean _isEmpty_1 = IterableExtensions.isEmpty(TabulatorGenerator.this.extensions.metaAnnotations(attr));
                        boolean bl = _not_1 = !_isEmpty_1;
                        if (_not_1) {
                            _builder.append((Object)".getValue()");
                        }
                        _builder.append((Object)"));");
                        _builder.newLineIfNotEmpty();
                    }
                }
            });
        } else {
            StringConcatenationClient _client;
            StringConcatenationClient _xblockexpression_2 = null;
            final JavaReferenceType resultType = this.typeTranslator.toPolymorphicListOrSingleJavaType(rType, attr.getCard().isIsMany());
            _xifexpression = _xblockexpression_2 = (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _isEmpty = IterableExtensions.isEmpty(TabulatorGenerator.this.extensions.metaAnnotations(attr));
                    if (_isEmpty) {
                        _builder.append(Optional.class);
                        _builder.append((Object)"<");
                        _builder.append((Object)resultType);
                        _builder.append((Object)"> ");
                        _builder.append((Object)resultId);
                        _builder.append((Object)" = ");
                        _builder.append(Optional.class);
                        _builder.append((Object)".ofNullable(");
                        _builder.append((Object)inputParam);
                        _builder.append((Object)".get");
                        String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
                        _builder.append((Object)_firstUpper);
                        _builder.append((Object)"());");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _isIsMany = attr.getCard().isIsMany();
                        if (_isIsMany) {
                            _builder.append(Optional.class);
                            _builder.append((Object)"<");
                            _builder.append((Object)resultType);
                            _builder.append((Object)"> ");
                            _builder.append((Object)resultId);
                            _builder.append((Object)" = ");
                            _builder.append(Optional.class);
                            _builder.append((Object)".ofNullable(");
                            _builder.append((Object)inputParam);
                            _builder.append((Object)".get");
                            String _firstUpper_1 = StringExtensions.toFirstUpper((String)attr.getName());
                            _builder.append((Object)_firstUpper_1);
                            _builder.append((Object)"())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)".stream()");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)nestedLambdaParam, "\t\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)nestedLambdaParam, "\t\t");
                            _builder.append((Object)".getValue())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".collect(");
                            _builder.append(Collectors.class, "\t\t");
                            _builder.append((Object)".toList()));");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append(Optional.class);
                            _builder.append((Object)"<");
                            _builder.append((Object)resultType);
                            _builder.append((Object)"> ");
                            _builder.append((Object)resultId);
                            _builder.append((Object)" = ");
                            _builder.append(Optional.class);
                            _builder.append((Object)".ofNullable(");
                            _builder.append((Object)inputParam);
                            _builder.append((Object)".get");
                            String _firstUpper_2 = StringExtensions.toFirstUpper((String)attr.getName());
                            _builder.append((Object)_firstUpper_2);
                            _builder.append((Object)"())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)lambdaParam, "\t");
                            _builder.append((Object)".getValue());");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            });
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private StringConcatenationClient fieldValuesAsList(final Data type, final TabulatorContext context, final JavaScope scope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Arrays.class);
                _builder.append((Object)".asList(");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function = it -> context.isTabulated((Attribute)it);
                Iterable _filter = IterableExtensions.filter(TabulatorGenerator.this.extensions.allNonOverridesAttributes(type), (Functions.Function1)_function);
                boolean _hasElements = false;
                for (Attribute attr : _filter) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",", "\t");
                    }
                    _builder.append((Object)"\t");
                    RosettaType attrType = attr.getTypeCall().getType();
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    Class<Tabulator.FieldValueImpl> _xifexpression = null;
                    if (attrType instanceof Data) {
                        Class _xifexpression_1 = null;
                        boolean _isIsMany = attr.getCard().isIsMany();
                        _xifexpression_1 = _isIsMany ? Tabulator.MultiNestedFieldValueImpl.class : Tabulator.NestedFieldValueImpl.class;
                        _xifexpression = _xifexpression_1;
                    } else {
                        _xifexpression = Tabulator.FieldValueImpl.class;
                    }
                    Class<Tabulator.FieldValueImpl> valueClass = _xifexpression;
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"new ");
                    _builder.append(valueClass, "\t");
                    _builder.append((Object)"(");
                    GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(attr);
                    _builder.append((Object)_identifierOrThrow, "\t");
                    _builder.append((Object)", ");
                    GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(TabulatorGenerator.this.toComputedField(attr));
                    _builder.append((Object)_identifierOrThrow_1, "\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)")");
            }
        };
        return _client;
    }

    private StringConcatenationClient toOptionalCode(final Optional<?> object) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = object.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Optional.class);
                _builder.append((Object)".of(");
                Object _get = object.get();
                _builder.append(_get);
                _builder.append((Object)")");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Optional.class);
                _builder.append((Object)".empty()");
            }
        });
        return _xifexpression;
    }

    private StringConcatenationClient toDottedPathCode(final DottedPath path) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(DottedPath.class);
                _builder.append((Object)".of(\"");
                String _withSeparator = path.withSeparator((CharSequence)"\", \"");
                _builder.append((Object)_withSeparator);
                _builder.append((Object)"\")");
            }
        };
        return _client;
    }

    private StringConcatenationClient toModelSymbolCode(final ModelSymbolId symbolId) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"new ");
                _builder.append(ModelSymbolId.class);
                _builder.append((Object)"(");
                StringConcatenationClient _dottedPathCode = TabulatorGenerator.this.toDottedPathCode(symbolId.getNamespace());
                _builder.append((Object)_dottedPathCode);
                _builder.append((Object)", \"");
                String _name = symbolId.getName();
                _builder.append((Object)_name);
                _builder.append((Object)"\")");
            }
        };
        return _client;
    }

    private NestedTabulatorInstance toNestedTabulatorInstance(Data type) {
        return new NestedTabulatorInstance(type);
    }

    private ComputedField toComputedField(Attribute attr) {
        return new ComputedField(attr);
    }

    @org.eclipse.xtend.lib.annotations.Data
    private static class ReportTabulatorContext
    implements TabulatorContext {
        @Extension
        private final RosettaExtensions _rosettaExtensions;
        @Extension
        private final JavaTypeTranslator _javaTypeTranslator;
        private final Map<Attribute, RosettaRule> ruleMap;
        private final Optional<RosettaExternalRuleSource> ruleSource;

        @Override
        public boolean needsTabulator(Data type) {
            return this.needsTabulator(type, CollectionLiterals.newHashSet());
        }

        private boolean needsTabulator(Data type, Set<Data> visited) {
            boolean _xifexpression = false;
            boolean _add = visited.add(type);
            if (_add) {
                Functions.Function1 _function = it -> this.isTabulated((Attribute)it, visited);
                _xifexpression = IterableExtensions.exists(this._rosettaExtensions.getAllAttributes(type), (Functions.Function1)_function);
            } else {
                _xifexpression = false;
            }
            return _xifexpression;
        }

        @Override
        public boolean isTabulated(Attribute attr) {
            return this.isTabulated(attr, CollectionLiterals.newHashSet());
        }

        private boolean isTabulated(Attribute attr, Set<Data> visited) {
            boolean _xblockexpression = false;
            RosettaType attrType = attr.getTypeCall().getType();
            boolean _xifexpression = false;
            _xifexpression = attrType instanceof Data ? this.needsTabulator((Data)attrType, visited) : this.ruleMap.containsKey(attr);
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        @Override
        public JavaClass<Tabulator<?>> toTabulatorJavaClass(Data type) {
            return this._javaTypeTranslator.toTabulatorJavaClass(type, this.ruleSource);
        }

        @Override
        public Optional<RosettaRule> getRule(Attribute attr) {
            return Optional.ofNullable(this.ruleMap.get(attr));
        }

        public ReportTabulatorContext(RosettaExtensions _rosettaExtensions, JavaTypeTranslator _javaTypeTranslator, Map<Attribute, RosettaRule> ruleMap, Optional<RosettaExternalRuleSource> ruleSource) {
            this._rosettaExtensions = _rosettaExtensions;
            this._javaTypeTranslator = _javaTypeTranslator;
            this.ruleMap = ruleMap;
            this.ruleSource = ruleSource;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._rosettaExtensions == null ? 0 : this._rosettaExtensions.hashCode());
            result = 31 * result + (this._javaTypeTranslator == null ? 0 : this._javaTypeTranslator.hashCode());
            result = 31 * result + (this.ruleMap == null ? 0 : this.ruleMap.hashCode());
            return 31 * result + (this.ruleSource == null ? 0 : this.ruleSource.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReportTabulatorContext other = (ReportTabulatorContext)obj;
            if (this._rosettaExtensions == null ? other._rosettaExtensions != null : !this._rosettaExtensions.equals(other._rosettaExtensions)) {
                return false;
            }
            if (this._javaTypeTranslator == null ? other._javaTypeTranslator != null : !this._javaTypeTranslator.equals(other._javaTypeTranslator)) {
                return false;
            }
            if (this.ruleMap == null ? other.ruleMap != null : !this.ruleMap.equals(other.ruleMap)) {
                return false;
            }
            return !(this.ruleSource == null ? other.ruleSource != null : !this.ruleSource.equals(other.ruleSource));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("_rosettaExtensions", (Object)this._rosettaExtensions);
            b.add("_javaTypeTranslator", (Object)this._javaTypeTranslator);
            b.add("ruleMap", this.ruleMap);
            b.add("ruleSource", this.ruleSource);
            return b.toString();
        }

        @Pure
        public RosettaExtensions get_rosettaExtensions() {
            return this._rosettaExtensions;
        }

        @Pure
        public JavaTypeTranslator get_javaTypeTranslator() {
            return this._javaTypeTranslator;
        }

        @Pure
        public Map<Attribute, RosettaRule> getRuleMap() {
            return this.ruleMap;
        }

        @Pure
        public Optional<RosettaExternalRuleSource> getRuleSource() {
            return this.ruleSource;
        }
    }

    private static interface TabulatorContext {
        public boolean needsTabulator(Data var1);

        public boolean isTabulated(Attribute var1);

        public JavaClass<Tabulator<?>> toTabulatorJavaClass(Data var1);

        public Optional<RosettaRule> getRule(Attribute var1);
    }

    @org.eclipse.xtend.lib.annotations.Data
    private static class ProjectionTabulatorContext
    implements TabulatorContext {
        @Extension
        private final JavaTypeTranslator _javaTypeTranslator;
        private final com.regnosys.rosetta.rosetta.simple.Function projection;

        @Override
        public boolean needsTabulator(Data type) {
            return true;
        }

        @Override
        public boolean isTabulated(Attribute attr) {
            return true;
        }

        @Override
        public JavaClass<Tabulator<?>> toTabulatorJavaClass(Data type) {
            return this._javaTypeTranslator.toTabulatorJavaClass(type, this.projection);
        }

        @Override
        public Optional<RosettaRule> getRule(Attribute attr) {
            return Optional.empty();
        }

        public ProjectionTabulatorContext(JavaTypeTranslator _javaTypeTranslator, com.regnosys.rosetta.rosetta.simple.Function projection) {
            this._javaTypeTranslator = _javaTypeTranslator;
            this.projection = projection;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._javaTypeTranslator == null ? 0 : this._javaTypeTranslator.hashCode());
            return 31 * result + (this.projection == null ? 0 : this.projection.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectionTabulatorContext other = (ProjectionTabulatorContext)obj;
            if (this._javaTypeTranslator == null ? other._javaTypeTranslator != null : !this._javaTypeTranslator.equals(other._javaTypeTranslator)) {
                return false;
            }
            return !(this.projection == null ? other.projection != null : !this.projection.equals(other.projection));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("_javaTypeTranslator", (Object)this._javaTypeTranslator);
            b.add("projection", (Object)this.projection);
            return b.toString();
        }

        @Pure
        public JavaTypeTranslator get_javaTypeTranslator() {
            return this._javaTypeTranslator;
        }

        @Pure
        public com.regnosys.rosetta.rosetta.simple.Function getProjection() {
            return this.projection;
        }
    }

    @org.eclipse.xtend.lib.annotations.Data
    private static class ComputedField {
        private final Attribute attribute;

        public ComputedField(Attribute attribute) {
            this.attribute = attribute;
        }

        @Pure
        public int hashCode() {
            return 31 + (this.attribute == null ? 0 : this.attribute.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComputedField other = (ComputedField)obj;
            return !(this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("attribute", (Object)this.attribute);
            return b.toString();
        }

        @Pure
        public Attribute getAttribute() {
            return this.attribute;
        }
    }

    @org.eclipse.xtend.lib.annotations.Data
    private static class NestedTabulatorInstance {
        private final Data type;

        public NestedTabulatorInstance(Data type) {
            this.type = type;
        }

        @Pure
        public int hashCode() {
            return 31 + (this.type == null ? 0 : this.type.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NestedTabulatorInstance other = (NestedTabulatorInstance)obj;
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("type", (Object)this.type);
            return b.toString();
        }

        @Pure
        public Data getType() {
            return this.type;
        }
    }
}

