/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.fasterxml.jackson.core.type.TypeReference;
import com.regnosys.rosetta.RosettaExtensions;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.types.RJavaEnum;
import com.regnosys.rosetta.generator.java.types.RJavaPojoInterface;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.object.ExpandedType;
import com.regnosys.rosetta.rosetta.RegulatoryDocumentReference;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RErrorType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.ROperation;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RDateTimeType;
import com.regnosys.rosetta.types.builtin.RDateType;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.types.builtin.RZonedDateTimeType;
import com.regnosys.rosetta.utils.RosettaTypeSwitch;
import com.rosetta.model.lib.ModelReportId;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.lib.reports.Tabulator;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import com.rosetta.util.types.generated.GeneratedJavaClassService;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class JavaTypeTranslator
extends RosettaTypeSwitch<JavaType, Void> {
    private RBuiltinTypeService builtins;
    @Inject
    private RosettaJavaPackages packages;
    @Inject
    private RosettaExtensions extensions;
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private TypeSystem typeSystem;
    @Inject
    private GeneratedJavaClassService generatedJavaClassService;
    @Inject
    private JavaTypeUtil typeUtil;

    @Inject
    public JavaTypeTranslator(RBuiltinTypeService builtins) {
        super(builtins);
        this.builtins = builtins;
    }

    private DottedPath getModelPackage(RosettaNamed object) {
        RosettaRootElement rootElement = (RosettaRootElement)EcoreUtil2.getContainerOfType((EObject)object, RosettaRootElement.class);
        RosettaModel model = rootElement.getModel();
        if (model == null) {
            throw new IllegalArgumentException("Can not compute package name for " + object.eClass().getName() + " " + object.getName() + ". Element is not attached to a RosettaModel.");
        }
        return this.modelPackage(model);
    }

    public JavaParameterizedType<List<?>> toPolymorphicList(JavaReferenceType t) {
        return this.typeUtil.wrapExtends(this.typeUtil.LIST, (JavaType)t);
    }

    public JavaClass<? extends RosettaFunction> toFunctionJavaClass(RFunction func) {
        switch (func.getOrigin()) {
            case FUNCTION: {
                return this.generatedJavaClassService.toJavaFunction(func.getSymbolId());
            }
            case REPORT: {
                return this.generatedJavaClassService.toJavaReportFunction(func.getReportId());
            }
            case RULE: {
                return this.generatedJavaClassService.toJavaRule(func.getSymbolId());
            }
        }
        throw new IllegalStateException("Unknown origin of RFunction: " + func.getOrigin());
    }

    public JavaClass<RosettaFunction> toFunctionJavaClass(Function func) {
        return this.generatedJavaClassService.toJavaFunction(this.getSymbolId(func));
    }

    public JavaClass<RosettaFunction> toFunctionJavaClass(RosettaExternalFunction func) {
        return new GeneratedJavaClass(this.packages.defaultLibFunctions(), func.getName(), RosettaFunction.class);
    }

    public JavaClass<ReportFunction<?, ?>> toReportFunctionJavaClass(RosettaReport report) {
        return this.generatedJavaClassService.toJavaReportFunction(this.getReportId(report));
    }

    public JavaClass<Tabulator<?>> toReportTabulatorJavaClass(RosettaReport report) {
        return this.generatedJavaClassService.toJavaReportTabulator(this.getReportId(report));
    }

    public JavaClass<Tabulator<?>> toTabulatorJavaClass(Data type, Optional<RosettaExternalRuleSource> ruleSource) {
        ModelSymbolId typeId = this.getSymbolId(type);
        Optional containingRuleSource = ruleSource.flatMap(rs -> this.findContainingSuperRuleSource(type, (RosettaExternalRuleSource)rs));
        if (containingRuleSource.isEmpty()) {
            DottedPath packageName = typeId.getNamespace().child("reports");
            String simpleName = typeId.getName() + "TypeTabulator";
            return new GeneratedJavaClass(packageName, simpleName, new TypeReference<Tabulator<?>>(){});
        }
        ModelSymbolId sourceId = this.getSymbolId((RosettaNamed)containingRuleSource.get());
        DottedPath packageName = sourceId.getNamespace().child("reports");
        String simpleName = typeId.getName() + sourceId.getName() + "TypeTabulator";
        return new GeneratedJavaClass(packageName, simpleName, new TypeReference<Tabulator<?>>(){});
    }

    private Optional<RosettaExternalRuleSource> findContainingSuperRuleSource(Data type, RosettaExternalRuleSource ruleSource) {
        if (ruleSource.getExternalClasses().stream().filter(c -> c.getData().equals(type)).findAny().isPresent()) {
            return Optional.of(ruleSource);
        }
        return Optional.ofNullable(ruleSource.getSuperRuleSource()).flatMap(s -> this.findContainingSuperRuleSource(type, (RosettaExternalRuleSource)s));
    }

    public JavaClass<Tabulator<?>> toProjectionTabulatorJavaClass(Function projection) {
        return this.generatedJavaClassService.toJavaProjectionTabulator(this.getSymbolId(projection));
    }

    public JavaClass<Tabulator<?>> toTabulatorJavaClass(Data type, Function projection) {
        ModelSymbolId typeId = this.getSymbolId(type);
        ModelSymbolId projectionId = this.getSymbolId(projection);
        DottedPath packageName = projectionId.getNamespace().child("projections");
        String simpleName = typeId.getName() + projection.getName() + "TypeTabulator";
        return new GeneratedJavaClass(packageName, simpleName, new TypeReference<Tabulator<?>>(){});
    }

    public JavaClass<?> toDeepPathUtilJavaClass(Data choiceType) {
        ModelSymbolId typeId = this.getSymbolId(choiceType);
        DottedPath packageName = typeId.getNamespace().child("util");
        String simpleName = typeId.getName() + "DeepPathUtil";
        return new GeneratedJavaClass(packageName, simpleName, Object.class);
    }

    public JavaReferenceType toMetaJavaType(Attribute attribute) {
        JavaReferenceType attrType = this.toJavaReferenceType(this.typeProvider.getRTypeOfSymbol(attribute));
        DottedPath namespace = this.getModelPackage(attribute.getTypeCall().getType());
        return this.toMetaJavaType(attrType, this.extensions.hasMetaFieldAnnotations(attribute), namespace);
    }

    public JavaReferenceType toMetaOrRegularJavaType(ExpandedAttribute expAttr) {
        JavaReferenceType attrType = expAttr.getRosettaType() != null ? this.toJavaReferenceType(this.typeSystem.typeCallToRType(expAttr.getRosettaType())) : this.expandedTypeToJavaType(expAttr.getType());
        if (!expAttr.hasMetas()) {
            return attrType;
        }
        DottedPath namespace = this.getModelPackage(expAttr.getRosettaType().getType());
        return this.toMetaJavaType(attrType, expAttr.refIndex() < 0, namespace);
    }

    public JavaReferenceType toMultiMetaOrRegularJavaType(ExpandedAttribute expAttr) {
        JavaReferenceType singleType = this.toMetaOrRegularJavaType(expAttr);
        if (expAttr.isMultiple()) {
            if (expAttr.isDataType() || expAttr.hasMetas()) {
                return this.toPolymorphicList(singleType);
            }
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)singleType);
        }
        return singleType;
    }

    public JavaReferenceType toMultiRegularJavaType(ExpandedAttribute expAttr) {
        JavaReferenceType singleType = this.toJavaReferenceType(this.typeSystem.typeCallToRType(expAttr.getRosettaType()));
        if (expAttr.isMultiple()) {
            if (expAttr.isDataType()) {
                return this.toPolymorphicList(singleType);
            }
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)singleType);
        }
        return singleType;
    }

    public JavaClass<?> toMetaJavaType(ExpandedAttribute expAttr) {
        JavaReferenceType attrType = expAttr.getRosettaType() != null ? this.toJavaReferenceType(this.typeSystem.typeCallToRType(expAttr.getRosettaType())) : this.expandedTypeToJavaType(expAttr.getType());
        DottedPath namespace = this.getModelPackage(expAttr.getRosettaType().getType());
        return this.toMetaJavaType(attrType, expAttr.refIndex() < 0, namespace);
    }

    public JavaReferenceType expandedTypeToJavaType(ExpandedType type) {
        if (type.getName().equals("MetaFields") || type.getName().equals("MetaAndTemplateFields")) {
            return new GeneratedJavaClass(this.packages.basicMetafields(), type.getName(), Object.class);
        }
        if (type.isMetaType()) {
            return this.typeUtil.STRING;
        }
        if (type.isBuiltInType()) {
            return this.toJavaReferenceType(this.builtins.getType(type.getName(), Collections.emptyMap()));
        }
        return new GeneratedJavaClass(this.modelPackage(type.getModel()), type.getName(), Object.class);
    }

    private JavaClass<?> toMetaJavaType(JavaReferenceType base, boolean hasMetaFieldAnnotations, DottedPath namespace) {
        String attributeTypeName = base.getSimpleName();
        String name = hasMetaFieldAnnotations ? "FieldWithMeta" + attributeTypeName : "ReferenceWithMeta" + attributeTypeName;
        DottedPath pkg = this.metaField(namespace);
        return new GeneratedJavaClass(pkg, name, Object.class);
    }

    public JavaClass<?> operationToReferenceWithMetaType(Operation op) {
        Attribute attr;
        if (op.getPath() == null) {
            attr = (Attribute)op.getAssignRoot();
        } else {
            EList<Segment> segments = op.pathAsSegmentList();
            attr = ((Segment)segments.get(segments.size() - 1)).getAttribute();
        }
        DottedPath namespace = this.getModelPackage(attr.getTypeCall().getType());
        return this.toMetaJavaType(this.toJavaReferenceType(this.typeProvider.getRTypeOfSymbol(attr)), false, namespace);
    }

    public JavaReferenceType operationToJavaType(ROperation op) {
        RAttribute attr;
        if (op.getPathTail().isEmpty()) {
            attr = (RAttribute)op.getPathHead();
        } else {
            List<RAttribute> segments = op.getPathTail();
            attr = segments.get(segments.size() - 1);
        }
        return this.attributeToJavaType(attr);
    }

    public JavaClass<?> operationToReferenceWithMetaType(ROperation op) {
        RAttribute attr;
        if (op.getPathTail().isEmpty()) {
            attr = (RAttribute)op.getPathHead();
        } else {
            List<RAttribute> segments = op.getPathTail();
            attr = segments.get(segments.size() - 1);
        }
        return this.toMetaJavaType(this.toJavaReferenceType(attr.getRType()), false, attr.getRType().getNamespace());
    }

    private String getTypeDebugInfo(RType type) {
        return type.toString() + " (" + type.getClass().getSimpleName() + ")";
    }

    public JavaReferenceType toJavaReferenceType(RType type) {
        JavaType jt = this.toJavaType(type);
        if (jt instanceof JavaPrimitiveType) {
            return ((JavaPrimitiveType)jt).toReferenceType();
        }
        if (jt instanceof JavaReferenceType) {
            return (JavaReferenceType)jt;
        }
        throw new UnsupportedOperationException("Cannot convert type " + this.getTypeDebugInfo(type) + " to a Java reference type.");
    }

    public JavaReferenceType toJavaReferenceType(Optional<RType> type) {
        return (JavaReferenceType)type.map(t -> this.toJavaReferenceType((RType)t)).orElse((JavaReferenceType)this.typeUtil.OBJECT);
    }

    public JavaReferenceType attributeToJavaType(RAttribute rAttribute) {
        JavaReferenceType itemType = this.toJavaReferenceType(rAttribute.getRType());
        if (rAttribute.isMulti()) {
            return this.typeUtil.wrapExtendsIfNotFinal(this.typeUtil.LIST, (JavaType)itemType);
        }
        return itemType;
    }

    public JavaType toJavaType(RType type) {
        return (JavaType)this.doSwitch(type, null);
    }

    public JavaType toJavaType(Optional<RType> type) {
        return (JavaType)type.map(t -> this.toJavaType((RType)t)).orElse((JavaType)this.typeUtil.OBJECT);
    }

    public JavaClass<?> toJavaType(RDataType type) {
        return this.caseDataType(type, null);
    }

    public JavaReferenceType toPolymorphicListOrSingleJavaType(RType type, boolean isMany) {
        if (isMany) {
            return this.toPolymorphicList(this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public JavaReferenceType toListOrSingleJavaType(RType type, boolean isMany) {
        if (isMany) {
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public JavaClass<?> toImplType(JavaClass<?> type) {
        return new GeneratedJavaClass(type.getPackageName(), type.getSimpleName() + "." + type.getSimpleName() + "Impl", Object.class);
    }

    public JavaClass<?> toBuilderType(JavaClass<?> type) {
        return new GeneratedJavaClass(type.getPackageName(), type.getSimpleName() + "." + type.getSimpleName() + "Builder", Object.class);
    }

    public JavaClass<?> toBuilderImplType(JavaClass<?> type) {
        return new GeneratedJavaClass(type.getPackageName(), type.getSimpleName() + "." + type.getSimpleName() + "BuilderImpl", Object.class);
    }

    public JavaClass<?> toValidatorClass(RDataType t) {
        return new GeneratedJavaClass(this.validation(this.getModelPackage(t.getData())), t.getName() + "Validator", Object.class);
    }

    public JavaClass<?> toTypeFormatValidatorClass(RDataType t) {
        return new GeneratedJavaClass(this.validation(this.getModelPackage(t.getData())), t.getName() + "TypeFormatValidator", Object.class);
    }

    public JavaClass<?> toOnlyExistsValidatorClass(RDataType t) {
        return new GeneratedJavaClass(this.existsValidation(this.getModelPackage(t.getData())), t.getName() + "OnlyExistsValidator", Object.class);
    }

    private ModelSymbolId getSymbolId(RosettaNamed named) {
        RosettaRootElement rootElement = (RosettaRootElement)EcoreUtil2.getContainerOfType((EObject)named, RosettaRootElement.class);
        RosettaModel model = rootElement.getModel();
        if (model == null) {
            throw new IllegalArgumentException("Can not compute package name for " + named.eClass().getName() + " " + named.getName() + ". Element is not attached to a RosettaModel.");
        }
        DottedPath namespace = DottedPath.splitOnDots((String)model.getName());
        return new ModelSymbolId(namespace, named.getName());
    }

    private ModelReportId getReportId(RosettaReport report) {
        RosettaRootElement rootElement = (RosettaRootElement)EcoreUtil2.getContainerOfType((EObject)report, RosettaRootElement.class);
        RosettaModel model = rootElement.getModel();
        if (model == null) {
            throw new IllegalArgumentException("Can not compute package name for " + report.eClass().getName() + " " + report.getRegulatoryId() + ". Element is not attached to a RosettaModel.");
        }
        DottedPath namespace = DottedPath.splitOnDots((String)model.getName());
        RegulatoryDocumentReference ref = report.getRegulatoryBody();
        String body = ref.getBody().getName();
        String[] corpusList = (String[])ref.getCorpusList().stream().map(c -> c.getName()).toArray(String[]::new);
        return new ModelReportId(namespace, body, corpusList);
    }

    private DottedPath modelPackage(RosettaModel model) {
        return DottedPath.splitOnDots((String)model.getName());
    }

    private DottedPath metaField(DottedPath p) {
        return p.child("metafields");
    }

    private DottedPath validation(DottedPath p) {
        return p.child("validation");
    }

    public DottedPath existsValidation(DottedPath p) {
        return this.validation(p).child("exists");
    }

    @Override
    protected JavaType caseErrorType(RErrorType type, Void context) {
        throw new IllegalArgumentException("Cannot convert an error type to a Java type.");
    }

    @Override
    protected JavaClass<?> caseDataType(RDataType type, Void context) {
        return new RJavaPojoInterface(type.getData(), this.typeSystem);
    }

    @Override
    protected JavaClass<?> caseEnumType(REnumType type, Void context) {
        return new RJavaEnum(type.getEnumeration());
    }

    @Override
    protected JavaType caseAliasType(RAliasType type, Void context) {
        return this.toJavaType(type.getRefersTo());
    }

    @Override
    protected JavaType caseNumberType(RNumberType type, Void context) {
        if (!type.isInteger()) {
            return JavaClass.from(BigDecimal.class);
        }
        int digits = type.getDigits().orElse(9);
        if (digits <= 9) {
            return JavaPrimitiveType.INT;
        }
        if (digits <= 18) {
            return JavaPrimitiveType.LONG;
        }
        return JavaClass.from(BigInteger.class);
    }

    @Override
    protected JavaClass<String> caseStringType(RStringType type, Void context) {
        return this.typeUtil.STRING;
    }

    @Override
    protected JavaPrimitiveType caseBooleanType(RBasicType type, Void context) {
        return JavaPrimitiveType.BOOLEAN;
    }

    @Override
    protected JavaClass<LocalTime> caseTimeType(RBasicType type, Void context) {
        return this.typeUtil.LOCAL_TIME;
    }

    @Override
    protected JavaType caseMissingType(RBasicType type, Void context) {
        throw new IllegalArgumentException("Cannot convert a missing type to a Java type.");
    }

    @Override
    protected JavaClass<Void> caseNothingType(RBasicType type, Void context) {
        return this.typeUtil.VOID;
    }

    @Override
    protected JavaClass<Object> caseAnyType(RBasicType type, Void context) {
        return this.typeUtil.OBJECT;
    }

    @Override
    protected JavaClass<Date> caseDateType(RDateType type, Void context) {
        return this.typeUtil.DATE;
    }

    @Override
    protected JavaClass<LocalDateTime> caseDateTimeType(RDateTimeType type, Void context) {
        return this.typeUtil.LOCAL_DATE_TIME;
    }

    @Override
    protected JavaClass<ZonedDateTime> caseZonedDateTimeType(RZonedDateTimeType type, Void context) {
        return this.typeUtil.ZONED_DATE_TIME;
    }
}

