/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.fasterxml.jackson.core.type.TypeReference;
import com.regnosys.rosetta.generator.java.types.JavaTypeJoiner;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.RJavaPojoInterface;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.JavaWildcardTypeArgument;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import javax.inject.Inject;

public class JavaTypeUtil {
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private JavaTypeTranslator typeTranslator;
    @Inject
    private JavaTypeJoiner typeJoiner;
    public final JavaClass<Number> NUMBER = JavaClass.from(Number.class);
    public final JavaClass<Integer> INTEGER = JavaClass.from(Integer.class);
    public final JavaClass<Long> LONG = JavaClass.from(Long.class);
    public final JavaClass<BigInteger> BIG_INTEGER = JavaClass.from(BigInteger.class);
    public final JavaClass<BigDecimal> BIG_DECIMAL = JavaClass.from(BigDecimal.class);
    public final JavaClass<Boolean> BOOLEAN = JavaClass.from(Boolean.class);
    public final JavaClass<String> STRING = JavaClass.from(String.class);
    public final JavaClass<Void> VOID = JavaClass.from(Void.class);
    public final JavaClass<LocalTime> LOCAL_TIME = JavaClass.from(LocalTime.class);
    public final JavaClass<Date> DATE = JavaClass.from(Date.class);
    public final JavaClass<LocalDateTime> LOCAL_DATE_TIME = JavaClass.from(LocalDateTime.class);
    public final JavaClass<ZonedDateTime> ZONED_DATE_TIME = JavaClass.from(ZonedDateTime.class);
    public final JavaClass<Object> OBJECT = JavaClass.OBJECT;
    public final JavaClass<Cloneable> CLONEABLE = JavaClass.CLONEABLE;
    public final JavaClass<Serializable> SERIALIZABLE = JavaClass.SERIALIZABLE;
    public final JavaGenericTypeDeclaration<List<?>> LIST = JavaGenericTypeDeclaration.from((TypeReference)new TypeReference<List<?>>(){});
    public final JavaGenericTypeDeclaration<Mapper<?>> MAPPER = JavaGenericTypeDeclaration.from((TypeReference)new TypeReference<Mapper<?>>(){});
    public final JavaGenericTypeDeclaration<MapperS<?>> MAPPER_S = JavaGenericTypeDeclaration.from((TypeReference)new TypeReference<MapperS<?>>(){});
    public final JavaGenericTypeDeclaration<MapperC<?>> MAPPER_C = JavaGenericTypeDeclaration.from((TypeReference)new TypeReference<MapperC<?>>(){});
    public final JavaClass<ComparisonResult> COMPARISON_RESULT = JavaClass.from(ComparisonResult.class);
    public final JavaGenericTypeDeclaration<MapperListOfLists<?>> MAPPER_LIST_OF_LISTS = JavaGenericTypeDeclaration.from((TypeReference)new TypeReference<MapperListOfLists<?>>(){});

    public <T> JavaParameterizedType<T> wrap(JavaGenericTypeDeclaration<T> wrapperType, JavaType itemType) {
        return JavaParameterizedType.from(wrapperType, (JavaTypeArgument[])new JavaTypeArgument[]{itemType.toReferenceType()});
    }

    public <T> JavaParameterizedType<T> wrap(JavaGenericTypeDeclaration<T> wrapperType, Class<?> itemType) {
        return this.wrap(wrapperType, JavaType.from(itemType));
    }

    public <T> JavaParameterizedType<T> wrap(JavaGenericTypeDeclaration<T> wrapperType, RosettaExpression item) {
        return this.wrap(wrapperType, (JavaType)this.typeTranslator.toJavaReferenceType(this.typeProvider.getRType(item)));
    }

    public <T> JavaParameterizedType<T> wrapExtends(JavaGenericTypeDeclaration<T> wrapperType, JavaType itemType) {
        return JavaParameterizedType.from(wrapperType, (JavaTypeArgument[])new JavaTypeArgument[]{JavaWildcardTypeArgument.extendsBound((JavaReferenceType)itemType.toReferenceType())});
    }

    public <T> JavaParameterizedType<T> wrapExtends(JavaGenericTypeDeclaration<T> wrapperType, Class<?> itemType) {
        return this.wrapExtends(wrapperType, JavaType.from(itemType));
    }

    public <T> JavaParameterizedType<T> wrapExtends(JavaGenericTypeDeclaration<T> wrapperType, RosettaExpression item) {
        return this.wrapExtends(wrapperType, (JavaType)this.typeTranslator.toJavaReferenceType(this.typeProvider.getRType(item)));
    }

    public <T> JavaParameterizedType<T> wrapExtendsIfNotFinal(JavaGenericTypeDeclaration<T> wrapperType, JavaType itemType) {
        if (itemType instanceof RJavaPojoInterface) {
            return this.wrapExtends(wrapperType, itemType);
        }
        return this.wrap(wrapperType, itemType);
    }

    public <T> JavaParameterizedType<T> wrapExtendsIfNotFinal(JavaGenericTypeDeclaration<T> wrapperType, Class<?> itemType) {
        return this.wrapExtendsIfNotFinal(wrapperType, JavaType.from(itemType));
    }

    public <T> JavaParameterizedType<T> wrapExtendsIfNotFinal(JavaGenericTypeDeclaration<T> wrapperType, RosettaExpression item) {
        return this.wrapExtendsIfNotFinal(wrapperType, (JavaType)this.typeTranslator.toJavaReferenceType(this.typeProvider.getRType(item)));
    }

    public boolean hasWildcardArgument(JavaType t) {
        return t instanceof JavaParameterizedType && ((JavaParameterizedType)t).getArguments().get(0) instanceof JavaWildcardTypeArgument;
    }

    public JavaType getItemType(JavaType t) {
        if (this.isWrapper(t)) {
            if (this.isComparisonResult(t)) {
                return this.BOOLEAN;
            }
            JavaTypeArgument arg = (JavaTypeArgument)((JavaParameterizedType)t).getArguments().get(0);
            if (arg instanceof JavaWildcardTypeArgument) {
                return (JavaType)((JavaWildcardTypeArgument)arg).getBound().orElse(this.OBJECT);
            }
            return (JavaReferenceType)arg;
        }
        return t;
    }

    public JavaType changeItemType(JavaType t, JavaType newItemType) {
        if (this.isWrapper(t)) {
            if (this.isComparisonResult(t)) {
                return t;
            }
            JavaGenericTypeDeclaration base = ((JavaParameterizedType)t).getGenericTypeDeclaration();
            return JavaParameterizedType.from((JavaGenericTypeDeclaration)base, (JavaTypeArgument[])new JavaTypeArgument[]{newItemType.toReferenceType()});
        }
        return newItemType;
    }

    public boolean extendsNumber(JavaType t) {
        return t.isSubtypeOf(this.NUMBER);
    }

    public boolean isInteger(JavaType t) {
        return this.INTEGER.equals((Object)t);
    }

    public boolean isLong(JavaType t) {
        return this.LONG.equals((Object)t);
    }

    public boolean isBigInteger(JavaType t) {
        return this.BIG_INTEGER.equals((Object)t);
    }

    public boolean isBigDecimal(JavaType t) {
        return this.BIG_DECIMAL.equals((Object)t);
    }

    public boolean isBoolean(JavaType t) {
        return this.BOOLEAN.equals((Object)t);
    }

    public boolean isVoid(JavaType t) {
        return this.VOID.equals((Object)t);
    }

    public boolean isList(JavaType t) {
        if (t instanceof JavaParameterizedType) {
            return this.LIST.equals((Object)((JavaParameterizedType)t).getGenericTypeDeclaration());
        }
        return this.LIST.equals((Object)t);
    }

    public boolean extendsMapper(JavaType t) {
        if (t instanceof JavaParameterizedType) {
            return ((JavaParameterizedType)t).getGenericTypeDeclaration().extendsDeclaration(this.MAPPER);
        }
        if (t instanceof JavaClass) {
            return ((JavaClass)t).extendsDeclaration(this.MAPPER);
        }
        return false;
    }

    public boolean isMapper(JavaType t) {
        if (t instanceof JavaParameterizedType) {
            return this.MAPPER.equals((Object)((JavaParameterizedType)t).getGenericTypeDeclaration());
        }
        return false;
    }

    public boolean isMapperS(JavaType t) {
        if (t instanceof JavaParameterizedType) {
            return this.MAPPER_S.equals((Object)((JavaParameterizedType)t).getGenericTypeDeclaration());
        }
        return false;
    }

    public boolean isMapperC(JavaType t) {
        if (t instanceof JavaParameterizedType) {
            return this.MAPPER_C.equals((Object)((JavaParameterizedType)t).getGenericTypeDeclaration());
        }
        return false;
    }

    public boolean isComparisonResult(JavaType t) {
        return this.COMPARISON_RESULT.equals((Object)t);
    }

    public boolean isMapperListOfLists(JavaType t) {
        if (t instanceof JavaParameterizedType) {
            return this.MAPPER_LIST_OF_LISTS.equals((Object)((JavaParameterizedType)t).getGenericTypeDeclaration());
        }
        return false;
    }

    public boolean isWrapper(JavaType t) {
        return t != JavaReferenceType.NULL_TYPE && (this.isList(t) || this.extendsMapper(t) || this.isMapperListOfLists(t));
    }

    public JavaType join(JavaType left, JavaType right) {
        return (JavaType)this.typeJoiner.visitTypes(left, right);
    }
}

